/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class YetAnotherClobTest
extends Test {
    private static final String help = "help for YetAnotherClobTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public YetAnotherClobTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public YetAnotherClobTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "YetAnotherClobTest";
        this.testcase("Homer");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 12288; ++i) {
            stringBuffer.append("Homer Simpson");
        }
        this.testcase(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testcase(String string) throws SQLException {
        Object[] objectArray;
        Closeable closeable;
        String string2 = "YetAnotherClobTest";
        String string3 = this.getUnicodeIdentifier(string2);
        this.dropTable(string3);
        this.stmt.execute("CREATE TABLE " + string3 + " (" + " NAMESPACE               Long)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string3 + " values (?)");
        preparedStatement.setString(1, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.connection.commit();
        preparedStatement = this.connection.prepareStatement("Select * from " + string3);
        ResultSet resultSet = null;
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        long l = clob.length();
        this.log.addDifference(string2, "Check Clob length", new Long(string.length()), new Long(l));
        String string4 = clob.getSubString(1L, (int)l);
        this.log.addDifference(string2, "Check Clob content", string, string4);
        resultSet.close();
        try {
            string2 = "YetAnotherClobTest getAsciiStream";
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            clob = resultSet.getClob(1);
            closeable = clob.getAsciiStream();
            objectArray = new byte[(int)clob.length()];
            this.log.addDifference(string2, "Check Clob length", new Long(string.length()), new Long(((InputStream)closeable).read((byte[])objectArray, 0, (int)clob.length())));
            this.log.addDifference(string2, "Check Clob content", string, new String((byte[])objectArray));
        }
        catch (IOException iOException) {
            this.log.addFailure(new Failure(iOException.toString()));
        }
        finally {
            resultSet.close();
        }
        try {
            string2 = "YetAnotherClobTest getCharacterStream";
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            clob = resultSet.getClob(1);
            closeable = clob.getCharacterStream();
            this.log.addDifference(string2, "Check Clob length", new Long(string.length()), new Long(clob.length()));
            objectArray = new char[(int)clob.length()];
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            while (-1 != (n = ((Reader)closeable).read((char[])objectArray, 0, (int)clob.length()))) {
                stringBuffer.append((char[])objectArray, 0, n);
            }
            this.log.addDifference(string2, "Check Clob length", new Long(string.length()), new Long(stringBuffer.length()));
            this.log.addDifference(string2, "Check Clob content", string, stringBuffer.toString());
        }
        catch (IOException iOException) {
            this.log.addFailure(new Failure(iOException.toString()));
        }
        finally {
            resultSet.close();
        }
        preparedStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        YetAnotherClobTest yetAnotherClobTest = new YetAnotherClobTest(stringArray);
        try {
            yetAnotherClobTest.runInner();
        }
        finally {
            yetAnotherClobTest.connection.close();
        }
        if (yetAnotherClobTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

