/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IllegalNumberTest
extends Test {
    private static final String help = "Tests not-a-number values.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public IllegalNumberTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public IllegalNumberTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        block17: {
            ResultSet resultSet;
            String string;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                string = "IllegalNumberTest";
                                String string2 = this.getUnicodeIdentifier(string);
                                this.dropTable(string2);
                                this.stmt.executeUpdate("CREATE " + string2 + " (a integer)");
                                resultSet = this.stmt.executeQuery("Select num ('1234567890123456789012345678901234567890123456789012345678901234567890') from " + string2);
                                resultSet.next();
                                this.log.addDifference(string, "getString(specialNullValue)", "NaN", resultSet.getString(1));
                                this.log.addDifference(string, "getDouble(specialNullValue)", new Double(Double.NaN), new Double(resultSet.getDouble(1)));
                                this.log.addDifference(string, "getFloat(specialNullValue)", new Float(Float.NaN), new Float(resultSet.getFloat(1)));
                                try {
                                    resultSet.getObject(1);
                                    this.log.addFailure(new Failure(string, "getObject() should throw an exception"));
                                }
                                catch (SQLException sQLException) {
                                    if (sQLException.getMessage().startsWith("Result of arithmetic operation") && sQLException.getErrorCode() == -10811) break block12;
                                    throw sQLException;
                                }
                            }
                            try {
                                resultSet.getBigDecimal(1);
                                this.log.addFailure(new Failure(string, "getBigDecimal() should throw an exception"));
                            }
                            catch (SQLException sQLException) {
                                if (sQLException.getMessage().startsWith("Result of arithmetic operation") && sQLException.getErrorCode() == -10811) break block13;
                                throw sQLException;
                            }
                        }
                        try {
                            resultSet.getInt(1);
                            this.log.addFailure(new Failure(string, "getInt() should throw an exception"));
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getMessage().startsWith("Result of arithmetic operation") && sQLException.getErrorCode() == -10811) break block14;
                            throw sQLException;
                        }
                    }
                    try {
                        resultSet.getLong(1);
                        this.log.addFailure(new Failure(string, "getLong() should throw an exception"));
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage().startsWith("Result of arithmetic operation") && sQLException.getErrorCode() == -10811) break block15;
                        throw sQLException;
                    }
                }
                try {
                    resultSet.getBoolean(1);
                    this.log.addFailure(new Failure(string, "getBoolean() should throw an exception"));
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().startsWith("Result of arithmetic operation") && sQLException.getErrorCode() == -10811) break block16;
                    throw sQLException;
                }
            }
            try {
                resultSet.getShort(1);
                this.log.addFailure(new Failure(string, "getShort() should throw an exception"));
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("Result of arithmetic operation") && sQLException.getErrorCode() == -10811) break block17;
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        IllegalNumberTest illegalNumberTest = new IllegalNumberTest(stringArray);
        try {
            illegalNumberTest.runInner();
        }
        finally {
            illegalNumberTest.connection.close();
        }
        if (illegalNumberTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

