/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ColumnDefinition;
import com.sap.dbtechtest.jdbc.types.Constants;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.Reflector;
import com.sap.dbtechtest.jdbc.types.SharedConstants;
import com.sap.dbtechtest.jdbc.types.TypeEnums;
import com.sap.dbtechtest.util.ObjectServices;
import com.sap.dbtechtest.util.options.ListOption;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.LogWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

abstract class ConversionTest
extends Test {
    protected static final String colNameC = "datacol";
    public static final boolean useReflectorInsertC = false;
    public static final boolean useObjectInsertC = true;
    public static final boolean useReflectorFetchC = false;
    public static final boolean useObjectFetchC = true;
    public static Class JDBCDriverExceptionClass = SharedConstants.JDBCDriverExceptionClass;
    public Class ValueOverflowClass = SharedConstants.ValueOverflowClass;
    public static Class ConversionExceptionClass = SharedConstants.ConversionExceptionClass;
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("subtest", "[both | insert | fetch]", "both", null), new ListOption("jdbcType", "jdbc types to test", null), new ListOption("ordinal", "restrict test cases to this index", null)};

    protected ConversionTest(OptionDesc[] optionDescArray, String string, String[] stringArray) throws SQLException {
        super(OptionDesc.concatArrays(optionDescArray, optdesc), string, stringArray);
        if (!this.environment.testRunsWithMaxDB()) {
            JDBCDriverExceptionClass = ObjectServices.loadClass("java.sql.SQLException");
            ConversionExceptionClass = ObjectServices.loadClass("java.sql.SQLException");
            this.ValueOverflowClass = ObjectServices.loadClass("java.sql.SQLException");
        }
    }

    public ConversionTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
        if (!this.environment.testRunsWithMaxDB()) {
            JDBCDriverExceptionClass = ObjectServices.loadClass("java.sql.SQLException");
            ConversionExceptionClass = ObjectServices.loadClass("java.sql.SQLException");
            this.ValueOverflowClass = ObjectServices.loadClass("java.sql.SQLException");
        }
    }

    protected abstract ConversionTestCase[] getInputTestCases();

    protected abstract ConversionTestCase[] getFetchTestCases();

    protected ConversionTestCase[] filterTestCases(ConversionTestCase[] conversionTestCaseArray, LogWriter logWriter) {
        ConversionTestCase[] conversionTestCaseArray2 = conversionTestCaseArray;
        conversionTestCaseArray2 = this.filterTestCasesByJdbcType(conversionTestCaseArray2);
        if ((conversionTestCaseArray2 = this.filterTestCasesByOrdinal(conversionTestCaseArray2)).length == conversionTestCaseArray.length && this.options.getBoolean("picky")) {
            this.checkForAllJdbcTypes(conversionTestCaseArray2, logWriter);
        }
        return conversionTestCaseArray2;
    }

    private ConversionTestCase[] filterTestCasesByJdbcType(ConversionTestCase[] conversionTestCaseArray) {
        Vector vector = this.options.getVector("jdbcType");
        if (vector == null || vector.size() == 0) {
            return conversionTestCaseArray;
        }
        ConversionTestCase[] conversionTestCaseArray2 = new ConversionTestCase[conversionTestCaseArray.length];
        int n = 0;
        for (int i = 0; i < conversionTestCaseArray.length; ++i) {
            ConversionTestCase conversionTestCase = conversionTestCaseArray[i];
            if (!vector.contains(conversionTestCase.jdbcType)) continue;
            conversionTestCaseArray2[n] = conversionTestCase;
            ++n;
        }
        return this.truncateArray(conversionTestCaseArray2, n);
    }

    private ConversionTestCase[] filterTestCasesByOrdinal(ConversionTestCase[] conversionTestCaseArray) {
        Vector vector = this.options.getVector("ordinal");
        if (vector == null || vector.size() == 0) {
            return conversionTestCaseArray;
        }
        ConversionTestCase[] conversionTestCaseArray2 = new ConversionTestCase[conversionTestCaseArray.length];
        int n = 0;
        for (int i = 0; i < conversionTestCaseArray.length; ++i) {
            ConversionTestCase conversionTestCase = conversionTestCaseArray[i];
            if (!vector.contains("" + i)) continue;
            conversionTestCaseArray2[n] = conversionTestCase;
            ++n;
        }
        return this.truncateArray(conversionTestCaseArray2, n);
    }

    private ConversionTestCase[] truncateArray(ConversionTestCase[] conversionTestCaseArray, int n) {
        ConversionTestCase[] conversionTestCaseArray2 = new ConversionTestCase[n];
        System.arraycopy(conversionTestCaseArray, 0, conversionTestCaseArray2, 0, n);
        return conversionTestCaseArray2;
    }

    protected void checkForAllJdbcTypes(ConversionTestCase[] conversionTestCaseArray, LogWriter logWriter) {
        String[] stringArray = TypeEnums.JDBCTypesC;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            boolean bl = false;
            for (int j = 0; j < conversionTestCaseArray.length; ++j) {
                if (!string.equals(conversionTestCaseArray[j].jdbcType)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            logWriter.addFailure(new Failure("missing test case for JDBC type " + string));
        }
    }

    public void testRun() throws SQLException {
        ConversionTestCase[] conversionTestCaseArray;
        String string = this.options.getEnum("subtest", new String[]{"both", "insert", "fetch"});
        String string2 = this.getTestName();
        String string3 = this.getUnicodeIdentifier(string2);
        this.createTable(string3);
        ColumnDefinition columnDefinition = ColumnDefinition.getTableColumnDefinition(this.connection, string3, colNameC);
        if (string.equals("both") || string.equals("insert")) {
            conversionTestCaseArray = this.filterTestCases(this.getInputTestCases(), this.log);
            if (conversionTestCaseArray.length == 0) {
                this.log.addWarning("insert", "no test cases remaining");
            }
            this.runXTest(string3, columnDefinition, "insert", conversionTestCaseArray, false, true);
        }
        if (string.equals("both") || string.equals("fetch")) {
            conversionTestCaseArray = this.filterTestCases(this.getFetchTestCases(), this.log);
            if (conversionTestCaseArray.length == 0) {
                this.log.addWarning("fetch", "no test cases remaining");
            }
            this.runXTest(string3, columnDefinition, "fetch", conversionTestCaseArray, true, false);
        }
    }

    protected void createTable(String string) throws SQLException {
        String string2 = this.options.getString("sqlcol");
        this.dropTable(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string);
        stringBuffer.append(" (context varchar (50), datacol " + string2 + ")");
        this.stmt.execute(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runXTest(String string, ColumnDefinition columnDefinition, String string2, ConversionTestCase[] conversionTestCaseArray, boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = this.createInsert(string);
        PreparedStatement preparedStatement2 = this.createSelect(string);
        try {
            this.log.push(string2);
            for (int i = 0; i < conversionTestCaseArray.length; ++i) {
                Exception exception;
                ConversionTestCase conversionTestCase = conversionTestCaseArray[i];
                String string3 = conversionTestCase.jdbcType + "|" + ObjectServices.toString(conversionTestCase.inputValue);
                if (string3.length() > 50) {
                    string3 = string3.substring(0, 46) + "...";
                }
                if (!this.supportsTestCase(string3, conversionTestCase)) continue;
                this.sql("delete from " + string);
                Object[] objectArray = new Object[]{Constants.secondColC, null, Constants.undefC};
                try {
                    exception = null;
                    preparedStatement.setString(1, string3);
                    if (bl) {
                        preparedStatement.setObject(2, conversionTestCase.inputValue);
                    } else {
                        objectArray[1] = conversionTestCase.inputValue;
                        Reflector.apply(preparedStatement, "set" + conversionTestCase.jdbcType, objectArray);
                    }
                    preparedStatement.execute();
                    this.log.addInfo(string3, "inserted");
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                conversionTestCase.testForInsertException(string3, columnDefinition, exception, this.log);
                if (exception != null) continue;
                Object[] objectArray2 = new Object[]{Constants.secondColC};
                try {
                    exception = null;
                    ResultSet resultSet = preparedStatement2.executeQuery();
                    if (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        Object object = bl2 ? resultSet.getObject(2) : Reflector.apply(resultSet, "get" + conversionTestCase.jdbcType, objectArray2);
                        conversionTestCase.testForDiff(string3, columnDefinition, "fetch", object, this.log);
                    } else {
                        this.log.addDifference(string3, "cursor.next ()", Boolean.TRUE, Boolean.FALSE);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
                conversionTestCase.testForFetchException(string3, columnDefinition, exception, this.log);
            }
        }
        finally {
            this.log.pop();
        }
    }

    protected String getTestName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    protected PreparedStatement createInsert(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepare("Insert into " + string + " values (?, ?)");
        return preparedStatement;
    }

    protected PreparedStatement createSelect(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepare("SELECT context, datacol from " + string);
        return preparedStatement;
    }
}

