/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.jdbc.types.InputConversionFailureCase;
import com.sap.dbtechtest.jdbc.types.OutputConversionFailureCase;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class BooleanTest
extends ConversionTest {
    private static final String help = "help for BooleanTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "sql column definition", "BOOLEAN", null)};
    private final ConversionTestCase[] insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), (ConversionTestCase)new EqualityTestCase("BigDecimal", new BigDecimal(0.0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("BigDecimal", new BigDecimal(1.0), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("BigDecimal", new BigDecimal(-1.0), Boolean.TRUE).bugFixed("PTS1111481"), new EqualityTestCase("Boolean", Boolean.TRUE), new EqualityTestCase("Boolean", Boolean.FALSE), (ConversionTestCase)new EqualityTestCase("Byte", new Byte(0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Byte", new Byte(1), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Byte", new Byte(-1), Boolean.TRUE).bugFixed("PTS1111481"), new InputConversionFailureCase("Bytes", new byte[]{0}), (ConversionTestCase)new InputConversionFailureCase("Date", new Date(100, 0, 1)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Double", new Double(0.0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Double", new Double(1.0), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Double", new Double(-1.0), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Float", new Float(0.0f), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Float", new Float(1.0f), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Float", new Float(-1.0f), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Int", new Integer(0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Int", new Integer(1), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Int", new Integer(-1), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Long", new Long(0L), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Long", new Long(1L), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Long", new Long(-1L), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Object", new BigDecimal(0.0), Boolean.FALSE).bugFixed("PTS1111481"), new EqualityTestCase("Object", Boolean.TRUE), new EqualityTestCase("Object", Boolean.FALSE), (ConversionTestCase)new EqualityTestCase("Object", new Byte(0), Boolean.FALSE).bugFixed("PTS1111481"), new InputConversionFailureCase("Object", new byte[]{0}), (ConversionTestCase)new EqualityTestCase("Object", new Double(0.0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Object", new Float(0.0f), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Object", new Integer(0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Object", new Long(0L), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Object", new Short(0), Boolean.FALSE).bugFixed("PTS1111481"), new EqualityTestCase("Object", "true", Boolean.TRUE), (ConversionTestCase)new InputConversionFailureCase("Object", new Time(0, 0, 0)).bugFixed("PTS1111481"), (ConversionTestCase)new InputConversionFailureCase("Object", new Timestamp(100, 0, 1, 0, 0, 0, 0)).bugFixed("PTS1111481"), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), (ConversionTestCase)new EqualityTestCase("Short", new Short(0), Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Short", new Short(1), Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Short", new Short(-1), Boolean.TRUE).bugFixed("PTS1111481"), new EqualityTestCase("String", "true", Boolean.TRUE), new EqualityTestCase("String", "false", Boolean.FALSE), new EqualityTestCase("String", "on", Boolean.FALSE), (ConversionTestCase)new InputConversionFailureCase("Time", new Time(0, 0, 0)).bugFixed("PTS1111481"), (ConversionTestCase)new InputConversionFailureCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 0)).bugFixed("PTS1111481")};
    private final ConversionTestCase[] fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), (ConversionTestCase)new EqualityTestCase("BigDecimal", Boolean.FALSE, new BigDecimal(0.0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("BigDecimal", Boolean.TRUE, new BigDecimal(1.0)).bugFixed("PTS1111481"), new EqualityTestCase("Boolean", Boolean.TRUE), new EqualityTestCase("Boolean", Boolean.FALSE), (ConversionTestCase)new EqualityTestCase("Byte", Boolean.FALSE, new Byte(0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Byte", Boolean.TRUE, new Byte(1)).bugFixed("PTS1111481"), new InputConversionFailureCase("Bytes", new byte[]{0}), (ConversionTestCase)new OutputConversionFailureCase("Date", Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new OutputConversionFailureCase("Date", Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Double", Boolean.FALSE, new Double(0.0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Double", Boolean.TRUE, new Double(1.0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Float", Boolean.FALSE, new Float(0.0f)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Float", Boolean.TRUE, new Float(1.0f)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Int", Boolean.FALSE, new Integer(0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Int", Boolean.TRUE, new Integer(1)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Byte", Boolean.FALSE, new Byte(0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Byte", Boolean.TRUE, new Byte(1)).bugFixed("PTS1111481"), new EqualityTestCase("Object", Boolean.TRUE), new EqualityTestCase("Object", Boolean.FALSE), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), (ConversionTestCase)new EqualityTestCase("Short", Boolean.FALSE, new Short(0)).bugFixed("PTS1111481"), (ConversionTestCase)new EqualityTestCase("Short", Boolean.TRUE, new Short(1)).bugFixed("PTS1111481"), new EqualityTestCase("String", Boolean.TRUE, "true"), new EqualityTestCase("String", Boolean.FALSE, "false"), (ConversionTestCase)new OutputConversionFailureCase("Time", Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new OutputConversionFailureCase("Time", Boolean.FALSE).bugFixed("PTS1111481"), (ConversionTestCase)new OutputConversionFailureCase("Timestamp", Boolean.TRUE).bugFixed("PTS1111481"), (ConversionTestCase)new OutputConversionFailureCase("Timestamp", Boolean.FALSE).bugFixed("PTS1111481")};

    public BooleanTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BooleanTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BooleanTest booleanTest = new BooleanTest(stringArray);
        try {
            booleanTest.runInner();
        }
        finally {
            booleanTest.connection.close();
        }
        if (booleanTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

