/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobSkipTest
extends Test {
    private static final String help = "help for BlobSkipTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private final int NUM_RECORDS = 1;
    private final int BLOCK_SIZE = 25;
    private final int START_CHAR = 65;
    private final int START_BYTE = 0;
    private final int LOB_LENGTH = 17;
    private final int SKIP = 190002;

    public BlobSkipTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BlobSkipTest(Test test) throws SQLException {
        super(test);
    }

    private byte[] makeBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(0 + i % 25);
        }
        return byArray;
    }

    private String makeString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(n);
        char[] cArray = new char[25];
        for (n2 = 0; n2 < 25; ++n2) {
            cArray[n2] = (char)(65 + n2);
        }
        for (n2 = 0; n2 < 680; ++n2) {
            stringBuffer.append(cArray);
        }
        return stringBuffer.toString();
    }

    public void testRun() throws SQLException {
        int n = 17000;
        byte[] byArray = this.makeBytes(n);
        String string = this.makeString(n);
        String string2 = "BlobSkipTest";
        String string3 = this.getUnicodeIdentifier(string2);
        this.dropTable(string3);
        if (this.environment.hasFeature("UnicodeDB")) {
            this.stmt.execute("CREATE TABLE " + string3 + " (K1VC4 VARCHAR(4) UNICODE  NOT NULL, K2INT INTEGER  NOT NULL, FVC8 VARCHAR(8) UNICODE  , FVB16 CHAR(16) BYTE  , FSHORT SMALLINT  , FINT INTEGER  , FBIGINT FIXED(19)  , FDEC5_2 FIXED(5,2)  , FDOUBLE FLOAT(38)  , FDATE DATE  , FTIME TIME  , FTSTAMP TIMESTAMP  , FCLOB LONG UNICODE  , FBLOB LONG BYTE  )");
        } else {
            this.stmt.execute("CREATE TABLE " + string3 + "(K1VC4 VARCHAR(4) NOT NULL, K2INT INTEGER  NOT NULL, FVC8 VARCHAR(8) , FVB16 CHAR(16) BYTE  , FSHORT SMALLINT  , FINT INTEGER  , FBIGINT FIXED(19)  , FDEC5_2 FIXED(5,2)  , FDOUBLE FLOAT(38)  , FDATE DATE  , FTIME TIME  , FTSTAMP TIMESTAMP  , FCLOB LONG, FBLOB LONG BYTE  )");
        }
        this.stmt.execute("ALTER TABLE " + string3 + " ADD PRIMARY KEY ( K1VC4, K2INT ) ");
        this.connection.commit();
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string3 + " (K1VC4, K2INT, FCLOB, FBLOB) values ('STR', ?, ?, ?)");
        preparedStatement.setInt(1, 0);
        preparedStatement.setString(2, string);
        preparedStatement.setBytes(3, byArray);
        preparedStatement.executeUpdate();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("Select FCLOB, FBLOB, K2INT from " + string3 + " where K1VC4 = 'STR' ORDER BY K2INT");
        byArray = this.makeBytes(n);
        string = this.makeString(n);
        block2: for (int i = 0; i < 1; ++i) {
            int n2 = 0;
            resultSet.next();
            Blob blob = resultSet.getBlob(2);
            try {
                InputStream inputStream = blob.getBinaryStream();
                for (int j = 0; j < n; ++j) {
                    int n3 = inputStream.read();
                    if (n3 == byArray[j]) continue;
                    if (++n2 > 10) {
                        this.log.addFailure(new Failure(string2, "Too many error - stoping"));
                        continue block2;
                    }
                    this.log.addDifference(string2, "Ivalid long column content at pos " + j, new Byte(byArray[j]), new Byte((byte)n3));
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BlobSkipTest blobSkipTest = new BlobSkipTest(stringArray);
        try {
            blobSkipTest.runInner();
        }
        finally {
            blobSkipTest.connection.close();
        }
        if (blobSkipTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

