/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobBatchTest
extends Test {
    private static final String help = "Test for stream handling.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";

    public BlobBatchTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BlobBatchTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        this.tableName = this.getUnicodeIdentifier("JDBC_LONG_BATCH");
        this.connection.setAutoCommit(true);
        this.testRunBytes();
        this.testRunCharData("LONG ASCII");
        if (this.environment.hasFeature("UnicodeDB")) {
            this.testRunCharData("LONG UNICODE");
        }
    }

    public void testRunCharData(String string) throws SQLException {
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + "(V " + string + ")");
        PreparedStatement preparedStatement = this.prepare("INSERT INTO " + this.tableName + " VALUES (?)");
        String string2 = "The quick brown fox jumps over the lazy dog.";
        preparedStatement.setString(1, string2);
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.close();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.tableName + "");
        while (resultSet.next()) {
            String string3 = resultSet.getString(1);
            if (string3.equals(string2)) continue;
            this.log.addFailure(new Failure("String mismatch."));
        }
    }

    public void testRunBytes() throws SQLException {
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + "(V LONG BYTE)");
        PreparedStatement preparedStatement = this.prepare("INSERT INTO " + this.tableName + " VALUES (?)");
        byte[] byArray = new byte[27];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 85;
        }
        preparedStatement.setBytes(1, byArray);
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.close();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.tableName);
        while (resultSet.next()) {
            byte[] byArray2 = resultSet.getBytes(1);
            if (byArray2.length != 27) {
                this.log.addFailure(new Failure("Length of byte array in colum does not match."));
            }
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == 85) continue;
                this.log.addFailure(new Failure("Content of byte array in colum does not match."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BlobBatchTest blobBatchTest = new BlobBatchTest(stringArray);
        try {
            blobBatchTest.runInner();
        }
        finally {
            blobBatchTest.connection.close();
        }
        if (blobBatchTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

