/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.Statement;

public class StandardConformance
extends Test {
    private static final String help = "help for ApiTests";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public StandardConformance(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public StandardConformance(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "StandardConformance";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int)");
        string = "FetchSize < 0 should throw an SQLException";
        Statement statement = this.connection.createStatement();
        try {
            statement.setFetchSize(-1);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "MaxRows < 0 should throw an SQLException";
        try {
            statement.setMaxRows(-1);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "QueryTimeout < 0 should throw an SQLException";
        try {
            statement.setQueryTimeout(-1);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "MaxFieldSize < 0 should throw an SQLException";
        try {
            statement.setMaxFieldSize(-1);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeQuery(null)";
        try {
            statement.executeQuery(null);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeUpdate(null)";
        try {
            statement.executeUpdate(null);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeQuery(\"(((Update ...\")";
        try {
            statement.executeQuery("(((Update " + string2 + " set a = 5)))");
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeUpdate(\"Select * from dual\")";
        try {
            statement.executeUpdate("select * from dual");
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeBatch(\"Select * from dual\")";
        statement.addBatch("Insert into " + string2 + " values (42)");
        statement.addBatch("Update " + string2 + " set a = 42");
        statement.addBatch("DELETE FROM " + string2);
        boolean bl = false;
        try {
            statement.addBatch("Select * from dual");
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        if (!bl) {
            try {
                statement.executeBatch();
                this.log.addFailure(new Failure("executeBatch - excepted SQLException is not occured"));
            }
            catch (BatchUpdateException batchUpdateException) {
                int[] nArray = batchUpdateException.getUpdateCounts();
                this.log.addDifference(string, "getUpdateCounts.length()", new Integer(3), new Integer(nArray.length));
                for (int i = 0; i < 3; ++i) {
                    if (nArray[i] == -2 || nArray[i] == 1) continue;
                    this.log.addFailure(new Failure("diff(" + string + ": getUpdateCounts[" + i + "]: actual Integer(" + nArray[i] + "); expected Integer(-2|1))"));
                }
            }
        }
        string = "executeBatch(\"Select * from dual\")";
        try {
            statement.clearBatch();
            try {
                statement.addBatch("Select * from dual");
            }
            catch (SQLException sQLException) {
                throw new BatchUpdateException();
            }
            statement.executeBatch();
            this.log.addFailure(new Failure("executeBatch - excepted SQLException is not occured"));
        }
        catch (BatchUpdateException batchUpdateException) {
            // empty catch block
        }
        this.stmt.executeQuery("DECLARE CUR_0 CURSOR FOR SELECT * FROM dual");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        StandardConformance standardConformance = new StandardConformance(stringArray);
        try {
            standardConformance.runInner();
        }
        finally {
            standardConformance.connection.close();
        }
        if (standardConformance.log.hasErrors()) {
            System.exit(5);
        }
    }
}

