/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ForwardOnlyAndForUpdate
extends Test {
    private static final String help = "help for ForwardOnlyAndForUpdate";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public ForwardOnlyAndForUpdate(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ForwardOnlyAndForUpdate(Test test) throws SQLException {
        super(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws SQLException {
        String string = "ForwardOnlyAndForUpdate";
        String string2 = this.getUnicodeIdentifier(string);
        this.connection.setAutoCommit(true);
        try {
            this.dropTable(string2);
            this.stmt.execute("CREATE TABLE " + string2 + " (a char(100), b int)");
            PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string2 + " values (?,?)");
            preparedStatement.setString(1, "Du must es laut anh\u00f6ren und Deine Nachbar st\u00f6ren");
            preparedStatement.setInt(2, 42);
            preparedStatement.execute();
            Statement statement = this.connection.createStatement(1003, 1008);
            ResultSet resultSet = statement.executeQuery("Select * from " + string2);
            resultSet.next();
            String string3 = "Andere M\u00fctter haben auch sch\u00f6ne T\u00f6chter";
            resultSet.updateString(1, string3);
            resultSet.updateRow();
            resultSet.close();
            this.connection.commit();
            resultSet = this.stmt.executeQuery("Select * from " + string2);
            resultSet.next();
            this.log.addDifference(string, "check updated value", string3, resultSet.getString(1));
            this.log.addDifference(string, "check updated value", new Integer(42), new Integer(resultSet.getInt(2)));
        }
        finally {
            this.connection.setAutoCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ForwardOnlyAndForUpdate forwardOnlyAndForUpdate = new ForwardOnlyAndForUpdate(stringArray);
        try {
            forwardOnlyAndForUpdate.runInner();
        }
        finally {
            forwardOnlyAndForUpdate.connection.close();
        }
        if (forwardOnlyAndForUpdate.log.hasErrors()) {
            System.exit(5);
        }
    }
}

