/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpdatableStmt3
extends Test {
    private static final String help = "help for UpdatableStmt3";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UpdatableStmt3(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UpdatableStmt3(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "UpdatableStmt3";
        String string2 = this.getUnicodeIdentifier(string);
        if (!this.checkVersion("7.5.0")) {
            return;
        }
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (homer varchar(10), " + "bart integer, " + "liza timestamp, " + "marge varchar (10) byte, " + "apu long byte)");
        String string3 = this.makeRandomString(10);
        int n = 42;
        Timestamp timestamp = new Timestamp(n);
        String string4 = this.makeRandomString(10);
        int n2 = 84;
        Timestamp timestamp2 = new Timestamp(n2);
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string2 + " values (?,?,?,?,?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n);
            preparedStatement.setTimestamp(3, timestamp);
            preparedStatement.setBytes(4, string3.getBytes());
            preparedStatement.setBytes(5, string3.getBytes());
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement = this.connection.prepareStatement("SELECT * FROM " + string2, 1003, 1008);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n3 = 1;
        while (resultSet.next()) {
            switch (n3 % 6) {
                case 1: {
                    resultSet.updateString(1, string4);
                    break;
                }
                case 2: {
                    resultSet.updateInt(2, n2);
                    break;
                }
                case 3: {
                    resultSet.updateTimestamp(3, timestamp2);
                    break;
                }
                case 4: {
                    resultSet.updateBytes(4, string4.getBytes());
                    break;
                }
                case 5: {
                    resultSet.updateBytes(5, string4.getBytes());
                }
            }
            resultSet.updateRow();
            ++n3;
        }
        resultSet = this.stmt.executeQuery("SELECT * FROM " + string2);
        n3 = 1;
        while (resultSet.next()) {
            switch (n3 % 6) {
                case 1: {
                    this.log.addDifference(string, "Check updated values for row " + n3, string4, resultSet.getString(1));
                    this.log.addDifference(string, "Check updated values for row " + n3, new Integer(n), new Integer(resultSet.getInt(2)));
                    this.log.addDifference(string, "Check updated values for row " + n3, timestamp, resultSet.getTimestamp(3));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(4));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(5));
                    break;
                }
                case 2: {
                    this.log.addDifference(string, "Check updated values for row " + n3, string3, resultSet.getString(1));
                    this.log.addDifference(string, "Check updated values for row " + n3, new Integer(n2), new Integer(resultSet.getInt(2)));
                    this.log.addDifference(string, "Check updated values for row " + n3, timestamp, resultSet.getTimestamp(3));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(4));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(5));
                    break;
                }
                case 3: {
                    this.log.addDifference(string, "Check updated values for row " + n3, string3, resultSet.getString(1));
                    this.log.addDifference(string, "Check updated values for row " + n3, new Integer(n), new Integer(resultSet.getInt(2)));
                    this.log.addDifference(string, "Check updated values for row " + n3, timestamp2, resultSet.getTimestamp(3));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(4));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(5));
                    break;
                }
                case 4: {
                    this.log.addDifference(string, "Check updated values for row " + n3, string3, resultSet.getString(1));
                    this.log.addDifference(string, "Check updated values for row " + n3, new Integer(n), new Integer(resultSet.getInt(2)));
                    this.log.addDifference(string, "Check updated values for row " + n3, timestamp, resultSet.getTimestamp(3));
                    this.log.addDifference(string, "Check updated values for row " + n3, string4.getBytes(), resultSet.getBytes(4));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(5));
                    break;
                }
                case 5: {
                    this.log.addDifference(string, "Check updated values for row " + n3, string3, resultSet.getString(1));
                    this.log.addDifference(string, "Check updated values for row " + n3, new Integer(n), new Integer(resultSet.getInt(2)));
                    this.log.addDifference(string, "Check updated values for row " + n3, timestamp, resultSet.getTimestamp(3));
                    this.log.addDifference(string, "Check updated values for row " + n3, string3.getBytes(), resultSet.getBytes(4));
                    this.log.addDifference(string, "Check updated values for row " + n3, string4.getBytes(), resultSet.getBytes(5));
                }
            }
            ++n3;
        }
        Statement statement = this.connection.createStatement(1003, 1008);
        resultSet = statement.executeQuery("SELECT Apu, Homer||Homer, Bart  FROM " + string2);
        while (resultSet.next()) {
            try {
                resultSet.updateString(2, "GERMAN DARK BREAD");
            }
            catch (SQLException sQLException) {
                this.log.addDifference(string, "Check if Column not updatable exception will be thrown", "The column EXPRESSION1 is not updatable.", sQLException.getMessage());
            }
            resultSet.updateInt(3, 706);
            resultSet.updateRow();
        }
        resultSet = this.stmt.executeQuery("SELECT BART FROM " + string2);
        int n4 = 1;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check updated values for row Bart", new Integer(706), new Integer(resultSet.getInt(1)));
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UpdatableStmt3 updatableStmt3 = new UpdatableStmt3(stringArray);
        try {
            updatableStmt3.runInner();
        }
        finally {
            updatableStmt3.connection.close();
        }
        if (updatableStmt3.log.hasErrors()) {
            System.exit(5);
        }
    }
}

