/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.TestDifference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RefreshRow
extends Test {
    private static final String help = "Test a simple refresh row.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public RefreshRow(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public RefreshRow(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "TEST_REFRESH";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (A INTEGER)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES(1)");
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + string2 + "");
        resultSet.next();
        int n = resultSet.getInt(1);
        if (n != 1) {
            this.log.addFailure(new TestDifference("refresh", "first query", "1", "" + n));
        }
        Statement statement = this.connection.createStatement(1005, 1007);
        statement.execute("UPDATE " + string2 + " SET A=999");
        resultSet.refreshRow();
        int n2 = resultSet.getInt(1);
        if (n2 != 999) {
            this.log.addFailure(new TestDifference("refresh", "second query", "999", "" + n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        RefreshRow refreshRow = new RefreshRow(stringArray);
        try {
            refreshRow.runInner();
        }
        finally {
            refreshRow.connection.close();
        }
        if (refreshRow.log.hasErrors()) {
            System.exit(5);
        }
    }
}

