/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StandardConformance
extends Test {
    private static final String help = "help for ApiTests";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public StandardConformance(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public StandardConformance(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        PreparedStatement preparedStatement;
        String string = "StandardConformance";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int, b int)");
        string = "prepareStatement(null)";
        try {
            preparedStatement = this.connection.prepareStatement(null);
            preparedStatement.executeQuery();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "prepareStatement(null)";
        try {
            preparedStatement = this.connection.prepareStatement(null);
            preparedStatement.executeQuery();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeQuery(\"(((Update ...\")";
        try {
            preparedStatement = this.connection.prepareStatement("Update " + string2 + " set a = 5, b= 6");
            preparedStatement.executeQuery();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeUpdate(\"Select * from dual\")";
        try {
            preparedStatement = this.connection.prepareStatement("select * from dual");
            preparedStatement.executeUpdate();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeQuery without setting all parameters";
        try {
            preparedStatement = this.connection.prepareStatement("select * from " + string2 + " where a=? and b=?");
            ResultSet resultSet = preparedStatement.executeQuery();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeQuery without setting all parameters";
        try {
            preparedStatement = this.connection.prepareStatement("select * from " + string2 + " where a=? and b=?");
            preparedStatement.execute();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "execute without setting all parameters";
        try {
            preparedStatement = this.connection.prepareStatement("Update " + string2 + " set a=?");
            preparedStatement.executeUpdate();
            this.log.addFailure(new Failure(string + " excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "executeBatch with select statement";
        try {
            preparedStatement = this.connection.prepareStatement("Select * from dual");
            preparedStatement.executeBatch();
            this.log.addFailure(new Failure(string + " - excepted SQLException not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "ps.executeQuery(\"SELECT 1 FROM DUAL\")";
        try {
            preparedStatement = this.connection.prepareStatement("SELECT * FROM DUAL");
            preparedStatement.executeQuery("SELECT 1 FROM DUAL");
            this.log.addFailure(new Failure(string + " - excepted SQLException not occured."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement = this.connection.prepareStatement("SELECT * FROM DUAL");
            preparedStatement.executeUpdate("SELECT 1 FROM DUAL");
            this.log.addFailure(new Failure(string + " - excepted SQLException did not occur."));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        StandardConformance standardConformance = new StandardConformance(stringArray);
        try {
            standardConformance.runInner();
        }
        finally {
            standardConformance.connection.close();
        }
        if (standardConformance.log.hasErrors()) {
            System.exit(5);
        }
    }
}

