/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;

public class ExecuteDescribe
extends Test {
    private static final String help = "This test tests sending executeQuery and describe parseid in one order packet.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private static final boolean debug = true;

    public ExecuteDescribe(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ExecuteDescribe(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        Wrapper wrapper;
        Wrapper wrapper2;
        PreparedStatement preparedStatement;
        Wrapper wrapper3;
        Wrapper wrapper4;
        Wrapper wrapper5;
        PreparedStatement preparedStatement2;
        String string = this.getUnicodeIdentifier("ExecuteDescribe");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + " (A INTEGER, B VARCHAR(20), C FIXED(5,2))");
        this.stmt.execute("INSERT INTO " + string + " VALUES (1, 'hello', 42.42)");
        if (this.isVersion("7.3.0") || this.checkVersion("7.4.3")) {
            try {
                this.stmt.execute("DROP DBPROC " + string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stmt.execute("CREATE DBPROC " + string + " (IN NUMVAL INTEGER) RETURNS CURSOR " + "AS " + "BEGIN " + "  IF NUMVAL=1 THEN " + "    DECLARE :$CURSOR CURSOR FOR SELECT A, B, C FROM " + this.getUsername() + "." + string + " " + "  ELSE " + "    DECLARE :$CURSOR CURSOR FOR SELECT 42 FROM SYSDBA.DUAL; " + "END;");
            preparedStatement2 = this.connection.prepareCall("CALL " + string + "(?)");
            wrapper5 = preparedStatement2.getMetaData();
            if (wrapper5 != null) {
                this.log.addFailure(new Failure("ExecuteDescribe.dbproc", "metadata shall not be there after prepare"));
            }
            preparedStatement2.setInt(1, 1);
            wrapper4 = preparedStatement2.executeQuery();
            wrapper3 = preparedStatement2.getMetaData();
            this.checkMetaData("dbproc", (ResultSetMetaData)wrapper3);
            preparedStatement2.close();
        }
        preparedStatement2 = this.prepare("SELECT A,B,C FROM " + string);
        wrapper5 = preparedStatement2.executeQuery();
        wrapper4 = preparedStatement2.getMetaData();
        this.checkMetaData("execute", (ResultSetMetaData)wrapper4);
        wrapper5.next();
        wrapper3 = this.prepare("SELECT * FROM " + string + " WHERE A=? AND B=?");
        wrapper5.close();
        preparedStatement2.close();
        wrapper3.setInt(1, 1);
        wrapper3.setString(2, "hello");
        ResultSet resultSet = wrapper3.executeQuery();
        ResultSetMetaData resultSetMetaData = wrapper3.getMetaData();
        this.checkMetaData("execute param", resultSetMetaData);
        resultSet.next();
        resultSet.close();
        wrapper3.close();
        PreparedStatement preparedStatement3 = this.prepare("SELECT * FROM " + string + " WHERE A=:a AND B=:b");
        preparedStatement3.setInt(1, 1);
        preparedStatement3.setString(2, "hello");
        ResultSet resultSet2 = preparedStatement3.executeQuery();
        ResultSetMetaData resultSetMetaData2 = preparedStatement3.getMetaData();
        this.checkMetaData("execute named param", resultSetMetaData2);
        resultSet2.next();
        resultSet2.close();
        preparedStatement3.close();
        if (this.isVersion("7.3.0")) {
            preparedStatement = this.prepare("SHOW VERSION");
            wrapper2 = preparedStatement.executeQuery();
            wrapper = wrapper2.getMetaData();
            if (!wrapper.getColumnName(1).equalsIgnoreCase("KERNEL")) {
                this.log.addFailure(new Failure("show version", "column name should be KERNEL"));
            }
            wrapper2.next();
            wrapper2.close();
            preparedStatement.close();
        }
        preparedStatement = this.prepare("EXPLAIN SELECT A, B, C FROM " + string);
        wrapper2 = preparedStatement.getMetaData();
        wrapper = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData3 = preparedStatement.getMetaData();
        if (!resultSetMetaData3.getColumnName(2).equalsIgnoreCase("TABLENAME")) {
            this.log.addFailure(new Failure("explain select", "column name should be TABLENAME"));
        }
        wrapper.next();
        wrapper.close();
        preparedStatement.close();
    }

    private void checkMetaData(String string, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (resultSetMetaData.getColumnCount() != 3) {
            this.log.addFailure(new Failure(string, "column count != 3"));
        }
        if (!resultSetMetaData.getColumnName(1).equals("A")) {
            this.log.addFailure(new Failure(string, "column name (1) != A"));
        }
        if (!resultSetMetaData.getColumnName(2).equals("B")) {
            this.log.addFailure(new Failure(string, "column name (2) != B"));
        }
        if (!resultSetMetaData.getColumnName(3).equals("C")) {
            this.log.addFailure(new Failure(string, "column name (3) != C"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ExecuteDescribe executeDescribe = new ExecuteDescribe(stringArray);
        try {
            executeDescribe.runInner();
        }
        finally {
            executeDescribe.connection.close();
        }
        if (executeDescribe.log.hasErrors()) {
            System.exit(5);
        }
    }
}

