/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtech.util.Tracer;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BatchLong
extends Test {
    private static final String help = "help for BatchLong";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BatchLong(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BatchLong(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        Object object;
        int n;
        String string = "BatchLong";
        String string2 = this.getUnicodeIdentifier(string);
        int n2 = 5;
        int n3 = 5;
        InputStream[] inputStreamArray = new InputStream[n2];
        byte[] byArray = new byte[211];
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int, b long byte)");
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i % 10 & 0xFF);
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?)");
        int[] nArray = null;
        for (int i = 0; i < n3; ++i) {
            for (n = 1; n <= n2; ++n) {
                preparedStatement.setInt(1, n);
                preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                preparedStatement.addBatch();
            }
            if (i == 1) {
                for (n = 0; n < 10; ++n) {
                    object = this.connection.createStatement();
                    ResultSet resultSet = object.executeQuery("Select a from " + string2);
                }
                System.gc();
            }
            nArray = preparedStatement.executeBatch();
            preparedStatement.clearBatch();
            if (i == 0) {
                this.stmt.executeUpdate("ALTER TABLE " + string2 + " ADD CONSTRAINT A <=" + n2);
            }
            this.log.addDifference(string, "Check BatchUpdateCount length", new Integer(n2), new Integer(nArray.length));
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 1 || nArray[n] == -2) continue;
                this.log.addFailure(new Failure(string, "Unexpected update count: " + nArray[n]));
            }
        }
        ResultSet resultSet = this.stmt.executeQuery("Select a,b from " + string2);
        for (n = 0; n < n3 * n2; ++n) {
            if (!resultSet.next()) {
                this.log.addDifference(string, "Missing row " + n + " in Resultset", Boolean.TRUE, Boolean.FALSE);
                break;
            }
            this.log.addDifference(string, "Check Resultset", new Integer(n % n2 + 1), resultSet.getObject("a"));
            this.log.addDifference(string, "Check Resultset", new Long(byArray.length), new Long(resultSet.getBlob("b").length()));
            object = resultSet.getBytes("b");
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i] == (byte)(i % 10 & 0xFF)) continue;
                this.log.addFailure(new Failure("WRONG ARRAY:", Tracer.Hex2String((byte[])object)));
                this.log.addFailure(new Failure(string, "Invalid ByteArray Row:" + n + " BytePos:" + i + " value is: " + (int)object[i] + " instead of " + (byte)(i % 10 & 0xFF)));
            }
        }
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BatchLong batchLong = new BatchLong(stringArray);
        try {
            batchLong.runInner();
        }
        finally {
            batchLong.connection.close();
        }
        if (batchLong.log.hasErrors()) {
            System.exit(5);
        }
    }
}

