/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import com.sap.dbtechtest.jdbc.benchmark.AccessType;
import com.sap.dbtechtest.jdbc.benchmark.JavaUser;
import com.sap.dbtechtest.jdbc.benchmark.TP2;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class OriginalTp2JavaUser
extends JavaUser {
    protected static final String HISTORY_FILLER = "xxxxxxxxxxxxxxxxxxxxxxxxxx";
    protected static final String ACCOUNT_ADD = "1";
    protected int branchKey;
    private int branchKeySave;
    private int branchDecision;
    private int accountBranch;
    protected String tellerKeyStr;
    protected String accountKeyStr;
    private int branchRandom = 654321;
    private int accountRandom = 55;
    private int accountModulo = 100;
    private PreparedStatement updateAccount = null;
    private PreparedStatement selectAccount = null;
    private PreparedStatement insertHistory = null;
    private PreparedStatement updateTeller = null;
    private PreparedStatement updateBranch = null;
    private StringBuffer updateAccountSQL = null;
    private StringBuffer selectAccountSQL = null;
    private StringBuffer insertHistorySQL = null;
    private StringBuffer updateTellerSQL = null;
    private StringBuffer updateBranchSQL = null;
    private StringBuffer insertResultsSQL = null;
    private Statement stmtSQL = null;
    private CallableStatement stmtPlDBProc = null;
    private CallableStatement stmtCppDBProc = null;
    private boolean abort = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OriginalTp2JavaUser(int n, TP2 tP2) throws SQLException {
        super(n, tP2);
        for (int i = 0; i <= n * 500; ++i) {
            this.randomSuccessor();
        }
        if (tP2 == null) return;
        try {
            AccessType accessType = tP2.getAccessType();
            if (accessType.getTransacImpl() == 32) {
                if (accessType.getInterface() == 512) {
                    this.updateAccount = this.connection.prepareStatement("UPDATE account SET  account_value=account_value+? WHERE account_key = ?");
                    this.selectAccount = this.connection.prepareStatement("SELECT account_value FROM account WHERE account_key=?");
                    this.insertHistory = this.connection.prepareStatement("INSERT INTO history VALUES (?, ?, ?,?,?)");
                    this.updateTeller = this.connection.prepareStatement("UPDATE teller SET  teller_value=teller_value+? WHERE teller_key = ?");
                    this.updateBranch = this.connection.prepareStatement("UPDATE branch SET  branch_value=branch_value+? WHERE branch_key=?");
                    return;
                } else {
                    if (accessType.getInterface() != 768) throw new SQLException("Cannot initialize OriginalTp2JavaUser[" + this.getId() + "]:" + " AccessType '" + accessType.getCodeStr() + "' is not compatible.");
                    this.stmtSQL = this.connection.createStatement();
                    this.updateAccountSQL = new StringBuffer("UPDATE account SET account_value=account_value+1 WHERE account_key = 'XXXXXXXXXX'");
                    this.selectAccountSQL = new StringBuffer("SELECT account_value FROM account WHERE account_key='XXXXXXXXXX'");
                    this.insertHistorySQL = new StringBuffer("INSERT INTO history VALUES ('XXXXXXXXXX',1,'XXX','XXXX','xxxxxxxxxxxxxxxxxxxxxxxxxx')");
                    this.updateTellerSQL = new StringBuffer("UPDATE teller SET teller_value=teller_value+1 WHERE teller_key = 'XXXX'");
                    this.updateBranchSQL = new StringBuffer("UPDATE branch SET branch_value=branch_value+1 WHERE branch_key='XXX'");
                }
                return;
            } else if (accessType.getTransacImpl() == 0) {
                this.stmtPlDBProc = this.connection.prepareCall("CALL tp2_transac(?,?,?,?,?,?)");
                return;
            } else {
                if (accessType.getTransacImpl() != 16) return;
                this.stmtCppDBProc = this.connection.prepareCall("CALL tp2_transac_cpp(?,?,?,?,?,?)");
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new SQLException("Cannont initialize OriginalTp2JavaUser[" + this.getId() + "]" + sQLException.toString());
        }
    }

    protected void formatKey(StringBuffer stringBuffer, long l, int n, int n2) {
        stringBuffer.setCharAt(n + n2 - 1, Character.forDigit((int)(l % 10L), 10));
        for (int i = n2 - 2; i >= 0; --i) {
            stringBuffer.setCharAt(n + i, Character.forDigit((int)((double)l % Math.pow(10.0, n2 - i) / Math.pow(10.0, n2 - i - 1)), 10));
        }
    }

    protected void executeTransaction() throws SQLException {
        this.randomSuccessor();
        this.updateAccount.setString(1, ACCOUNT_ADD);
        this.updateAccount.setString(2, this.accountKeyStr);
        this.updateAccount.executeUpdate();
        this.selectAccount.setString(1, this.accountKeyStr);
        this.selectAccount.executeQuery();
        this.insertHistory.setString(1, this.accountKeyStr);
        this.insertHistory.setString(2, ACCOUNT_ADD);
        this.insertHistory.setString(3, Integer.toString(this.branchKey));
        this.insertHistory.setString(4, this.tellerKeyStr);
        this.insertHistory.setString(5, HISTORY_FILLER);
        this.insertHistory.executeUpdate();
        this.updateTeller.setString(1, ACCOUNT_ADD);
        this.updateTeller.setString(2, this.tellerKeyStr);
        this.updateTeller.executeUpdate();
        this.updateBranch.setString(1, ACCOUNT_ADD);
        this.updateBranch.setString(2, Integer.toString(this.branchKey));
        this.updateBranch.executeUpdate();
        this.connection.commit();
    }

    protected void executeTransactionPlDBProc() throws SQLException {
        this.randomSuccessor();
        this.stmtPlDBProc.setString(1, this.accountKeyStr);
        this.stmtPlDBProc.setString(2, ACCOUNT_ADD);
        this.stmtPlDBProc.setString(3, Long.toString(this.branchKey));
        this.stmtPlDBProc.setString(4, this.tellerKeyStr);
        this.stmtPlDBProc.setString(5, HISTORY_FILLER);
        this.stmtPlDBProc.registerOutParameter(6, 4);
        this.stmtPlDBProc.execute();
        this.connection.commit();
        int n = this.stmtPlDBProc.getInt(6);
        if (n != 0) {
            throw new SQLException("Return code of DBProc was " + n);
        }
    }

    protected void executeTransactionCppDBProc() throws SQLException {
        this.randomSuccessor();
        this.stmtCppDBProc.setString(1, this.accountKeyStr);
        this.stmtCppDBProc.setString(2, ACCOUNT_ADD);
        this.stmtCppDBProc.setString(3, Long.toString(this.branchKey));
        this.stmtCppDBProc.setString(4, this.tellerKeyStr);
        this.stmtCppDBProc.setString(5, HISTORY_FILLER);
        this.stmtCppDBProc.registerOutParameter(6, 4);
        this.stmtCppDBProc.execute();
        this.connection.commit();
        int n = this.stmtCppDBProc.getInt(5);
        if (n != 0) {
            throw new SQLException("Return code of DBProc was " + n);
        }
    }

    protected void randomSuccessor() {
        this.branchRandom = this.branchRandom * 421 + 683;
        this.branchKey = this.branchRandom % 1000;
        long l = this.branchRandom % 10000 / 1000;
        this.branchDecision = this.branchRandom % 1000000 / 10000;
        this.branchRandom %= 1000000;
        this.accountRandom = this.accountRandom * 421 + 683;
        int n = this.accountRandom / this.accountModulo;
        this.accountRandom -= n * this.accountModulo;
        this.tellerKeyStr = String.valueOf(l * 1000L + (long)this.branchKey);
        if (this.branchDecision < 85) {
            this.accountBranch = this.branchKey;
        } else {
            this.accountBranch = this.branchKeySave;
            this.branchKeySave = this.branchKey;
        }
        if (this.accountBranch == 0) {
            this.accountKeyStr = String.valueOf(this.accountRandom);
        } else {
            int n2 = this.accountRandom < 10 ? this.accountBranch * 100000 : this.accountBranch * 10000;
            this.accountKeyStr = String.valueOf(n2) + String.valueOf(this.accountRandom);
        }
    }

    public void runUser(int n) {
    }

    protected void closeSQL() {
        try {
            if (this.stmtSQL != null) {
                this.stmtSQL.close();
                this.stmtSQL = null;
            }
            if (this.stmtPlDBProc != null) {
                this.stmtPlDBProc.close();
                this.stmtPlDBProc = null;
            }
            if (this.stmtCppDBProc != null) {
                this.stmtCppDBProc.close();
                this.stmtCppDBProc = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

