/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class AccessType
implements Comparable {
    public static final int CPC_DIRECT = 0;
    public static final int CPC_VSERVER = 256;
    public static final int JDBC_NATIVE = 512;
    public static final int JDBC_SOCKET = 768;
    public static final int ODBC = 1024;
    public static final int SQLDBC = 1280;
    public static final int PL_DBPROC = 0;
    public static final int CPP_DBPROC = 16;
    public static final int STATEMENT = 32;
    public static final int SYSTEM = 0;
    public static final int JAVA = 1;
    private int mInterface = 0;
    private int transacImpl = 0;
    private int userImpl = 0;

    public static int convertStr2Interface(String string) throws SQLException {
        if (string.equals("CPC_DIRECT")) {
            return 0;
        }
        if (string.equals("CPC_VSERVER")) {
            return 256;
        }
        if (string.equals("JDBC_SOCKET")) {
            return 768;
        }
        if (string.equals("JDBC_NATIVE")) {
            return 512;
        }
        if (string.equals("ODBC")) {
            return 1024;
        }
        if (string.equals("SQLDBC")) {
            return 1280;
        }
        throw new SQLException("Undefined interface: " + string);
    }

    public static int convertStr2TransacImpl(String string) throws SQLException {
        if (string.equals("STATEMENT")) {
            return 32;
        }
        if (string.equals("PL_DBPROC")) {
            return 0;
        }
        if (string.equals("CPP_DBPROC")) {
            return 16;
        }
        throw new SQLException("Undefined transaction implementation: " + string);
    }

    public static int convertStr2UserImpl(String string) throws SQLException {
        if (string.equals("SYSTEM")) {
            return 0;
        }
        if (string.equals("JAVA")) {
            return 1;
        }
        throw new SQLException("Undefined user implementation: " + string);
    }

    public static String convertInterface2Str(int n) throws SQLException {
        if (n == 0) {
            return "CPC_DIRECT";
        }
        if (n == 256) {
            return "CPC_VSERVER";
        }
        if (n == 768) {
            return "JDBC_SOCKET";
        }
        if (n == 512) {
            return "JDBC_NATIVE";
        }
        if (n == 1024) {
            return "ODBC";
        }
        if (n == 1280) {
            return "SQLDBC";
        }
        throw new SQLException("String not defined for interface=" + n);
    }

    public static String convertTransacImpl2Str(int n) throws SQLException {
        if (n == 32) {
            return "STATEMENT";
        }
        if (n == 0) {
            return "PL_DBPROC";
        }
        if (n == 16) {
            return "CPP_DBPROC";
        }
        throw new SQLException("String not defined for transacImpl=" + n);
    }

    public static String convertUserImpl2Str(int n) throws SQLException {
        if (n == 0) {
            return "SYSTEM";
        }
        if (n == 1) {
            return "JAVA";
        }
        throw new SQLException("String not defined for userImpl=" + n);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new AccessType("CPC_DIRECT-CPP_DBPROC-SYSTEM").getCodeStr());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public AccessType(int n, int n2, int n3) throws SQLException {
        this.initFromCodes(n, n2, n3);
    }

    public AccessType(int n) throws SQLException {
        this.initFromCodes(n & 0xF00, n & 0xF0, n & 0xF);
    }

    public AccessType(String string, String string2, String string3) throws SQLException {
        this.initFromStr(string, string2, string3);
    }

    public AccessType(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SQLException("Access type code string (" + string + ") in bad format");
        }
        String string3 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SQLException("Access type code string (" + string + ") in bad format");
        }
        String string4 = stringTokenizer.nextToken();
        this.initFromStr(string2, string3, string4);
    }

    private void initFromStr(String string, String string2, String string3) throws SQLException {
        this.initFromCodes(AccessType.convertStr2Interface(string), AccessType.convertStr2TransacImpl(string2), AccessType.convertStr2UserImpl(string3));
    }

    private void initFromCodes(int n, int n2, int n3) throws SQLException {
        if (n == 768 || n == 512 ? n3 != 1 : n3 == 1) {
            throw new SQLException("Interface " + AccessType.convertInterface2Str(n) + " is not compatible with user " + AccessType.convertUserImpl2Str(n3));
        }
        this.mInterface = n;
        this.transacImpl = n2;
        this.userImpl = n3;
    }

    public String toString() {
        return this.getCodeStr();
    }

    public boolean equals(Object object) {
        if (object instanceof AccessType) {
            return ((AccessType)object).getCode() == this.getCode();
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof AccessType) {
            return this.getCode() - ((AccessType)object).getCode();
        }
        return 0;
    }

    public String getAsStaticWherePart(String string) {
        return string + ".user_type='" + this.getCodeStr() + "'";
    }

    public String getPreparedWherePart(String string) {
        return AccessType.getClassPreparedWherePart(string);
    }

    public static String getClassPreparedWherePart(String string) {
        return string + ".user_type=?";
    }

    public int setPeparedStatementValues(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, this.getCodeStr());
        return n + 1;
    }

    public int getInterface() {
        return this.mInterface;
    }

    public int getTransacImpl() {
        return this.transacImpl;
    }

    public int getUserImpl() {
        return this.userImpl;
    }

    public int getCode() {
        return this.mInterface | this.transacImpl | this.userImpl;
    }

    public String getInterfaceStr() {
        try {
            return AccessType.convertInterface2Str(this.mInterface);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public String getTransacImplStr() {
        try {
            return AccessType.convertTransacImpl2Str(this.mInterface);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public String getUserImplStr() {
        try {
            return AccessType.convertUserImpl2Str(this.mInterface);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public String getCodeStr() {
        try {
            return AccessType.convertInterface2Str(this.mInterface) + "-" + AccessType.convertTransacImpl2Str(this.transacImpl) + "-" + AccessType.convertUserImpl2Str(this.userImpl);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public String getDescription() {
        String string = "";
        if (this.userImpl == 0) {
            string = string + "Executable ";
        } else if (this.userImpl == 1) {
            string = string + "Java thread ";
        }
        string = string + "executing ";
        if (this.transacImpl == 32) {
            string = string + "statements ";
        } else if (this.transacImpl == 0) {
            string = string + "PL DB procedures ";
        } else if (this.transacImpl == 16) {
            string = string + "C++ DB procedures ";
        }
        string = string + "through ";
        if (this.mInterface == 0) {
            string = string + "CPC (direct) ";
        } else if (this.mInterface == 256) {
            string = string + "CPC (vserver) ";
        } else if (this.mInterface == 512) {
            string = string + "JDBC (native) ";
        } else if (this.mInterface == 768) {
            string = string + "JDBC (socket) ";
        } else if (this.mInterface == 1024) {
            string = string + "ODBC ";
        } else if (this.mInterface == 1280) {
            string = string + "SQLDBC ";
        }
        return string;
    }

    public boolean isSystemUser() {
        return this.userImpl == 0;
    }

    public boolean isCpcInterface() {
        return this.mInterface == 0 || this.mInterface == 256;
    }

    public boolean isJdbcInterface() {
        return this.mInterface == 768 || this.mInterface == 512;
    }
}

