/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XMLNSDecl;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.UnImplNode;
import org.apache.xpath.WhitespaceStrippingElementMatcher;
import org.apache.xpath.XPathContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ElemTemplateElement
extends UnImplNode
implements PrefixResolver,
Serializable,
SourceLocator,
WhitespaceStrippingElementMatcher {
    private int m_lineNumber;
    private int m_columnNumber;
    private boolean m_defaultSpace = true;
    private boolean m_hasTextLitOnly = false;
    protected boolean m_hasVariableDecl = false;
    private Vector m_declaredPrefixes;
    Vector m_prefixTable;
    protected int m_docOrderNumber = -1;
    protected ElemTemplateElement m_parentNode;
    ElemTemplateElement m_nextSibling;
    ElemTemplateElement m_firstChild;
    private transient Node m_DOMBackPointer;

    public boolean isCompiledTemplate() {
        return false;
    }

    public int getXSLToken() {
        return -1;
    }

    public String getNodeName() {
        return "Unknown XSLT Element";
    }

    public void runtimeInit(TransformerImpl transformer) throws TransformerException {
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
    }

    public StylesheetComposed getStylesheetComposed() {
        return this.m_parentNode.getStylesheetComposed();
    }

    public Stylesheet getStylesheet() {
        return this.m_parentNode.getStylesheet();
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_parentNode.getStylesheetRoot();
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        this.resolvePrefixTables();
        ElemTemplateElement t = this.getFirstChildElem();
        this.m_hasTextLitOnly = t != null && t.getXSLToken() == 78 && t.getNextSiblingElem() == null;
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        cstate.pushStackMark();
    }

    public void endCompose(StylesheetRoot sroot) throws TransformerException {
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        cstate.popStackMark();
    }

    protected boolean isValidNCName(String s) {
        int len = s.length();
        char c = s.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        if (len > 0) {
            int i = 1;
            while (i < len) {
                c = s.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void error(int msg, Object[] args) {
        String themsg = XSLMessages.createMessage(msg, args);
        this.error(XSLMessages.createMessage(19, new Object[]{themsg}));
    }

    public void error(int msg) {
        this.error(msg, null);
    }

    public void error(String msg) {
        throw new RuntimeException(msg);
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (null == newChild) {
            this.error(20, null);
        }
        ElemTemplateElement elem = (ElemTemplateElement)newChild;
        if (null == this.m_firstChild) {
            this.m_firstChild = elem;
        } else {
            ElemTemplateElement last = (ElemTemplateElement)this.getLastChild();
            last.m_nextSibling = elem;
        }
        elem.m_parentNode = this;
        return newChild;
    }

    public ElemTemplateElement appendChild(ElemTemplateElement elem) {
        if (null == elem) {
            this.error(20, null);
        }
        if (null == this.m_firstChild) {
            this.m_firstChild = elem;
        } else {
            ElemTemplateElement last = this.getLastChildElem();
            last.m_nextSibling = elem;
        }
        elem.setParentElem(this);
        return elem;
    }

    public boolean hasChildNodes() {
        return null != this.m_firstChild;
    }

    public short getNodeType() {
        return 1;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public ElemTemplateElement removeChild(ElemTemplateElement childETE) {
        if (childETE == null || childETE.m_parentNode != this) {
            return null;
        }
        if (childETE == this.m_firstChild) {
            this.m_firstChild = childETE.m_nextSibling;
        } else {
            ElemTemplateElement prev = childETE.getPreviousSiblingElem();
            prev.m_nextSibling = childETE.m_nextSibling;
        }
        childETE.m_parentNode = null;
        childETE.m_nextSibling = null;
        return childETE;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild == null || oldChild.getParentNode() != this) {
            return null;
        }
        ElemTemplateElement newChildElem = (ElemTemplateElement)newChild;
        ElemTemplateElement oldChildElem = (ElemTemplateElement)oldChild;
        ElemTemplateElement prev = (ElemTemplateElement)oldChildElem.getPreviousSibling();
        if (null != prev) {
            prev.m_nextSibling = newChildElem;
        }
        if (this.m_firstChild == oldChildElem) {
            this.m_firstChild = newChildElem;
        }
        newChildElem.m_parentNode = this;
        oldChildElem.m_parentNode = null;
        newChildElem.m_nextSibling = oldChildElem.m_nextSibling;
        oldChildElem.m_nextSibling = null;
        return newChildElem;
    }

    public ElemTemplateElement replaceChild(ElemTemplateElement newChildElem, ElemTemplateElement oldChildElem) {
        if (oldChildElem == null || oldChildElem.getParentElem() != this) {
            return null;
        }
        ElemTemplateElement prev = oldChildElem.getPreviousSiblingElem();
        if (null != prev) {
            prev.m_nextSibling = newChildElem;
        }
        if (this.m_firstChild == oldChildElem) {
            this.m_firstChild = newChildElem;
        }
        newChildElem.m_parentNode = this;
        oldChildElem.m_parentNode = null;
        newChildElem.m_nextSibling = oldChildElem.m_nextSibling;
        oldChildElem.m_nextSibling = null;
        return newChildElem;
    }

    public int getLength() {
        int count = 0;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            ++count;
            node = node.m_nextSibling;
        }
        return count;
    }

    public Node item(int index) {
        ElemTemplateElement node = this.m_firstChild;
        int i = 0;
        while (i < index && node != null) {
            node = node.m_nextSibling;
            ++i;
        }
        return node;
    }

    public Document getOwnerDocument() {
        return this.getStylesheet();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public boolean hasTextLitOnly() {
        return this.m_hasTextLitOnly;
    }

    public String getBaseIdentifier() {
        return this.getSystemId();
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public String getPublicId() {
        return null != this.m_parentNode ? this.m_parentNode.getPublicId() : null;
    }

    public String getSystemId() {
        return this.getStylesheet().getHref();
    }

    public void setLocaterInfo(SourceLocator locator) {
        this.m_lineNumber = locator.getLineNumber();
        this.m_columnNumber = locator.getColumnNumber();
    }

    public boolean hasVariableDecl() {
        return this.m_hasVariableDecl;
    }

    public void setXmlSpace(int v) {
        this.m_defaultSpace = 2 == v;
    }

    public boolean getXmlSpace() {
        return this.m_defaultSpace;
    }

    public Vector getDeclaredPrefixes() {
        return this.m_declaredPrefixes;
    }

    public void setPrefixes(NamespaceSupport nsSupport) throws TransformerException {
        this.setPrefixes(nsSupport, false);
    }

    public void setPrefixes(NamespaceSupport nsSupport, boolean excludeXSLDecl) throws TransformerException {
        Enumeration decls = nsSupport.getDeclaredPrefixes();
        while (decls.hasMoreElements()) {
            String prefix = (String)decls.nextElement();
            if (null == this.m_declaredPrefixes) {
                this.m_declaredPrefixes = new Vector();
            }
            String uri = nsSupport.getURI(prefix);
            if (excludeXSLDecl && uri.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            XMLNSDecl decl = new XMLNSDecl(prefix, uri, false);
            this.m_declaredPrefixes.addElement(decl);
        }
    }

    public String getNamespaceForPrefix(String prefix, Node context) {
        this.error(16, null);
        return null;
    }

    public String getNamespaceForPrefix(String prefix) {
        Vector nsDecls = this.m_declaredPrefixes;
        if (null != nsDecls) {
            int n = nsDecls.size();
            if (prefix.equals("#default")) {
                prefix = "";
            }
            int i = 0;
            while (i < n) {
                XMLNSDecl decl = (XMLNSDecl)nsDecls.elementAt(i);
                if (prefix.equals(decl.getPrefix())) {
                    return decl.getURI();
                }
                ++i;
            }
        }
        if (null != this.m_parentNode) {
            return this.m_parentNode.getNamespaceForPrefix(prefix);
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return null;
    }

    public Vector getPrefixes() {
        return this.m_prefixTable;
    }

    public boolean containsExcludeResultPrefix(String prefix, String uri) {
        ElemTemplateElement parent = this.getParentElem();
        if (null != parent) {
            return parent.containsExcludeResultPrefix(prefix, uri);
        }
        return false;
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        if (uri != null) {
            if (uri.equals("http://www.w3.org/1999/XSL/Transform") || this.getStylesheet().containsExtensionElementURI(uri) || uri.equals("http://xml.apache.org/xslt")) {
                return true;
            }
            if (this.containsExcludeResultPrefix(prefix, uri)) {
                return true;
            }
        }
        return false;
    }

    public void resolvePrefixTables() throws TransformerException {
        ElemTemplateElement parent;
        this.m_prefixTable = null;
        if (null != this.m_declaredPrefixes) {
            StylesheetRoot stylesheet = this.getStylesheetRoot();
            int n = this.m_declaredPrefixes.size();
            int i = 0;
            while (i < n) {
                NamespaceAlias nsAlias;
                XMLNSDecl decl = (XMLNSDecl)this.m_declaredPrefixes.elementAt(i);
                String prefix = decl.getPrefix();
                String uri = decl.getURI();
                if (null == uri) {
                    uri = "";
                }
                boolean shouldExclude = this.excludeResultNSDecl(prefix, uri);
                if (null == this.m_prefixTable) {
                    this.m_prefixTable = new Vector();
                }
                decl = null != (nsAlias = stylesheet.getNamespaceAliasComposed(uri)) ? new XMLNSDecl(nsAlias.getStylesheetPrefix(), nsAlias.getResultNamespace(), shouldExclude) : new XMLNSDecl(prefix, uri, shouldExclude);
                this.m_prefixTable.addElement(decl);
                ++i;
            }
        }
        if (null != (parent = this.getParentNodeElem())) {
            Vector prefixes = parent.m_prefixTable;
            if (null == this.m_prefixTable && !this.needToCheckExclude()) {
                this.m_prefixTable = parent.m_prefixTable;
            } else {
                int n = prefixes.size();
                int i = 0;
                while (i < n) {
                    XMLNSDecl decl = (XMLNSDecl)prefixes.elementAt(i);
                    boolean shouldExclude = this.excludeResultNSDecl(decl.getPrefix(), decl.getURI());
                    if (shouldExclude != decl.getIsExcluded()) {
                        decl = new XMLNSDecl(decl.getPrefix(), decl.getURI(), shouldExclude);
                    }
                    this.addOrReplaceDecls(decl);
                    ++i;
                }
            }
        } else if (null == this.m_prefixTable) {
            this.m_prefixTable = new Vector();
        }
    }

    void addOrReplaceDecls(XMLNSDecl newDecl) {
        int n = this.m_prefixTable.size();
        int i = n - 1;
        while (i >= 0) {
            XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
            if (decl.getPrefix().equals(newDecl.getPrefix())) {
                return;
            }
            --i;
        }
        this.m_prefixTable.addElement(newDecl);
    }

    boolean needToCheckExclude() {
        return false;
    }

    void executeNSDecls(TransformerImpl transformer) throws TransformerException {
        try {
            if (null != this.m_prefixTable) {
                ResultTreeHandler rhandler = transformer.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                int i = n - 1;
                while (i >= 0) {
                    XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
                    if (!decl.getIsExcluded()) {
                        rhandler.startPrefixMapping(decl.getPrefix(), decl.getURI(), true);
                    }
                    --i;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    void unexecuteNSDecls(TransformerImpl transformer) throws TransformerException {
        try {
            if (null != this.m_prefixTable) {
                ResultTreeHandler rhandler = transformer.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                int i = 0;
                while (i < n) {
                    XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
                    if (!decl.getIsExcluded()) {
                        rhandler.endPrefixMapping(decl.getPrefix());
                    }
                    ++i;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public void setUid(int i) {
        this.m_docOrderNumber = i;
    }

    public int getUid() {
        return this.m_docOrderNumber;
    }

    public Node getParentNode() {
        return this.m_parentNode;
    }

    public ElemTemplateElement getParentElem() {
        return this.m_parentNode;
    }

    public void setParentElem(ElemTemplateElement p) {
        this.m_parentNode = p;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public Node getPreviousSibling() {
        Node walker = this.getParentNode();
        Node prev = null;
        if (walker != null) {
            walker = walker.getFirstChild();
            while (walker != null) {
                if (walker == this) {
                    return prev;
                }
                prev = walker;
                walker = walker.getNextSibling();
            }
        }
        return null;
    }

    public ElemTemplateElement getPreviousSiblingElem() {
        ElemTemplateElement walker = this.getParentNodeElem();
        ElemTemplateElement prev = null;
        if (walker != null) {
            walker = walker.getFirstChildElem();
            while (walker != null) {
                if (walker == this) {
                    return prev;
                }
                prev = walker;
                walker = walker.getNextSiblingElem();
            }
        }
        return null;
    }

    public ElemTemplateElement getNextSiblingElem() {
        return this.m_nextSibling;
    }

    public ElemTemplateElement getParentNodeElem() {
        return this.m_parentNode;
    }

    public Node getFirstChild() {
        return this.m_firstChild;
    }

    public ElemTemplateElement getFirstChildElem() {
        return this.m_firstChild;
    }

    public Node getLastChild() {
        ElemTemplateElement lastChild = null;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            lastChild = node;
            node = node.m_nextSibling;
        }
        return lastChild;
    }

    public ElemTemplateElement getLastChildElem() {
        ElemTemplateElement lastChild = null;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            lastChild = node;
            node = node.m_nextSibling;
        }
        return lastChild;
    }

    public Node getDOMBackPointer() {
        return this.m_DOMBackPointer;
    }

    public void setDOMBackPointer(Node n) {
        this.m_DOMBackPointer = n;
    }

    public int compareTo(Object o) throws ClassCastException {
        ElemTemplateElement ro = (ElemTemplateElement)o;
        int roPrecedence = ro.getStylesheetComposed().getImportCountComposed();
        int myPrecedence = this.getStylesheetComposed().getImportCountComposed();
        if (myPrecedence < roPrecedence) {
            return -1;
        }
        if (myPrecedence > roPrecedence) {
            return 1;
        }
        return this.getUid() - ro.getUid();
    }

    public boolean shouldStripWhiteSpace(XPathContext support, Element targetElement) throws TransformerException {
        StylesheetRoot sroot = this.getStylesheetRoot();
        return null != sroot ? sroot.shouldStripWhiteSpace(support, targetElement) : false;
    }

    public boolean canStripWhiteSpace() {
        StylesheetRoot sroot = this.getStylesheetRoot();
        return null != sroot ? sroot.canStripWhiteSpace() : false;
    }
}

