/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.Hashtable;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final int EPSILON = -2;
    private static final int EOC = -3;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fMixed;
    private static String fEOCString = "<<CMNODE_EOC>>";
    private int fEOCPos = 0;
    private static String fEpsilonString = "<<CMNODE_EPSILON>>";
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private Object fElementDecl = new Object();
    private static long time;

    public XSDFACM(CMNode syntaxTree, int leafCount) {
        this(syntaxTree, leafCount, false);
    }

    public XSDFACM(CMNode syntaxTree, int leafCount, boolean mixed) {
        this.fLeafCount = leafCount;
        this.fMixed = mixed;
        this.buildDFA(syntaxTree);
    }

    public boolean isFinalState(int state) {
        return state < 0 ? false : this.fFinalStateFlags[state];
    }

    public Object oneTransition(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler) {
        int curState = state[0];
        if (curState == -1 || curState == -2) {
            if (curState == -1) {
                state[0] = -2;
            }
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        int nextState = 0;
        int elemIndex = 0;
        Object matchingDecl = null;
        while (elemIndex < this.fElemMapSize) {
            int type = this.fElemMapType[elemIndex];
            if (type == 1) {
                matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                if (matchingDecl != null && (nextState = this.fTransTable[curState][elemIndex]) != -1) {
                    break;
                }
            } else if (type == 2 && ((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) {
                matchingDecl = this.fElemMap[elemIndex];
                nextState = this.fTransTable[curState][elemIndex];
                if (nextState != -1) break;
            }
            ++elemIndex;
        }
        if (elemIndex == this.fElemMapSize) {
            state[0] = -1;
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        state[0] = nextState;
        return matchingDecl;
    }

    Object findMatchingDecl(QName curElem, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int type = this.fElemMapType[elemIndex];
            if (type == 1) {
                matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                if (matchingDecl != null) {
                    return matchingDecl;
                }
            } else if (type == 2 && ((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) {
                return this.fElemMap[elemIndex];
            }
            ++elemIndex;
        }
        return null;
    }

    public int[] startContentModel() {
        int[] val = new int[]{0};
        return val;
    }

    public boolean endContentModel(int[] state) {
        return this.fFinalStateFlags[state[0]];
    }

    private void buildDFA(CMNode syntaxTree) {
        this.fElementDecl = new XSElementDecl();
        ((XSElementDecl)this.fElementDecl).fName = fEOCString;
        XSCMLeaf nodeEOC = new XSCMLeaf((XSElementDecl)this.fElementDecl);
        this.fHeadNode = new XSCMBinOp(4, syntaxTree, nodeEOC);
        this.fEOCPos = this.fLeafCount;
        nodeEOC.setPosition(this.fLeafCount++);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int index = 0;
        while (index < this.fLeafCount) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
            ++index;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int outIndex = 0;
        while (outIndex < this.fLeafCount) {
            this.fElemMap[outIndex] = null;
            int inIndex = 0;
            Object decl = this.fLeafList[outIndex].getDecl();
            if (this.fLeafListType[outIndex] == 2) {
                while (inIndex < this.fElemMapSize) {
                    if (decl != this.fElemMap[inIndex]) {
                        ++inIndex;
                        continue;
                    }
                    break;
                }
            } else {
                XSElementDecl element = (XSElementDecl)decl;
                while (inIndex < this.fElemMapSize) {
                    if (this.fElemMapType[inIndex] != this.fLeafListType[outIndex] || ((XSElementDecl)this.fElemMap[inIndex]).fTargetNamespace != element.fTargetNamespace || ((XSElementDecl)this.fElemMap[inIndex]).fName != element.fName) {
                        ++inIndex;
                        continue;
                    }
                    break;
                }
            }
            if (inIndex == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize] = decl;
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[outIndex];
                ++this.fElemMapSize;
            }
            ++outIndex;
        }
        --this.fElemMapSize;
        int[] fLeafSorter = new int[this.fLeafCount + this.fElemMapSize];
        int fSortCount = 0;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            Object decl = this.fElemMap[elemIndex];
            int leafIndex = 0;
            while (leafIndex < this.fLeafCount) {
                if (this.fElemMapType[elemIndex] == this.fLeafListType[leafIndex]) {
                    if (this.fLeafListType[leafIndex] == 2) {
                        if (decl == this.fLeafList[leafIndex].getDecl()) {
                            fLeafSorter[fSortCount++] = leafIndex;
                        }
                    } else {
                        XSElementDecl leaf = (XSElementDecl)this.fLeafList[leafIndex].getDecl();
                        XSElementDecl element = (XSElementDecl)decl;
                        if (leaf.fTargetNamespace == element.fTargetNamespace && leaf.fName == element.fName) {
                            fLeafSorter[fSortCount++] = leafIndex;
                        }
                    }
                }
                ++leafIndex;
            }
            fLeafSorter[fSortCount++] = -1;
            ++elemIndex;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        Hashtable<CMStateSet, Integer> stateTable = new Hashtable<CMStateSet, Integer>();
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(this.fEOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int sorterIndex = 0;
            int elemIndex2 = 0;
            while (elemIndex2 < this.fElemMapSize) {
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = fLeafSorter[sorterIndex++];
                while (leafIndex != -1) {
                    if (setT.getBit(leafIndex)) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    leafIndex = fLeafSorter[sorterIndex++];
                }
                if (!newSet.isEmpty()) {
                    int stateIndex;
                    Integer stateObj = (Integer)stateTable.get(newSet);
                    int n = stateIndex = stateObj == null ? curState : stateObj;
                    if (stateIndex == curState) {
                        statesToDo[curState] = newSet;
                        this.fTransTable[curState] = this.makeDefStateList();
                        stateTable.put(newSet, new Integer(curState));
                        ++curState;
                        newSet = null;
                    }
                    transEntry[elemIndex2] = stateIndex;
                    if (curState == curArraySize) {
                        int newSize = (int)((double)curArraySize * 1.5);
                        CMStateSet[] newToDo = new CMStateSet[newSize];
                        boolean[] newFinalFlags = new boolean[newSize];
                        int[][] newTransTable = new int[newSize][];
                        int expIndex = 0;
                        while (expIndex < curArraySize) {
                            newToDo[expIndex] = statesToDo[expIndex];
                            newFinalFlags[expIndex] = this.fFinalStateFlags[expIndex];
                            newTransTable[expIndex] = this.fTransTable[expIndex];
                            ++expIndex;
                        }
                        curArraySize = newSize;
                        statesToDo = newToDo;
                        this.fFinalStateFlags = newFinalFlags;
                        this.fTransTable = newTransTable;
                    }
                }
                ++elemIndex2;
            }
        }
        this.fEmptyContentIsValid = ((XSCMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode nodeCur) {
        if (nodeCur.type() == 3) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 4) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
            CMStateSet last = ((XSCMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((XSCMBinOp)nodeCur).getRight().firstPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 7 || nodeCur.type() == 8) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 6) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
        }
    }

    private void dumpTree(CMNode nodeCur, int level) {
        int index = 0;
        while (index < level) {
            System.out.print("   ");
            ++index;
        }
        int type = nodeCur.type();
        switch (type) {
            case 3: 
            case 4: {
                if (type == 3) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMBinOp)nodeCur).getLeft(), level + 1);
                this.dumpTree(((XSCMBinOp)nodeCur).getRight(), level + 1);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                System.out.print("Rep Node ");
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMUniOp)nodeCur).getChild(), level + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)nodeCur).getPosition() + "), " + ((XSCMLeaf)nodeCur).getDecl() + "(elemIndex=" + ((XSCMLeaf)nodeCur).getDecl() + ") ");
                if (nodeCur.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fElemMapSize];
        int index = 0;
        while (index < this.fElemMapSize) {
            retArray[index] = -1;
            ++index;
        }
        return retArray;
    }

    private int postTreeBuildInit(CMNode nodeCur, int curIndex) throws RuntimeException {
        nodeCur.setMaxStates(this.fLeafCount);
        if (nodeCur.type() == 2) {
            this.fElementDecl = ((XSCMLeaf)nodeCur).getDecl();
            this.fLeafList[curIndex] = (XSCMLeaf)nodeCur;
            this.fLeafListType[curIndex] = 2;
            ++curIndex;
        } else if (nodeCur.type() == 3 || nodeCur.type() == 4) {
            curIndex = this.postTreeBuildInit(((XSCMBinOp)nodeCur).getLeft(), curIndex);
            curIndex = this.postTreeBuildInit(((XSCMBinOp)nodeCur).getRight(), curIndex);
        } else if (nodeCur.type() == 7 || nodeCur.type() == 8 || nodeCur.type() == 6) {
            curIndex = this.postTreeBuildInit(((XSCMUniOp)nodeCur).getChild(), curIndex);
        } else if (nodeCur.type() == 1) {
            XSElementDecl elementDecl = (XSElementDecl)((XSCMLeaf)nodeCur).getDecl();
            if (elementDecl.fName != fEpsilonString) {
                this.fLeafList[curIndex] = (XSCMLeaf)nodeCur;
                this.fLeafListType[curIndex] = 1;
                ++curIndex;
            }
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
        return curIndex;
    }

    static {
        fEpsilonString = fEpsilonString.intern();
        fEOCString = fEOCString.intern();
        time = 0L;
    }
}

