/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;

public class XSCMLeaf
extends CMNode {
    private Object fElement = null;
    private int fPosition = -1;

    public XSCMLeaf(int type, Object element, int position) {
        super(type);
        this.fElement = element;
        this.fPosition = position;
    }

    public XSCMLeaf(XSElementDecl element) {
        super(1);
        this.fElement = element;
    }

    final Object getDecl() {
        return this.fElement;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int newPosition) {
        this.fPosition = newPosition;
    }

    public boolean isNullable() {
        return this.fPosition == -1;
    }

    public String toString() {
        StringBuffer strRet = new StringBuffer(this.fElement.toString());
        strRet.append(" (");
        if (this.type() == 1) {
            strRet.append(((XSElementDecl)this.fElement).fTargetNamespace);
            strRet.append(',');
            strRet.append(((XSElementDecl)this.fElement).fName);
        } else {
            strRet.append("##any:uri=");
            strRet.append(((XSWildcardDecl)this.fElement).fNamespaceList[0]);
        }
        strRet.append(')');
        if (this.fPosition >= 0) {
            strRet.append(" (Pos:" + new Integer(this.fPosition).toString() + ")");
        }
        return strRet.toString();
    }

    protected void calcFirstPos(CMStateSet toSet) {
        if (this.fPosition == -1) {
            toSet.zeroBits();
        } else {
            toSet.setBit(this.fPosition);
        }
    }

    protected void calcLastPos(CMStateSet toSet) {
        if (this.fPosition == -1) {
            toSet.zeroBits();
        } else {
            toSet.setBit(this.fPosition);
        }
    }
}

