/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDDatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarResolver;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLEntityResolver;

public class XMLSchemaValidator
implements XMLComponent,
XMLDocumentFilter,
FieldActivator {
    private static final boolean DEBUG = false;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic"};
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager"};
    protected boolean fSeenRoot = false;
    protected boolean fNamespaces = false;
    protected boolean fValidation = false;
    protected boolean fDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = null;
    protected XMLDocumentHandler fDocumentHandler;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;
    final XSGrammarResolver fGrammarResolver;
    final SubstitutionGroupHandler fSubGroupHandler;
    final XSDHandler fSchemaHandler;
    final NamespaceSupport fNamespaceSupport = new NamespaceSupport();
    boolean fPushForNextBinding;
    final DatatypeValidator fQNameDV = (DatatypeValidator)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    final CMBuilder fCMBuilder = new CMBuilder(new XSDeclarationPool());
    int fSkipValidationDepth;
    int fElementDepth;
    int fChildCount;
    int[] fChildCountStack = new int[8];
    XSElementDecl fCurrentElemDecl;
    XSElementDecl[] fElemDeclStack = new XSElementDecl[8];
    boolean fNil;
    boolean[] fNilStack = new boolean[8];
    XSTypeDecl fCurrentType;
    XSTypeDecl[] fTypeStack = new XSTypeDecl[8];
    XSCMValidator fCurrentCM;
    XSCMValidator[] fCMStack = new XSCMValidator[8];
    int[] fCurrCMState;
    int[][] fCMStateStack = new int[8][];
    final StringBuffer fBuffer = new StringBuffer();
    boolean fSawCharacters = false;
    boolean[] fStringContent = new boolean[8];
    final Hashtable fTableOfIDs = new Hashtable();
    final Hashtable fTableOfIDRefs = new Hashtable();
    final QName fTempQName = new QName();
    static final Object fTempObject = new Object();
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void startDocument(XMLLocator locator, String encoding) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(locator, encoding);
        }
        if (this.fValidation) {
            this.fValueStoreCache.startDocument();
        }
    }

    public void xmlDecl(String version, String encoding, String standalone) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(version, encoding, standalone);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws XNIException {
        this.handleStartPrefix(prefix, uri);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void startElement(QName element, XMLAttributes attributes) throws XNIException {
        this.handleStartElement(element, attributes);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(element, attributes);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes) throws XNIException {
        this.handleStartElement(element, attributes);
        this.handleEndElement(element);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.emptyElement(element, attributes);
        }
    }

    public void characters(XMLString text) throws XNIException {
        boolean allWhiteSpace = true;
        int i = text.offset;
        while (i < text.offset + text.length) {
            if (!XMLChar.isSpace(text.ch[i])) {
                allWhiteSpace = false;
                break;
            }
            ++i;
        }
        this.fBuffer.append(text.toString());
        if (!allWhiteSpace) {
            this.fSawCharacters = true;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(text);
        }
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        int count = this.fMatcherStack.getMatcherCount();
        int i2 = 0;
        while (i2 < count) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i2);
            matcher.characters(text);
            ++i2;
        }
    }

    public void ignorableWhitespace(XMLString text) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(text);
        }
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        int count = this.fMatcherStack.getMatcherCount();
        int i = 0;
        while (i < count) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.characters(text);
            ++i;
        }
    }

    public void endElement(QName element) throws XNIException {
        this.handleEndElement(element);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(element);
        }
    }

    public void endPrefixMapping(String prefix) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(prefix);
        }
    }

    public void startCDATA() throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA();
        }
    }

    public void endCDATA() throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA();
        }
    }

    public void endDocument() throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument();
        }
        if (this.fValidation) {
            this.fValueStoreCache.endDocument();
        }
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startEntity(name, publicId, systemId, baseSystemId, encoding);
        }
    }

    public void textDecl(String version, String encoding) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(version, encoding);
        }
    }

    public void comment(XMLString text) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(text);
        }
    }

    public void processingInstruction(String target, XMLString data) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(target, data);
        }
    }

    public void endEntity(String name) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endEntity(name);
        }
    }

    public XMLSchemaValidator() {
        this.fGrammarResolver = new XSGrammarResolver();
        this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarResolver);
        this.fSchemaHandler = new XSDHandler(this.fGrammarResolver, this.fSubGroupHandler);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        SymbolTable symbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        if (symbolTable != this.fSymbolTable) {
            this.XMLNS = symbolTable.addSymbol("xmlns");
            this.URI_XSI = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
            this.XSI_SCHEMALOCATION = symbolTable.addSymbol("schemaLocation");
            this.XSI_NONAMESPACESCHEMALOCATION = symbolTable.addSymbol("noNamespaceSchemaLocation");
            this.XSI_TYPE = symbolTable.addSymbol("type");
            this.XSI_NIL = symbolTable.addSymbol("nil");
            this.URI_SCHEMAFORSCHEMA = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
        }
        this.fSymbolTable = symbolTable;
        try {
            this.fNamespaces = componentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException e) {
            this.fNamespaces = true;
        }
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fValidation = componentManager.getFeature(SCHEMA_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fDynamicValidation = componentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fDynamicValidation = false;
        }
        this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_MANAGER);
        this.fNamespaceSupport.reset(this.fSymbolTable);
        this.fPushForNextBinding = true;
        this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.reset();
        this.fGrammarResolver.reset();
        this.fGrammarResolver.putGrammar(this.URI_SCHEMAFORSCHEMA, SchemaGrammar.SG_SchemaNS);
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable);
        this.fCurrentElemDecl = null;
        this.fNil = false;
        this.fCurrentType = null;
        this.fCurrentCM = null;
        this.fCurrCMState = null;
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        this.fSkipValidationDepth = -1;
        this.fElementDepth = -1;
        this.fChildCount = 0;
        this.fTableOfIDs.clear();
        this.fTableOfIDRefs.clear();
        this.fMatcherStack.clear();
        this.fValueStoreCache = new ValueStoreCache();
    }

    void ensureStackCapacity() {
        if (this.fElementDepth == this.fElemDeclStack.length) {
            int newSize = this.fElementDepth + 8;
            int[] newArrayI = new int[newSize];
            System.arraycopy(this.fChildCountStack, 0, newArrayI, 0, this.fElementDepth);
            this.fChildCountStack = newArrayI;
            XSElementDecl[] newArrayE = new XSElementDecl[newSize];
            System.arraycopy(this.fElemDeclStack, 0, newArrayE, 0, this.fElementDepth);
            this.fElemDeclStack = newArrayE;
            boolean[] newArrayB = new boolean[newSize];
            System.arraycopy(this.fNilStack, 0, newArrayB, 0, this.fElementDepth);
            this.fNilStack = newArrayB;
            XSTypeDecl[] newArrayT = new XSTypeDecl[newSize];
            System.arraycopy(this.fTypeStack, 0, newArrayT, 0, this.fElementDepth);
            this.fTypeStack = newArrayT;
            XSCMValidator[] newArrayC = new XSCMValidator[newSize];
            System.arraycopy(this.fCMStack, 0, newArrayC, 0, this.fElementDepth);
            this.fCMStack = newArrayC;
            boolean[] newArrayD = new boolean[newSize];
            System.arraycopy(this.fStringContent, 0, newArrayD, 0, this.fElementDepth);
            this.fStringContent = newArrayD;
            int[][] newArrayIA = new int[newSize][];
            System.arraycopy(this.fCMStateStack, 0, newArrayIA, 0, this.fElementDepth);
            this.fCMStateStack = newArrayIA;
        }
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        int i = 0;
        while (i < identityConstraint.getFieldCount()) {
            Field field = identityConstraint.getFieldAt(i);
            ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field);
            valueStore.startValueScope();
            ++i;
        }
    }

    public XPathMatcher activateField(Field field) throws XNIException {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field);
        field.setMayMatch(true);
        XPathMatcher matcher = field.createMatcher(valueStore);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fSymbolTable);
        return matcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint);
        valueStore.endValueScope();
    }

    private void activateSelectorFor(IdentityConstraint ic) throws XNIException {
        Selector selector = ic.getSelector();
        XMLSchemaValidator activator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher matcher = selector.createMatcher(activator);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fSymbolTable);
    }

    void handleStartElement(QName element, XMLAttributes attributes) {
        String xsiType;
        SchemaGrammar sGrammar;
        XSComplexTypeDecl ctype;
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
        } else {
            this.fPushForNextBinding = true;
        }
        if (this.fElementDepth == -1) {
            this.fDoValidation = this.fValidation && !this.fValidationManager.isGrammarFound() && !this.fDynamicValidation;
            this.fValidationState = this.fValidationManager.getValidationState();
            this.fValidationState.setNamespaceSupport(this.fNamespaceSupport);
            this.fValidationState.setSymbolTable(this.fSymbolTable);
        }
        String sLocation = attributes.getValue(this.URI_XSI, this.XSI_SCHEMALOCATION);
        String nsLocation = attributes.getValue(this.URI_XSI, this.XSI_NONAMESPACESCHEMALOCATION);
        if (sLocation != null) {
            StringTokenizer t = new StringTokenizer(sLocation, " \n\t\r");
            while (t.hasMoreTokens()) {
                String namespace = t.nextToken();
                if (!t.hasMoreTokens()) break;
                String location = t.nextToken();
                if (this.fGrammarResolver.getGrammar(namespace) != null) continue;
                this.fSchemaHandler.parseSchema(namespace, location);
            }
        }
        if (nsLocation != null && this.fGrammarResolver.getGrammar(null) == null) {
            this.fSchemaHandler.parseSchema(null, nsLocation);
        }
        if (sLocation != null || nsLocation != null) {
            this.fDoValidation = this.fValidation;
        }
        if (this.fSkipValidationDepth >= 0) {
            ++this.fElementDepth;
            return;
        }
        if (this.fElementDepth != -1) {
            this.ensureStackCapacity();
            this.fChildCountStack[this.fElementDepth] = this.fChildCount + 1;
            this.fChildCount = 0;
            this.fElemDeclStack[this.fElementDepth] = this.fCurrentElemDecl;
            this.fNilStack[this.fElementDepth] = this.fNil;
            this.fTypeStack[this.fElementDepth] = this.fCurrentType;
            this.fCMStack[this.fElementDepth] = this.fCurrentCM;
            this.fStringContent[this.fElementDepth] = this.fSawCharacters;
        }
        this.fCurrentElemDecl = null;
        this.fNil = false;
        XSWildcardDecl wildcard = null;
        if (this.fCurrentCM != null) {
            Object decl = this.fCurrentCM.oneTransition(element, this.fCurrCMState, this.fSubGroupHandler);
            if (this.fCurrCMState[0] == -1 && this.fDoValidation) {
                ctype = (XSComplexTypeDecl)this.fCurrentType;
                if (ctype.fParticle != null) {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{element.rawname, ctype.fParticle.toString()});
                } else {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{element.rawname, "mixed with no element content"});
                }
            }
            if (decl != null) {
                if (decl instanceof XSElementDecl) {
                    this.fCurrentElemDecl = (XSElementDecl)decl;
                } else {
                    wildcard = (XSWildcardDecl)decl;
                }
            }
        }
        if (this.fElementDepth != -1) {
            this.fCMStateStack[this.fElementDepth] = this.fCurrCMState;
        }
        ++this.fElementDepth;
        if (wildcard != null && wildcard.fProcessContents == 2) {
            this.fSkipValidationDepth = this.fElementDepth;
            return;
        }
        if (this.fCurrentElemDecl == null && (sGrammar = this.fGrammarResolver.getGrammar(element.uri)) != null) {
            this.fCurrentElemDecl = sGrammar.getGlobalElementDecl(element.localpart);
        }
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.isAbstract()) {
            this.reportSchemaError("cvc-elt.2", new Object[]{element.rawname});
        }
        this.fCurrentType = null;
        if (this.fCurrentElemDecl != null) {
            this.fCurrentType = this.fCurrentElemDecl.fType;
        }
        if ((xsiType = attributes.getValue(this.URI_XSI, this.XSI_TYPE)) != null) {
            this.getAndCheckXsiType(element, xsiType);
        }
        if (this.fCurrentType != null && this.fCurrentType.getXSType() == 1 && (ctype = (XSComplexTypeDecl)this.fCurrentType).isAbstractType()) {
            this.reportSchemaError("cvc-type.2", new Object[]{"Element " + element.rawname + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type"});
        }
        if (this.fCurrentType == null) {
            if (this.fDoValidation) {
                if (this.fElementDepth == 0) {
                    this.reportSchemaError("cvc-elt.1", new Object[]{element.rawname});
                } else if (wildcard != null && wildcard.fProcessContents == 0) {
                    this.reportSchemaError("cvc-complex-type.2.4.c", new Object[]{element.rawname});
                }
            }
            this.fSkipValidationDepth = this.fElementDepth;
            return;
        }
        this.fCurrentCM = null;
        if (this.fCurrentType != null && this.fCurrentType.getXSType() == 1) {
            this.fCurrentCM = ((XSComplexTypeDecl)this.fCurrentType).getContentModel(this.fCMBuilder);
        }
        this.fCurrCMState = null;
        if (this.fCurrentCM != null) {
            this.fCurrCMState = this.fCurrentCM.startContentModel();
        }
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        String xsiNil = attributes.getValue(this.URI_XSI, this.XSI_NIL);
        if (xsiNil != null) {
            this.getXsiNil(element, xsiNil);
        }
        XSAttributeGroupDecl attrGrp = null;
        if (this.fCurrentType.getXSType() == 1) {
            XSComplexTypeDecl ctype2 = (XSComplexTypeDecl)this.fCurrentType;
            attrGrp = ctype2.fAttrGrp;
        }
        this.processAttributes(element, attributes, attrGrp);
        if (this.fDoValidation) {
            this.fValueStoreCache.startElement();
            this.fMatcherStack.pushContext();
            if (this.fCurrentElemDecl != null) {
                this.fValueStoreCache.initValueStoresFor(this.fCurrentElemDecl);
                int icCount = this.fCurrentElemDecl.fIDCPos;
                int uniqueOrKey = 0;
                while (uniqueOrKey < icCount) {
                    if (this.fCurrentElemDecl.fIDConstraints[uniqueOrKey].getType() == 2) break;
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[uniqueOrKey]);
                    ++uniqueOrKey;
                }
                int keyref = uniqueOrKey;
                while (keyref < icCount) {
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[keyref]);
                    ++keyref;
                }
            }
            int count = this.fMatcherStack.getMatcherCount();
            int i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.startElement(element, attributes, this.fCurrentElemDecl);
                ++i;
            }
        }
    }

    void handleEndElement(QName element) {
        this.fNamespaceSupport.popContext();
        if (this.fSkipValidationDepth >= 0) {
            if (this.fSkipValidationDepth == this.fElementDepth && this.fSkipValidationDepth > 0) {
                this.fSkipValidationDepth = -1;
                --this.fElementDepth;
                this.fChildCount = this.fChildCountStack[this.fElementDepth];
                this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
                this.fNil = this.fNilStack[this.fElementDepth];
                this.fCurrentType = this.fTypeStack[this.fElementDepth];
                this.fCurrentCM = this.fCMStack[this.fElementDepth];
                this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
                this.fSawCharacters = this.fStringContent[this.fElementDepth];
            } else {
                --this.fElementDepth;
            }
            return;
        }
        this.processElementContent(element);
        int oldCount = this.fMatcherStack.getMatcherCount();
        int i = oldCount - 1;
        while (i >= 0) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.endElement(element, this.fCurrentElemDecl);
            --i;
        }
        if (this.fMatcherStack.size() > 0) {
            this.fMatcherStack.popContext();
        }
        int newCount = this.fMatcherStack.getMatcherCount();
        int i2 = oldCount - 1;
        while (i2 >= newCount) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i2);
            IdentityConstraint id = matcher.getIDConstraint();
            if (id != null && id.getType() != 2) {
                matcher.endDocumentFragment();
                this.fValueStoreCache.transplant(id);
            } else if (id == null) {
                matcher.endDocumentFragment();
            }
            --i2;
        }
        int i3 = oldCount - 1;
        while (i3 >= newCount) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i3);
            IdentityConstraint id = matcher.getIDConstraint();
            if (id != null && id.getType() == 2) {
                ValueStoreBase values = this.fValueStoreCache.getValueStoreFor(id);
                if (values != null) {
                    values.endDocumentFragment();
                }
                matcher.endDocumentFragment();
            }
            --i3;
        }
        this.fValueStoreCache.endElement();
        --this.fElementDepth;
        if (this.fElementDepth == -1) {
            if (this.fDoValidation && !this.fValidationState.checkIDRefID()) {
                this.reportSchemaError("ValidationRoot", null);
            }
        } else {
            this.fChildCount = this.fChildCountStack[this.fElementDepth];
            this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
            this.fNil = this.fNilStack[this.fElementDepth];
            this.fCurrentType = this.fTypeStack[this.fElementDepth];
            this.fCurrentCM = this.fCMStack[this.fElementDepth];
            this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
            this.fSawCharacters = this.fStringContent[this.fElementDepth];
        }
    }

    void handleStartPrefix(String prefix, String uri) {
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
            this.fPushForNextBinding = false;
        }
        this.fNamespaceSupport.declarePrefix(prefix, uri.length() != 0 ? uri : null);
    }

    void getAndCheckXsiType(QName element, String xsiType) {
        QName typeName = null;
        try {
            this.fQNameDV.validate(xsiType, this.fValidationState);
            String prefix = this.fSchemaHandler.EMPTY_STRING;
            String localpart = xsiType;
            int colonptr = xsiType.indexOf(":");
            if (colonptr > 0) {
                prefix = this.fSymbolTable.addSymbol(xsiType.substring(0, colonptr));
                localpart = xsiType.substring(colonptr + 1);
            }
            String uri = this.fNamespaceSupport.getURI(prefix);
            typeName = new QName(prefix, localpart, xsiType, uri);
        }
        catch (InvalidDatatypeValueException e) {
            this.reportSchemaError("cvc-elt.4.1", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_TYPE, xsiType});
            return;
        }
        XSTypeDecl type = null;
        SchemaGrammar grammar = this.fGrammarResolver.getGrammar(typeName.uri);
        if (grammar != null) {
            type = grammar.getGlobalTypeDecl(typeName.localpart);
        }
        if (type == null) {
            this.reportSchemaError("cvc-elt.4.2", new Object[]{element.rawname, xsiType});
            return;
        }
        if (this.fCurrentType != null) {
            int block = this.fCurrentElemDecl.fBlock;
            if (this.fCurrentType.getXSType() == 1) {
                block |= ((XSComplexTypeDecl)this.fCurrentType).fBlock;
            }
            if (!XSConstraints.checkTypeDerivationOk(type, this.fCurrentType, block)) {
                this.reportSchemaError("cvc-elt.4.3", new Object[]{element.rawname, xsiType});
            }
        }
        this.fCurrentType = type;
    }

    void getXsiNil(QName element, String xsiNil) {
        if (this.fCurrentElemDecl != null && !this.fCurrentElemDecl.isNillable()) {
            this.reportSchemaError("cvc-elt.3.1", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_NIL});
        }
        if (xsiNil.equals("true") || xsiNil.equals("1")) {
            this.fNil = true;
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                this.reportSchemaError("cvc-elt.3.2.2", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_NIL});
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void processAttributes(QName element, XMLAttributes attributes, XSAttributeGroupDecl attrGrp) {
        if (attrGrp != null) {
            this.addDefaultAttributes(element, attributes, attrGrp);
        }
        if (!this.fDoValidation) {
            return;
        }
        if (this.fCurrentType == null || this.fCurrentType.getXSType() == 2) {
            attCount = attributes.getLength();
            index = 0;
            while (index < attCount) {
                attributes.getName(index, this.fTempQName);
                if (this.fTempQName.uri == this.URI_XSI) {
                    if (this.fTempQName.localpart != this.XSI_SCHEMALOCATION && this.fTempQName.localpart != this.XSI_NONAMESPACESCHEMALOCATION && this.fTempQName.localpart != this.XSI_NIL && this.fTempQName.localpart != this.XSI_TYPE) {
                        this.reportSchemaError("cvc-type.3.1.1", new Object[]{element.rawname});
                    }
                } else if (this.fTempQName.rawname != this.XMLNS && !this.fTempQName.rawname.startsWith("xmlns:")) {
                    this.reportSchemaError("cvc-type.3.1.1", new Object[]{element.rawname});
                }
                ++index;
            }
            return;
        }
        attrUses = attrGrp.getAttributeUses();
        useCount = attrUses.length;
        attrWildcard = attrGrp.fAttributeWC;
        wildcardIDName = null;
        attCount = attributes.getLength();
        index = 0;
        while (index < attCount) {
            block25: {
                block27: {
                    block26: {
                        attributes.getName(index, this.fTempQName);
                        if (this.fTempQName.uri == this.URI_XSI ? this.fTempQName.localpart == this.XSI_SCHEMALOCATION || this.fTempQName.localpart == this.XSI_NONAMESPACESCHEMALOCATION || this.fTempQName.localpart == this.XSI_NIL || this.fTempQName.localpart == this.XSI_TYPE : this.fTempQName.rawname == this.XMLNS || this.fTempQName.rawname.startsWith("xmlns:") != false) break block25;
                        currUse = null;
                        i = 0;
                        while (i < useCount) {
                            if (attrUses[i].fAttrDecl.fName == this.fTempQName.localpart && attrUses[i].fAttrDecl.fTargetNamespace == this.fTempQName.uri) {
                                currUse = attrUses[i];
                                break;
                            }
                            ++i;
                        }
                        if (currUse != null || attrWildcard != null && attrWildcard.allowNamespace(this.fTempQName.uri)) break block26;
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{element.rawname, this.fTempQName.rawname});
                        break block25;
                    }
                    currDecl = null;
                    if (currUse == null) break block27;
                    currDecl = currUse.fAttrDecl;
                    ** GOTO lbl58
                }
                if (attrWildcard.fProcessContents == 2) break block25;
                grammar = this.fGrammarResolver.getGrammar(this.fTempQName.uri);
                if (grammar != null) {
                    currDecl = grammar.getGlobalAttributeDecl(this.fTempQName.localpart);
                }
                if (currDecl == null) {
                    if (attrWildcard.fProcessContents == 0) {
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{element.rawname, this.fTempQName.rawname});
                    }
                } else {
                    if (currDecl.fType instanceof IDDatatypeValidator) {
                        if (wildcardIDName != null) {
                            this.reportSchemaError("cvc-complex-type.5.1", new Object[]{element.rawname, currDecl.fName, wildcardIDName});
                        } else {
                            wildcardIDName = currDecl.fName;
                        }
                    }
lbl58:
                    // 5 sources

                    attDV = currDecl.fType;
                    attrValue = attributes.getValue(index);
                    attrValue = XSAttributeChecker.normalize(attrValue, attDV.getWSFacet());
                    actualValue = null;
                    try {
                        attDV.validate(attrValue, this.fValidationState);
                    }
                    catch (InvalidDatatypeValueException idve) {
                        this.reportSchemaError("cvc-attribute.3", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
                    }
                    if (currDecl.fConstraintType == 2 && attDV.compare(attrValue, (String)currDecl.fDefault) != 0) {
                        this.reportSchemaError("cvc-attribute.4", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
                    }
                    if (currUse != null && currUse.fConstraintType == 2 && attDV.compare(attrValue, (String)currUse.fDefault) != 0) {
                        this.reportSchemaError("cvc-complex-type.3.1", new Object[]{element.rawname, this.fTempQName.rawname, attrValue});
                    }
                }
            }
            ++index;
        }
        if (attrGrp.fIDAttrName != null && wildcardIDName != null) {
            this.reportSchemaError("cvc-complex-type.5.2", new Object[]{element.rawname, wildcardIDName, attrGrp.fIDAttrName});
        }
    }

    void addDefaultAttributes(QName element, XMLAttributes attributes, XSAttributeGroupDecl attrGrp) {
        XSAttributeUse[] attrUses = attrGrp.getAttributeUses();
        int useCount = attrUses.length;
        int i = 0;
        while (i < useCount) {
            boolean isSpecified;
            XSAttributeUse currUse = attrUses[i];
            XSAttributeDecl currDecl = currUse.fAttrDecl;
            short constType = currUse.fConstraintType;
            Object defaultValue = currUse.fDefault;
            if (constType == 0) {
                constType = currDecl.fConstraintType;
                defaultValue = currDecl.fDefault;
            }
            boolean bl = isSpecified = attributes.getValue(currDecl.fTargetNamespace, currDecl.fName) != null;
            if (currUse.fUse == 1 && !isSpecified) {
                this.reportSchemaError("cvc-complex-type.4", new Object[]{element.rawname, currDecl.fName});
            }
            if (!isSpecified && constType != 0) {
                QName attName = new QName(null, currDecl.fName, currDecl.fName, currDecl.fTargetNamespace);
                attributes.addAttribute(attName, null, defaultValue != null ? defaultValue.toString() : "");
            }
            ++i;
        }
    }

    void processElementContent(QName element) {
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.fDefault != null && this.fBuffer.toString().trim().length() == 0) {
            int bufLen = this.fCurrentElemDecl.fDefault.toString().length();
            char[] chars = new char[bufLen];
            this.fCurrentElemDecl.fDefault.toString().getChars(0, bufLen, chars, 0);
            XMLString text = new XMLString(chars, 0, bufLen);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(text);
            }
            int count = this.fMatcherStack.getMatcherCount();
            int i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.characters(text);
                ++i;
            }
        }
        if (this.fCurrentElemDecl == null || this.fCurrentElemDecl.getConstraintType() == 1) {
            // empty if block
        }
        if (this.fDoValidation) {
            String content = this.fBuffer.toString();
            if (this.fNil && (this.fChildCount != 0 || content.length() != 0)) {
                this.reportSchemaError("cvc-elt.3.2.1", new Object[]{element.rawname, this.URI_XSI + "," + this.XSI_NIL});
            }
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() != 0 && this.fChildCount == 0 && content.length() == 0 && !this.fNil) {
                if (this.fCurrentType != this.fCurrentElemDecl.fType && !XSConstraints.ElementDefaultValidImmediate(this.fCurrentType, this.fCurrentElemDecl.fDefault.toString())) {
                    this.reportSchemaError("cvc-elt.5.1.1", new Object[]{element.rawname, this.fCurrentType.getXSTypeName(), this.fCurrentElemDecl.fDefault.toString()});
                }
                this.elementLocallyValidType(element, this.fCurrentElemDecl.fDefault.toString());
            } else {
                Object actualValue = this.elementLocallyValidType(element, content);
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2 && !this.fNil) {
                    DatatypeValidator sType;
                    if (this.fChildCount != 0) {
                        this.reportSchemaError("cvc-elt.5.2.2.1", new Object[]{element.rawname});
                    }
                    if (this.fCurrentType.getXSType() == 1) {
                        XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
                        if (ctype.fContentType == 2) {
                            if (!this.fCurrentElemDecl.fDefault.toString().equals(content)) {
                                this.reportSchemaError("cvc-elt.5.2.2.2.1", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.toString()});
                            }
                        } else if (ctype.fContentType == 1 && ctype.fDatatypeValidator.compare((String)actualValue, (String)this.fCurrentElemDecl.fDefault) != 0) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.toString()});
                        }
                    } else if (this.fCurrentType.getXSType() == 2 && (sType = (DatatypeValidator)this.fCurrentType).compare((String)actualValue, (String)this.fCurrentElemDecl.fDefault) != 0) {
                        this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{element.rawname, content, this.fCurrentElemDecl.fDefault.toString()});
                    }
                }
            }
        }
    }

    Object elementLocallyValidType(QName element, String textContent) {
        if (this.fCurrentType == null) {
            return null;
        }
        Object retValue = null;
        if (this.fCurrentType.getXSType() == 2) {
            if (this.fChildCount != 0) {
                this.reportSchemaError("cvc-type.3.1.2", new Object[]{element.rawname});
            }
            if (!this.fNil) {
                DatatypeValidator dv = (DatatypeValidator)this.fCurrentType;
                String content = XSAttributeChecker.normalize(textContent, dv.getWSFacet());
                try {
                    retValue = content;
                    dv.validate(content, this.fValidationState);
                }
                catch (InvalidDatatypeValueException e) {
                    this.reportSchemaError("cvc-type.3.1.3", new Object[]{element.rawname, content});
                }
            }
        } else {
            retValue = this.elementLocallyValidComplexType(element, textContent);
        }
        return retValue;
    }

    Object elementLocallyValidComplexType(QName element, String textContent) {
        String actualValue = null;
        XSComplexTypeDecl ctype = (XSComplexTypeDecl)this.fCurrentType;
        if (!this.fNil) {
            if (ctype.fContentType == 0 && (this.fChildCount != 0 || textContent.length() != 0)) {
                this.reportSchemaError("cvc-complex-type.2.1", new Object[]{element.rawname});
            } else if (ctype.fContentType == 1) {
                if (this.fChildCount != 0) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{element.rawname});
                }
                DatatypeValidator dv = ctype.fDatatypeValidator;
                String content = XSAttributeChecker.normalize(textContent, dv.getWSFacet());
                try {
                    dv.validate(content, this.fValidationState);
                }
                catch (InvalidDatatypeValueException e) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{element.rawname});
                }
                actualValue = content;
            } else if (ctype.fContentType == 3 && this.fSawCharacters) {
                this.reportSchemaError("cvc-complex-type.2.3", new Object[]{element.rawname});
            }
            if (!(ctype.fContentType != 3 && ctype.fContentType != 2 || this.fCurrCMState[0] < 0 || this.fCurrentCM.endContentModel(this.fCurrCMState))) {
                this.reportSchemaError("cvc-complex-type.2.4.b", new Object[]{element.rawname, ctype.fParticle.toString()});
            }
        }
        return actualValue;
    }

    void reportSchemaError(String key, Object[] arguments) {
        if (this.fDoValidation) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, arguments, (short)1);
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field key, IDValue value) {
            int index = this.indexOf(key);
            if (index == -1) {
                this.ensureCapacity(this.fSize);
                index = this.fSize++;
                this.fEntries[index].key = key;
            }
            this.fEntries[index].value = value;
        }

        public IDValue get(Field key) {
            return this.fEntries[this.indexOf((Field)key)].value;
        }

        public int indexOf(Field key) {
            int i = 0;
            while (i < this.fSize) {
                if (this.fEntries[i].key == key) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Field keyAt(int index) {
            return this.fEntries[index].key;
        }

        public IDValue valueAt(int index) {
            return this.fEntries[index].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int size) {
            int osize = -1;
            int nsize = -1;
            if (this.fEntries == null) {
                osize = 0;
                nsize = 2;
                this.fEntries = new Entry[nsize];
            } else if (this.fEntries.length <= size) {
                osize = this.fEntries.length;
                nsize = 2 * osize;
                Entry[] array = new Entry[nsize];
                System.arraycopy(this.fEntries, 0, array, 0, osize);
                this.fEntries = array;
            }
            int i = osize;
            while (i < nsize) {
                this.fEntries[i] = new Entry();
                ++i;
            }
        }

        public Object clone() {
            OrderedHashtable hashtable = new OrderedHashtable();
            int i = 0;
            while (i < this.fSize) {
                hashtable.put(this.fEntries[i].key, this.fEntries[i].value);
                ++i;
            }
            return hashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer str = new StringBuffer();
            str.append('[');
            int i = 0;
            while (i < this.fSize) {
                if (i > 0) {
                    str.append(',');
                }
                str.append('{');
                str.append(this.fEntries[i].key);
                str.append(',');
                str.append(this.fEntries[i].value);
                str.append('}');
                ++i;
            }
            str.append(']');
            return str.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws XNIException {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable oldMap = (Hashtable)this.fGlobalMapStack.pop();
            Enumeration keys = oldMap.keys();
            while (keys.hasMoreElements()) {
                IdentityConstraint id = (IdentityConstraint)keys.nextElement();
                ValueStoreBase oldVal = (ValueStoreBase)oldMap.get(id);
                if (oldVal == null) continue;
                ValueStoreBase currVal = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
                if (currVal == null) {
                    this.fGlobalIDConstraintMap.put(id, oldVal);
                    continue;
                }
                currVal.append(oldVal);
                this.fGlobalIDConstraintMap.put(id, currVal);
            }
        }

        public void initValueStoresFor(XSElementDecl eDecl) throws XNIException {
            IdentityConstraint[] icArray = eDecl.fIDConstraints;
            int icCount = eDecl.fIDCPos;
            int i = 0;
            while (i < icCount) {
                switch (icArray[i].getType()) {
                    case 0: {
                        UniqueOrKey unique = (UniqueOrKey)icArray[i];
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(unique);
                        if (uniqueValueStore != null) break;
                        uniqueValueStore = new UniqueValueStore(unique);
                        this.fValueStores.addElement(uniqueValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(unique, uniqueValueStore);
                        break;
                    }
                    case 1: {
                        UniqueOrKey key = (UniqueOrKey)icArray[i];
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(key);
                        if (keyValueStore != null) break;
                        keyValueStore = new KeyValueStore(key);
                        this.fValueStores.addElement(keyValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(key, keyValueStore);
                        break;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)icArray[i];
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(keyRef);
                        if (keyRefValueStore != null) break;
                        keyRefValueStore = new KeyRefValueStore(keyRef, null);
                        this.fValueStores.addElement(keyRefValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(keyRef, keyRefValueStore);
                    }
                }
                ++i;
            }
        }

        public ValueStoreBase getValueStoreFor(Field field) {
            IdentityConstraint identityConstraint = field.getIdentityConstraint();
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(id);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
        }

        public void transplant(IdentityConstraint id) {
            if (id.getType() == 2) {
                return;
            }
            ValueStoreBase newVals = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(id);
            this.fIdentityConstraint2ValueStoreMap.remove(id);
            ValueStoreBase currVals = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
            if (currVals != null) {
                currVals.append(newVals);
                this.fGlobalIDConstraintMap.put(id, currVals);
            } else {
                this.fGlobalIDConstraintMap.put(id, newVals);
            }
        }

        public void endDocument() throws XNIException {
            int count = this.fValueStores.size();
            int i = 0;
            while (i < count) {
                ValueStoreBase valueStore = (ValueStoreBase)this.fValueStores.elementAt(i);
                valueStore.endDocument();
                ++i;
            }
        }

        public String toString() {
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                return s.substring(index1 + 1);
            }
            int index2 = s.lastIndexOf(46);
            if (index2 != -1) {
                return s.substring(index2 + 1);
            }
            return s;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws XNIException {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLSchemaValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String code = "KeyRefOutOfScope";
                String value = this.fIdentityConstraint.toString();
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value});
                return;
            }
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                OrderedHashtable values = (OrderedHashtable)this.fValueTuples.elementAt(i);
                if (!this.fKeyValueStore.contains(values)) {
                    String code = "KeyNotFound";
                    String value = this.toString(values);
                    String element = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, element});
                }
                ++i;
            }
        }

        public void endDocument() throws XNIException {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey key) {
            super(key);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
            String code = "DuplicateKey";
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey unique) {
            super(unique);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
            String code = "DuplicateUnique";
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void destroy() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase newVal) {
            int i = 0;
            while (i < newVal.fValueTuples.size()) {
                OrderedHashtable o = (OrderedHashtable)newVal.fValueTuples.elementAt(i);
                if (!this.contains(o)) {
                    this.fValueTuples.addElement(o);
                }
                ++i;
            }
        }

        public void startValueScope() throws XNIException {
            this.fValuesCount = 0;
            int count = this.fIdentityConstraint.getFieldCount();
            int i = 0;
            while (i < count) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(i), this.NOT_AN_IDVALUE);
                ++i;
            }
        }

        public void endValueScope() throws XNIException {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getType() == 1) {
                    String code = "AbsentKeyValue";
                    String eName = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(code, new Object[]{eName});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getType()) {
                    case 0: {
                        String code = "UniqueNotEnoughValues";
                        String ename = this.fIdentityConstraint.getElementName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename});
                        break;
                    }
                    case 1: {
                        String code = "KeyNotEnoughValues";
                        UniqueOrKey key = (UniqueOrKey)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = key.getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                    case 2: {
                        String code = "KeyRefNotEnoughValues";
                        KeyRef keyref = (KeyRef)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = keyref.getKey().getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws XNIException {
        }

        public void endDocument() throws XNIException {
        }

        public void reportNilError(IdentityConstraint id) {
            if (id.getType() == 1) {
                String code = "KeyMatchesNillable";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{id.getElementName()});
            }
        }

        public void addValue(Field field, IDValue value) {
            int index;
            if (!field.mayMatch()) {
                String code = "FieldMultipleMatch";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{field.toString()});
            }
            if ((index = this.fValues.indexOf(field)) == -1) {
                String code = "UnknownField";
                XMLSchemaValidator.this.reportSchemaError(code, new Object[]{field.toString()});
                return;
            }
            IDValue storedValue = this.fValues.valueAt(index);
            if (storedValue.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, value);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable values = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(values);
            }
        }

        public boolean contains(OrderedHashtable tuple) {
            int tcount = tuple.size();
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                block3: {
                    OrderedHashtable vtuple = (OrderedHashtable)this.fValueTuples.elementAt(i);
                    int j = 0;
                    while (j < tcount) {
                        IDValue value2;
                        IDValue value1 = vtuple.valueAt(j);
                        if (value1.isDuplicateOf(value2 = tuple.valueAt(j))) {
                            ++j;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable tuple) throws XNIException {
        }

        protected String toString(OrderedHashtable tuple) {
            int size = tuple.size();
            if (size == 0) {
                return "";
            }
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(tuple.valueAt(i));
                ++i;
            }
            return str.toString();
        }

        public String toString() {
            int index2;
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                s = s.substring(index1 + 1);
            }
            if ((index2 = s.lastIndexOf(46)) != -1) {
                s = s.substring(index2 + 1);
            }
            return s + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int i = 0;
            while (i < this.fMatchersCount) {
                this.fMatchers[i] = null;
                ++i;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher matcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = matcher;
        }

        public XPathMatcher getMatcherAt(int index) {
            return this.fMatchers[index];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] array = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, array, 0, this.fMatchers.length);
                this.fMatchers = array;
            }
        }
    }
}

