/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class IDDatatypeValidator
extends StringDatatypeValidator {
    public IDDatatypeValidator() {
        this(null, null, false, null);
    }

    public IDDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
        if (derivedByList) {
            return;
        }
        if (base instanceof IDDatatypeValidator) {
            this.setTokenType(((IDDatatypeValidator)base).fTokenType);
        } else {
            this.setTokenType("ID(Name)");
        }
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        Object retVal = super.validate(content, state);
        if (state != null) {
            if (state.isIdDeclared(content)) {
                throw new InvalidDatatypeValueException("ID '" + content + "'  has to be unique");
            }
            state.addId(content);
        }
        return retVal;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }
}

