/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidatorFactory;
import org.apache.xerces.impl.dv.dtd.DatatypeValidatorFactoryImpl;
import org.apache.xerces.impl.dv.dtd.ENTITYDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.IDDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.IDREFDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.ListDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.NOTATIONDatatypeValidator;
import org.apache.xerces.impl.validation.GrammarPool;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDContentModelFilter;
import org.apache.xerces.xni.parser.XMLDTDFilter;
import org.apache.xerces.xni.parser.XMLDocumentFilter;

public class XMLDTDValidator
implements XMLComponent,
XMLDocumentFilter,
XMLDTDFilter,
XMLDTDContentModelFilter {
    private static final int TOP_LEVEL_SCOPE = -1;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String DATATYPE_VALIDATOR_FACTORY = "http://apache.org/xml/properties/internal/datatype-validator-factory";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema"};
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/internal/datatype-validator-factory", "http://apache.org/xml/properties/internal/validation-manager"};
    private static final boolean DEBUG_ATTRIBUTES = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    protected ValidationManager fValidationManager = null;
    protected boolean fNamespaces;
    protected boolean fValidation;
    protected boolean fDTDValidation;
    protected boolean fDynamicValidation;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected GrammarPool fGrammarPool;
    protected DatatypeValidatorFactory fDatatypeValidatorFactory;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected DTDGrammar fDTDGrammar;
    private boolean fPerformValidation;
    private boolean fSkipValidation;
    protected boolean fInDTD;
    protected boolean fInDTDIgnore;
    private final QName fCurrentElement = new QName();
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private final QName fRootElement = new QName();
    private boolean fSeenDoctypeDecl = false;
    private boolean fInCDATASection = false;
    private int[] fElementIndexStack = new int[8];
    private int[] fContentSpecTypeStack = new int[8];
    private QName[] fElementQNamePartsStack = new QName[8];
    private QName[] fElementChildren = new QName[32];
    private int fElementChildrenLength = 0;
    private int[] fElementChildrenOffsetStack = new int[32];
    private int fElementDepth = -1;
    private boolean fStandaloneIsYes = false;
    private boolean fSeenRootElement = false;
    private boolean fInElementContent = false;
    private boolean fMixed;
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fTempAttDecl = new XMLAttributeDecl();
    private XMLEntityDecl fEntityDecl = new XMLEntityDecl();
    private QName fTempQName = new QName();
    private Hashtable fNDataDeclNotations = new Hashtable();
    private String fDTDElementDeclName = null;
    private Vector fMixedElementTypes = new Vector();
    private Vector fDTDElementDecls = new Vector();
    private StringBuffer fBuffer = new StringBuffer();
    private String fEMPTYSymbol;
    private String fANYSymbol;
    private String fMIXEDSymbol;
    private String fCHILDRENSymbol;
    private String fCDATASymbol;
    private String fIDSymbol;
    private String fIDREFSymbol;
    private String fIDREFSSymbol;
    private String fENTITYSymbol;
    private String fENTITIESSymbol;
    private String fNMTOKENSymbol;
    private String fNMTOKENSSymbol;
    private String fNOTATIONSymbol;
    private String fENUMERATIONSymbol;
    private String fIMPLIEDSymbol;
    private String fREQUIREDSymbol;
    private String fFIXEDSymbol;
    private String fDATATYPESymbol;
    private IDDatatypeValidator fValID;
    private IDREFDatatypeValidator fValIDRef;
    private ListDatatypeValidator fValIDRefs;
    private ENTITYDatatypeValidator fValENTITY;
    private ListDatatypeValidator fValENTITIES;
    private DatatypeValidator fValNMTOKEN;
    private DatatypeValidator fValNMTOKENS;
    private NOTATIONDatatypeValidator fValNOTATION;
    private Hashtable fTableOfIDs;
    private Hashtable fTableOfIDAttributeNames;
    private Hashtable fTableOfNOTATIONAttributeNames;
    private Hashtable fNotationEnumVals;

    public XMLDTDValidator() {
        int i = 0;
        while (i < this.fElementQNamePartsStack.length) {
            this.fElementQNamePartsStack[i] = new QName();
            ++i;
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fDTDGrammar = null;
        this.fSeenDoctypeDecl = false;
        this.fInCDATASection = false;
        this.fInDTD = false;
        this.fInDTDIgnore = false;
        this.fStandaloneIsYes = false;
        this.fSeenRootElement = false;
        this.fInElementContent = false;
        this.fCurrentElementIndex = -1;
        this.fCurrentContentSpecType = -1;
        this.fSkipValidation = false;
        this.fRootElement.clear();
        this.fNDataDeclNotations.clear();
        try {
            this.fNamespaces = componentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException e) {
            this.fNamespaces = true;
        }
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fDTDValidation = !componentManager.getFeature(SCHEMA_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fDynamicValidation = componentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fDynamicValidation = false;
        }
        this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.reset();
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fGrammarPool = (GrammarPool)componentManager.getProperty(GRAMMAR_POOL);
        this.fDatatypeValidatorFactory = (DatatypeValidatorFactory)componentManager.getProperty(DATATYPE_VALIDATOR_FACTORY);
        this.fElementDepth = -1;
        this.init();
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void setDTDHandler(XMLDTDHandler dtdHandler) {
        this.fDTDHandler = dtdHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler dtdContentModelHandler) {
        this.fDTDContentModelHandler = dtdContentModelHandler;
    }

    public void startDocument(XMLLocator locator, String encoding) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(locator, encoding);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone) throws XNIException {
        boolean bl = this.fStandaloneIsYes = standalone != null && standalone.equals("yes");
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(version, encoding, standalone);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId) throws XNIException {
        this.fSeenDoctypeDecl = true;
        this.fRootElement.setValues(null, rootElement, rootElement, null);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(rootElement, publicId, systemId);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void startElement(QName element, XMLAttributes attributes) throws XNIException {
        this.handleStartElement(element, attributes, false);
    }

    public void emptyElement(QName element, XMLAttributes attributes) throws XNIException {
        this.handleStartElement(element, attributes, true);
        this.handleEndElement(element, true);
    }

    public void characters(XMLString text) throws XNIException {
        if (this.fInDTD) {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.characters(text);
            }
        } else {
            boolean callNextCharacters = true;
            boolean allWhiteSpace = true;
            int i = text.offset;
            while (i < text.offset + text.length) {
                if (!XMLChar.isSpace(text.ch[i])) {
                    allWhiteSpace = false;
                    break;
                }
                ++i;
            }
            if (this.fInElementContent && allWhiteSpace && !this.fInCDATASection && this.fDocumentHandler != null) {
                this.fDocumentHandler.ignorableWhitespace(text);
                callNextCharacters = false;
            }
            if (this.fPerformValidation) {
                if (this.fInElementContent) {
                    if (this.fStandaloneIsYes && this.fDTDGrammar.getElementDeclIsExternal(this.fCurrentElementIndex) && allWhiteSpace) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_WHITE_SPACE_IN_ELEMENT_CONTENT_WHEN_STANDALONE", null, (short)1);
                    }
                    if (!allWhiteSpace) {
                        this.charDataInContent();
                    }
                }
                if (this.fCurrentContentSpecType == 1) {
                    this.charDataInContent();
                }
            }
            if (callNextCharacters && this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(text);
            }
        }
    }

    public void ignorableWhitespace(XMLString text) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(text);
        }
    }

    public void endElement(QName element) throws XNIException {
        this.handleEndElement(element, false);
    }

    public void endPrefixMapping(String prefix) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(prefix);
        }
    }

    public void startCDATA() throws XNIException {
        if (this.fPerformValidation && this.fInElementContent) {
            this.charDataInContent();
        }
        this.fInCDATASection = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA();
        }
    }

    public void endCDATA() throws XNIException {
        this.fInCDATASection = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA();
        }
    }

    public void endDocument() throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument();
        }
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
        if (this.fInDTD) {
            this.fDTDGrammar.startEntity(name, publicId, systemId, baseSystemId, encoding);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startEntity(name, publicId, systemId, baseSystemId, encoding);
            }
        } else {
            int entIndex;
            if (this.fPerformValidation && this.fDTDGrammar != null && this.fStandaloneIsYes && !name.startsWith("[") && (entIndex = this.fDTDGrammar.getEntityDeclIndex(name)) > -1) {
                this.fDTDGrammar.getEntityDecl(entIndex, this.fEntityDecl);
                if (this.fEntityDecl.inExternal) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{name}, (short)1);
                }
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.startEntity(name, publicId, systemId, baseSystemId, encoding);
            }
        }
    }

    public void textDecl(String version, String encoding) throws XNIException {
        if (this.fInDTD) {
            this.fDTDGrammar.textDecl(version, encoding);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.textDecl(version, encoding);
            }
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(version, encoding);
        }
    }

    public void comment(XMLString text) throws XNIException {
        if (this.fInDTD) {
            this.fDTDGrammar.comment(text);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.comment(text);
            }
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(text);
        }
    }

    public void processingInstruction(String target, XMLString data) throws XNIException {
        if (this.fInDTD) {
            this.fDTDGrammar.processingInstruction(target, data);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.processingInstruction(target, data);
            }
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(target, data);
        }
    }

    public void endEntity(String name) throws XNIException {
        if (this.fInDTD) {
            this.fDTDGrammar.endEntity(name);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endEntity(name);
            }
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endEntity(name);
        }
    }

    public void startDTD(XMLLocator locator) throws XNIException {
        this.fInDTD = true;
        this.fNDataDeclNotations.clear();
        this.fDTDElementDecls.removeAllElements();
        this.fDTDGrammar = this.createDTDGrammar();
        this.fGrammarPool.putGrammar("", this.fDTDGrammar);
        this.fDTDGrammar.startDTD(locator);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(locator);
        }
    }

    public void elementDecl(String name, String contentModel) throws XNIException {
        if (this.fValidation) {
            if (this.fDTDElementDecls.contains(name)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ELEMENT_ALREADY_DECLARED", new Object[]{name}, (short)1);
            } else {
                this.fDTDElementDecls.addElement(name);
            }
        }
        this.fDTDGrammar.elementDecl(name, contentModel);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.elementDecl(name, contentModel);
        }
    }

    public void startAttlist(String elementName) throws XNIException {
        this.fDTDGrammar.startAttlist(elementName);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startAttlist(elementName);
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue) throws XNIException {
        if (type != this.fCDATASymbol) {
            this.normalizeDefaultAttrValue(defaultValue);
        }
        if (this.fValidation) {
            if (type == this.fIDSymbol) {
                if (defaultValue != null && defaultValue.length != 0 && (defaultType == null || defaultType != this.fIMPLIEDSymbol && defaultType != this.fREQUIREDSymbol)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "IDDefaultTypeInvalid", new Object[]{attributeName}, (short)1);
                }
                if (!this.fTableOfIDAttributeNames.containsKey(elementName)) {
                    this.fTableOfIDAttributeNames.put(elementName, attributeName);
                } else {
                    String previousIDAttributeName = (String)this.fTableOfIDAttributeNames.get(elementName);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_MORE_THAN_ONE_ID_ATTRIBUTE", new Object[]{elementName, previousIDAttributeName, attributeName}, (short)1);
                }
            }
            if (type == this.fNOTATIONSymbol) {
                int i = 0;
                while (i < enumeration.length) {
                    this.fNotationEnumVals.put(enumeration[i], attributeName);
                    ++i;
                }
                if (!this.fTableOfNOTATIONAttributeNames.containsKey(elementName)) {
                    this.fTableOfNOTATIONAttributeNames.put(elementName, attributeName);
                } else {
                    String previousNOTATIONAttributeName = (String)this.fTableOfNOTATIONAttributeNames.get(elementName);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_MORE_THAN_ONE_NOTATION_ATTRIBUTE", new Object[]{elementName, previousNOTATIONAttributeName, attributeName}, (short)1);
                }
            }
            boolean ok = true;
            if (defaultValue != null && (defaultType == null || defaultType != null && defaultType == this.fFIXEDSymbol)) {
                String value = defaultValue.toString();
                if (type == this.fNMTOKENSSymbol || type == this.fENTITIESSymbol || type == this.fIDREFSSymbol) {
                    StringTokenizer tokenizer = new StringTokenizer(value);
                    if (tokenizer.hasMoreTokens()) {
                        do {
                            String nmtoken = tokenizer.nextToken();
                            if (type == this.fNMTOKENSSymbol) {
                                if (XMLChar.isValidNmtoken(nmtoken)) continue;
                                ok = false;
                            } else {
                                if (type != this.fENTITIESSymbol && type != this.fIDREFSSymbol || XMLChar.isValidName(nmtoken)) continue;
                                ok = false;
                            }
                            break;
                        } while (tokenizer.hasMoreTokens());
                    }
                } else {
                    if (type == this.fENTITYSymbol || type == this.fIDSymbol || type == this.fIDREFSymbol || type == this.fNOTATIONSymbol) {
                        if (!XMLChar.isValidName(value)) {
                            ok = false;
                        }
                    } else if (!(type != this.fNMTOKENSymbol && type != this.fENUMERATIONSymbol || XMLChar.isValidNmtoken(value))) {
                        ok = false;
                    }
                    if (type == this.fNOTATIONSymbol || type == this.fENUMERATIONSymbol) {
                        ok = false;
                        int i = 0;
                        while (i < enumeration.length) {
                            if (defaultValue.equals(enumeration[i])) {
                                ok = true;
                            }
                            ++i;
                        }
                    }
                }
                if (!ok) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATT_DEFAULT_INVALID", new Object[]{attributeName, value}, (short)1);
                }
            }
        }
        this.fDTDGrammar.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue);
        }
    }

    public void endAttlist() throws XNIException {
        this.fDTDGrammar.endAttlist();
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endAttlist();
        }
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText) throws XNIException {
        this.fDTDGrammar.internalEntityDecl(name, text, nonNormalizedText);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.internalEntityDecl(name, text, nonNormalizedText);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId) throws XNIException {
        this.fDTDGrammar.externalEntityDecl(name, publicId, systemId, baseSystemId);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.externalEntityDecl(name, publicId, systemId, baseSystemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) throws XNIException {
        if (this.fValidation) {
            this.fNDataDeclNotations.put(name, notation);
        }
        this.fDTDGrammar.unparsedEntityDecl(name, publicId, systemId, notation);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.unparsedEntityDecl(name, publicId, systemId, notation);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws XNIException {
        this.fDTDGrammar.notationDecl(name, publicId, systemId);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void startConditional(short type) throws XNIException {
        this.fInDTDIgnore = type == 1;
        this.fDTDGrammar.startConditional(type);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startConditional(type);
        }
    }

    public void endConditional() throws XNIException {
        this.fInDTDIgnore = false;
        this.fDTDGrammar.endConditional();
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endConditional();
        }
    }

    public void endDTD() throws XNIException {
        this.fInDTD = false;
        this.fDTDGrammar.endDTD();
        if (this.fValidation) {
            String notation;
            this.fValENTITY.initialize(this.fDTDGrammar);
            this.fValENTITIES.initialize(this.fDTDGrammar);
            Enumeration entities = this.fNDataDeclNotations.keys();
            while (entities.hasMoreElements()) {
                String entity = (String)entities.nextElement();
                notation = (String)this.fNDataDeclNotations.get(entity);
                if (this.fDTDGrammar.getNotationDeclIndex(notation) != -1) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_NOTATION_NOT_DECLARED_FOR_UNPARSED_ENTITYDECL", new Object[]{entity, notation}, (short)1);
            }
            Enumeration notationVals = this.fNotationEnumVals.keys();
            while (notationVals.hasMoreElements()) {
                notation = (String)notationVals.nextElement();
                String attributeName = (String)this.fNotationEnumVals.get(notation);
                if (this.fDTDGrammar.getNotationDeclIndex(notation) != -1) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_NOTATION_NOT_DECLARED_FOR_NOTATIONTYPE_ATTRIBUTE", new Object[]{attributeName, notation}, (short)1);
            }
            this.fTableOfIDAttributeNames = null;
            this.fTableOfNOTATIONAttributeNames = null;
        }
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endDTD();
        }
    }

    public void startContentModel(String elementName) throws XNIException {
        if (this.fValidation) {
            this.fDTDElementDeclName = elementName;
            this.fMixedElementTypes.removeAllElements();
        }
        this.fDTDGrammar.startContentModel(elementName);
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.startContentModel(elementName);
        }
    }

    public void any() throws XNIException {
        this.fDTDGrammar.any();
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.any();
        }
    }

    public void empty() throws XNIException {
        this.fDTDGrammar.empty();
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.empty();
        }
    }

    public void startGroup() throws XNIException {
        this.fMixed = false;
        this.fDTDGrammar.startGroup();
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.startGroup();
        }
    }

    public void pcdata() {
        this.fMixed = true;
        this.fDTDGrammar.pcdata();
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.pcdata();
        }
    }

    public void element(String elementName) throws XNIException {
        if (this.fMixed && this.fValidation) {
            if (this.fMixedElementTypes.contains(elementName)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "DuplicateTypeInMixedContent", new Object[]{this.fDTDElementDeclName, elementName}, (short)1);
            } else {
                this.fMixedElementTypes.addElement(elementName);
            }
        }
        this.fDTDGrammar.element(elementName);
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.element(elementName);
        }
    }

    public void separator(short separator) throws XNIException {
        this.fDTDGrammar.separator(separator);
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.separator(separator);
        }
    }

    public void occurrence(short occurrence) throws XNIException {
        this.fDTDGrammar.occurrence(occurrence);
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.occurrence(occurrence);
        }
    }

    public void endGroup() throws XNIException {
        this.fDTDGrammar.endGroup();
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.endGroup();
        }
    }

    public void endContentModel() throws XNIException {
        this.fDTDGrammar.endContentModel();
        if (this.fDTDContentModelHandler != null) {
            this.fDTDContentModelHandler.endContentModel();
        }
    }

    private void addDTDDefaultAttrsAndValidate(int elementIndex, XMLAttributes attributes) throws XNIException {
        if (elementIndex == -1 || this.fDTDGrammar == null) {
            return;
        }
        this.fDTDGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
        QName element = this.fTempElementDecl.name;
        int attlistIndex = this.fDTDGrammar.getFirstAttributeDeclIndex(elementIndex);
        while (attlistIndex != -1) {
            boolean cdata;
            this.fDTDGrammar.getAttributeDecl(attlistIndex, this.fTempAttDecl);
            String attPrefix = this.fTempAttDecl.name.prefix;
            String attLocalpart = this.fTempAttDecl.name.localpart;
            String attRawName = this.fTempAttDecl.name.rawname;
            String attType = this.getAttributeTypeName(this.fTempAttDecl);
            short attDefaultType = this.fTempAttDecl.simpleType.defaultType;
            String attValue = null;
            if (this.fTempAttDecl.simpleType.defaultValue != null) {
                attValue = this.fTempAttDecl.simpleType.defaultValue;
            }
            boolean specified = false;
            boolean required = attDefaultType == 2;
            boolean bl = cdata = attType == this.fCDATASymbol;
            if (!cdata || required || attValue != null) {
                int attrCount = attributes.getLength();
                int i = 0;
                while (i < attrCount) {
                    if (attributes.getQName(i) == attRawName) {
                        specified = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!specified) {
                if (required) {
                    if (this.fValidation) {
                        Object[] args = new Object[]{element.localpart, attRawName};
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REQUIRED_ATTRIBUTE_NOT_SPECIFIED", args, (short)1);
                    }
                } else if (attValue != null) {
                    int index;
                    if (this.fPerformValidation && this.fStandaloneIsYes && this.fDTDGrammar.getAttributeDeclIsExternal(attlistIndex)) {
                        Object[] args = new Object[]{element.localpart, attRawName};
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DEFAULTED_ATTRIBUTE_NOT_SPECIFIED", args, (short)1);
                    }
                    if (this.fNamespaces && (index = attRawName.indexOf(58)) != -1) {
                        attPrefix = attRawName.substring(0, index);
                        attPrefix = this.fSymbolTable.addSymbol(attPrefix);
                        attLocalpart = attRawName.substring(index + 1);
                        attLocalpart = this.fSymbolTable.addSymbol(attLocalpart);
                    }
                    this.fTempQName.setValues(attPrefix, attLocalpart, attRawName, this.fTempAttDecl.name.uri);
                    int newAttr = attributes.addAttribute(this.fTempQName, attType, attValue);
                }
            }
            attlistIndex = this.fDTDGrammar.getNextAttributeDeclIndex(attlistIndex);
        }
        int attrCount = attributes.getLength();
        int i = 0;
        while (i < attrCount) {
            String entityName;
            String nonNormalizedValue;
            String attrRawName = attributes.getQName(i);
            boolean declared = false;
            if (this.fPerformValidation && this.fStandaloneIsYes && (nonNormalizedValue = attributes.getNonNormalizedValue(i)) != null && (entityName = this.getExternalEntityRefInAttrValue(nonNormalizedValue)) != null) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{entityName}, (short)1);
            }
            int attDefIndex = -1;
            int position = this.fDTDGrammar.getFirstAttributeDeclIndex(elementIndex);
            while (position != -1) {
                this.fDTDGrammar.getAttributeDecl(position, this.fTempAttDecl);
                if (this.fTempAttDecl.name.rawname == attrRawName) {
                    attDefIndex = position;
                    declared = true;
                    break;
                }
                position = this.fDTDGrammar.getNextAttributeDeclIndex(position);
            }
            if (!declared) {
                if (this.fPerformValidation) {
                    Object[] args = new Object[]{element.rawname, attrRawName};
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATTRIBUTE_NOT_DECLARED", args, (short)1);
                }
            } else {
                String oldValue;
                String type = this.getAttributeTypeName(this.fTempAttDecl);
                attributes.setType(i, type);
                boolean changedByNormalization = false;
                String attrValue = oldValue = attributes.getValue(i);
                if (attributes.isSpecified(i) && type != this.fCDATASymbol) {
                    changedByNormalization = this.normalizeAttrValue(attributes, i);
                    attrValue = attributes.getValue(i);
                    if (this.fPerformValidation && this.fStandaloneIsYes && changedByNormalization && this.fDTDGrammar.getAttributeDeclIsExternal(position)) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATTVALUE_CHANGED_DURING_NORMALIZATION_WHEN_STANDALONE", new Object[]{attrRawName, oldValue, attrValue}, (short)1);
                    }
                }
                if (this.fPerformValidation) {
                    String defaultValue;
                    if (this.fTempAttDecl.simpleType.defaultType == 1 && !attrValue.equals(defaultValue = this.fTempAttDecl.simpleType.defaultValue)) {
                        Object[] args = new Object[]{element.localpart, attrRawName, attrValue, defaultValue};
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_FIXED_ATTVALUE_INVALID", args, (short)1);
                    }
                    if (this.fTempAttDecl.simpleType.type == 1 || this.fTempAttDecl.simpleType.type == 2 || this.fTempAttDecl.simpleType.type == 3 || this.fTempAttDecl.simpleType.type == 4 || this.fTempAttDecl.simpleType.type == 5 || this.fTempAttDecl.simpleType.type == 6) {
                        this.validateDTDattribute(element, attrValue, this.fTempAttDecl);
                    }
                }
            }
            ++i;
        }
    }

    private String getExternalEntityRefInAttrValue(String nonNormalizedValue) {
        int valLength = nonNormalizedValue.length();
        int ampIndex = nonNormalizedValue.indexOf(38);
        while (ampIndex != -1) {
            if (ampIndex + 1 < valLength && nonNormalizedValue.charAt(ampIndex + 1) != '#') {
                int semicolonIndex = nonNormalizedValue.indexOf(59, ampIndex + 1);
                String entityName = nonNormalizedValue.substring(ampIndex + 1, semicolonIndex);
                int entIndex = this.fDTDGrammar.getEntityDeclIndex(entityName = this.fSymbolTable.addSymbol(entityName));
                if (entIndex > -1) {
                    this.fDTDGrammar.getEntityDecl(entIndex, this.fEntityDecl);
                    if (this.fEntityDecl.inExternal || (entityName = this.getExternalEntityRefInAttrValue(this.fEntityDecl.value)) != null) {
                        return entityName;
                    }
                }
            }
            ampIndex = nonNormalizedValue.indexOf(38, ampIndex + 1);
        }
        return null;
    }

    private void validateDTDattribute(QName element, String attValue, XMLAttributeDecl attributeDecl) throws XNIException {
        switch (attributeDecl.simpleType.type) {
            case 1: {
                boolean isAlistAttribute = attributeDecl.simpleType.list;
                try {
                    if (isAlistAttribute) {
                        this.fValENTITIES.validate(attValue, null);
                        break;
                    }
                    this.fValENTITY.validate(attValue, null);
                }
                catch (InvalidDatatypeValueException ex) {
                    String key = ex.getKeyIntoReporter();
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", key, new Object[]{ex.getMessage()}, (short)1);
                }
                break;
            }
            case 2: 
            case 6: {
                boolean found = false;
                String[] enumVals = attributeDecl.simpleType.enumeration;
                if (enumVals == null) {
                    found = false;
                } else {
                    int i = 0;
                    while (i < enumVals.length) {
                        if (attValue == enumVals[i] || attValue.equals(enumVals[i])) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (found) break;
                StringBuffer enumValueString = new StringBuffer();
                if (enumVals != null) {
                    int i = 0;
                    while (i < enumVals.length) {
                        enumValueString.append(enumVals[i] + " ");
                        ++i;
                    }
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ATTRIBUTE_VALUE_NOT_IN_LIST", new Object[]{attributeDecl.name.rawname, attValue, enumValueString}, (short)1);
                break;
            }
            case 3: {
                try {
                    this.fValID.validate(attValue, null);
                }
                catch (InvalidDatatypeValueException ex) {
                    String key = ex.getKeyIntoReporter();
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", key, new Object[]{ex.getMessage()}, (short)1);
                }
                break;
            }
            case 4: {
                boolean isAlistAttribute = attributeDecl.simpleType.list;
                try {
                    if (isAlistAttribute) {
                        this.fValIDRefs.validate(attValue, null);
                        break;
                    }
                    this.fValIDRef.validate(attValue, null);
                }
                catch (InvalidDatatypeValueException ex) {
                    String key = ex.getKeyIntoReporter();
                    if (key == null) {
                        key = "IDREFSInvalid";
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", key, new Object[]{ex.getMessage()}, (short)1);
                }
                break;
            }
            case 5: {
                boolean isAlistAttribute = attributeDecl.simpleType.list;
                try {
                    if (isAlistAttribute) {
                        this.fValNMTOKENS.validate(attValue, null);
                        break;
                    }
                    this.fValNMTOKEN.validate(attValue, null);
                }
                catch (InvalidDatatypeValueException ex) {
                    if (isAlistAttribute) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "NMTOKENSInvalid", new Object[]{attValue}, (short)1);
                        break;
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "NMTOKENInvalid", new Object[]{attValue}, (short)1);
                }
                break;
            }
        }
    }

    boolean invalidStandaloneAttDef(QName element, QName attribute) {
        boolean state = true;
        return state;
    }

    private boolean normalizeAttrValue(XMLAttributes attributes, int index) {
        boolean leadingSpace = true;
        boolean spaceStart = false;
        boolean readingNonSpace = false;
        int count = 0;
        int eaten = 0;
        String attrValue = attributes.getValue(index);
        char[] attValue = new char[attrValue.length()];
        this.fBuffer.setLength(0);
        attrValue.getChars(0, attrValue.length(), attValue, 0);
        int i = 0;
        while (i < attValue.length) {
            if (attValue[i] == ' ') {
                if (readingNonSpace) {
                    spaceStart = true;
                    readingNonSpace = false;
                }
                if (spaceStart && !leadingSpace) {
                    spaceStart = false;
                    this.fBuffer.append(attValue[i]);
                    ++count;
                } else if (leadingSpace || !spaceStart) {
                    ++eaten;
                }
            } else {
                readingNonSpace = true;
                spaceStart = false;
                leadingSpace = false;
                this.fBuffer.append(attValue[i]);
                ++count;
            }
            ++i;
        }
        if (count > 0 && this.fBuffer.charAt(count - 1) == ' ') {
            this.fBuffer.setLength(count - 1);
        }
        String newValue = this.fBuffer.toString();
        attributes.setValue(index, newValue);
        return !attrValue.equals(newValue);
    }

    private boolean normalizeDefaultAttrValue(XMLString value) {
        int oldLength = value.length;
        boolean skipSpace = true;
        int current = value.offset;
        int end = value.offset + value.length;
        int i = value.offset;
        while (i < end) {
            if (value.ch[i] == ' ') {
                if (!skipSpace) {
                    value.ch[current++] = 32;
                    skipSpace = true;
                }
            } else {
                if (current != i) {
                    value.ch[current] = value.ch[i];
                }
                ++current;
                skipSpace = false;
            }
            ++i;
        }
        if (current != end) {
            if (skipSpace) {
                --current;
            }
            value.length = current - value.offset;
            return true;
        }
        return false;
    }

    private void rootElementSpecified(QName rootElement) throws XNIException {
        if (this.fPerformValidation) {
            String root1 = this.fRootElement.rawname;
            String root2 = rootElement.rawname;
            if (root1 == null || !root1.equals(root2)) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RootElementTypeMustMatchDoctypedecl", new Object[]{root1, root2}, (short)1);
            }
        }
    }

    private int checkContent(int elementIndex, QName[] children, int childOffset, int childCount) throws XNIException {
        this.fDTDGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
        String elementType = this.fCurrentElement.rawname;
        int contentType = this.fCurrentContentSpecType;
        if (contentType == 1) {
            if (childCount != 0) {
                return 0;
            }
        } else if (contentType != 0) {
            if (contentType == 2 || contentType == 3) {
                ContentModelValidator cmElem = null;
                cmElem = this.fTempElementDecl.contentModelValidator;
                int result = cmElem.validate(children, childOffset, childCount);
                return result;
            }
            if (contentType == -1 || contentType == 4) {
                // empty if block
            }
        }
        return -1;
    }

    private int getContentSpecType(int elementIndex) {
        int contentSpecType = -1;
        if (elementIndex > -1 && this.fDTDGrammar.getElementDecl(elementIndex, this.fTempElementDecl)) {
            contentSpecType = this.fTempElementDecl.type;
        }
        return contentSpecType;
    }

    private void charDataInContent() {
        QName qname;
        if (this.fElementChildren.length <= this.fElementChildrenLength) {
            QName[] newarray = new QName[this.fElementChildren.length * 2];
            System.arraycopy(this.fElementChildren, 0, newarray, 0, this.fElementChildren.length);
            this.fElementChildren = newarray;
        }
        if ((qname = this.fElementChildren[this.fElementChildrenLength]) == null) {
            int i = this.fElementChildrenLength;
            while (i < this.fElementChildren.length) {
                this.fElementChildren[i] = new QName();
                ++i;
            }
            qname = this.fElementChildren[this.fElementChildrenLength];
        }
        qname.clear();
        ++this.fElementChildrenLength;
    }

    private String getAttributeTypeName(XMLAttributeDecl attrDecl) {
        switch (attrDecl.simpleType.type) {
            case 1: {
                return attrDecl.simpleType.list ? this.fENTITIESSymbol : this.fENTITYSymbol;
            }
            case 2: {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < attrDecl.simpleType.enumeration.length) {
                    if (i > 0) {
                        buffer.append("|");
                    }
                    buffer.append(attrDecl.simpleType.enumeration[i]);
                    ++i;
                }
                return this.fSymbolTable.addSymbol(buffer.toString());
            }
            case 3: {
                return this.fIDSymbol;
            }
            case 4: {
                return attrDecl.simpleType.list ? this.fIDREFSSymbol : this.fIDREFSymbol;
            }
            case 5: {
                return attrDecl.simpleType.list ? this.fNMTOKENSSymbol : this.fNMTOKENSSymbol;
            }
            case 6: {
                return this.fNOTATIONSymbol;
            }
        }
        return this.fCDATASymbol;
    }

    private void init() {
        this.fEMPTYSymbol = this.fSymbolTable.addSymbol("EMPTY");
        this.fANYSymbol = this.fSymbolTable.addSymbol("ANY");
        this.fMIXEDSymbol = this.fSymbolTable.addSymbol("MIXED");
        this.fCHILDRENSymbol = this.fSymbolTable.addSymbol("CHILDREN");
        this.fCDATASymbol = this.fSymbolTable.addSymbol("CDATA");
        this.fIDSymbol = this.fSymbolTable.addSymbol("ID");
        this.fIDREFSymbol = this.fSymbolTable.addSymbol("IDREF");
        this.fIDREFSSymbol = this.fSymbolTable.addSymbol("IDREFS");
        this.fENTITYSymbol = this.fSymbolTable.addSymbol("ENTITY");
        this.fENTITIESSymbol = this.fSymbolTable.addSymbol("ENTITIES");
        this.fNMTOKENSymbol = this.fSymbolTable.addSymbol("NMTOKEN");
        this.fNMTOKENSSymbol = this.fSymbolTable.addSymbol("NMTOKENS");
        this.fNOTATIONSymbol = this.fSymbolTable.addSymbol("NOTATION");
        this.fENUMERATIONSymbol = this.fSymbolTable.addSymbol("ENUMERATION");
        this.fIMPLIEDSymbol = this.fSymbolTable.addSymbol("#IMPLIED");
        this.fREQUIREDSymbol = this.fSymbolTable.addSymbol("#REQUIRED");
        this.fFIXEDSymbol = this.fSymbolTable.addSymbol("#FIXED");
        this.fDATATYPESymbol = this.fSymbolTable.addSymbol("<<datatype>>");
        if (this.fValidation) {
            try {
                ((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).initializeDTDRegistry();
                this.fValID = (IDDatatypeValidator)((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("ID");
                this.fValIDRef = (IDREFDatatypeValidator)((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("IDREF");
                this.fValIDRefs = (ListDatatypeValidator)((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("IDREFS");
                this.fValENTITY = (ENTITYDatatypeValidator)((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("ENTITY");
                this.fValENTITIES = (ListDatatypeValidator)((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("ENTITIES");
                this.fValNMTOKEN = ((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("NMTOKEN");
                this.fValNMTOKENS = ((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("NMTOKENS");
                this.fValNOTATION = (NOTATIONDatatypeValidator)((DatatypeValidatorFactoryImpl)this.fDatatypeValidatorFactory).getDatatypeValidator("NOTATION");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (this.fTableOfIDs == null) {
                this.fTableOfIDs = new Hashtable();
            }
            this.fTableOfIDs.clear();
            this.fValID.initialize(this.fTableOfIDs);
            this.fValIDRef.initialize(this.fTableOfIDs);
            this.fValIDRefs.initialize(this.fTableOfIDs);
            if (this.fNotationEnumVals == null) {
                this.fNotationEnumVals = new Hashtable();
            }
            this.fNotationEnumVals.clear();
            this.fTableOfIDAttributeNames = new Hashtable();
            this.fTableOfNOTATIONAttributeNames = new Hashtable();
        }
    }

    private void ensureStackCapacity(int newElementDepth) {
        if (newElementDepth == this.fElementQNamePartsStack.length) {
            int[] newStack = new int[newElementDepth * 2];
            QName[] newStackOfQueue = new QName[newElementDepth * 2];
            System.arraycopy(this.fElementQNamePartsStack, 0, newStackOfQueue, 0, newElementDepth);
            this.fElementQNamePartsStack = newStackOfQueue;
            QName qname = this.fElementQNamePartsStack[newElementDepth];
            if (qname == null) {
                int i = newElementDepth;
                while (i < this.fElementQNamePartsStack.length) {
                    this.fElementQNamePartsStack[i] = new QName();
                    ++i;
                }
            }
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fElementIndexStack, 0, newStack, 0, newElementDepth);
            this.fElementIndexStack = newStack;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fContentSpecTypeStack, 0, newStack, 0, newElementDepth);
            this.fContentSpecTypeStack = newStack;
        }
    }

    protected void handleStartElement(QName element, XMLAttributes attributes, boolean isEmpty) throws XNIException {
        boolean bl = this.fPerformValidation = !(!this.fValidation || this.fDynamicValidation && !this.fSeenDoctypeDecl || !this.fDTDValidation && !this.fSeenDoctypeDecl);
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            this.fValidationManager.getValidationState().setEntityState(this.fDTDGrammar);
            this.fValidationManager.setGrammarFound(this.fSeenDoctypeDecl);
            this.rootElementSpecified(element);
        }
        if (this.fDTDGrammar == null) {
            if (!this.fPerformValidation) {
                this.fCurrentElementIndex = -1;
                this.fCurrentContentSpecType = -1;
                this.fInElementContent = false;
            }
            if (this.fPerformValidation && !this.fSkipValidation) {
                this.fSkipValidation = true;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_GRAMMAR_NOT_FOUND", new Object[]{element.rawname}, (short)1);
            }
        } else {
            this.fCurrentElementIndex = this.fDTDGrammar.getElementDeclIndex(element, -1);
            this.fCurrentContentSpecType = this.getContentSpecType(this.fCurrentElementIndex);
            if (this.fCurrentElementIndex == -1 && this.fPerformValidation) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_ELEMENT_NOT_DECLARED", new Object[]{element.rawname}, (short)1);
            } else {
                this.addDTDDefaultAttrsAndValidate(this.fCurrentElementIndex, attributes);
            }
        }
        this.fInElementContent = this.fCurrentContentSpecType == 3;
        ++this.fElementDepth;
        if (this.fPerformValidation) {
            QName qname;
            Object[] newarray;
            if (this.fElementChildrenOffsetStack.length < this.fElementDepth) {
                newarray = new int[this.fElementChildrenOffsetStack.length * 2];
                System.arraycopy(this.fElementChildrenOffsetStack, 0, newarray, 0, this.fElementChildrenOffsetStack.length);
                this.fElementChildrenOffsetStack = newarray;
            }
            this.fElementChildrenOffsetStack[this.fElementDepth] = this.fElementChildrenLength;
            if (this.fElementChildren.length <= this.fElementChildrenLength) {
                newarray = new QName[this.fElementChildrenLength * 2];
                System.arraycopy(this.fElementChildren, 0, newarray, 0, this.fElementChildren.length);
                this.fElementChildren = (QName[])newarray;
            }
            if ((qname = this.fElementChildren[this.fElementChildrenLength]) == null) {
                int i = this.fElementChildrenLength;
                while (i < this.fElementChildren.length) {
                    this.fElementChildren[i] = new QName();
                    ++i;
                }
                qname = this.fElementChildren[this.fElementChildrenLength];
            }
            qname.setValues(element);
            ++this.fElementChildrenLength;
        }
        this.fCurrentElement.setValues(element);
        this.ensureStackCapacity(this.fElementDepth);
        this.fElementQNamePartsStack[this.fElementDepth].setValues(this.fCurrentElement);
        this.fElementIndexStack[this.fElementDepth] = this.fCurrentElementIndex;
        this.fContentSpecTypeStack[this.fElementDepth] = this.fCurrentContentSpecType;
        if (this.fDocumentHandler != null) {
            if (isEmpty) {
                this.fDocumentHandler.emptyElement(element, attributes);
            } else {
                this.fDocumentHandler.startElement(element, attributes);
            }
        }
    }

    protected void handleEndElement(QName element, boolean isEmpty) throws XNIException {
        --this.fElementDepth;
        if (this.fPerformValidation) {
            int childrenLength;
            int childrenOffset;
            QName[] children;
            int result;
            int elementIndex = this.fCurrentElementIndex;
            if (elementIndex != -1 && this.fCurrentContentSpecType != -1 && (result = this.checkContent(elementIndex, children = this.fElementChildren, childrenOffset = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1, childrenLength = this.fElementChildrenLength - childrenOffset)) != -1) {
                this.fDTDGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
                if (this.fTempElementDecl.type == 1) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID", new Object[]{element.rawname, "EMPTY"}, (short)1);
                } else {
                    String messageKey = result != childrenLength ? "MSG_CONTENT_INVALID" : "MSG_CONTENT_INCOMPLETE";
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", messageKey, new Object[]{element.rawname, this.fDTDGrammar.getContentSpecAsString(elementIndex)}, (short)1);
                }
            }
            this.fElementChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1;
        }
        if (this.fDocumentHandler != null && !isEmpty) {
            this.fDocumentHandler.endElement(this.fCurrentElement);
        }
        if (this.fElementDepth < -1) {
            throw new RuntimeException("FWK008 Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElement.clear();
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fPerformValidation) {
                try {
                    this.fValIDRef.validate();
                    this.fValIDRefs.validate();
                }
                catch (InvalidDatatypeValueException ex) {
                    String key = ex.getKeyIntoReporter();
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", key, new Object[]{ex.getMessage()}, (short)1);
                }
                this.fTableOfIDs.clear();
            }
            return;
        }
        this.fCurrentElement.setValues(this.fElementQNamePartsStack[this.fElementDepth]);
        this.fCurrentElementIndex = this.fElementIndexStack[this.fElementDepth];
        this.fCurrentContentSpecType = this.fContentSpecTypeStack[this.fElementDepth];
        this.fInElementContent = this.fCurrentContentSpecType == 3;
    }

    protected DTDGrammar createDTDGrammar() {
        return new DTDGrammar(this.fSymbolTable);
    }
}

