/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public abstract class XMLScanner
implements XMLComponent {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final boolean DEBUG_ATTR_NORMALIZATION = false;
    protected boolean fValidation = false;
    protected boolean fNotifyCharRefs = false;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityScanner fEntityScanner;
    protected int fEntityDepth;
    protected String fCharRefLiteral = null;
    protected boolean fScanningAttribute;
    protected String fVersionSymbol;
    protected String fEncodingSymbol;
    protected String fStandaloneSymbol;
    protected String fAmpSymbol;
    protected String fLtSymbol;
    protected String fGtSymbol;
    protected String fQuotSymbol;
    protected String fAposSymbol;
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
        this.fEntityDepth = 0;
        this.fVersionSymbol = this.fSymbolTable.addSymbol("version");
        this.fEncodingSymbol = this.fSymbolTable.addSymbol("encoding");
        this.fStandaloneSymbol = this.fSymbolTable.addSymbol("standalone");
        this.fAmpSymbol = this.fSymbolTable.addSymbol("amp");
        this.fLtSymbol = this.fSymbolTable.addSymbol("lt");
        this.fGtSymbol = this.fSymbolTable.addSymbol("gt");
        this.fQuotSymbol = this.fSymbolTable.addSymbol("quot");
        this.fAposSymbol = this.fSymbolTable.addSymbol("apos");
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fNotifyCharRefs = componentManager.getFeature(NOTIFY_CHAR_REFS);
        }
        catch (XMLConfigurationException e) {
            this.fNotifyCharRefs = false;
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
            } else if (property.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
            } else if (property.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)value;
            }
            return;
        }
    }

    public void setFeature(String featureId, boolean value) throws XMLConfigurationException {
        if (VALIDATION.equals(featureId)) {
            this.fValidation = value;
        } else if (NOTIFY_CHAR_REFS.equals(featureId)) {
            this.fNotifyCharRefs = value;
        }
    }

    protected void scanXMLDeclOrTextDecl(boolean scanningTextDecl, String[] pseudoAttributeValues) throws IOException, XNIException {
        String version = null;
        String encoding = null;
        String standalone = null;
        boolean STATE_VERSION = false;
        boolean STATE_ENCODING = true;
        int STATE_STANDALONE = 2;
        int STATE_DONE = 3;
        int state = 0;
        boolean sawSpace = this.fEntityScanner.skipSpaces();
        while (this.fEntityScanner.peekChar() != 63) {
            String name = this.scanPseudoAttribute(scanningTextDecl, this.fString);
            switch (state) {
                case 0: {
                    if (name == this.fVersionSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        version = this.fString.toString();
                        state = 1;
                        if (version.equals("1.0")) break;
                        this.reportFatalError("VersionNotSupported", new Object[]{version});
                        break;
                    }
                    if (name == this.fEncodingSymbol) {
                        if (!scanningTextDecl) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        encoding = this.fString.toString();
                        state = scanningTextDecl ? 3 : 2;
                        break;
                    }
                    if (scanningTextDecl) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (name == this.fEncodingSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        encoding = this.fString.toString();
                        state = scanningTextDecl ? 3 : 2;
                        break;
                    }
                    if (!scanningTextDecl && name == this.fStandaloneSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        standalone = this.fString.toString();
                        state = 3;
                        if (standalone.equals("yes") || standalone.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (name == this.fStandaloneSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        standalone = this.fString.toString();
                        state = 3;
                        if (standalone.equals("yes") || standalone.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            sawSpace = this.fEntityScanner.skipSpaces();
        }
        if (scanningTextDecl && state != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        pseudoAttributeValues[0] = version;
        pseudoAttributeValues[1] = encoding;
        pseudoAttributeValues[2] = standalone;
    }

    public String scanPseudoAttribute(boolean scanningTextDecl, XMLString value) throws IOException, XNIException {
        String name = this.fEntityScanner.scanName();
        if (name == null) {
            this.reportFatalError("PseudoAttrNameExpected", null);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError(scanningTextDecl ? "EqRequiredInTextDecl" : "EqRequiredInXMLDecl", new Object[]{name});
        }
        this.fEntityScanner.skipSpaces();
        int quote = this.fEntityScanner.peekChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError(scanningTextDecl ? "QuoteRequiredInTextDecl" : "QuoteRequiredInXMLDecl", new Object[]{name});
        }
        this.fEntityScanner.scanChar();
        int c = this.fEntityScanner.scanLiteral(quote, value);
        if (c != quote) {
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append(value);
                if (c == -1) continue;
                if (c == 38 || c == 37 || c == 60 || c == 93) {
                    this.fStringBuffer2.append((char)this.fEntityScanner.scanChar());
                    continue;
                }
                if (XMLChar.isHighSurrogate(c)) {
                    this.scanSurrogates(this.fStringBuffer2);
                    continue;
                }
                if (!XMLChar.isInvalid(c)) continue;
                String key = scanningTextDecl ? "InvalidCharInTextDecl" : "InvalidCharInXMLDecl";
                this.reportFatalError(key, new Object[]{Integer.toString(c, 16)});
                this.fEntityScanner.scanChar();
            } while ((c = this.fEntityScanner.scanLiteral(quote, value)) != quote);
            this.fStringBuffer2.append(value);
            value.setValues(this.fStringBuffer2);
        }
        if (!this.fEntityScanner.skipChar(quote)) {
            this.reportFatalError(scanningTextDecl ? "CloseQuoteMissingInTextDecl" : "CloseQuoteMissingInXMLDecl", new Object[]{name});
        }
        return name;
    }

    protected void scanPI() throws IOException, XNIException {
        String target = this.fEntityScanner.scanName();
        if (target == null) {
            this.reportFatalError("PITargetRequired", null);
        }
        this.scanPIData(target, this.fString);
    }

    protected void scanPIData(String target, XMLString data) throws IOException, XNIException {
        if (target.length() == 3) {
            char c0 = Character.toLowerCase(target.charAt(0));
            char c1 = Character.toLowerCase(target.charAt(1));
            char c2 = Character.toLowerCase(target.charAt(2));
            if (c0 == 'x' && c1 == 'm' && c2 == 'l') {
                this.reportFatalError("ReservedPITarget", null);
            }
        }
        if (!this.fEntityScanner.skipSpaces()) {
            if (this.fEntityScanner.skipString("?>")) {
                data.clear();
                return;
            }
            this.reportFatalError("SpaceRequiredInPI", null);
        }
        if (this.fEntityScanner.scanData("?>", data)) {
            this.fStringBuffer.clear();
            do {
                this.fStringBuffer.append(data);
                int c = this.fEntityScanner.peekChar();
                if (c == -1) continue;
                if (XMLChar.isHighSurrogate(c)) {
                    this.scanSurrogates(this.fStringBuffer);
                    continue;
                }
                if (!XMLChar.isInvalid(c)) continue;
                this.reportFatalError("InvalidCharInPI", new Object[]{Integer.toHexString(c)});
                this.fEntityScanner.scanChar();
            } while (this.fEntityScanner.scanData("?>", data));
            this.fStringBuffer.append(data);
            data.setValues(this.fStringBuffer);
        }
    }

    protected void scanComment(XMLStringBuffer text) throws IOException, XNIException {
        text.clear();
        while (this.fEntityScanner.scanData("--", this.fString)) {
            text.append(this.fString);
            int c = this.fEntityScanner.peekChar();
            if (c == -1) continue;
            if (XMLChar.isHighSurrogate(c)) {
                this.scanSurrogates(text);
            }
            if (!XMLChar.isInvalid(c)) continue;
            this.reportFatalError("InvalidCharInComment", new Object[]{Integer.toHexString(c)});
            this.fEntityScanner.scanChar();
        }
        text.append(this.fString);
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("DashDashInComment", null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scanAttributeValue(XMLString value, XMLString nonNormalizedValue, String atName, XMLAttributes attributes, int attrIndex, boolean checkEntities) throws IOException, XNIException {
        int quote;
        block26: {
            quote = this.fEntityScanner.peekChar();
            if (quote != 39 && quote != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{atName});
            }
            this.fEntityScanner.scanChar();
            int entityDepth = this.fEntityDepth;
            int c = this.fEntityScanner.scanLiteral(quote, value);
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(value);
            this.normalizeWhitespace(value);
            if (c == quote) break block26;
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                block29: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block27: {
                                        String entityName;
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        block30: {
                                                            block28: {
                                                                int ch;
                                                                this.fStringBuffer.append(value);
                                                                if (c != 38) break block27;
                                                                this.fEntityScanner.skipChar(38);
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('&');
                                                                }
                                                                if (!this.fEntityScanner.skipChar(35)) break block28;
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('#');
                                                                }
                                                                if ((ch = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) == -1) {
                                                                    // empty if block
                                                                }
                                                                break block29;
                                                            }
                                                            entityName = this.fEntityScanner.scanName();
                                                            if (entityName == null) {
                                                                this.reportFatalError("NameRequiredInReference", null);
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(entityName);
                                                            }
                                                            if (!this.fEntityScanner.skipChar(59)) {
                                                                this.reportFatalError("SemicolonRequiredInReference", new Object[]{entityName});
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(';');
                                                            }
                                                            if (entityName != this.fAmpSymbol) break block30;
                                                            this.fStringBuffer.append('&');
                                                            break block29;
                                                        }
                                                        if (entityName != this.fAposSymbol) break block31;
                                                        this.fStringBuffer.append('\'');
                                                        break block29;
                                                    }
                                                    if (entityName != this.fLtSymbol) break block32;
                                                    this.fStringBuffer.append('<');
                                                    break block29;
                                                }
                                                if (entityName != this.fGtSymbol) break block33;
                                                this.fStringBuffer.append('>');
                                                break block29;
                                            }
                                            if (entityName != this.fQuotSymbol) break block34;
                                            this.fStringBuffer.append('\"');
                                            break block29;
                                        }
                                        if (this.fEntityManager.isExternalEntity(entityName)) {
                                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{entityName});
                                            break block29;
                                        } else {
                                            if (!this.fEntityManager.isDeclaredEntity(entityName)) {
                                                if (checkEntities) {
                                                    if (this.fValidation) {
                                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{entityName}, (short)1);
                                                    }
                                                } else {
                                                    this.reportFatalError("EntityNotDeclared", new Object[]{entityName});
                                                }
                                            }
                                            this.fEntityManager.startEntity(entityName, true);
                                        }
                                        break block29;
                                    }
                                    if (c != 60) break block35;
                                    this.reportFatalError("LessthanInAttValue", new Object[]{null, atName});
                                    this.fEntityScanner.scanChar();
                                    if (entityDepth == this.fEntityDepth) {
                                        this.fStringBuffer2.append((char)c);
                                    }
                                    break block29;
                                }
                                if (c != 37 && c != 93) break block36;
                                this.fEntityScanner.scanChar();
                                this.fStringBuffer.append((char)c);
                                if (entityDepth == this.fEntityDepth) {
                                    this.fStringBuffer2.append((char)c);
                                }
                                break block29;
                            }
                            if (c != 10 && c != 13) break block37;
                            this.fEntityScanner.scanChar();
                            this.fStringBuffer.append(' ');
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append('\n');
                            }
                            break block29;
                        }
                        if (c == -1 || !XMLChar.isHighSurrogate(c)) break block38;
                        if (this.scanSurrogates(this.fStringBuffer3)) {
                            this.fStringBuffer.append(this.fStringBuffer3);
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append(this.fStringBuffer3);
                            }
                        }
                        break block29;
                    }
                    if (c != -1 && XMLChar.isInvalid(c)) {
                        this.reportFatalError("InvalidCharInAttValue", new Object[]{Integer.toString(c, 16)});
                        this.fEntityScanner.scanChar();
                        if (entityDepth == this.fEntityDepth) {
                            this.fStringBuffer2.append((char)c);
                        }
                    }
                }
                c = this.fEntityScanner.scanLiteral(quote, value);
                if (entityDepth == this.fEntityDepth) {
                    this.fStringBuffer2.append(value);
                }
                this.normalizeWhitespace(value);
            } while (c != quote || entityDepth != this.fEntityDepth);
            this.fStringBuffer.append(value);
            value.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        nonNormalizedValue.setValues(this.fStringBuffer2);
        int cquote = this.fEntityScanner.scanChar();
        if (cquote != quote) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{atName});
        }
    }

    protected void scanExternalID(String[] identifiers, boolean optionalSystemId) throws IOException, XNIException {
        String systemId = null;
        String publicId = null;
        if (this.fEntityScanner.skipString("PUBLIC")) {
            if (!this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterPUBLIC", null);
            }
            this.scanPubidLiteral(this.fString);
            publicId = this.fString.toString();
            if (!this.fEntityScanner.skipSpaces() && !optionalSystemId) {
                this.reportFatalError("SpaceRequiredBetweenPublicAndSystem", null);
            }
        }
        if (publicId != null || this.fEntityScanner.skipString("SYSTEM")) {
            int quote;
            if (publicId == null && !this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterSYSTEM", null);
            }
            if ((quote = this.fEntityScanner.peekChar()) != 39 && quote != 34) {
                if (publicId != null && optionalSystemId) {
                    identifiers[0] = null;
                    identifiers[1] = publicId;
                    return;
                }
                this.reportFatalError("QuoteRequiredInSystemID", null);
            }
            this.fEntityScanner.scanChar();
            XMLString ident = this.fString;
            if (this.fEntityScanner.scanLiteral(quote, ident) != quote) {
                this.fStringBuffer.clear();
                do {
                    this.fStringBuffer.append(ident);
                    int c = this.fEntityScanner.peekChar();
                    if (!XMLChar.isMarkup(c) && c != 93) continue;
                    this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
                } while (this.fEntityScanner.scanLiteral(quote, ident) != quote);
                this.fStringBuffer.append(ident);
                ident = this.fStringBuffer;
            }
            systemId = ident.toString();
            if (!this.fEntityScanner.skipChar(quote)) {
                this.reportFatalError("SystemIDUnterminated", null);
            }
        }
        identifiers[0] = systemId;
        identifiers[1] = publicId;
    }

    protected boolean scanPubidLiteral(XMLString literal) throws IOException, XNIException {
        int quote = this.fEntityScanner.scanChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean skipSpace = true;
        boolean dataok = true;
        while (true) {
            int c;
            if ((c = this.fEntityScanner.scanChar()) == 32 || c == 10 || c == 13) {
                if (skipSpace) continue;
                this.fStringBuffer.append(' ');
                skipSpace = true;
                continue;
            }
            if (c == quote) {
                if (skipSpace) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(c)) {
                this.fStringBuffer.append((char)c);
                skipSpace = false;
                continue;
            }
            if (c == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            dataok = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(c)});
        }
        literal.setValues(this.fStringBuffer);
        return dataok;
    }

    protected void normalizeWhitespace(XMLString value) {
        int end = value.offset + value.length;
        int i = value.offset;
        while (i < end) {
            char c = value.ch[i];
            if (XMLChar.isSpace(c)) {
                value.ch[i] = 32;
            }
            ++i;
        }
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
        ++this.fEntityDepth;
    }

    public void endEntity(String name) throws XNIException {
        --this.fEntityDepth;
    }

    protected int scanCharReferenceValue(XMLStringBuffer buf, XMLStringBuffer buf2) throws IOException, XNIException {
        int c;
        boolean digit;
        boolean hex = false;
        if (this.fEntityScanner.skipChar(120)) {
            if (buf2 != null) {
                buf2.append('x');
            }
            hex = true;
            this.fStringBuffer3.clear();
            digit = true;
            do {
                boolean bl = digit = (c = this.fEntityScanner.peekChar()) >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
                if (!digit) continue;
                if (buf2 != null) {
                    buf2.append((char)c);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)c);
            } while (digit);
        } else {
            this.fStringBuffer3.clear();
            digit = true;
            do {
                boolean bl = digit = (c = this.fEntityScanner.peekChar()) >= 48 && c <= 57;
                if (!digit) continue;
                if (buf2 != null) {
                    buf2.append((char)c);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)c);
            } while (digit);
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInCharRef", null);
        }
        if (buf2 != null) {
            buf2.append(';');
        }
        int value = -1;
        try {
            value = Integer.parseInt(this.fStringBuffer3.toString(), hex ? 16 : 10);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (!XMLChar.isValid(value)) {
            this.reportFatalError("InvalidCharRef", new Object[]{Integer.toString(value, 16)});
        }
        if (!XMLChar.isSupplemental(value)) {
            buf.append((char)value);
        } else {
            buf.append(XMLChar.highSurrogate(value));
            buf.append(XMLChar.lowSurrogate(value));
        }
        if (this.fNotifyCharRefs && value != -1) {
            String literal = "#" + (hex ? "x" : "") + this.fStringBuffer3.toString();
            if (!this.fScanningAttribute) {
                this.fCharRefLiteral = literal;
            }
        }
        return value;
    }

    protected boolean scanSurrogates(XMLStringBuffer buf) throws IOException, XNIException {
        int high = this.fEntityScanner.scanChar();
        int low = this.fEntityScanner.peekChar();
        if (!XMLChar.isLowSurrogate(low)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(high, 16)});
            return false;
        }
        this.fEntityScanner.scanChar();
        int c = XMLChar.supplemental((char)high, (char)low);
        if (!XMLChar.isValid(c)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(c, 16)});
            return false;
        }
        buf.append((char)high);
        buf.append((char)low);
        return true;
    }

    protected void reportFatalError(String msgId, Object[] args) throws XNIException {
        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", msgId, args, (short)2);
    }

    public abstract String[] getRecognizedProperties();

    public abstract String[] getRecognizedFeatures();
}

