/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.io.ASCIIReader;
import org.apache.xerces.impl.io.UTF8Reader;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLEntityManager
implements XMLComponent,
XMLEntityResolver {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/allow-java-encodings"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver"};
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_ENTITIES = false;
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_RESOLVER = false;
    protected boolean fValidation;
    protected boolean fExternalGeneralEntities;
    protected boolean fExternalParameterEntities;
    protected boolean fAllowJavaEncodings;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected int fBufferSize = 2048;
    protected boolean fStandalone;
    protected XMLEntityHandler fEntityHandler;
    protected XMLEntityScanner fEntityScanner;
    protected Hashtable fEntities = new Hashtable();
    protected Stack fEntityStack = new Stack();
    protected ScannedEntity fCurrentEntity;
    protected Hashtable fDeclaredEntities;

    public XMLEntityManager() {
        this(null);
    }

    public XMLEntityManager(XMLEntityManager entityManager) {
        this.fEntityScanner = new EntityScanner();
        this.fDeclaredEntities = entityManager != null ? entityManager.getDeclaredEntities() : null;
    }

    public void setStandalone(boolean standalone) {
        this.fStandalone = standalone;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public void setEntityHandler(XMLEntityHandler entityHandler) {
        this.fEntityHandler = entityHandler;
    }

    public void addInternalEntity(String name, String text) {
        if (!this.fEntities.containsKey(name)) {
            InternalEntity entity = new InternalEntity(name, text);
            this.fEntities.put(name, entity);
        }
    }

    public void addExternalEntity(String name, String publicId, String systemId, String baseSystemId) {
        if (!this.fEntities.containsKey(name)) {
            if (baseSystemId == null) {
                int size = this.fEntityStack.size();
                if (size == 0 && this.fCurrentEntity != null) {
                    baseSystemId = this.fCurrentEntity.systemId;
                }
                int i = size - 1;
                while (i >= 0) {
                    ScannedEntity externalEntity = (ScannedEntity)this.fEntityStack.elementAt(i);
                    if (externalEntity.systemId != null) {
                        baseSystemId = externalEntity.systemId;
                    }
                    --i;
                }
            }
            ExternalEntity entity = new ExternalEntity(name, publicId, systemId, baseSystemId, null);
            this.fEntities.put(name, entity);
        }
    }

    public boolean isExternalEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public void addUnparsedEntity(String name, String publicId, String systemId, String notation) {
        if (!this.fEntities.containsKey(name)) {
            ExternalEntity entity = new ExternalEntity(name, publicId, systemId, null, notation);
            this.fEntities.put(name, entity);
        }
    }

    public boolean isUnparsedEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        return entity != null;
    }

    public XMLInputSource resolveEntity(String publicId, String systemId, String baseSystemId) throws IOException, XNIException {
        if (baseSystemId == null) {
            baseSystemId = this.fCurrentEntity.systemId;
        }
        XMLInputSource xmlInputSource = null;
        if (this.fEntityResolver != null) {
            xmlInputSource = this.fEntityResolver.resolveEntity(publicId, systemId, baseSystemId);
        }
        if (xmlInputSource == null) {
            xmlInputSource = new XMLInputSource(publicId, systemId, baseSystemId);
        }
        return xmlInputSource;
    }

    public void startEntity(String entityName, boolean literal) throws IOException, XNIException {
        int size;
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            if (this.fEntityHandler != null) {
                String publicId = null;
                String systemId = null;
                String baseSystemId = null;
                String encoding = null;
                this.fEntityHandler.startEntity(entityName, publicId, systemId, baseSystemId, encoding);
                this.fEntityHandler.endEntity(entityName);
            }
            return;
        }
        boolean external = entity.isExternal();
        if (external) {
            boolean general;
            boolean unparsed = entity.isUnparsed();
            boolean parameter = entityName.startsWith("%");
            boolean bl = general = !parameter;
            if (unparsed || general && !this.fExternalGeneralEntities || parameter && !this.fExternalParameterEntities) {
                if (this.fEntityHandler != null) {
                    String publicId = null;
                    String systemId = null;
                    String baseSystemId = null;
                    String encoding = null;
                    if (external) {
                        ExternalEntity externalEntity = (ExternalEntity)entity;
                        publicId = externalEntity.publicId;
                        systemId = externalEntity.systemId;
                        baseSystemId = XMLEntityManager.expandSystemId(systemId, externalEntity.baseSystemId);
                    }
                    this.fEntityHandler.startEntity(entityName, publicId, systemId, baseSystemId, encoding);
                    this.fEntityHandler.endEntity(entityName);
                }
                return;
            }
        }
        int i = size = this.fEntityStack.size();
        while (i >= 0) {
            Entity activeEntity;
            Entity entity2 = activeEntity = i == size ? this.fCurrentEntity : (Entity)this.fEntityStack.elementAt(i);
            if (activeEntity.name == entityName) {
                String path = entityName;
                int j = i + 1;
                while (j < size) {
                    activeEntity = (Entity)this.fEntityStack.elementAt(j);
                    path = path + " -> " + activeEntity.name;
                    ++j;
                }
                path = path + " -> " + this.fCurrentEntity.name;
                path = path + " -> " + entityName;
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RecursiveReference", new Object[]{entityName, path}, (short)2);
                if (this.fEntityHandler != null) {
                    String publicId = null;
                    String systemId = null;
                    String baseSystemId = null;
                    String encoding = null;
                    if (external) {
                        ExternalEntity externalEntity = (ExternalEntity)entity;
                        publicId = externalEntity.publicId;
                        systemId = externalEntity.systemId;
                        baseSystemId = XMLEntityManager.expandSystemId(systemId, externalEntity.baseSystemId);
                    }
                    this.fEntityHandler.startEntity(entityName, publicId, systemId, baseSystemId, encoding);
                    this.fEntityHandler.endEntity(entityName);
                }
                return;
            }
            --i;
        }
        XMLInputSource xmlInputSource = null;
        if (external) {
            ExternalEntity externalEntity = (ExternalEntity)entity;
            String publicId = externalEntity.publicId;
            String systemId = externalEntity.systemId;
            String baseSystemId = externalEntity.baseSystemId;
            xmlInputSource = this.resolveEntity(publicId, systemId, baseSystemId);
        } else {
            InternalEntity internalEntity = (InternalEntity)entity;
            StringReader reader = new StringReader(internalEntity.text);
            xmlInputSource = new XMLInputSource(null, null, null, reader, null);
        }
        this.startEntity(entityName, xmlInputSource, literal);
    }

    public void startDocumentEntity(XMLInputSource xmlInputSource) throws IOException, XNIException {
        String entityName = this.fSymbolTable.addSymbol("[xml]");
        this.startEntity(entityName, xmlInputSource, false);
    }

    public void startDTDEntity(XMLInputSource xmlInputSource) throws IOException, XNIException {
        String entityName = this.fSymbolTable.addSymbol("[dtd]");
        this.startEntity(entityName, xmlInputSource, false);
    }

    public void startEntity(String name, XMLInputSource xmlInputSource, boolean literal) throws IOException, XNIException {
        String expandedSystemId;
        String publicId = xmlInputSource.getPublicId();
        String systemId = xmlInputSource.getSystemId();
        String baseSystemId = xmlInputSource.getBaseSystemId();
        String encoding = xmlInputSource.getEncoding();
        InputStream stream = null;
        Reader reader = xmlInputSource.getCharacterStream();
        if (reader == null) {
            stream = xmlInputSource.getByteStream();
            if (stream == null) {
                expandedSystemId = XMLEntityManager.expandSystemId(systemId, baseSystemId);
                if (baseSystemId == null) {
                    baseSystemId = expandedSystemId;
                }
                stream = new URL(expandedSystemId).openStream();
            }
            if (encoding == null) {
                byte[] b4 = new byte[4];
                int count = stream.read(b4, 0, 4);
                if (count != -1) {
                    encoding = this.getEncodingName(b4, count);
                    PushbackInputStream pbstream = new PushbackInputStream(stream, 4);
                    int offset = 0;
                    if (count > 2 && encoding.equals("UTF-8")) {
                        int b0 = b4[0] & 0xFF;
                        int b1 = b4[1] & 0xFF;
                        int b2 = b4[2] & 0xFF;
                        if (b0 == 239 && b1 == 187 && b2 == 191) {
                            offset = 3;
                            count -= offset;
                        }
                    }
                    pbstream.unread(b4, offset, count);
                    reader = this.createReader(pbstream, encoding);
                } else {
                    reader = this.createReader(stream, encoding);
                }
            } else {
                reader = this.createReader(stream, encoding);
            }
            reader = new OneCharReader(reader);
        }
        if (this.fCurrentEntity != null) {
            this.fEntityStack.push(this.fCurrentEntity);
        }
        expandedSystemId = XMLEntityManager.expandSystemId(systemId, baseSystemId);
        this.fCurrentEntity = new ScannedEntity(name, publicId, systemId, expandedSystemId, stream, reader, encoding, literal);
        if (this.fEntityHandler != null) {
            this.fEntityHandler.startEntity(name, publicId, systemId, baseSystemId, encoding);
        }
    }

    public XMLEntityScanner getEntityScanner() {
        return this.fEntityScanner;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fExternalGeneralEntities = componentManager.getFeature(EXTERNAL_GENERAL_ENTITIES);
        }
        catch (XMLConfigurationException e) {
            this.fExternalGeneralEntities = true;
        }
        try {
            this.fExternalParameterEntities = componentManager.getFeature(EXTERNAL_PARAMETER_ENTITIES);
        }
        catch (XMLConfigurationException e) {
            this.fExternalParameterEntities = true;
        }
        try {
            this.fAllowJavaEncodings = componentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException e) {
            this.fAllowJavaEncodings = false;
        }
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException e) {
            this.fEntityResolver = null;
        }
        this.fStandalone = false;
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fCurrentEntity = null;
        if (this.fDeclaredEntities != null) {
            Enumeration keys = this.fDeclaredEntities.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = this.fDeclaredEntities.get(key);
                this.fEntities.put(key, value);
            }
        }
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        String feature;
        if (featureId.startsWith("http://apache.org/xml/features/") && (feature = featureId.substring("http://apache.org/xml/features/".length())).equals("allow-java-encodings")) {
            this.fAllowJavaEncodings = state;
        }
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
                return;
            }
            if (property.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
                return;
            }
            if (property.equals("internal/entity-resolver")) {
                this.fEntityResolver = (XMLEntityResolver)value;
                return;
            }
        }
    }

    public static String expandSystemId(String systemId) {
        return XMLEntityManager.expandSystemId(systemId, null);
    }

    public static String expandSystemId(String systemId, String baseSystemId) {
        if (systemId == null || systemId.length() == 0) {
            return systemId;
        }
        try {
            URI uri = new URI(systemId);
            if (uri != null) {
                return systemId;
            }
        }
        catch (URI.MalformedURIException e) {
            // empty catch block
        }
        String id = XMLEntityManager.fixURI(systemId);
        URI base = null;
        URI uri = null;
        try {
            if (baseSystemId == null || baseSystemId.length() == 0 || baseSystemId.equals(systemId)) {
                String dir;
                try {
                    dir = XMLEntityManager.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException se) {
                    dir = "";
                }
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                base = new URI("file", "", dir, null, null);
            } else {
                try {
                    base = new URI(XMLEntityManager.fixURI(baseSystemId));
                }
                catch (URI.MalformedURIException e) {
                    String dir;
                    try {
                        dir = XMLEntityManager.fixURI(System.getProperty("user.dir"));
                    }
                    catch (SecurityException se) {
                        dir = "";
                    }
                    if (baseSystemId.indexOf(58) != -1) {
                        base = new URI("file", "", XMLEntityManager.fixURI(baseSystemId), null, null);
                    }
                    if (!dir.endsWith("/")) {
                        dir = dir + "/";
                    }
                    dir = dir + XMLEntityManager.fixURI(baseSystemId);
                    base = new URI("file", "", dir, null, null);
                }
            }
            uri = new URI(base, id);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (uri == null) {
            return systemId;
        }
        return uri.toString();
    }

    protected void endEntity() throws XNIException {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.endEntity(this.fCurrentEntity.name);
        }
        this.fCurrentEntity = this.fEntityStack.size() > 0 ? (ScannedEntity)this.fEntityStack.pop() : null;
    }

    protected String getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            return "UTF-8";
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return "UTF-16";
        }
        if (b0 == 255 && b1 == 254) {
            return "UTF-16";
        }
        if (count < 3) {
            return "UTF-8";
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return "UTF-8";
        }
        if (count < 4) {
            return "UTF-8";
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return "UCS-4";
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return "UCS-4";
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return "UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return "UCS-4";
        }
        if (b1 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return "UCS-4";
        }
        if (b1 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return "UCS-4";
        }
        if (b1 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return "EBCDIC";
        }
        return "UTF-8";
    }

    protected Reader createReader(InputStream inputStream, String encoding) throws IOException {
        String javaEncoding;
        String ENCODING;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((ENCODING = encoding.toUpperCase()).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fBufferSize);
        }
        if (ENCODING.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize);
        }
        boolean validIANA = XMLChar.isValidIANAEncoding(encoding);
        boolean validJava = XMLChar.isValidJavaEncoding(encoding);
        if (!validIANA || this.fAllowJavaEncodings && !validJava) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
            encoding = "ISO-8859-1";
        }
        if ((javaEncoding = EncodingMap.getIANA2JavaMapping(ENCODING)) == null) {
            javaEncoding = encoding;
        }
        return new InputStreamReader(inputStream, javaEncoding);
    }

    protected static String fixURI(String str) {
        char ch0;
        char ch1;
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2 && (ch1 = str.charAt(1)) == ':' && (ch0 = Character.toUpperCase(str.charAt(0))) >= 'A' && ch0 <= 'Z') {
            str = "/" + str;
        }
        return str;
    }

    Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    final void print() {
    }

    protected class OneCharReader
    extends FilterReader {
        private final char[] TEXTDECL = new char[]{'<', '?', 'x', 'm', 'l'};
        private int fOffset;
        private boolean fSeenFirstChar;
        private boolean fSeenEndOfMarkup;

        public OneCharReader(Reader reader) {
            super(reader);
        }

        public Reader getReader() {
            return this.in;
        }

        public int read() throws IOException {
            if (this.fSeenEndOfMarkup) {
                XMLEntityManager.this.fCurrentEntity.reader = this.in;
                return XMLEntityManager.this.fCurrentEntity.reader.read();
            }
            int c = this.in.read();
            this.fSeenEndOfMarkup = this.fOffset < this.TEXTDECL.length ? c != this.TEXTDECL[this.fOffset++] : c == 62;
            return c;
        }

        public int read(char[] ch, int offset, int length) throws IOException {
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            ch[offset] = (char)c;
            return 1;
        }
    }

    protected class EntityScanner
    extends XMLEntityScanner {
        public String getBaseSystemId() {
            return XMLEntityManager.this.fCurrentEntity != null ? XMLEntityManager.this.fCurrentEntity.baseSystemId : null;
        }

        public void setEncoding(String encoding) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.stream != null) {
                XMLEntityManager.this.fCurrentEntity.reader = XMLEntityManager.this.fCurrentEntity.encoding != null && XMLEntityManager.this.fCurrentEntity.encoding.equals(encoding) ? ((OneCharReader)XMLEntityManager.this.fCurrentEntity.reader).getReader() : XMLEntityManager.this.createReader(XMLEntityManager.this.fCurrentEntity.stream, encoding);
            }
        }

        public boolean isExternal() {
            return XMLEntityManager.this.fCurrentEntity.isExternal();
        }

        public int peekChar() throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
            if (XMLEntityManager.this.fCurrentEntity.isExternal()) {
                return c != 13 ? c : 10;
            }
            return c;
        }

        public int scanChar() throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++];
            boolean external = false;
            if (c == 10 || c == 13 && (external = XMLEntityManager.this.fCurrentEntity.isExternal())) {
                ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    XMLEntityManager.this.fCurrentEntity.ch[0] = (char)c;
                    this.load(1, false);
                }
                if (c == 13 && external) {
                    if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++] != '\n') {
                        --XMLEntityManager.this.fCurrentEntity.position;
                    }
                    c = 10;
                }
            }
            ++XMLEntityManager.this.fCurrentEntity.columnNumber;
            return c;
        }

        public String scanNmtoken() throws IOException {
            int length;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int offset = XMLEntityManager.this.fCurrentEntity.position;
            while (XMLChar.isName(XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position])) {
                if (++XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                length = XMLEntityManager.this.fCurrentEntity.position - offset;
                if (length == XMLEntityManager.this.fBufferSize) {
                    char[] tmp = new char[XMLEntityManager.this.fBufferSize * 2];
                    System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, offset, tmp, 0, length);
                    XMLEntityManager.this.fCurrentEntity.ch = tmp;
                    XMLEntityManager.this.fBufferSize *= 2;
                } else {
                    System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, offset, XMLEntityManager.this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (this.load(length, false)) break;
            }
            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            XMLEntityManager.this.fCurrentEntity.columnNumber += length;
            String symbol = null;
            if (length > 0) {
                symbol = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            }
            return symbol;
        }

        /*
         * Unable to fully structure code
         */
        public String scanName() throws IOException {
            block5: {
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    this.load(0, true);
                }
                if (!XMLChar.isNameStart(XMLEntityManager.this.fCurrentEntity.ch[offset = XMLEntityManager.this.fCurrentEntity.position++])) break block5;
                if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) ** GOTO lbl23
                XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[offset];
                offset = 0;
                if (!this.load(1, false)) ** GOTO lbl23
                ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                symbol = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, 0, 1);
                return symbol;
lbl-1000:
                // 1 sources

                {
                    if (++XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    length = XMLEntityManager.this.fCurrentEntity.position - offset;
                    if (length == XMLEntityManager.this.fBufferSize) {
                        tmp = new char[XMLEntityManager.this.fBufferSize * 2];
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, offset, tmp, 0, length);
                        XMLEntityManager.this.fCurrentEntity.ch = tmp;
                        XMLEntityManager.this.fBufferSize *= 2;
                    } else {
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, offset, XMLEntityManager.this.fCurrentEntity.ch, 0, length);
                    }
                    offset = 0;
                    if (this.load(length, false)) break;
lbl23:
                    // 4 sources

                    ** while (XMLChar.isName((int)XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position]))
                }
            }
            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            XMLEntityManager.this.fCurrentEntity.columnNumber += length;
            symbol = null;
            if (length > 0) {
                symbol = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            }
            return symbol;
        }

        public boolean scanQName(QName qname) throws IOException {
            int offset;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if (XMLChar.isNameStart(XMLEntityManager.this.fCurrentEntity.ch[offset = XMLEntityManager.this.fCurrentEntity.position++])) {
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[offset];
                    offset = 0;
                    if (this.load(1, false)) {
                        ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                        String name = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, 0, 1);
                        qname.setValues(null, name, name, null);
                        return true;
                    }
                }
                int index = -1;
                while (XMLChar.isName(XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position])) {
                    char c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
                    if (c == ':') {
                        if (index != -1) break;
                        index = XMLEntityManager.this.fCurrentEntity.position;
                    }
                    if (++XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    int length = XMLEntityManager.this.fCurrentEntity.position - offset;
                    if (length == XMLEntityManager.this.fBufferSize) {
                        char[] tmp = new char[XMLEntityManager.this.fBufferSize * 2];
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, offset, tmp, 0, length);
                        XMLEntityManager.this.fCurrentEntity.ch = tmp;
                        XMLEntityManager.this.fBufferSize *= 2;
                    } else {
                        System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, offset, XMLEntityManager.this.fCurrentEntity.ch, 0, length);
                    }
                    if (index != -1) {
                        index -= offset;
                    }
                    offset = 0;
                    if (this.load(length, false)) break;
                }
                int length = XMLEntityManager.this.fCurrentEntity.position - offset;
                XMLEntityManager.this.fCurrentEntity.columnNumber += length;
                if (length > 0) {
                    String prefix = null;
                    String localpart = null;
                    String rawname = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
                    if (index != -1) {
                        int prefixLength = index - offset;
                        prefix = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, offset, prefixLength);
                        int len = length - prefixLength - 1;
                        localpart = XMLEntityManager.this.fSymbolTable.addSymbol(XMLEntityManager.this.fCurrentEntity.ch, index + 1, len);
                    } else {
                        localpart = rawname;
                    }
                    qname.setValues(prefix, localpart, rawname, null);
                    return true;
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        public int scanContent(XMLString content) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.count - 1];
                this.load(1, false);
                XMLEntityManager.this.fCurrentEntity.position = 0;
            }
            offset = XMLEntityManager.this.fCurrentEntity.position;
            c = XMLEntityManager.this.fCurrentEntity.ch[offset];
            newlines = 0;
            external = XMLEntityManager.this.fCurrentEntity.isExternal();
            if (c != 10 && (c != 13 || !external)) ** GOTO lbl54
            do {
                if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == 13 && external) {
                    ++newlines;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                        offset = 0;
                        XMLEntityManager.this.fCurrentEntity.position = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                        ++XMLEntityManager.this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10) {
                    ++newlines;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    offset = 0;
                    XMLEntityManager.this.fCurrentEntity.position = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
            } while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count - 1);
            i = offset;
            while (i < XMLEntityManager.this.fCurrentEntity.position) {
                XMLEntityManager.this.fCurrentEntity.ch[i] = 10;
                ++i;
            }
            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count - 1) ** GOTO lbl54
            content.setValues(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            return -1;
lbl-1000:
            // 1 sources

            {
                if (XMLChar.isContent(c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++])) continue;
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
lbl54:
                // 3 sources

                ** while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count)
            }
lbl55:
            // 2 sources

            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            XMLEntityManager.this.fCurrentEntity.columnNumber += length - newlines;
            content.setValues(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) {
                c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
                if (c == 13 && external) {
                    c = 10;
                }
            } else {
                c = -1;
            }
            return c;
        }

        /*
         * Unable to fully structure code
         */
        public int scanLiteral(int quote, XMLString content) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                XMLEntityManager.this.fCurrentEntity.ch[0] = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.count - 1];
                this.load(1, false);
                XMLEntityManager.this.fCurrentEntity.position = 0;
            }
            offset = XMLEntityManager.this.fCurrentEntity.position;
            c = XMLEntityManager.this.fCurrentEntity.ch[offset];
            newlines = 0;
            external = XMLEntityManager.this.fCurrentEntity.isExternal();
            if (c != 10 && (c != 13 || !external)) ** GOTO lbl54
            do {
                if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == 13 && external) {
                    ++newlines;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                        offset = 0;
                        XMLEntityManager.this.fCurrentEntity.position = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                        ++XMLEntityManager.this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10) {
                    ++newlines;
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                    if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    offset = 0;
                    XMLEntityManager.this.fCurrentEntity.position = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
            } while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count - 1);
            i = offset;
            while (i < XMLEntityManager.this.fCurrentEntity.position) {
                XMLEntityManager.this.fCurrentEntity.ch[i] = 10;
                ++i;
            }
            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count - 1) ** GOTO lbl54
            content.setValues(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            return -1;
lbl-1000:
            // 1 sources

            {
                if (((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) != quote || XMLEntityManager.this.fCurrentEntity.literal && !external) && c != 37 && XMLChar.isContent(c)) continue;
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
lbl54:
                // 3 sources

                ** while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count)
            }
lbl55:
            // 2 sources

            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            XMLEntityManager.this.fCurrentEntity.columnNumber += length - newlines;
            content.setValues(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) {
                c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position];
                if (c == quote && XMLEntityManager.this.fCurrentEntity.literal) {
                    c = -1;
                }
            } else {
                c = -1;
            }
            return c;
        }

        public boolean scanData(String delimiter, XMLString data) throws IOException {
            int length;
            int delimLen = delimiter.length();
            char charAt0 = delimiter.charAt(0);
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (XMLEntityManager.this.fCurrentEntity.position >= XMLEntityManager.this.fCurrentEntity.count - delimLen) {
                System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, XMLEntityManager.this.fCurrentEntity.position, XMLEntityManager.this.fCurrentEntity.ch, 0, XMLEntityManager.this.fCurrentEntity.count - XMLEntityManager.this.fCurrentEntity.position);
                this.load(XMLEntityManager.this.fCurrentEntity.count - XMLEntityManager.this.fCurrentEntity.position, false);
                XMLEntityManager.this.fCurrentEntity.position = 0;
            }
            int offset = XMLEntityManager.this.fCurrentEntity.position;
            char c = XMLEntityManager.this.fCurrentEntity.ch[offset];
            int newlines = 0;
            boolean external = XMLEntityManager.this.fCurrentEntity.isExternal();
            if (c == '\n' || c == '\r' && external) {
                do {
                    if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == '\r' && external) {
                        ++newlines;
                        ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                        XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                        if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                            offset = 0;
                            XMLEntityManager.this.fCurrentEntity.position = newlines;
                            if (this.load(newlines, false)) break;
                        }
                        if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                            ++XMLEntityManager.this.fCurrentEntity.position;
                            ++offset;
                            continue;
                        }
                        ++newlines;
                        continue;
                    }
                    if (c == '\n') {
                        ++newlines;
                        ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                        XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                        if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                        offset = 0;
                        XMLEntityManager.this.fCurrentEntity.position = newlines;
                        XMLEntityManager.this.fCurrentEntity.count = newlines;
                        if (!this.load(newlines, false)) continue;
                        break;
                    }
                    --XMLEntityManager.this.fCurrentEntity.position;
                    break;
                } while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count - 1);
                int i = offset;
                while (i < XMLEntityManager.this.fCurrentEntity.position) {
                    XMLEntityManager.this.fCurrentEntity.ch[i] = 10;
                    ++i;
                }
                length = XMLEntityManager.this.fCurrentEntity.position - offset;
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                    data.setValues(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
                    return true;
                }
            }
            boolean done = false;
            block2: while (XMLEntityManager.this.fCurrentEntity.position < XMLEntityManager.this.fCurrentEntity.count) {
                if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) == charAt0) {
                    int delimOffset = XMLEntityManager.this.fCurrentEntity.position - 1;
                    int i = 1;
                    while (i < delimLen) {
                        if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                            XMLEntityManager.this.fCurrentEntity.position -= i;
                            break block2;
                        }
                        c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++];
                        if (delimiter.charAt(i) != c) {
                            --XMLEntityManager.this.fCurrentEntity.position;
                            break;
                        }
                        ++i;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.position != delimOffset + delimLen) continue;
                    done = true;
                    break;
                }
                if (c == '\n' || external && c == '\r') {
                    --XMLEntityManager.this.fCurrentEntity.position;
                    break;
                }
                if (!XMLChar.isInvalid(c)) continue;
                --XMLEntityManager.this.fCurrentEntity.position;
                break;
            }
            length = XMLEntityManager.this.fCurrentEntity.position - offset;
            XMLEntityManager.this.fCurrentEntity.columnNumber += length - newlines;
            if (done) {
                length -= delimLen;
            }
            data.setValues(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            return !done;
        }

        public boolean skipChar(int c) throws IOException {
            char cc;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if ((cc = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position]) == c) {
                ++XMLEntityManager.this.fCurrentEntity.position;
                if (c == 10) {
                    ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                    XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                } else {
                    ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                }
                return true;
            }
            if (c == 10 && cc == '\r' && XMLEntityManager.this.fCurrentEntity.isExternal()) {
                if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    XMLEntityManager.this.fCurrentEntity.ch[0] = cc;
                    this.load(1, false);
                }
                ++XMLEntityManager.this.fCurrentEntity.position;
                if (XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position] == '\n') {
                    ++XMLEntityManager.this.fCurrentEntity.position;
                }
                ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                return true;
            }
            return false;
        }

        public boolean skipSpaces() throws IOException {
            char c;
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            if (XMLChar.isSpace(c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position])) {
                boolean external = XMLEntityManager.this.fCurrentEntity.isExternal();
                do {
                    boolean entityChanged = false;
                    if (c == '\n' || external && c == '\r') {
                        ++XMLEntityManager.this.fCurrentEntity.lineNumber;
                        XMLEntityManager.this.fCurrentEntity.columnNumber = 1;
                        if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count - 1) {
                            XMLEntityManager.this.fCurrentEntity.ch[0] = c;
                            entityChanged = this.load(1, true);
                            if (!entityChanged) {
                                XMLEntityManager.this.fCurrentEntity.position = 0;
                            }
                        }
                        if (c == '\r' && external && XMLEntityManager.this.fCurrentEntity.ch[++XMLEntityManager.this.fCurrentEntity.position] != '\n') {
                            --XMLEntityManager.this.fCurrentEntity.position;
                        }
                    } else {
                        ++XMLEntityManager.this.fCurrentEntity.columnNumber;
                    }
                    if (!entityChanged) {
                        ++XMLEntityManager.this.fCurrentEntity.position;
                    }
                    if (XMLEntityManager.this.fCurrentEntity.position != XMLEntityManager.this.fCurrentEntity.count) continue;
                    this.load(0, true);
                } while (XMLChar.isSpace(c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position]));
                return true;
            }
            return false;
        }

        public boolean skipString(String s) throws IOException {
            if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                this.load(0, true);
            }
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c;
                if ((c = XMLEntityManager.this.fCurrentEntity.ch[XMLEntityManager.this.fCurrentEntity.position++]) != s.charAt(i)) {
                    XMLEntityManager.this.fCurrentEntity.position -= i + 1;
                    return false;
                }
                if (i < length - 1 && XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                    System.arraycopy(XMLEntityManager.this.fCurrentEntity.ch, XMLEntityManager.this.fCurrentEntity.count - i - 1, XMLEntityManager.this.fCurrentEntity.ch, 0, i + 1);
                    if (this.load(i + 1, false)) {
                        XMLEntityManager.this.fCurrentEntity.position -= i + 1;
                        return false;
                    }
                }
                ++i;
            }
            XMLEntityManager.this.fCurrentEntity.columnNumber += length;
            return true;
        }

        public String getPublicId() {
            return XMLEntityManager.this.fCurrentEntity != null ? XMLEntityManager.this.fCurrentEntity.publicId : null;
        }

        public String getSystemId() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.systemId != null) {
                    return XMLEntityManager.this.fCurrentEntity.systemId;
                }
                int size = XMLEntityManager.this.fEntityStack.size();
                int i = size - 1;
                while (i >= 0) {
                    ScannedEntity externalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                    if (externalEntity.systemId != null) {
                        return externalEntity.systemId;
                    }
                    --i;
                }
            }
            return null;
        }

        public int getLineNumber() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.systemId != null) {
                    return XMLEntityManager.this.fCurrentEntity.lineNumber;
                }
                int size = XMLEntityManager.this.fEntityStack.size();
                int i = size - 1;
                while (i > 0) {
                    ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                    if (firstExternalEntity.systemId != null) {
                        return firstExternalEntity.lineNumber;
                    }
                    --i;
                }
            }
            return -1;
        }

        public int getColumnNumber() {
            if (XMLEntityManager.this.fCurrentEntity != null) {
                if (XMLEntityManager.this.fCurrentEntity.systemId != null) {
                    return XMLEntityManager.this.fCurrentEntity.columnNumber;
                }
                int size = XMLEntityManager.this.fEntityStack.size();
                int i = size - 1;
                while (i > 0) {
                    ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                    if (firstExternalEntity.systemId != null) {
                        return firstExternalEntity.columnNumber;
                    }
                    --i;
                }
            }
            return -1;
        }

        private final boolean load(int offset, boolean changeEntity) throws IOException {
            int length = XMLEntityManager.this.fCurrentEntity.ch.length - offset;
            int count = XMLEntityManager.this.fCurrentEntity.reader.read(XMLEntityManager.this.fCurrentEntity.ch, offset, length);
            boolean entityChanged = false;
            if (count != -1) {
                if (count != 0) {
                    XMLEntityManager.this.fCurrentEntity.count = count + offset;
                    XMLEntityManager.this.fCurrentEntity.position = offset;
                }
            } else {
                XMLEntityManager.this.fCurrentEntity.count = offset;
                XMLEntityManager.this.fCurrentEntity.position = offset;
                entityChanged = true;
                if (changeEntity) {
                    XMLEntityManager.this.endEntity();
                    if (XMLEntityManager.this.fCurrentEntity == null) {
                        throw new EOFException();
                    }
                    if (XMLEntityManager.this.fCurrentEntity.position == XMLEntityManager.this.fCurrentEntity.count) {
                        this.load(0, true);
                    }
                }
            }
            return entityChanged;
        }
    }

    protected class ScannedEntity
    extends Entity {
        public InputStream stream;
        public Reader reader;
        public String publicId;
        public String systemId;
        public String baseSystemId;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public String encoding;
        public boolean literal;
        public char[] ch;
        public int position;
        public int count;

        public ScannedEntity(String name, String publicId, String systemId, String baseSystemId, InputStream stream, Reader reader, String encoding, boolean literal) {
            super(name);
            this.ch = new char[XMLEntityManager.this.fBufferSize];
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseSystemId = baseSystemId;
            this.stream = stream;
            this.reader = reader;
            this.encoding = encoding;
            this.literal = literal;
        }

        public final boolean isExternal() {
            return this.systemId != null;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("name=\"" + this.name + '\"');
            str.append(",ch=" + this.ch);
            str.append(",position=" + this.position);
            str.append(",count=" + this.count);
            return str.toString();
        }
    }

    protected static class ExternalEntity
    extends Entity {
        public String publicId;
        public String systemId;
        public String baseSystemId;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String name, String publicId, String systemId, String baseSystemId, String notation) {
            super(name);
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseSystemId = baseSystemId;
            this.notation = notation;
        }

        public final boolean isExternal() {
            return true;
        }

        public final boolean isUnparsed() {
            return this.notation != null;
        }

        public void clear() {
            super.clear();
            this.publicId = null;
            this.systemId = null;
            this.baseSystemId = null;
            this.notation = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.publicId = null;
            this.systemId = null;
            this.baseSystemId = null;
            this.notation = null;
        }

        public void setValues(ExternalEntity entity) {
            super.setValues(entity);
            this.publicId = entity.publicId;
            this.systemId = entity.systemId;
            this.baseSystemId = entity.baseSystemId;
            this.notation = entity.notation;
        }
    }

    protected static class InternalEntity
    extends Entity {
        public String text;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String name, String text) {
            super(name);
            this.text = text;
        }

        public final boolean isExternal() {
            return false;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void clear() {
            super.clear();
            this.text = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.text = null;
        }

        public void setValues(InternalEntity entity) {
            super.setValues(entity);
            this.text = entity.text;
        }
    }

    protected static abstract class Entity {
        public String name;

        public Entity() {
            this.clear();
        }

        public Entity(String name) {
            this.name = name;
        }

        public abstract boolean isExternal();

        public abstract boolean isUnparsed();

        public void clear() {
            this.name = null;
        }

        public void setValues(Entity entity) {
            this.name = entity.name;
        }
    }
}

