/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttributeMap
extends NamedNodeMapImpl {
    protected AttributeMap(ElementImpl ownerNode, NamedNodeMapImpl defaults) {
        super(ownerNode);
        if (defaults != null) {
            this.cloneContent(defaults);
            if (this.nodes != null) {
                this.hasDefaults(true);
            }
        }
    }

    public Node setNamedItem(Node arg) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        if (arg.getNodeType() != 2) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        AttrImpl argn = (AttrImpl)arg;
        if (argn.isOwned()) {
            throw new DOMException(10, "DOM009 Attribute already in use");
        }
        argn.ownerNode = this.ownerNode;
        argn.isOwned(true);
        int i = this.findNamePoint(arg.getNodeName(), 0);
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
            previous.ownerNode = this.ownerNode.ownerDocument();
            previous.isOwned(false);
            previous.isSpecified(true);
        } else {
            i = -1 - i;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(arg, i);
        }
        this.ownerNode.ownerDocument().setAttrNode(argn, previous);
        if (!argn.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return previous;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        if (arg.getNodeType() != 2) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        AttrImpl argn = (AttrImpl)arg;
        if (argn.isOwned()) {
            throw new DOMException(10, "DOM009 Attribute already in use");
        }
        argn.ownerNode = this.ownerNode;
        argn.isOwned(true);
        int i = this.findNamePoint(argn.getNamespaceURI(), argn.getLocalName());
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
            previous.ownerNode = this.ownerNode.ownerDocument();
            previous.isOwned(false);
            previous.isSpecified(true);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                previous = (AttrImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        this.ownerNode.ownerDocument().setAttrNode(argn, previous);
        if (!argn.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return previous;
    }

    public Node removeNamedItem(String name) throws DOMException {
        return this.internalRemoveNamedItem(name, true);
    }

    Node safeRemoveNamedItem(String name) {
        return this.internalRemoveNamedItem(name, false);
    }

    protected final Node internalRemoveNamedItem(String name, boolean raiseEx) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int i = this.findNamePoint(name, 0);
        if (i < 0) {
            if (raiseEx) {
                throw new DOMException(8, "DOM008 Not found");
            }
            return null;
        }
        AttrImpl n = (AttrImpl)this.nodes.elementAt(i);
        CoreDocumentImpl ownerDocument = this.ownerNode.ownerDocument();
        if (this.hasDefaults()) {
            Node d;
            NamedNodeMapImpl defaults = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (defaults != null && (d = defaults.getNamedItem(name)) != null && this.findNamePoint(name, i + 1) < 0) {
                NodeImpl clone = (NodeImpl)d.cloneNode(true);
                clone.ownerNode = this.ownerNode;
                clone.isOwned(true);
                clone.isSpecified(false);
                this.nodes.setElementAt(clone, i);
            } else {
                this.nodes.removeElementAt(i);
            }
        } else {
            this.nodes.removeElementAt(i);
        }
        n.ownerNode = ownerDocument;
        n.isOwned(false);
        n.isSpecified(true);
        ownerDocument.removedAttrNode(n, this.ownerNode, name);
        return n;
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        return this.internalRemoveNamedItemNS(namespaceURI, name, true);
    }

    Node safeRemoveNamedItemNS(String namespaceURI, String name) {
        return this.internalRemoveNamedItemNS(namespaceURI, name, false);
    }

    protected final Node internalRemoveNamedItemNS(String namespaceURI, String name, boolean raiseEx) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int i = this.findNamePoint(namespaceURI, name);
        if (i < 0) {
            if (raiseEx) {
                throw new DOMException(8, "DOM008 Not found");
            }
            return null;
        }
        AttrImpl n = (AttrImpl)this.nodes.elementAt(i);
        CoreDocumentImpl ownerDocument = this.ownerNode.ownerDocument();
        String nodeName = n.getNodeName();
        if (this.hasDefaults()) {
            Node d;
            NamedNodeMapImpl defaults = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (defaults != null && (d = defaults.getNamedItem(nodeName)) != null) {
                int j = this.findNamePoint(nodeName, 0);
                if (j >= 0 && this.findNamePoint(nodeName, j + 1) < 0) {
                    NodeImpl clone = (NodeImpl)d.cloneNode(true);
                    clone.ownerNode = this.ownerNode;
                    clone.isOwned(true);
                    clone.isSpecified(false);
                    this.nodes.setElementAt(clone, i);
                } else {
                    this.nodes.removeElementAt(i);
                }
            } else {
                this.nodes.removeElementAt(i);
            }
        } else {
            this.nodes.removeElementAt(i);
        }
        n.ownerNode = ownerDocument;
        n.isOwned(false);
        n.isSpecified(true);
        ownerDocument.removedAttrNode(n, this.ownerNode, name);
        return n;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl ownerNode) {
        AttributeMap newmap = new AttributeMap((ElementImpl)ownerNode, null);
        newmap.hasDefaults(this.hasDefaults());
        newmap.cloneContent(this);
        return newmap;
    }

    protected void cloneContent(NamedNodeMapImpl srcmap) {
        if (srcmap.nodes != null) {
            if (this.nodes == null) {
                this.nodes = new Vector(srcmap.nodes.size());
            } else {
                this.nodes.setSize(srcmap.nodes.size());
            }
            int i = 0;
            while (i < srcmap.nodes.size()) {
                NodeImpl n = (NodeImpl)srcmap.nodes.elementAt(i);
                NodeImpl clone = (NodeImpl)n.cloneNode(true);
                clone.isSpecified(n.isSpecified());
                this.nodes.insertElementAt(clone, i);
                clone.ownerNode = this.ownerNode;
                clone.isOwned(true);
                ++i;
            }
        }
    }

    protected void reconcileDefaults(NamedNodeMapImpl defaults) {
        int nsize = this.nodes != null ? this.nodes.size() : 0;
        int i = nsize - 1;
        while (i >= 0) {
            AttrImpl attr = (AttrImpl)this.nodes.elementAt(i);
            if (!attr.isSpecified()) {
                attr.ownerNode = this.ownerNode.ownerDocument();
                attr.isOwned(false);
                attr.isSpecified(true);
                this.nodes.removeElementAt(i);
            }
            --i;
        }
        if (defaults == null) {
            return;
        }
        if (this.nodes == null || this.nodes.size() == 0) {
            this.cloneContent(defaults);
        } else {
            int dsize = defaults.nodes.size();
            int n = 0;
            while (n < dsize) {
                AttrImpl d = (AttrImpl)defaults.nodes.elementAt(n);
                int i2 = this.findNamePoint(d.getNodeName(), 0);
                if (i2 < 0) {
                    NodeImpl clone = (NodeImpl)d.cloneNode(true);
                    clone.ownerNode = this.ownerNode;
                    clone.isOwned(true);
                    clone.isSpecified(false);
                    this.nodes.setElementAt(clone, i2);
                }
                ++n;
            }
        }
    }
}

