/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class TestPut017
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut017.createWebDAVSchema();
        TestPut017.addGlobalMessage((String)("prepare test " + TestPut017.getTestClassId()), (char)'I', (String)"try to put a file using a malformed request uri\nThe server must reply with '400 Bad Request'");
        host = new String(TestPut017.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut017.getPort();
        baseUrl = TestPut017.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPut017.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut017.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut017.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut017.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut017.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut017.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut017";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut017.addGlobalMessage((String)"1. DELETE resource /TestPut017 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut017.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        if (!TestPut017.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        Vector<String> restrictedSigns = new Vector<String>();
        restrictedSigns.add(new Character('<').toString());
        restrictedSigns.add(new Character('>').toString());
        restrictedSigns.add(new Character('\"').toString());
        restrictedSigns.add(new Character('[').toString());
        restrictedSigns.add(new Character(']').toString());
        restrictedSigns.add(new Character('{').toString());
        restrictedSigns.add(new Character('}').toString());
        restrictedSigns.add(new Character('|').toString());
        restrictedSigns.add(new Character('`').toString());
        restrictedSigns.add(new Character('^').toString());
        restrictedSigns.add(new Character('\u001e').toString());
        restrictedSigns.add(new Character('\u007f').toString());
        Vector<String> resourceUriVector = new Vector<String>(10, 5);
        Enumeration e = restrictedSigns.elements();
        while (e.hasMoreElements()) {
            String sign = (String)e.nextElement();
            resourceUriVector.add("/TestPut017/" + sign + "_Put_1.txt");
            resourceUriVector.add("/TestPut017/Put_" + sign + "_1.txt");
            resourceUriVector.add("/TestPut017/Put_" + sign + ".txt");
        }
        Enumeration enum1 = resourceUriVector.elements();
        while (enum1.hasMoreElements()) {
            String resourceUri = (String)enum1.nextElement();
            content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
            contentType = "text/plain";
            contentLength = content.length();
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, resourceUri);
            try {
                TestPut017.addGlobalMessage((String)("2. create the resource /TestPut017/" + resourceUri + ".txt"), (char)'I', (String)"starting...");
                resource.PUT(content, contentType, locktoken);
                if (resource.getStatus().getStatusCode() != 400) {
                    TestPut017.addGlobalMessage((String)("the server accepted the following resource URI: " + resourceUri), (char)'E', (String)"Test was not successful and will be aborted.");
                    return;
                }
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 400) {
                    try {
                        if (resource.exists()) {
                            TestPut017.addGlobalMessage((String)"2.1. check if the file was not created", (char)'E', (String)"The file was created instead. Test Failed!");
                        }
                    }
                    catch (NullPointerException e2) {
                        this.handleExceptions(e2);
                    }
                }
                TestPut017.addGlobalMessage((String)("2. create the resource /TestPut017/" + resourceUri + ".txt at baseUrl"), (char)'E', (String)("The Server accepted a malformed request uri within the PUT-request.The test failed. server replied '" + exc.getStatusCode() + " " + exc.getMessage()));
                return;
            }
            catch (Exception e3) {
                this.handleExceptions(e3);
            }
            TestPut017.addGlobalMessage((String)"2. create the resource /TestPut017.txt several times at baseUrl with wrong content-types", (char)'I', (String)"the server declined all requests...test was successful!");
            try {
                if (!resource.exists()) continue;
                try {
                    resource.DELETE(locktoken);
                }
                catch (WDVTestJ_WdvException exc) {
                    TestPut017.addGlobalMessage((String)("2.2. DELETE of " + host + ":" + WDV_PORT + baseUrl + urlStr + " failed"), (char)'E', (String)"Test cannot be finished!");
                    return;
                }
            }
            catch (NullPointerException e4) {
                this.handleExceptions(e4);
            }
            catch (IOException exc) {
                this.handleExceptions(exc);
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPut017");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut017.addGlobalMessage((String)"3. clean up and DELETE the resource /TestPut017.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPut017.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

