/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node getcontentlength_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch005.createWebDAVSchema();
        TestProppatch005.addGlobalMessage((String)("prepare test " + TestProppatch005.getTestClassId()), (char)'I', (String)"patch the live property 'getcontentlength'");
        host = new String(TestProppatch005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch005.getPort();
        baseUrl = TestProppatch005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch005.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch005.addGlobalMessage((String)"1. DELETE the resource /TestProppatch005.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch005.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = String.valueOf(body) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = String.valueOf(body) + "\nxmlns:Z=\"DAV:\">";
        body = String.valueOf(body) + "\n<D:set>";
        body = String.valueOf(body) + "\n<D:prop>";
        body = String.valueOf(body) + "\n<Z:getcontentlength>today</Z:getcontentlength>";
        body = String.valueOf(body) + "\n</D:prop>";
        body = String.valueOf(body) + "\n</D:set>";
        body = String.valueOf(body) + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlDocument.getElementsByTagName("getcontentlength");
                getcontentlength_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch005.addGlobalMessage((String)"5. check if the property status of 'getcontentlength' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'getcontentlength'-element for the resource could not be retrieved");
            }
            if (xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().startsWith("HTTP/1.1 409")) {
                TestProppatch005.addGlobalMessage((String)"5. check if the property status of 'getcontentlength' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
            } else {
                TestProppatch005.addGlobalMessage((String)"5. check if the property status of 'getcontentlength' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
        } else {
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch005.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'getcontentlength'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch005.addGlobalMessage((String)"5. clean up and DELETE the resource /TestProppatch005.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

