/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock016
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock016.createWebDAVSchema();
        TestLock016.addGlobalMessage((String)("prepare test " + TestLock016.getTestClassId()), (char)'I', (String)"******************************************************************\n* HEAD and GET on a null resource must result in '404 Not Found' *\n******************************************************************");
        host = new String(TestLock016.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock016.getPort();
        baseUrl = TestLock016.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock016.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock016.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock016.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock016.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock016.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock016.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock016.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock016.addGlobalMessage((String)"1. create the null resource", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock016.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock016.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock016.doDelete(resource, locktoken = TestLock016.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                TestLock016.addGlobalMessage((String)"3. LOCK the null-resource /TestLock016.txt", (char)'I', (String)"LOCK was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock016.addGlobalMessage((String)"3. LOCK the null-resource /TestLock016.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 200 OK"));
            throw new TestCaseException(exc.getMessage());
        }
        catch (Exception exc) {
            TestLock016.addGlobalMessage((String)"3. LOCK the null-resource /TestLock016.txt", (char)'E', (String)("Java exception: " + exc.getMessage() + "\n" + "Test failed due to some Java feature."));
            throw new TestCaseException(exc.getMessage());
        }
    }

    public void run() {
        try {
            resource.HEAD(null);
            if (resource.getStatus().getStatusCode() != 404) {
                TestLock016.addGlobalMessage((String)"2. call HEAD on the null resource", (char)'W', (String)("HEAD could be executed!Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 404 Not Found." + "PTS messages: " + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127816\n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124239"));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestLock016.addGlobalMessage((String)"2. call HEAD on the null resource", (char)'I', (String)("Test was successful! Response: " + exc.getStatusCode() + " " + exc.getMessage()));
            } else {
                TestLock016.addGlobalMessage((String)"2. call HEAD on the null resource", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 404 Not Found."));
            }
        }
        catch (Exception exc) {
            TestLock016.addGlobalMessage((String)"2. call HEAD on the null resource", (char)'E', (String)("Java exception: " + exc));
            TestLock016.addGlobalMessage((String)"2. call HEAD on the null resource", (char)'I', (String)"Test failed due to some Java feature");
        }
        try {
            resource.GET();
            if (resource.getStatus().getStatusCode() != 404) {
                TestLock016.addGlobalMessage((String)"3. call GET on the null resource", (char)'W', (String)("GET could be executed!Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 404 Not Found." + "PTS messages: " + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127816\n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124239"));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestLock016.addGlobalMessage((String)"3. call GET on the null resource", (char)'I', (String)("Test was successful! Response: " + exc.getStatusCode() + " " + exc.getMessage()));
            } else {
                TestLock016.addGlobalMessage((String)"3. call GET on the null resource", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 404 Not Found."));
            }
        }
        catch (Exception exc) {
            TestLock016.addGlobalMessage((String)"3. call GET on the null resource", (char)'E', (String)("Java exception: " + exc));
            TestLock016.addGlobalMessage((String)"3. call GET on the null resource", (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        locktoken = TestLock016.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        if (locktoken != null) {
            TestLock016.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

