/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestLock015
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock015.createWebDAVSchema();
        TestLock015.addGlobalMessage((String)("prepare test " + TestLock015.getTestClassId()), (char)'I', (String)"*********************************************************************************\n* create a null resource and do a MOVE with correct locktoken on it (must fail) *\n*********************************************************************************");
        host = new String(TestLock015.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock015.getPort();
        baseUrl = TestLock015.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock015.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock015.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock015.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock015.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock015.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock015.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock015.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock015.addGlobalMessage((String)"1. create the null resource", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock015.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock015.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock015.doDelete(resource, locktoken = TestLock015.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                TestLock015.addGlobalMessage((String)"3. LOCK the null-resource /TestLock015.txt", (char)'I', (String)"LOCK was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock015.addGlobalMessage((String)"3. LOCK the null-resource /TestLock015.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock015.addGlobalMessage((String)"3. LOCK the null-resource /TestLock015.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 200 OK");
            throw new TestCaseException(exc.getMessage());
        }
        catch (Exception exc) {
            TestLock015.addGlobalMessage((String)"3. LOCK the null-resource /TestLock015.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock015.addGlobalMessage((String)"3. LOCK the null-resource /TestLock015.txt", (char)'I', (String)"Test failed due to some Java feature.");
            throw new TestCaseException(exc.getMessage());
        }
    }

    public void run() {
        try {
            String dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestLock015_copy.txt").toString();
            String body = null;
            locktoken = TestLock015.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            resource.MOVE(dest_Url, "F", body, locktoken);
            if (resource.getStatus().getStatusCode() != 405) {
                TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'E', (String)("MOVE could be executed!Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 405) {
                TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'I', (String)("Test was successful! Response: " + exc.getStatusCode() + " " + exc.getMessage()));
            }
            TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'W', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.\nPTS messages:\nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127815\nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124258");
            return;
        }
        catch (MalformedURLException exc) {
            TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'E', (String)"Test failed due to some Java-URL feature");
            return;
        }
        catch (Exception exc) {
            TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'E', (String)("Java exception: " + exc));
            TestLock015.addGlobalMessage((String)"2. do the MOVE on the null resource", (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        locktoken = TestLock015.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        if (locktoken != null) {
            TestLock015.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

