/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet009
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = "";
    static String contentType = null;
    static String expectedContent = "";
    static String locktoken = null;
    static String contentRange = null;
    static Byte firstByte = null;
    static Byte lastByte = null;

    public static void prepare() throws TestCaseException {
        TestGet009.createWebDAVSchema();
        TestGet009.addGlobalMessage((String)("prepare test " + TestGet009.getTestClassId()), (char)'I', (String)"*******************************************************************************************************\n* get on an existing file to get the last and the first Byte of its content (HTTP/1.1 Statuscode 501) *\n*******************************************************************************************************");
        host = new String(TestGet009.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet009.getPort();
        baseUrl = TestGet009.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet009.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet009.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet009.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet009.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet009.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet009.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet009.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet009.addGlobalMessage((String)"1. DELETE /TestGet009.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt! ";
        contentType = "text/plain";
        if (!TestGet009.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        contentRange = "bytes=0-0,-1";
        try {
            resource.GET(contentRange);
            if (resource.getStatus().getStatusCode() != 501) {
                TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("The HTTP status in the response DOES NOT equal the expected one\nexpected: HTTP/1.1 501 Not Implemented\nreceived: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 501) {
                TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)("The server replied: " + exc.getStatusCode() + " " + exc.getLocalizedMessage() + "\n" + "Test was successful!"));
            } else {
                if (!TestGet009.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                    TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'W', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "See PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128912"));
                } else {
                    TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage() + "\n"));
                }
                TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature. '501 Not Implemented' was expected.");
            }
        }
        catch (Exception exc) {
            TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestGet009.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some Java feature.");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

