/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.snapshot;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;

public class SnapShot
extends TestCase {
    private static final String mExUser = "sap";
    private static final String mExPassword = "sapr3";
    private static final int mNumberOfDocuments = 400;

    public static String getMinimumRelease() {
        return "7.5.*";
    }

    public static void cleanUp() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        try {
            SnapShot.writeInfoMessage("\nDrop user sap");
            myConnection = SnapShot.getDatabase().connect(SnapShot.getUser(), SnapShot.getPassword());
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user sap");
            myStatement.enableExceptions(true);
            myConnection.commit();
            Thread.sleep(1000L);
            SnapShot.writeInfoMessage("Set log auto overwrite off");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute set log auto overwrite off");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("Drop snapshot");
            SnapShot.getDatabase().executeDBMcmd("db_admin");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute drop snapshot");
            SnapShot.getDatabase().executeDBMcmd("backup_start IND");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.getDatabase().executeDBMcmd("db_online");
            SnapShot.getDatabase().executeDBMcmd("autosave_on");
        }
        catch (Exception e) {
            SnapShot.addGlobalMessage((String)"Method cleanUp", (char)'E', (String)"cleanUp failed");
            throw new TestCaseException("Error during cleanUp: " + e.getClass() + e.getMessage());
        }
        System.out.println("End of " + SnapShot.getTestClassId() + " Test\n");
    }

    public static String getTestClassId() {
        return "Converter SnapShot";
    }

    private static void writeInfoMessage(String pMessageText) {
        System.out.println(pMessageText);
        SnapShot.addGlobalMessage((String)"", (char)'I', (String)pMessageText);
    }

    /*
     * Loose catch block
     */
    public static void prepare() throws TestCaseException {
        block26: {
            Connection myConnection = null;
            TestStatement myStatement = null;
            TestPreparedStatement myPrepStatement = null;
            StringBuffer myStringBuffer = null;
            Random myRandomFactory = null;
            System.out.println("\nStart of " + SnapShot.getTestClassId() + " Test");
            SnapShot.writeInfoMessage("Create data base backup media");
            SnapShot.getDatabase().executeDBMcmd("medium_put DATA   data.sav   FILE DATA  0 8 YES NO");
            SnapShot.getDatabase().executeDBMcmd("medium_put PAGES1 pages1.sav FILE PAGES 0 8 YES NO");
            SnapShot.getDatabase().executeDBMcmd("medium_put PAGES2 pages2.sav FILE PAGES 0 8 YES NO");
            myConnection = SnapShot.getDatabase().connect(SnapShot.getUser(), SnapShot.getPassword());
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user sap");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user sap password sapr3 DBA not exclusive");
            myStatement.close();
            myConnection.close();
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            SnapShot.writeInfoMessage("Create Training Documents");
            SnapShot.writeInfoMessage("\tCreate table Training Documents");
            myStatement.executeUpdate("Create table TrainingDocuments(Doc_1_Id       char( 1000 ) key,Doc_2_Id       int          key,Weekday        char( 10 ),      Speaker        char( 10 ),      Company        char( 10 ),      DocumentSize   int,             Document       char( 4000 ))    ");
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Insert TrainingDocuments values (?,?,?,?,?,?,?)");
            myStringBuffer = new StringBuffer(2000);
            myStringBuffer.setLength(2000);
            for (int i = 0; i < myStringBuffer.capacity(); ++i) {
                myStringBuffer.setCharAt(i, 'x');
            }
            int myDoc2Id = 0;
            int randomValue = 0;
            myRandomFactory = new Random();
            int maxDocumentsPerSpeaker = SnapShot.getParameterInt((String)"NumberOfDocuments", (int)400);
            int totalDocuments = maxDocumentsPerSpeaker * 5;
            SnapShot.writeInfoMessage("\tFill table Training Documents with " + totalDocuments + " documents");
            for (int weekDay = 0; weekDay < 5; ++weekDay) {
                switch (weekDay) {
                    case 0: {
                        SnapShot.writeInfoMessage("\tLecture one is held by Albert on Monday");
                        myPrepStatement.setString(3, "Monday");
                        myPrepStatement.setString(4, "Albert");
                        myPrepStatement.setString(5, "SAP AG");
                        break;
                    }
                    case 1: {
                        SnapShot.writeInfoMessage("\tLecture two is held by Bert on Tuesday");
                        myPrepStatement.setString(3, "Tuesday");
                        myPrepStatement.setString(4, "Bert");
                        myPrepStatement.setString(5, "SAG");
                        break;
                    }
                    case 2: {
                        SnapShot.writeInfoMessage("\tLecture three is held by Caesar on Wednesday");
                        myPrepStatement.setString(3, "Wednesday");
                        myPrepStatement.setString(4, "Caesar");
                        myPrepStatement.setString(5, "Steeb");
                        break;
                    }
                    case 3: {
                        SnapShot.writeInfoMessage("\tLecture four is held by Dennis on Thursday");
                        myPrepStatement.setString(3, "Thursday");
                        myPrepStatement.setString(4, "Dennis");
                        myPrepStatement.setString(5, "Intel");
                        break;
                    }
                    case 4: {
                        SnapShot.writeInfoMessage("\tLecture five is held by Ernst on Friday");
                        myPrepStatement.setString(3, "Friday");
                        myPrepStatement.setString(4, "Ernst");
                        myPrepStatement.setString(5, "mySQL");
                        break;
                    }
                }
                for (int docCount = 0; docCount < maxDocumentsPerSpeaker; ++docCount) {
                    randomValue = myRandomFactory.nextInt(799) + 200;
                    String myDoc1Id = new String(myStringBuffer.substring(0, randomValue));
                    myPrepStatement.setString(1, myDoc1Id);
                    myPrepStatement.setInt(2, myDoc2Id++);
                    randomValue = myRandomFactory.nextInt(1499) + 500 % myStringBuffer.capacity();
                    String myDocument = new String(myStringBuffer.substring(0, randomValue));
                    myPrepStatement.setInt(6, myDocument.length());
                    myPrepStatement.setString(7, myDocument);
                    myPrepStatement.executeUpdate();
                }
                myStatement.executeUpdate("Commit");
            }
            myPrepStatement.close();
            SnapShot.writeInfoMessage("\n\tCreate index myIdx1 on TrainingDocuments.Weekday");
            myStatement.executeUpdate("Create index myIdx1 on TrainingDocuments ( Weekday )");
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tCreate index myIdx2 on TrainingDocuments.Speaker");
            myStatement.executeUpdate("Create index myIdx2 on TrainingDocuments ( Speaker )");
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tCreate index myIdx2 on TrainingDocuments.Company");
            myStatement.executeUpdate("Create index myIdx3 on TrainingDocuments ( Company )");
            myStatement.executeUpdate("Commit");
            ResultSet myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Create full data base backup of Master");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("backup_start DATA");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("First Modification of Training Documents");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            SnapShot.writeInfoMessage("\tLecture of Albert is held by Fritz on Tuesday");
            myStatement.executeUpdate("Update TrainingDocuments set Speaker = 'Fritz', Weekday = 'Tuesday' where Speaker = 'Albert'");
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tLecture of Bert is held by Gert on Wednesday");
            myStatement.executeUpdate("Update TrainingDocuments set Speaker = 'Gert', Weekday = 'Wednesday' where Speaker = 'Bert'");
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tLecture of Ceasar is held by Heinrich on Thursday");
            myStatement.executeUpdate("Update TrainingDocuments set Speaker = 'Heinrich', Weekday = 'Thursday' where Speaker = 'Ceasar'");
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tLecture of Dennis is held by Ingo on Friday");
            myStatement.executeUpdate("Update TrainingDocuments set Speaker = 'Ingo', Weekday = 'Friday' where Speaker = 'Dennis'");
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tLecture of Ernst is held by Jonas on Monday");
            myStatement.executeUpdate("Update TrainingDocuments set Speaker = 'Jonas', Weekday = 'Monday' where Speaker = 'Ernst'");
            myStatement.executeUpdate("Commit");
            myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Create first delta data base backup of Master");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("backup_start PAGES1");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("Second Modification of Training Documents");
            SnapShot.writeInfoMessage("\tUpdate training documents");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Update TrainingDocuments set DocumentSize = ?, Document = ? where Doc_2_Id = ? ");
            int updatedDocuments = 0;
            for (myDoc2Id = 0; myDoc2Id < totalDocuments; myDoc2Id += 10) {
                ++updatedDocuments;
                randomValue = myRandomFactory.nextInt(499) + 500 % myStringBuffer.capacity();
                String myDocument = new String(myStringBuffer.substring(0, randomValue));
                myPrepStatement.setInt(1, myDocument.length());
                myPrepStatement.setString(2, myDocument);
                myPrepStatement.setInt(3, myDoc2Id);
                myPrepStatement.executeUpdate();
                if (0 != myDoc2Id % 100) continue;
                myStatement.executeUpdate("Commit");
            }
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tNumber of updated documents: " + updatedDocuments);
            myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myResult.close();
            myPrepStatement.close();
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Create second delta data base backup of Master");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("backup_start PAGES2");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            Object var14_15 = null;
            try {
                myStatement.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                myPrepStatement.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
            break block26;
            {
                catch (Exception e) {
                    SnapShot.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
                    throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    myStatement.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    myPrepStatement.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    myConnection.commit();
                    myConnection.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block30: {
            Connection myConnection = null;
            TestStatement myStatement = null;
            TestPreparedStatement myPrepStatement = null;
            StringBuffer myStringBuffer = null;
            Random myRandomFactory = null;
            int maxDocumentsPerSpeaker = SnapShot.getParameterInt((String)"NumberOfDocuments", (int)400);
            int totalDocuments = maxDocumentsPerSpeaker * 5;
            SnapShot.writeInfoMessage("\nCreate instance with restore data");
            SnapShot.getDatabase().executeDBMcmd("db_admin");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_activate RECOVER DATA");
            SnapShot.writeInfoMessage("Create snapshot ");
            SnapShot.getDatabase().executeDBMcmd("db_execute create snapshot");
            SnapShot.writeInfoMessage("\tSet log auto overwrite, because of history lost after restore snapshot");
            SnapShot.getDatabase().executeDBMcmd("db_execute set log auto overwrite on");
            SnapShot.writeInfoMessage("\tCheck consistence of data base");
            SnapShot.writeInfoMessage("\t\tCheck data with update (admin)");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data with update");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("Modify Documents during first training week");
            SnapShot.getDatabase().executeDBMcmd("db_online");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            ResultSet myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            SnapShot.writeInfoMessage("\tSnapshot statistics ");
            myResult = myStatement.executeQuery("Select ID, USEDSIZE/8 from sysinfo.snapshots");
            myResult.next();
            SnapShot.writeInfoMessage("\t\tID is " + myResult.getInt(1) + " and size is " + myResult.getInt(2) + " pages");
            SnapShot.writeInfoMessage("\tUpdate company to SAP AG");
            myStatement.executeUpdate("Update TrainingDocuments set Company = 'SAP AG' where Company <> 'SAP AG' ");
            myStatement.executeUpdate("Commit");
            myStatement.close();
            myConnection.close();
            SnapShot.getDatabase().executeDBMcmd("db_offline");
            SnapShot.writeInfoMessage("\tCheck consistence of data base");
            SnapShot.writeInfoMessage("\t\tCheck data with update (admin)");
            SnapShot.getDatabase().executeDBMcmd("db_admin");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data with update");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck data (online)");
            SnapShot.getDatabase().executeDBMcmd("db_online");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck table consistency");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.executeQuery("select * from TrainingDocuments where Company <> 'SAP AG' ");
            if (0 != myStatement.getResultCounter()) {
                this.addMessage("select company ", 'E', "Mismatching result counter", myStatement.getSqlString());
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of 0");
            }
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Restore snapshot");
            SnapShot.getDatabase().executeDBMcmd("db_admin");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute restore snapshot");
            SnapShot.writeInfoMessage("\tCheck consistence of data base");
            SnapShot.writeInfoMessage("\t\tCheck data with update (admin)");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data with update");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck data (online)");
            SnapShot.getDatabase().executeDBMcmd("db_online");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck table consistency");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.executeQuery("select * from TrainingDocuments ");
            if (totalDocuments != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + totalDocuments);
            }
            myStatement.executeQuery("select distinct( company ) from TrainingDocuments ");
            if (5 != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of 5");
            }
            myStatement.executeQuery("select *  from TrainingDocuments where Speaker = 'Albert' and Weekday = 'Monday' and Company = 'SAP AG'");
            if (maxDocumentsPerSpeaker != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + maxDocumentsPerSpeaker);
            }
            myStatement.executeQuery("select *  from TrainingDocuments where Speaker = 'Caesar' and Weekday = 'Wednesday' and Company = 'Steeb' ");
            if (maxDocumentsPerSpeaker != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + maxDocumentsPerSpeaker);
            }
            myStatement.executeQuery("select *  from TrainingDocuments where Speaker = 'Ernst' and Weekday = 'Friday' and Company = 'mySQL' ");
            if (maxDocumentsPerSpeaker != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + maxDocumentsPerSpeaker);
            }
            myStatement.executeQuery("select Doc_2_Id from TrainingDocuments where DocumentSize <> length( Document )");
            if (0 != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of 0");
            }
            myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\t\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Restore snapshot and restore first page save");
            SnapShot.getDatabase().executeDBMcmd("db_admin");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute restore snapshot");
            SnapShot.getDatabase().executeDBMcmd("recover_start PAGES1");
            SnapShot.writeInfoMessage("\tCheck consistence of data base");
            SnapShot.writeInfoMessage("\t\tCheck data with update (admin)");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data with update");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck data (online)");
            SnapShot.getDatabase().executeDBMcmd("db_online");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck table consistency");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.executeQuery("select distinct( Speaker ) from TrainingDocuments ");
            if (5 != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of 5");
            }
            myStatement.executeQuery("select *  from TrainingDocuments where Speaker = 'Jonas' and Weekday = 'Monday' and Company = 'mySQL'");
            if (maxDocumentsPerSpeaker != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + maxDocumentsPerSpeaker);
            }
            myStatement.executeQuery("select *  from TrainingDocuments where Speaker = 'Gert' and Weekday = 'Wednesday' and Company = 'SAG' ");
            if (maxDocumentsPerSpeaker != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + maxDocumentsPerSpeaker);
            }
            myStatement.executeQuery("select *  from TrainingDocuments where Speaker = 'Ingo' and Weekday = 'Friday' and Company = 'Intel' ");
            if (maxDocumentsPerSpeaker != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of " + maxDocumentsPerSpeaker);
            }
            myStatement.executeQuery("select Doc_2_Id from TrainingDocuments where DocumentSize <> length( Document )");
            if (0 != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of 0");
            }
            myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Modify Documents during second training week");
            SnapShot.writeInfoMessage("\tRemove all documents");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Delete from TrainingDocuments where Doc_2_Id = ? ");
            for (int myDoc2Id = 0; myDoc2Id < totalDocuments; ++myDoc2Id) {
                myPrepStatement.setInt(1, myDoc2Id);
                if (0 != myDoc2Id % 100) continue;
                myStatement.executeUpdate("Commit");
            }
            myStatement.executeUpdate("Commit");
            myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myPrepStatement.close();
            myStatement.close();
            myConnection.close();
            SnapShot.writeInfoMessage("Restore snapshot and restore second page save");
            SnapShot.getDatabase().executeDBMcmd("db_admin");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute restore snapshot");
            SnapShot.getDatabase().executeDBMcmd("recover_start PAGES2");
            SnapShot.writeInfoMessage("\tCheck consistence of data base");
            SnapShot.writeInfoMessage("\t\tCheck data with update (admin)");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data with update");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck data (online)");
            SnapShot.getDatabase().executeDBMcmd("db_online");
            SnapShot.getDatabase().executeDBMcmd("util_connect");
            SnapShot.getDatabase().executeDBMcmd("db_execute check data");
            SnapShot.getDatabase().executeDBMcmd("util_release");
            SnapShot.writeInfoMessage("\t\tCheck table consistency");
            myConnection = SnapShot.getDatabase().connect(mExUser, mExPassword);
            myStatement = new TestStatement(null, myConnection, 1005, 1007);
            myStatement.executeQuery("select Doc_2_Id from TrainingDocuments where DocumentSize <> length( Document )");
            if (0 != myStatement.getResultCounter()) {
                throw new TestCaseException("Error during: " + myStatement.getSqlString() + " result count " + myStatement.getResultCounter() + " instead of 0");
            }
            myResult = myStatement.executeQuery("Select USEDSIZE/8 from sysinfo.datastatistics");
            myResult.next();
            SnapShot.writeInfoMessage("\tCurrent data base size is " + myResult.getInt(1) + " pages");
            myResult.close();
            SnapShot.writeInfoMessage("Modify Documents during third training week");
            SnapShot.writeInfoMessage("\tUpdate documents");
            int randomValue = 0;
            myRandomFactory = new Random();
            myStringBuffer = new StringBuffer(2000);
            myStringBuffer.setLength(2000);
            for (int i = 0; i < myStringBuffer.capacity(); ++i) {
                myStringBuffer.setCharAt(i, 'z');
            }
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Update TrainingDocuments set DocumentSize = ?, Document = ? where Doc_2_Id = ? ");
            int updatedDocuments = 0;
            for (int myDoc2Id = 0; myDoc2Id < totalDocuments; myDoc2Id += 7) {
                ++updatedDocuments;
                randomValue = myRandomFactory.nextInt(1499) + 500 % myStringBuffer.capacity();
                String myDocument = new String(myStringBuffer.substring(0, randomValue));
                myPrepStatement.setInt(1, myDocument.length());
                myPrepStatement.setString(2, myDocument);
                myPrepStatement.setInt(3, myDoc2Id);
                myPrepStatement.executeUpdate();
                if (0 != myDoc2Id % 100) continue;
                myStatement.executeUpdate("Commit");
            }
            myStatement.executeUpdate("Commit");
            SnapShot.writeInfoMessage("\tNumber of updated documents: " + updatedDocuments);
            myPrepStatement.close();
            myStatement.close();
            myConnection.close();
            Object var14_14 = null;
            try {
                myStatement.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e2) {}
            break block30;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var14_15 = null;
                    try {
                        myStatement.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        myConnection.commit();
                        myConnection.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    myStatement.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    myConnection.commit();
                    myConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

