/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class myLiveCacheTest
extends TestCase {
    private static final String mExUser = "TESTEXAMPLE";
    private static final String mExPassword = "TESTEXAMPLE";
    private int mStatementCounter = 0;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private int mNextKey = 0;
    private int mNextValue = 0;
    private int mNoOfObjects = myLiveCacheTest.getParameterInt((String)"NoOfObjects", (int)10);
    protected static final int mNumberOfConnections = 1;
    protected static final int USER1 = 1;
    protected static final int NO_ERROR = 0;
    protected static final int DBERR_DUPLICATE_NAME = -6006;
    protected static final int IGNORE_ALL_ERRORS = -999;
    protected static final int DEFAULT_TIMEOUT = 10;
    public static final String SCHEMA_NAME = "testteam";

    public static void prepare() throws TestCaseException {
        Connection lConnection = null;
        TestStatement lTstmt = null;
        try {
            block16: {
                TestCase.setInfoMessageFilter((boolean)false);
                try {
                    lConnection = myLiveCacheTest.getDatabase().connect(myLiveCacheTest.getDatabase().getDBAUser(), myLiveCacheTest.getDatabase().getDBAPassword());
                }
                catch (Exception e) {
                    myLiveCacheTest.addGlobalMessage((String)"Login failure", (char)'E', (String)("DBAUser: " + myLiveCacheTest.getDatabase().getDBAUser() + ", Password: " + myLiveCacheTest.getDatabase().getDBAPassword()));
                    throw e;
                }
                lTstmt = new TestStatement(null, lConnection);
                lTstmt.enableExceptions(false);
                try {
                    if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                        lTstmt.executeUpdate("enable write transaction");
                    }
                }
                catch (TestDatabaseException e) {
                    throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
                }
                lTstmt.executeUpdate("enable write transaction");
                lTstmt.executeUpdate("drop user TESTEXAMPLE");
                lTstmt.enableExceptions(true);
                try {
                    lTstmt.executeUpdate("Create user TESTEXAMPLE password TESTEXAMPLE dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block16;
                    myLiveCacheTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : TESTEXAMPLE not possible");
                    throw e;
                }
            }
            myLiveCacheTest.createDBProcedures();
            myLiveCacheTest.createConnections();
        }
        catch (Exception e) {
            throw (TestCaseException)((Object)e);
        }
        finally {
            try {
                lTstmt.close();
                lConnection.close();
            }
            catch (Exception e) {}
        }
    }

    public void run() {
        try {
            int key = this.getNextKey();
            int containerNumber = 1;
            int expectedChecksum = 10;
            myLiveCacheTest.addGlobalMessage((String)"myLiveCacheTest", (char)'I', (String)"--> Creating keyed container!");
            this.prCreateKeyedContainer(1, SCHEMA_NAME, containerNumber, 10, 0);
            this.prCommit(1);
            myLiveCacheTest.addGlobalMessage((String)"myLiveCacheTest", (char)'I', (String)("--> Creating " + this.mNoOfObjects + " keyed objects!"));
            this.prCreateKeyedObjects(1, SCHEMA_NAME, this.mNoOfObjects);
            this.prCommit(1);
            myLiveCacheTest.addGlobalMessage((String)"myLiveCacheTest", (char)'I', (String)"--> Going to check checksums!");
            this.prSumAllKeyedObjects(1, SCHEMA_NAME, containerNumber, expectedChecksum, 0);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (mStatements == null || mConnections == null) {
            return;
        }
        try {
            for (int i = 0; i < 1; ++i) {
                if (mStatements[i] != null) {
                    mStatements[i].close();
                }
                if (mConnections[i] == null) continue;
                mConnections[i].commit();
                mConnections[i].close();
            }
        }
        catch (Exception e) {
            myLiveCacheTest.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during connection closure: " + e.getMessage()));
            throw new TestCaseException("Error during connection closure: " + e.getMessage());
        }
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        int ExecMode = 1;
        try {
            con = myLiveCacheTest.getDatabase().connect("TESTEXAMPLE", "TESTEXAMPLE");
            stmt = new TestStatement(null, con);
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "mylctest", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "mylctest", "liveCache.consistent.TEST");
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'mylctest'");
            }
            DBProcedure.create(stmt, "CREATE_KEYED_CONTAINER", "mylctest");
            DBProcedure.create(stmt, "CREATE_KEYED_OBJECT", "mylctest");
            DBProcedure.create(stmt, "SUM_ALL_KEYED_OBJECTS", "mylctest");
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "mylctest", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "mylctest", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "mylctest", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "mylctest", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            con.commit();
        }
        catch (Exception e) {
            myLiveCacheTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("LCRecoverTest.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    private static boolean createConnections() {
        try {
            mConnections = new Connection[1];
            mStatements = new TestStatement[1];
            for (int i = 0; i < 1; ++i) {
                myLiveCacheTest.mConnections[i] = myLiveCacheTest.getDatabase().connect("TESTEXAMPLE", "TESTEXAMPLE");
                mConnections[i].setAutoCommit(false);
                myLiveCacheTest.mStatements[i] = new TestStatement(null, mConnections[i]);
            }
        }
        catch (Exception e) {
            myLiveCacheTest.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public int getNextKey() {
        return this.mNextKey++;
    }

    protected void prCommit(int pUserId) throws TestCaseException {
        ++this.mStatementCounter;
        String InfoString = this.getInfoString("prCommit", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            con.commit();
            myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'I', (String)"Commit --> OK");
        }
        catch (Exception e) {
            myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** Could not commit: " + e.getMessage()));
            throw new TestCaseException("Error in LCRecoverTest");
        }
    }

    protected void prCreateKeyedContainer(int pUserId, String pSchemaName, int pContainerNumber, int pRequestTimeout, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateKeyedContainer", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_KEYED_CONTAINER ('" + pSchemaName + "', " + pContainerNumber + ")");
            CallString = "Call of CREATE_KEYED_CONTAINER ('" + pSchemaName + "', " + pContainerNumber + ")";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
        myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " --> OK"));
    }

    protected boolean prCreateKeyedObjects(int pUserId, String pSchemaName, int pNumberOfKeyedObjects) throws TestCaseException {
        this.mNextKey = 0;
        this.mNextValue = 0;
        for (int i = 0; i < pNumberOfKeyedObjects; ++i) {
            this.prCreateKeyedObject(pUserId, this.mNextKey++, this.mNextValue++, 10, 0, pSchemaName, 1);
        }
        return true;
    }

    protected void prCreateKeyedObject(int pUserId, int pKey, int pValue, int pRequestTimeout, int pExpectedResultCode, String pSchemaName, int pContainerNumber) throws TestCaseException {
        ++this.mStatementCounter;
        String CallString = "";
        String InfoString = this.getInfoString("prCreateKeyedObject", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallableStatement stmt = con.prepareCall("CALL CREATE_KEYED_OBJECT (" + pKey + ", " + pValue + ", '" + pSchemaName + "', " + pContainerNumber + ")");
            CallString = "Call of CREATE_KEYED_OBJECT ( Key=" + pKey + ", Value=" + pValue + ", pSchemaName = '" + pSchemaName + "', pContainerNumber=" + pContainerNumber + " )";
            stmt.execute();
            this.checkResultCode(InfoString, CallString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, CallString, pExpectedResultCode, e);
            return;
        }
    }

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode) throws TestCaseException {
        if (pExpectedResultCode != 0 && pExpectedResultCode != -999) {
            myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> expecting result code " + pExpectedResultCode));
            throw new TestCaseException(CallString + " --> expecting result code " + pExpectedResultCode);
        }
    }

    private void checkResultCode(String InfoString, String CallString, int pExpectedResultCode, SQLException e) throws TestCaseException {
        if (pExpectedResultCode == -999) {
            return;
        }
        if (e.getErrorCode() != pExpectedResultCode) {
            myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + CallString + " --> " + e.getMessage()));
            throw new TestCaseException(CallString + " --> " + e.getMessage());
        }
        myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'I', (String)(CallString + " - Expected error: " + e.getMessage() + " --> OK"));
    }

    private String getInfoString(String pMethodName, int pCounter, int pUser) {
        return "<" + pMethodName + "(), Statement " + pCounter + ", User " + pUser + ">";
    }

    protected Connection getConnection(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 1) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 1 + "]");
        }
        return mConnections[UserId - 1];
    }

    protected TestStatement getStatement(int UserId) throws TestCaseException {
        if (UserId < 1 || UserId > 1) {
            throw new TestCaseException(" UserId " + UserId + " is out of range[1," + 1 + "]");
        }
        return mStatements[UserId - 1];
    }

    protected boolean prSumAllKeyedObjects(int pUserId, String pSchemaName, int pContainerNumber, int pExpectedValue, int pExpectedResultCode) throws TestCaseException {
        ++this.mStatementCounter;
        boolean ResultKey = false;
        int ResultValue1 = 0;
        int ResultValue2 = 0;
        String CallString = "";
        String ResultString = "";
        String InfoString = this.getInfoString("prSumAllKeyedObjects", this.mStatementCounter, pUserId);
        try {
            Connection con = this.getConnection(pUserId);
            CallString = "Call of SUM_ALL_KEYED_OBJECTS ( pSchemaName = '" + pSchemaName + "', pContainerNumber = " + pContainerNumber + "NumberOfKeyedObjecs = ?, SumOfKeyedObjects = ?)";
            CallableStatement stmt = con.prepareCall("CALL SUM_ALL_KEYED_OBJECTS ( '" + pSchemaName + "', " + pContainerNumber + ", ?, ?)");
            stmt.registerOutParameter(1, 4);
            stmt.registerOutParameter(2, 4);
            stmt.execute();
            ResultValue1 = stmt.getInt(1);
            ResultValue2 = stmt.getInt(2);
            ResultString = CallString + " returned: ( NumberOfKeyedObjects = " + ResultValue1 + ", SumOfKeyedObjects = " + ResultValue2 + " )";
            if (ResultValue2 != pExpectedValue) {
                myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'E', (String)("***** ERROR ****** " + ResultString + " --> expecting value " + pExpectedValue));
                throw new TestCaseException(ResultString + " --> expecting value " + pExpectedValue);
            }
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode);
        }
        catch (SQLException e) {
            this.checkResultCode(InfoString, ResultString, pExpectedResultCode, e);
            return true;
        }
        myLiveCacheTest.addGlobalMessage((String)InfoString, (char)'I', (String)(ResultString + " --> OK"));
        return true;
    }
}

