/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class SaveLogHoldRandom
extends TestCase {
    private static final String myUserName = "huba";
    private static final String myUserPassword = "hopp";
    public static final String DBERR_DATABACKUP_MISSING = "-126";
    public static final String DBERR_NO_LOG_TO_SAVE = "-123";
    public static final String NO_ERROR = null;
    SimpleDateFormat myStartDate = new SimpleDateFormat("HH:mm:ss.S");
    private Random mRandomGenerator = new Random();

    public static String getMinimumRelease() {
        return "7.5.*";
    }

    public static long getTimeout() {
        return 10800000L;
    }

    public static void cleanUp() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        try {
            SaveLogHoldRandom.db_online();
            myConnection = SaveLogHoldRandom.getDatabase().connect(SaveLogHoldRandom.getUser(), SaveLogHoldRandom.getPassword());
            myStatement = new TestStatement(null, myConnection);
            SaveLogHoldRandom.writeInfoMessage("\nDrop user huba");
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user huba");
            myStatement.enableExceptions(true);
            Thread.sleep(1000L);
            SaveLogHoldRandom.getDatabase().executeDBMcmd("medium_delete SLHDAT");
            SaveLogHoldRandom.getDatabase().executeDBMcmd("medium_delete SLHLOG");
            SaveLogHoldRandom.getDatabase().executeDBMcmd("param_directput LOG_SEGMENT_SIZE 833");
            SaveLogHoldRandom.getDatabase().executeDBMcmd("param_checkall");
            myConnection.close();
            SaveLogHoldRandom.writeInfoMessage("\n CleanUp finished");
        }
        catch (Exception e) {
            SaveLogHoldRandom.addGlobalMessage((String)"Method cleanUp", (char)'E', (String)"cleanUp failed");
            throw new TestCaseException("Error during cleanUp: " + e.getClass() + e.getMessage());
        }
        System.out.println("End of " + SaveLogHoldRandom.getTestClassId() + " Test\n");
    }

    public static String getTestClassId() {
        return "SaveLogHoldRandom";
    }

    public static void db_online() {
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            sapdb.executeDBMcmd("db_online -" + sapdb.getKernelMode());
        }
        catch (Exception e) {
            SaveLogHoldRandom.addGlobalMessage((String)"db_online()", (char)'E', (String)("db_online failed: " + e.getClass() + e.getMessage()));
        }
    }

    public static void db_offline() {
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            sapdb.executeDBMcmd("db_offline -" + sapdb.getKernelMode());
        }
        catch (Exception e) {
            SaveLogHoldRandom.addGlobalMessage((String)"db_offline()", (char)'E', (String)("db_offline failed: " + e.getClass() + e.getMessage()));
        }
    }

    public static void db_admin() {
        try {
            TestDatabaseSap sapdb = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            sapdb.executeDBMcmd("db_admin -" + sapdb.getKernelMode());
        }
        catch (Exception e) {
            SaveLogHoldRandom.addGlobalMessage((String)"db_admin()", (char)'E', (String)("db_admin failed: " + e.getClass() + e.getMessage()));
        }
    }

    private static void writeInfoMessage(String pMessageText) {
        System.out.println(pMessageText);
        SaveLogHoldRandom.addGlobalMessage((String)"", (char)'I', (String)pMessageText);
    }

    /*
     * Loose catch block
     */
    public static void prepare() throws TestCaseException {
        block15: {
            Connection myConnection = null;
            TestStatement myStatement = null;
            Object myPrepStatement = null;
            Object myStringBuffer = null;
            Object myRandomFactory = null;
            TestDatabaseSap db = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            System.out.println("\nStart of " + SaveLogHoldRandom.getTestClassId() + " Test");
            SaveLogHoldRandom.writeInfoMessage("Create data base backup media");
            db.executeDBMcmd("medium_put SLHDAT SLHDAT     FILE DATA  0 8 YES NO");
            db.executeDBMcmd("medium_put SLHLOG SLHLOG     FILE LOG  0 8 YES NO");
            db.executeDBMcmd("param_directput LOG_SEGMENT_SIZE 333");
            db.executeDBMcmd("param_checkall");
            myConnection = db.connect(SaveLogHoldRandom.getUser(), SaveLogHoldRandom.getPassword());
            db.executeDBMcmd("autolog_off");
            myStatement = new TestStatement(null, myConnection);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user huba");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user huba password hopp DBA not exclusive");
            myStatement.close();
            myConnection.close();
            myConnection = db.connect(myUserName, myUserPassword);
            myStatement = new TestStatement(null, myConnection);
            myStatement.executeUpdate("Create table myData(text       char( 1000 ) ,number     int          )");
            myStatement.executeUpdate("Create table SLH_TAB( text char(80), lfdnr int, zeitstempel timestamp, filler char(1000) DEFAULT '0123456789abcdefghijklmnopqrstuvwxyz')");
            myStatement.executeUpdate("CREATE DBPROC FILL_SLH_TAB (IN ident char(1000), IN numrows INT) AS  VAR x INT;  SET x=1;  WHILE x <= numrows DO BEGIN  INSERT INTO  HUBA.SLH_TAB VALUES (:ident, :x, Now(), DEFAULT);       IF $RC <> 0 THEN \t STOP ($RC, $ERRMSG);  x = x + 1;  END; ");
            SaveLogHoldRandom.writeInfoMessage("Create initial data base backup");
            myConnection.close();
            Object var8_6 = null;
            try {
                myStatement.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                myPrepStatement.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
            break block15;
            {
                catch (Exception e) {
                    SaveLogHoldRandom.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
                    throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    myStatement.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    myPrepStatement.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    myConnection.commit();
                    myConnection.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void insertOneRow(String rowValue, TestStatement statement, VerificationDataComplete verificationData) {
        try {
            statement.executeUpdate("insert into mydata values " + rowValue);
            statement.executeUpdate("COMMIT");
            statement.executeQuery("select * from mydata");
            verificationData.add(statement.getResultSet());
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    public void fillDB(String numberOfRows, TestStatement statement) {
        try {
            statement.executeUpdate("call HUBA.FILL_SLH_TAB ('before insert' , " + numberOfRows + " ) WITH COMMIT");
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    public void checkTableContent(VerificationDataComplete veriData, TestStatement statement) {
        try {
            statement.executeQuery("SELECT * from mydata");
            if (!this.checkQuery(statement, (VerificationData)veriData)) {
                throw new TestCaseException("veriData does not match query");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    public void saveData(String expectedError) throws TestDatabaseException {
        try {
            TestDatabaseSap db = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            db.executeDBMcmd("util_connect");
            db.executeDBMcmd("backup_start SLHDAT");
            db.executeDBMcmd("util_release");
        }
        catch (TestDatabaseException e) {
            if (expectedError != null) {
                if (e.toString().indexOf(expectedError) == -1) {
                    this.handleExceptions((Exception)((Object)e));
                    throw e;
                }
            }
            this.handleExceptions((Exception)((Object)e));
            throw e;
        }
    }

    public void saveLogHold(String expectedError) throws TestDatabaseException {
        try {
            System.out.println("  saveLogHold(" + expectedError + ") \tat " + this.myStartDate.format(new Date(System.currentTimeMillis())));
            TestDatabaseSap db = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            db.executeDBMcmd("util_connect");
            db.executeDBMcmd("util_execute SAVE LOG QUICK TO 'SLHLOG' FILE FVERSION MEDIANAME 'SLHLOG' HOLD");
            db.executeDBMcmd("util_release");
        }
        catch (TestDatabaseException e) {
            if (expectedError != null) {
                if (e.toString().indexOf(expectedError) == -1) {
                    this.handleExceptions((Exception)((Object)e));
                    throw e;
                }
            }
            this.handleExceptions((Exception)((Object)e));
            throw e;
        }
    }

    public void saveLog(String expectedError) throws TestDatabaseException {
        try {
            System.out.println("  saveLog(" + expectedError + ") \tat " + this.myStartDate.format(new Date(System.currentTimeMillis())));
            TestDatabaseSap db = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            db.executeDBMcmd("util_connect");
            db.executeDBMcmd("backup_start SLHLOG");
            db.executeDBMcmd("util_release");
        }
        catch (TestDatabaseException e) {
            if (expectedError != null) {
                if (e.toString().indexOf(expectedError) == -1) {
                    this.handleExceptions((Exception)((Object)e));
                    throw e;
                }
            }
            this.handleExceptions((Exception)((Object)e));
            throw e;
        }
    }

    public void restoreData(TestDatabaseSap db) throws TestDatabaseException {
        try {
            db.executeDBMcmd("recover_start SLHDAT");
        }
        catch (TestDatabaseException e) {
            this.handleExceptions((Exception)((Object)e));
            throw e;
        }
    }

    public void restoreLog(TestDatabaseSap db, String numberOfBackup) throws TestDatabaseException {
        block2: {
            try {
                db.executeDBMcmd("recover_start SLHLOG LOG " + numberOfBackup);
            }
            catch (TestDatabaseException e) {
                if (e.toString().indexOf("-8020") != -1) break block2;
                this.handleExceptions((Exception)((Object)e));
                throw e;
            }
        }
    }

    public void restoreLogReplace(TestDatabaseSap db, String numberOfBackup) throws TestDatabaseException {
        block2: {
            try {
                db.executeDBMcmd("recover_replace SLHLOG SLHLOG." + numberOfBackup);
            }
            catch (TestDatabaseException e) {
                if (e.toString().indexOf("-8020") != -1) break block2;
                this.handleExceptions((Exception)((Object)e));
                throw e;
            }
        }
    }

    public void recoverDataAndLog(String logsave1, String logsave2, String logsave3, String logsave4, String logsave5, String logsave6) throws TestDatabaseException {
        SaveLogHoldRandom.writeInfoMessage("  recoverDataAndLog(" + logsave1 + ", " + logsave2 + ", " + logsave3 + ", " + logsave4 + ", " + logsave5 + ", " + logsave6 + ") \tat " + this.myStartDate.format(new Date(System.currentTimeMillis())));
        try {
            SaveLogHoldRandom.db_admin();
            TestDatabaseSap db = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            db.executeDBMcmd("util_connect");
            db.executeDBMcmd("util_execute clear log");
            this.restoreData(db);
            if (logsave1 != null) {
                this.restoreLog(db, logsave1);
                if (logsave2 != null) {
                    this.restoreLogReplace(db, logsave2);
                    if (logsave3 != null) {
                        this.restoreLogReplace(db, logsave3);
                        if (logsave4 != null) {
                            this.restoreLogReplace(db, logsave4);
                            if (logsave5 != null) {
                                this.restoreLogReplace(db, logsave5);
                                if (logsave6 != null) {
                                    this.restoreLogReplace(db, logsave6);
                                }
                            }
                        }
                    }
                }
                db.executeDBMcmd("recover_ignore");
                db.executeDBMcmd("util_release");
            } else {
                db.executeDBMcmd("db_online");
            }
        }
        catch (TestDatabaseException e) {
            this.handleExceptions((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block14: {
            TestDatabaseSap db = (TestDatabaseSap)SaveLogHoldRandom.getDatabase();
            Connection myConnection = null;
            TestStatement myStatement = null;
            SaveLogHoldRandom.writeInfoMessage("\nRunning test ");
            myConnection = db.connect(myUserName, myUserPassword);
            myStatement = new TestStatement(null, myConnection);
            SaveLogHoldRandom.db_admin();
            db.executeDBMcmd("util_execute clear log");
            this.saveLogHold(DBERR_DATABACKUP_MISSING);
            this.saveLogHold(DBERR_DATABACKUP_MISSING);
            this.saveLog(DBERR_DATABACKUP_MISSING);
            this.saveData(NO_ERROR);
            this.saveLogHold(DBERR_NO_LOG_TO_SAVE);
            this.saveLogHold(DBERR_NO_LOG_TO_SAVE);
            this.saveLog(DBERR_NO_LOG_TO_SAVE);
            SaveLogHoldRandom.db_online();
            VerificationDataComplete veri1 = new VerificationDataComplete();
            this.insertOneRow("('single page online save', 1)", myStatement, veri1);
            this.saveLogHold(NO_ERROR);
            this.saveLogHold(NO_ERROR);
            this.saveLog(NO_ERROR);
            this.saveLogHold(DBERR_NO_LOG_TO_SAVE);
            this.saveLogHold(DBERR_NO_LOG_TO_SAVE);
            this.saveLog(DBERR_NO_LOG_TO_SAVE);
            VerificationDataComplete veri2 = new VerificationDataComplete();
            this.insertOneRow("('single page admin save', 2)", myStatement, veri2);
            SaveLogHoldRandom.db_admin();
            this.saveLogHold(NO_ERROR);
            this.saveLogHold(NO_ERROR);
            this.saveLog(NO_ERROR);
            SaveLogHoldRandom.db_online();
            this.fillDB("20000", myStatement);
            VerificationDataComplete veri3 = new VerificationDataComplete();
            this.insertOneRow("('one segment multiple pages online save', 3)", myStatement, veri3);
            this.saveLogHold(NO_ERROR);
            this.saveLog(NO_ERROR);
            this.fillDB("21000", myStatement);
            VerificationDataComplete veri4 = new VerificationDataComplete();
            this.insertOneRow("('one segment multiple pages admin save', 4)", myStatement, veri4);
            SaveLogHoldRandom.db_admin();
            this.saveLogHold(NO_ERROR);
            this.saveLog(NO_ERROR);
            SaveLogHoldRandom.db_online();
            this.checkTableContent(veri4, myStatement);
            DecimalFormat formatierer = new DecimalFormat("000");
            String value001 = null;
            String value002 = null;
            String value003 = null;
            String value004 = null;
            String value005 = null;
            String value006 = null;
            value001 = formatierer.format(this.randomInteger(1, 3));
            this.recoverDataAndLog(value001, null, null, null, null, null);
            this.checkTableContent(veri1, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            this.recoverDataAndLog(value001, value002, null, null, null, null);
            this.checkTableContent(veri2, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            this.recoverDataAndLog(value001, value002, null, null, null, null);
            this.checkTableContent(veri2, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            this.recoverDataAndLog(value001, value002, null, null, null, null);
            this.checkTableContent(veri2, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            this.recoverDataAndLog(value001, value002, null, null, null, null);
            this.checkTableContent(veri2, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            value003 = formatierer.format(this.randomInteger(0, 1) * 2 + 7);
            value004 = formatierer.format(this.randomInteger(0, 1) * 2 + 8);
            this.recoverDataAndLog(value001, value002, value003, value004, null, null);
            this.checkTableContent(veri3, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            value003 = formatierer.format(this.randomInteger(0, 1) * 2 + 7);
            value004 = formatierer.format(this.randomInteger(0, 1) * 2 + 8);
            this.recoverDataAndLog(value001, value002, value003, value004, null, null);
            this.checkTableContent(veri3, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            value003 = formatierer.format(this.randomInteger(0, 1) * 2 + 7);
            value004 = formatierer.format(this.randomInteger(0, 1) * 2 + 8);
            value005 = formatierer.format(this.randomInteger(0, 1) * 2 + 11);
            value006 = formatierer.format(this.randomInteger(0, 1) * 2 + 12);
            this.recoverDataAndLog(value001, value002, value003, value004, value005, value006);
            this.checkTableContent(veri4, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            value003 = formatierer.format(this.randomInteger(0, 1) * 2 + 7);
            value004 = formatierer.format(this.randomInteger(0, 1) * 2 + 8);
            value005 = formatierer.format(this.randomInteger(0, 1) * 2 + 11);
            value006 = formatierer.format(this.randomInteger(0, 1) * 2 + 12);
            this.recoverDataAndLog(value001, value002, value003, value004, value005, value006);
            this.checkTableContent(veri4, myStatement);
            value001 = formatierer.format(this.randomInteger(1, 3));
            value002 = formatierer.format(this.randomInteger(4, 6));
            value003 = formatierer.format(this.randomInteger(0, 1) * 2 + 7);
            value004 = formatierer.format(this.randomInteger(0, 1) * 2 + 8);
            value005 = formatierer.format(this.randomInteger(0, 1) * 2 + 11);
            value006 = formatierer.format(this.randomInteger(0, 1) * 2 + 12);
            this.recoverDataAndLog(value001, value002, value003, value004, value005, value006);
            this.checkTableContent(veri4, myStatement);
            Object var16_16 = null;
            try {
                myStatement.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e2) {}
            break block14;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var16_17 = null;
                    try {
                        myStatement.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        myConnection.commit();
                        myConnection.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    myStatement.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    myConnection.commit();
                    myConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)this.mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }
}

