/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.SQLRecoverTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class SQLRecoverTest5
extends SQLRecoverTest {
    public static void cleanUp() throws TestCaseException {
        SQLRecoverTest.cleanUp();
    }

    public static void prepare() throws TestCaseException {
        SQLRecoverTest.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean checksum = false;
        TestDatabaseSap sapdb = (TestDatabaseSap)SQLRecoverTest5.getDatabase();
        try {
            this.printTestHeader(this);
            this.executeSQL(1, "drop table SQLRecoverTest5");
            this.executeSQL(1, "commit");
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("medium_put srt5 srt5 FILE DATA 0 8 YES NO");
            this.executeDBMCmd("util_release");
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'I', (String)"--> Just created backup media (FILE c:/Temp/srt5)!");
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("backup_save srt5");
            this.executeDBMCmd("util_release");
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'I', (String)"--> Just performed backup srt5!");
            this.executeSQL(1, "Create table SQLRecoverTest5 (k0 int, k1 char(10), primary key(k0, k1))");
            this.executeSQL(1, "commit");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (1, 'Key1')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (2, 'Key2')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (3, 'Key3')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (4, 'Key4')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (5, 'Key5')");
            this.executeSQL(1, "subtrans begin");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (6, 'Key6')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (7, 'Key7')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (8, 'Key8')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (9, 'Key9')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (10, 'Key10')");
            this.executeSQL(1, "commit");
            this.checkChecksum("SQLRecoverTest5", 55);
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (11, 'Key11')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (12, 'Key12')");
            this.executeSQL(1, "subtrans begin");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (13, 'Key13')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (14, 'Key14')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (15, 'Key15')");
            this.executeSQL(1, "subtrans rollback");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (16, 'Key16')");
            this.executeSQL(1, "commit");
            this.checkChecksum("SQLRecoverTest5", 94);
            this.executeDBMCmd("db_offline");
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'I', (String)"--> Just performed db_offline!");
            this.executeDBMCmd("db_cold -" + sapdb.getKernelMode());
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'I', (String)("--> Just performed db_cold -" + sapdb.getKernelMode() + "!"));
            this.executeDBMCmd("util_connect");
            this.executeDBMCmd("recover_start srt5 data");
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'I', (String)"--> Just performed recovery!");
            this.executeDBMCmd("db_warm -" + sapdb.getKernelMode());
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'I', (String)("--> Just performed db_warm -" + sapdb.getKernelMode() + "!"));
            SQLRecoverTest5.createConnections();
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (13, 'Key13')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (14, 'Key14')");
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (15, 'Key15')");
            this.executeSQL(1, "commit");
            this.checkChecksum("SQLRecoverTest5", 136);
            this.executeSQL(1, "Insert into SQLRecoverTest5 values (5, 'Key5')");
            this.executeSQL(1, "commit");
            this.checkChecksum("SQLRecoverTest5", 136);
            this.executeDBMCmd("util_release");
        }
        catch (Exception e) {
            this.printTestError(this);
            SQLRecoverTest5.addGlobalMessage((String)"SQLRecoverTest5", (char)'E', (String)e.getMessage());
        }
        finally {
            try {
                this.executeDBMCmd("util_release");
                this.executeDBMCmd("sql_release");
            }
            catch (Exception exception) {}
        }
        this.printTestTrailer(this);
    }
}

