/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.lctest.TestActor;
import com.sap.sapdb.oltptest.mut.OLTPTestActor;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class RecoveryCancel
extends PrimaryTest {
    private static final String sVersion = "3.0";
    private String mKernelMode = "FAST";
    protected static int mNumberOfConcurrentUsers;
    protected static int mNumberOfKillers;
    protected static int mNumberOfWriters;
    protected static String mTypeOfKilling;
    protected static boolean mLongTransactions;
    protected static int mLOG_SEGMENT_SIZE;
    protected static int mStartDistance;
    protected static int mWaitTimeAfterStart;
    protected static int mNoOfCycles;
    private String sString = null;
    private static Random mRandomGenerator;
    private static int mTraceLevel;
    private DBM mDBMan = null;
    private DBM mDBMan2 = null;
    private DBM mDBMan3 = null;
    protected static boolean noFullRecovery;
    protected static boolean killing;
    protected static Killer[] KillerSet;
    protected static QueueCountChanger queueCountChangerThread;
    protected static Integer converterVersionObj;
    protected static int converterVersionNew;
    protected static int converterVersionStart;
    protected static int recoveryAborted;
    protected static boolean testIsInterrupted;
    protected Vector[] Oids;
    protected Vector[] keyOids;
    protected boolean globalError = false;
    protected String globalErrorText = "";

    public RecoveryCancel() throws SQLException, TestDatabaseException {
        this.mTrace = false;
    }

    public static String getMinimumRelease() {
        return "7.4.*";
    }

    public static String getTestClassId() {
        return "RecoveryCancel";
    }

    public static void prepare() throws TestCaseException {
        RecoveryCancel.readAndPrintParameters();
        PrimaryTest.prepare();
    }

    public static void readAndPrintParameters() throws TestCaseException {
        mTraceLevel = RecoveryCancel.getParameterInt((String)"TraceLevel", (int)2);
        mNumberOfKillers = RecoveryCancel.getParameterInt((String)"NumberOfKillers", (int)1);
        mLongTransactions = RecoveryCancel.getParameterBoolean((String)"LongTransaction", (boolean)false);
        mTypeOfKilling = "";
        if (mNumberOfKillers == 1) {
            mTypeOfKilling = RecoveryCancel.getParameterString((String)"TypeOfKilling", (String)"db_stop");
        }
        mNumberOfConcurrentUsers = mNumberOfWriters = RecoveryCancel.getParameterInt((String)"NumberOfWriters", (int)2);
        mNoOfCycles = RecoveryCancel.getParameterInt((String)"NoOfCycles", (int)6500);
        mLOG_SEGMENT_SIZE = RecoveryCancel.getParameterInt((String)"LOG_SEGMENT_SIZE", (int)2500);
        mStartDistance = RecoveryCancel.getParameterInt((String)"StartDistance", (int)1);
        mWaitTimeAfterStart = RecoveryCancel.getParameterInt((String)"WaitTimeAfterStart", (int)6);
        RecoveryCancel.printInfo(1, "\n" + RecoveryCancel.getTestClassId(), "Starting " + RecoveryCancel.getTestClassId() + " Test - Version: " + sVersion + "\n");
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: NumberOfKillers = " + mNumberOfKillers);
        if (mNumberOfKillers == 1) {
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: TypeOfKilling   = " + mTypeOfKilling);
        }
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: NumberOfWriters = " + mNumberOfWriters);
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: StartDistance   = " + mStartDistance);
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: WaitTimeAfterStart  = " + mWaitTimeAfterStart);
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: TraceLevel          = " + mTraceLevel);
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: NoOfCycles          = " + mNoOfCycles);
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: LOG_SEGMENT_SIZE    = " + mLOG_SEGMENT_SIZE);
        RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Parameter: LongTransaction     = " + mLongTransactions);
    }

    public String executeDBMCmd1(String pCmd) throws TestDatabaseException {
        String logon = "USER_LOGON DBM,DBM";
        String mHost = "";
        String mName = "";
        RecoveryCancel.printInfo(5, RecoveryCancel.getTestClassId(), "executeDBMCmd1: " + pCmd);
        try {
            mHost = RecoveryCancel.getDatabase().getHost();
            mName = RecoveryCancel.getDatabase().getName();
            int mPort = RecoveryCancel.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan != null) {
                try {
                    this.mDBMan.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeDBMCmd_2(String pCmd) throws TestDatabaseException {
        String logon = "USER_LOGON DBM,DBM";
        String mHost = "";
        String mName = "";
        try {
            mHost = RecoveryCancel.getDatabase().getHost();
            mName = RecoveryCancel.getDatabase().getName();
            int mPort = RecoveryCancel.getDatabase().getPort();
            if (this.mDBMan2 == null) {
                this.mDBMan2 = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                this.mDBMan2.cmd(logon);
            }
            return this.mDBMan2.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan2 != null) {
                try {
                    this.mDBMan2.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan2 = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public static void cleanUp() throws TestCaseException {
        if (mTraceLevel > 0) {
            System.out.println("End of " + RecoveryCancel.getTestClassId());
        }
        PrimaryTest.cleanUp();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            RecoveryCancel.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            RecoveryCancel.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private void createContainer(int user) {
        try {
            this.sString = "CREATE CONTAINER " + user;
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), this.sString);
            this.prCreateContainer(user + 1, 1, "testteam", user, 0);
        }
        catch (Exception e) {
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Error during container creation: " + e.getMessage());
        }
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public void startingMultipleThreads(int StartDistance) throws TestCaseException {
        try {
            boolean areWAlive;
            int i;
            this.Oids = new Vector[mNumberOfWriters];
            this.keyOids = new Vector[mNumberOfWriters];
            for (int z = 0; z < mNumberOfWriters; ++z) {
                this.Oids[z] = new Vector(mNoOfCycles + 100);
                this.keyOids[z] = new Vector(mNoOfCycles + 100);
            }
            long SleepTime = 500 * StartDistance;
            Writer[] WriterSet = new Writer[mNumberOfWriters + 1];
            for (i = 0; i < mNumberOfWriters; ++i) {
                RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Start Writer" + Integer.toString(i));
                WriterSet[i] = new Writer(i, i);
                Thread.sleep(SleepTime);
                if (mTraceLevel <= 0) continue;
                System.out.println("created writer: i = " + i);
            }
            SleepTime = 60000 * mWaitTimeAfterStart;
            Thread.sleep(SleepTime);
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Stop all writer threads");
            for (i = 0; i < mNumberOfWriters; ++i) {
                if (WriterSet[i] != null) {
                    WriterSet[i].pleaseStop();
                }
                if (mTraceLevel <= 0) continue;
                System.out.println("asked to stop writers: i = " + i + " Status: " + WriterSet[i].isAlive());
            }
            Thread.sleep(20000L);
            int k = 0;
            do {
                ++k;
                areWAlive = false;
                for (i = 0; i < mNumberOfWriters; ++i) {
                    if (WriterSet[i] == null) continue;
                    WriterSet[i].keepRunning = false;
                }
                for (i = 0; i < mNumberOfWriters; ++i) {
                    if (WriterSet[i] == null) continue;
                    areWAlive |= WriterSet[i].isAlive();
                }
                Thread.sleep(200L);
                for (i = 0; i < mNumberOfWriters; ++i) {
                    if (WriterSet[i] == null || !WriterSet[i].isAlive()) continue;
                    WriterSet[i].interrupt();
                }
            } while (areWAlive && k < 100);
            if (mTraceLevel > 0) {
                System.out.println("Writers: " + areWAlive);
            }
            if (areWAlive) {
                RecoveryCancel.addGlobalMessage((String)"db_cons show all", (char)'T', (String)("Because not all threads are stopped, call 'db_cons show all'\n" + this.executeDBMCmd("db_cons show all")));
                throw new TestCaseException("Not all threads stopped!\n");
            }
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "All threads stopped...\n");
            for (int user = 0; user < mNumberOfWriters; ++user) {
                if (mTraceLevel > 0) {
                    System.out.println("***Writer_" + user + " - Number of MyVarOids: " + this.Oids[user].size());
                }
                if (mTraceLevel <= 0) continue;
                System.out.println("***Writer_" + user + " - Number of KeyOids: " + this.keyOids[user].size());
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    public long getChecksum(int user) {
        long sum = 0L;
        try {
            for (int i = 0; i < this.Oids[user].size(); ++i) {
                sum += (long)this.prReadMyvarobj(user + 1, "testteam", user, (Oid)this.Oids[user].elementAt(i), 0, true)[1];
            }
        }
        catch (Exception ex) {
            this.handleExceptions(ex);
        }
        if (mTraceLevel > 0) {
            System.out.println("***Checksum Writer_" + user + ": " + sum);
        }
        return sum;
    }

    public long getKeyChecksum(int user) {
        long sum = 0L;
        try {
            for (int i = 0; i < this.keyOids[user].size(); ++i) {
                sum += (long)this.prGetKey(user + 1, (Oid)this.keyOids[user].elementAt(i));
            }
        }
        catch (Exception ex) {
            this.handleExceptions(ex);
        }
        if (mTraceLevel > 0) {
            System.out.println("***Key-Checksum Writer_" + user + ": " + sum);
        }
        return sum;
    }

    public void pause(String mode) {
        try {
            String state = "";
            String mode2 = "unknown";
            if (mode.equalsIgnoreCase("ADMIN")) {
                mode2 = "COLD";
            }
            if (mode.equalsIgnoreCase("ONLINE")) {
                mode2 = "WARM";
            }
            if (mTraceLevel > 0) {
                if (mode2.equalsIgnoreCase("unknown")) {
                    System.out.println("Mode: '" + mode + "' \n");
                } else {
                    System.out.println("Mode: '" + mode + "' or  '" + mode2 + "'\n");
                }
            }
            while (!state.equals(mode) && !state.equals(mode2)) {
                Thread.sleep(200L);
                state = this.executeDBMCmd1("db_state").substring(6).trim();
                if (mTraceLevel <= 3) continue;
                System.out.println("State: '" + state + "'");
            }
        }
        catch (Exception ex) {
            this.handleExceptions(ex);
        }
    }

    public void startingKillerThread() {
        KillerSet = new Killer[mNumberOfKillers + 1];
        try {
            for (int j = 0; j < mNumberOfKillers; ++j) {
                RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Start Killer " + Integer.toString(j));
                RecoveryCancel.KillerSet[j] = new Killer(j);
                if (mTraceLevel <= 0) continue;
                System.out.println("created killer: j = " + j);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int getConverterVersion() {
        try {
            String theCurrentDBState = this.executeDBMCmd_2("db_state").substring(6).trim().toUpperCase();
            if (theCurrentDBState.equals("ADMIN") || theCurrentDBState.equals("COLD")) {
                boolean theLastStatementWasOK = true;
                int attemptCounter = 0;
                String lastErrorMessage = null;
                String temp = null;
                do {
                    try {
                        ++attemptCounter;
                        temp = this.executeDBMCmd_2("db_execute get restart version");
                        theLastStatementWasOK = true;
                    }
                    catch (Exception exp) {
                        theLastStatementWasOK = false;
                        lastErrorMessage = exp.getLocalizedMessage();
                    }
                } while (!theLastStatementWasOK && attemptCounter < 11);
                if (attemptCounter == 11) {
                    this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getConverterVersion() after 11 attempts it was not possible to call 'db_execute get restart version'; \nlast message: " + lastErrorMessage);
                    return converterVersionNew;
                }
                BufferedReader br = new BufferedReader(new StringReader(temp));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("CONVERTER VERSION")) continue;
                    converterVersionObj = new Integer(line.substring(line.indexOf("=") + 1).trim());
                    converterVersionNew = converterVersionObj;
                    break;
                }
                br.close();
                if (mTraceLevel > 3) {
                    System.out.println("NEW Converter Version: " + converterVersionNew);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getConverterVersion(): NumberFormatException " + e.getLocalizedMessage());
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getConverterVersion() caught an exception. \n" + e.getMessage() + "\n Used Converter Version: " + converterVersionNew);
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return converterVersionNew;
    }

    public int getNumberOfLogSegments() {
        int noOfSegments = 0;
        String cmd = "backup_history_list -r last -c LABEL";
        String backup = null;
        try {
            backup = this.executeDBMCmd1(cmd);
            if (backup.indexOf("LOG") != -1) {
                noOfSegments = Integer.parseInt(backup.substring(backup.length() - 5, backup.length() - 2).trim());
            }
        }
        catch (NumberFormatException e) {
            this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getNumberOfLogSegments() caught an exception. \n" + e.getMessage() + "\n Used number of log segments: " + noOfSegments);
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getNumberOfLogSegments() caught an exception. \n" + e.getMessage() + "\n Used number of log segments: " + noOfSegments);
        }
        this.addMessage(RecoveryCancel.getTestClassId(), 'I', "Tried to call: " + cmd + "\ngot:\n" + backup + "\nNo of Segments = " + noOfSegments);
        return noOfSegments;
    }

    public int getUsedLogPage() {
        int usedLogPage = 0;
        String tmp = "";
        try {
            boolean loop_2 = true;
            do {
                try {
                    tmp = this.executeDBMCmd1("db_restartinfo");
                    loop_2 = false;
                }
                catch (TestDatabaseException e) {
                    if (mTraceLevel > 0) {
                        System.out.println("*** UsedLogPage ERROR: " + e.toString());
                    }
                    this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getUsedLogPage() caught an exception. \n" + e.getMessage() + " usedLogPage = " + usedLogPage);
                    if (e.toString().indexOf("-104") != -1) continue;
                    loop_2 = false;
                }
            } while (loop_2);
            int index = tmp.indexOf("First");
            Integer usedLogPageObj = new Integer(tmp.substring(index - 6, index - 1).trim());
            usedLogPage = usedLogPageObj;
            if (mTraceLevel > 0) {
                System.out.println("UsedLogPage: " + usedLogPage);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return usedLogPage;
    }

    public int getLogSegmentForRecovery(int usedLogPage) {
        Vector<Integer> lowerBound = new Vector<Integer>();
        Vector<Integer> upperBound = new Vector<Integer>();
        int LogSegmentForRecovery = 0;
        try {
            StringTokenizer hack = new StringTokenizer(this.executeDBMCmd1("backup_history_list -r last -c LABEL,FIRSTLOG,LASTLOG"), "|");
            int a = 1;
            while (hack.hasMoreElements()) {
                if (++a < 6) {
                    hack.nextElement();
                    continue;
                }
                Integer int_1 = new Integer(hack.nextElement().toString().trim());
                Integer int_2 = new Integer(hack.nextElement().toString().trim());
                if (mTraceLevel > 0) {
                    System.out.println(int_1);
                }
                if (mTraceLevel > 0) {
                    System.out.println(int_2);
                }
                lowerBound.add(int_1);
                upperBound.add(int_2);
                if (mTraceLevel <= 0) continue;
                System.out.println(hack.nextElement().toString().trim());
            }
            int endOfLoop = this.getNumberOfLogSegments();
            for (int i = 0; i < endOfLoop; ++i) {
                if (usedLogPage > (Integer)lowerBound.elementAt(i) && usedLogPage < (Integer)upperBound.elementAt(i)) {
                    LogSegmentForRecovery = i + 1;
                    break;
                }
                if (usedLogPage == (Integer)lowerBound.elementAt(i) || usedLogPage == (Integer)upperBound.elementAt(i)) {
                    LogSegmentForRecovery = i + 1;
                    break;
                }
                if (usedLogPage < 0) {
                    if (mTraceLevel > 0) {
                        System.out.println("IMPOSSIBLE");
                    }
                    break;
                }
                if (usedLogPage > (Integer)upperBound.elementAt(i)) {
                    if (mTraceLevel <= 0) continue;
                    System.out.println("continue");
                    continue;
                }
                if (usedLogPage < (Integer)lowerBound.elementAt(i) && (Integer)lowerBound.elementAt(i) != 0) {
                    LogSegmentForRecovery = i;
                    break;
                }
                if (mTraceLevel > 0) {
                    System.out.println("Lower: " + (Integer)lowerBound.elementAt(i));
                }
                if (mTraceLevel <= 0) continue;
                System.out.println("Upper: " + (Integer)upperBound.elementAt(i));
            }
        }
        catch (NumberFormatException e) {
            this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getLogSegmentForRecovery() caught an exception. \n" + e.getMessage() + " LogSegmentForRecovery = " + LogSegmentForRecovery);
            e.printStackTrace();
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancel.getTestClassId(), 'E', "getLogSegmentForRecovery() caught an exception. \n" + e.getMessage() + " LogSegmentForRecovery = " + LogSegmentForRecovery);
            e.printStackTrace();
        }
        return LogSegmentForRecovery;
    }

    public String getRecoveryString(int number) {
        String recoveryString = "";
        if (number > 0 && number < 10) {
            recoveryString = "00" + number;
        } else if (number >= 10 && number < 100) {
            recoveryString = "0" + number;
        } else if (number >= 100) {
            recoveryString = "" + number;
        } else if (number == 0) {
            if (mTraceLevel > 0) {
                System.out.println("getRecoveryString impossible ---> number = " + number);
            }
            recoveryString = "";
        }
        return recoveryString;
    }

    public static long getTimeout() {
        return 1800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block96: {
            RTEException rte2222;
            int i;
            int i2;
            if (mLOG_SEGMENT_SIZE != 1666) {
                if (mTraceLevel > 0) {
                    System.out.println("Put LOG_SEGMENT_SIZE: " + mLOG_SEGMENT_SIZE + "\n");
                }
                this.executeDBMCmd1("param_directput LOG_SEGMENT_SIZE " + mLOG_SEGMENT_SIZE);
                this.executeDBMCmd1("db_offline");
            }
            this.executeDBMCmd1("db_warm");
            this.executeDBMCmd1("autosave_off");
            for (i2 = 0; i2 < mNumberOfWriters; ++i2) {
                this.prReconnect(i2 + 1);
            }
            this.setStatus("createBackupMedia");
            this.executeDBMCmd1("util_connect");
            this.executeDBMCmd1("backup_media_put recancelauto recancelauto FILE AUTO");
            this.executeDBMCmd1("backup_media_put recanceldat recanceldat FILE DATA 0 8 YES NO ");
            this.executeDBMCmd1("util_release");
            this.setStatus("backup DATA");
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Backup data");
            this.executeDBMCmd1("util_connect");
            this.executeDBMCmd1("backup_save recanceldat DATA");
            this.executeDBMCmd1("util_release");
            this.executeDBMCmd1("util_connect");
            this.executeDBMCmd1("autosave_on");
            this.executeDBMCmd1("util_release");
            this.setStatus("createContainer");
            for (i2 = 0; i2 < mNumberOfWriters; ++i2) {
                this.createContainer(i2);
            }
            this.setStatus("backup DATA");
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Backup data");
            this.executeDBMCmd1("util_connect");
            this.executeDBMCmd1("backup_save recanceldat DATA");
            this.executeDBMCmd1("util_release");
            this.setStatus("Multi Users on DB");
            TestDatabase mTestDatabase = RecoveryCancel.getDatabase();
            TestDatabaseSap sapdb = null;
            if (mTestDatabase.isSap()) {
                sapdb = (TestDatabaseSap)mTestDatabase;
            }
            if (TestDriver.compareRelease((String)(sapdb.getKernelVersion() + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.6.0.15")) {
                queueCountChangerThread = new QueueCountChanger();
                this.startingMultipleThreads(mStartDistance);
                if (queueCountChangerThread.isAlive()) {
                    queueCountChangerThread.pleaseStop();
                    Thread.sleep(5000L);
                    if (queueCountChangerThread.isAlive()) {
                        queueCountChangerThread.pleaseStop();
                        Thread.sleep(5000L);
                        if (queueCountChangerThread.isAlive()) {
                            queueCountChangerThread.pleaseStop();
                            Thread.sleep(5000L);
                            if (queueCountChangerThread.isAlive()) {
                                queueCountChangerThread.pleaseStop();
                                Thread.sleep(5000L);
                                if (queueCountChangerThread.isAlive()) {
                                    queueCountChangerThread.pleaseStop();
                                    Thread.sleep(5000L);
                                    if (queueCountChangerThread.isAlive()) {
                                        queueCountChangerThread.pleaseStop();
                                        Thread.sleep(5000L);
                                        if (queueCountChangerThread.isAlive()) {
                                            queueCountChangerThread.pleaseStop();
                                            Thread.sleep(5000L);
                                            if (queueCountChangerThread.isAlive()) {
                                                queueCountChangerThread.pleaseStop();
                                                Thread.sleep(5000L);
                                                if (queueCountChangerThread.isAlive()) {
                                                    queueCountChangerThread.pleaseStop();
                                                    Thread.sleep(5000L);
                                                    if (queueCountChangerThread.isAlive()) {
                                                        queueCountChangerThread.pleaseStop();
                                                        Thread.sleep(5000L);
                                                        if (queueCountChangerThread.isAlive()) {
                                                            queueCountChangerThread.pleaseStop();
                                                            Thread.sleep(5000L);
                                                            if (queueCountChangerThread.isAlive()) {
                                                                queueCountChangerThread.pleaseStop();
                                                                Thread.sleep(5000L);
                                                                if (queueCountChangerThread.isAlive()) {
                                                                    queueCountChangerThread.pleaseStop();
                                                                    Thread.sleep(5000L);
                                                                    if (queueCountChangerThread.isAlive()) {
                                                                        queueCountChangerThread.pleaseStop();
                                                                        Thread.sleep(5000L);
                                                                        queueCountChangerThread.interrupt();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                this.startingMultipleThreads(mStartDistance);
            }
            if (this.globalError) {
                throw new TestCaseException("An global error is occured.\nDescription: " + this.globalErrorText);
            }
            this.executeDBMCmd1("util_connect");
            this.executeDBMCmd1("autosave_off");
            this.executeDBMCmd1("backup_start recancelauto");
            this.executeDBMCmd1("autosave_on");
            this.executeDBMCmd1("util_release");
            long[] check_1 = new long[mNumberOfWriters];
            long[] keyCheck_1 = new long[mNumberOfWriters];
            for (int i3 = 0; i3 < mNumberOfWriters; ++i3) {
                check_1[i3] = this.getChecksum(i3);
                keyCheck_1[i3] = this.getKeyChecksum(i3);
            }
            this.setStatus("Restart Database");
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Restart with init-config and backup_restore");
            this.executeDBMCmd1("autosave_off");
            this.executeDBMCmd1("db_offline");
            this.executeDBMCmd1("db_cold -" + this.mKernelMode);
            this.executeDBMCmd1("util_connect");
            this.executeDBMCmd1("backup_start recancelauto");
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "db_activate RECOVER recanceldat DATA");
            String actualCommand = "";
            if (TestDriver.compareRelease((String)(sapdb.getKernelVersion() + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.4.1")) {
                actualCommand = "db_activate RECOVER recanceldat DATA";
                this.executeDBMCmd1(actualCommand);
            } else {
                actualCommand = "util_execute INIT CONFIG";
                this.executeDBMCmd1(actualCommand);
                actualCommand = "backup_restore recanceldat DATA";
                this.executeDBMCmd1(actualCommand);
            }
            if (mTraceLevel > 0) {
                System.out.println("Result from backup_history_list (short): " + this.executeDBMCmd1("backup_history_list -r last -c LABEL"));
            }
            int NumberOfLogSegments = 0;
            NumberOfLogSegments = this.getNumberOfLogSegments();
            if (mTraceLevel > 0) {
                System.out.println("Number of LogSegments: " + NumberOfLogSegments);
            }
            converterVersionStart = this.getConverterVersion();
            killing = false;
            noFullRecovery = true;
            boolean firstTime = true;
            int usedLogPageForException = 0;
            recoveryAborted = 0;
            this.startingKillerThread();
            if (NumberOfLogSegments > 0) {
                while (noFullRecovery) {
                    try {
                        for (i = 1; i <= NumberOfLogSegments; ++i) {
                            if (mNumberOfKillers == 1 && !killing) {
                                if (firstTime) {
                                    if (NumberOfLogSegments > 1) {
                                        i = 2;
                                    }
                                    firstTime = false;
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_start recancelauto 001");
                                    this.executeDBMCmd1("recover_start recancelauto 001");
                                    recoveryAborted = 0;
                                }
                                if (NumberOfLogSegments > 1) {
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_replace recancelauto " + this.getRecoveryString(i).trim());
                                    this.executeDBMCmd1("recover_replace recancelauto recancelauto " + this.getRecoveryString(i).trim());
                                    recoveryAborted = 0;
                                }
                            }
                            if (mNumberOfKillers == 1 && killing) {
                                boolean loop = true;
                                do {
                                    try {
                                        this.executeDBMCmd1("util_connect");
                                        loop = false;
                                    }
                                    catch (Exception e) {
                                        if (e.toString().indexOf("-24992") != -1) continue;
                                        loop = false;
                                    }
                                } while (loop);
                                int usedLogPage = this.getUsedLogPage();
                                usedLogPageForException = i = this.getLogSegmentForRecovery(usedLogPage);
                                RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_start " + this.getRecoveryString(i).trim());
                                this.executeDBMCmd1("recover_start recancelauto " + this.getRecoveryString(i).trim());
                                recoveryAborted = 0;
                                killing = false;
                            }
                            if (mNumberOfKillers == 0) {
                                if (i == 1) {
                                    if (NumberOfLogSegments > 1) {
                                        i = 2;
                                    }
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_start recancelauto 001");
                                    this.executeDBMCmd1("recover_start recancelauto 001");
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_cancel");
                                    this.executeDBMCmd1("recover_cancel");
                                    this.pause("OFFLINE");
                                    this.executeDBMCmd1("db_cold -" + this.mKernelMode);
                                    this.pause("ADMIN");
                                    if (mTraceLevel > 0) {
                                        System.out.println("Result from db_restartinfo: " + this.executeDBMCmd1("db_restartinfo"));
                                    }
                                    this.executeDBMCmd1("util_connect");
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_start recancelauto 001");
                                    String rtcd = this.executeDBMCmd1("recover_start recancelauto 001");
                                    if (mTraceLevel > 0) {
                                        System.out.println(rtcd);
                                    }
                                }
                                if (NumberOfLogSegments > 1) {
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_replace recancelauto " + this.getRecoveryString(i).trim());
                                    this.executeDBMCmd1("recover_replace recancelauto recancelauto " + this.getRecoveryString(i).trim());
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_cancel");
                                    this.executeDBMCmd1("recover_cancel");
                                    this.pause("OFFLINE");
                                    this.executeDBMCmd1("db_cold -" + this.mKernelMode);
                                    this.pause("ADMIN");
                                    if (mTraceLevel > 0) {
                                        System.out.println("Result from db_restartinfo: " + this.executeDBMCmd1("db_restartinfo"));
                                    }
                                    this.executeDBMCmd1("util_connect");
                                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_start " + this.getRecoveryString(i).trim());
                                    this.executeDBMCmd1("recover_start recancelauto " + this.getRecoveryString(i).trim());
                                }
                            }
                            if (i != NumberOfLogSegments) continue;
                            noFullRecovery = false;
                            if (mTraceLevel > 0) {
                                System.out.println("***ENDE***");
                            }
                            for (int j = 0; j < mNumberOfKillers; ++j) {
                                if (KillerSet[j] != null) {
                                    KillerSet[j].pleaseStop();
                                    Thread.sleep(3000L);
                                    KillerSet[j].interrupt();
                                }
                                if (mTraceLevel <= 0) continue;
                                System.out.println("asked to stop killer: j = " + j + " Status: " + KillerSet[j].isAlive() + "\n");
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (mTypeOfKilling.equals("db_stop") && !killing) {
                            if (++recoveryAborted >= 4) {
                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                            }
                            while (!killing) {
                                Thread.sleep(1L);
                            }
                        }
                        if (mTypeOfKilling.equals("cancel") && !killing) {
                            if (++recoveryAborted >= 4) {
                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                            }
                            while (!killing) {
                                Thread.sleep(1L);
                            }
                        }
                        if (mTypeOfKilling.equals("db_stop") && killing) {
                            if (++recoveryAborted >= 4) {
                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                            }
                            if (mTraceLevel > 0) {
                                System.out.println("DB_STOP Exception");
                            }
                            this.pause("OFFLINE");
                            if (mTraceLevel > 0) {
                                System.out.println("db_cold -" + this.mKernelMode);
                            }
                            this.executeDBMCmd1("db_cold -" + this.mKernelMode);
                            this.pause("ADMIN");
                        }
                        if (mTypeOfKilling.equals("cancel") && killing) {
                            if (++recoveryAborted >= 4) {
                                throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                            }
                            if (ex.toString().indexOf("-24992") != -1) {
                                this.executeDBMCmd1("util_connect");
                                this.executeDBMCmd1("recover_start recancelauto " + this.getRecoveryString(usedLogPageForException).trim());
                                killing = false;
                            }
                            if (mTraceLevel > 0) {
                                System.out.println("CANCEL Exception");
                            }
                            this.pause("OFFLINE");
                            if (mTraceLevel > 0) {
                                System.out.println("db_cold -" + this.mKernelMode);
                            }
                            this.executeDBMCmd1("db_cold -" + this.mKernelMode);
                            this.pause("ADMIN");
                        }
                        if (mNumberOfKillers != 0) continue;
                        noFullRecovery = false;
                        if (mTraceLevel <= 0) continue;
                        System.out.println("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                    }
                }
            }
            Thread.sleep(2000L);
            this.executeDBMCmd1("recover_ignore");
            this.executeDBMCmd1("util_release");
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "recover_replace recancelauto 00* done");
            if (mTraceLevel > 0) {
                System.out.println("State: '" + this.executeDBMCmd1("db_state").substring(6).trim() + "'");
            }
            for (i = 0; i < mNumberOfWriters; ++i) {
                this.prReconnect(i + 1);
            }
            this.setStatus("createContainer");
            long[] check_2 = new long[mNumberOfWriters];
            long[] keyCheck_2 = new long[mNumberOfWriters];
            for (int i4 = 0; i4 < mNumberOfWriters; ++i4) {
                this.createContainer(i4);
                check_2[i4] = this.getChecksum(i4);
                keyCheck_2[i4] = this.getKeyChecksum(i4);
            }
            for (int user = 0; user < mNumberOfWriters; ++user) {
                if (check_1[user] == check_2[user] && keyCheck_1[user] == keyCheck_2[user]) {
                    if (mTraceLevel <= 0) continue;
                    System.out.println("***Writer_" + user + ": Recovery was successful***");
                    continue;
                }
                this.addMessage(RecoveryCancel.getTestClassId(), 'E', "**Writer_" + user + ": Recovery FAILED***");
                if (mTraceLevel <= 0) continue;
                System.out.println("***Writer_" + user + ": Recovery FAILED***");
            }
            Object var13_21 = null;
            RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Closing all opened dbm server connections!");
            if (this.mDBMan != null) {
                try {
                    this.mDBMan.release();
                }
                catch (RTEException rte2222) {
                    // empty catch block
                }
                this.mDBMan = null;
            }
            if (this.mDBMan2 != null) {
                try {
                    this.mDBMan2.release();
                }
                catch (RTEException rte2222) {
                    // empty catch block
                }
                this.mDBMan2 = null;
            }
            if (this.mDBMan3 == null) break block96;
            try {
                this.mDBMan3.release();
            }
            catch (RTEException rte2222) {
                // empty catch block
            }
            this.mDBMan3 = null;
            {
                break block96;
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var13_22 = null;
                    RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Closing all opened dbm server connections!");
                    if (this.mDBMan != null) {
                        try {
                            this.mDBMan.release();
                        }
                        catch (RTEException rte2222) {
                            // empty catch block
                        }
                        this.mDBMan = null;
                    }
                    if (this.mDBMan2 != null) {
                        try {
                            this.mDBMan2.release();
                        }
                        catch (RTEException rte2222) {
                            // empty catch block
                        }
                        this.mDBMan2 = null;
                    }
                    if (this.mDBMan3 == null) break block96;
                    try {
                        this.mDBMan3.release();
                    }
                    catch (RTEException rte2222) {
                        // empty catch block
                    }
                    this.mDBMan3 = null;
                }
            }
            catch (Throwable throwable) {
                Object var13_23 = null;
                RecoveryCancel.printInfo(2, RecoveryCancel.getTestClassId(), "Closing all opened dbm server connections!");
                if (this.mDBMan != null) {
                    try {
                        this.mDBMan.release();
                    }
                    catch (RTEException rte2222) {
                        // empty catch block
                    }
                    this.mDBMan = null;
                }
                if (this.mDBMan2 != null) {
                    try {
                        this.mDBMan2.release();
                    }
                    catch (RTEException rte2222) {
                        // empty catch block
                    }
                    this.mDBMan2 = null;
                }
                if (this.mDBMan3 != null) {
                    try {
                        this.mDBMan3.release();
                    }
                    catch (RTEException rte2222) {
                        // empty catch block
                    }
                    this.mDBMan3 = null;
                }
                throw throwable;
            }
        }
    }

    public String executeDBMCmd3(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = RecoveryCancel.getDatabase().getHost();
            mName = RecoveryCancel.getDatabase().getName();
            int mPort = RecoveryCancel.getDatabase().getPort();
            if (this.mDBMan3 == null) {
                this.mDBMan3 = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan3.cmd(logon);
            }
            return this.mDBMan3.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan3 != null) {
                try {
                    this.mDBMan3.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan3 = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    static {
        mRandomGenerator = new Random();
        converterVersionNew = -1;
        testIsInterrupted = false;
    }

    class QueueCountChanger
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameR = "QueueCntChanger ";

        QueueCountChanger() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + " constucted!");
            }
            this.start();
            RecoveryCancel.printInfo(5, RecoveryCancel.getTestClassId(), this.nameR + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("in check");
            }
        }

        public void run() {
            int queueCount = 1;
            try {
                String sMaxCPU = RecoveryCancel.this.executeDBMCmd3("param_directget MAXCPU");
                sMaxCPU = sMaxCPU.substring(7, 8);
                int iMaxCPU = RecoveryCancel.this.string2number(sMaxCPU);
                while (this.keepRunning && !testIsInterrupted) {
                    Thread.sleep(500L);
                    String theCurrentDBState = RecoveryCancel.this.executeDBMCmd3("db_state").substring(6).trim().toUpperCase();
                    if (!theCurrentDBState.equals("ONLINE") && !theCurrentDBState.equals("WARM")) continue;
                    RecoveryCancel.this.executeDBMCmd3("param_put -running -permanent LOG_QUEUE_COUNT " + queueCount);
                    if (++queueCount <= iMaxCPU) continue;
                    queueCount = 0;
                }
                RecoveryCancel.printInfo(5, RecoveryCancel.getTestClassId(), "Exiting QueueCountChanger");
                if (testIsInterrupted) {
                    System.out.println("QueueCountChanger interrupted by main test in run() - method.");
                }
                if (mTraceLevel > 0) {
                    System.out.println("QueueCountChanger stopped");
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("+++++++++++++++++++++Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                RecoveryCancel.addGlobalMessage((String)RecoveryCancel.getTestClassId(), (char)'E', (String)("QueueCountChanger caught an exception and stopped.\nMessage: " + e.getMessage()));
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + ": Asking thread 'QueueCountChanger' to please stop!");
            }
            RecoveryCancel.printInfo(5, RecoveryCancel.getTestClassId(), this.nameR + " please stop!");
            this.keepRunning = false;
        }
    }

    class Killer
    extends TestActor {
        boolean keepRunning = true;
        String nameR;
        int numberR;
        int tmpConVers;

        Killer(int killerNo) {
            this.nameR = "Killer " + killerNo;
            this.numberR = killerNo;
            this.tmpConVers = 0;
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + " constucted!");
            }
            this.start();
            RecoveryCancel.printInfo(5, RecoveryCancel.getTestClassId(), this.nameR + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("in check");
            }
        }

        public void run() {
            try {
                while (this.keepRunning && !testIsInterrupted) {
                    Killer.sleep(2000L);
                    if (!noFullRecovery) {
                        this.keepRunning = false;
                    }
                    if (!killing) {
                        this.tmpConVers = RecoveryCancel.this.getConverterVersion();
                    }
                    if (this.tmpConVers <= converterVersionStart) continue;
                    this.executeKillingOps(this.numberR);
                    this.keepRunning = true;
                    converterVersionStart = this.tmpConVers;
                }
                if (testIsInterrupted) {
                    System.out.println("Killer interrupted by main test in run() - method.");
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                RecoveryCancel.this.handleException(e);
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + ": Asking thread to please stop!");
            }
            this.keepRunning = false;
        }

        private void executeKillingOps(int user) throws TestCaseException {
            block11: {
                try {
                    while (this.keepRunning && !testIsInterrupted) {
                        if (mTypeOfKilling.equals("db_stop")) {
                            RecoveryCancel.this.executeDBMCmd_2("db_stop");
                            if (mTraceLevel > 0) {
                                System.out.println("DB_STOP by Killer");
                            }
                            killing = true;
                            if (mTraceLevel > 0) {
                                System.out.println("killing: " + killing);
                            }
                        } else if (mTypeOfKilling.equals("cancel")) {
                            RecoveryCancel.this.executeDBMCmd_2("db_cons cancel t4");
                            if (mTraceLevel > 0) {
                                System.out.println("Cancel by Killer");
                            }
                            Killer.sleep(1000L);
                            killing = true;
                            if (mTraceLevel > 0) {
                                System.out.println("killing: " + killing);
                            }
                        }
                        this.keepRunning = false;
                    }
                    if (testIsInterrupted) {
                        System.out.println("Killer interrupted by main test in executeKillingOps(" + user + ").");
                    }
                }
                catch (Exception e) {
                    if (mTraceLevel <= 0) break block11;
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
            }
        }
    }

    class Writer
    extends TestActor {
        boolean keepRunning = true;
        String nameW;
        int numberW;
        int connectionW;

        Writer(int writerNo, int conNo) {
            this.nameW = "Writer" + writerNo;
            this.numberW = writerNo;
            this.connectionW = conNo;
            this.start();
            RecoveryCancel.printInfo(5, RecoveryCancel.getTestClassId(), this.nameW + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("does not check anything yet");
            }
        }

        public void run() {
            try {
                while (this.keepRunning && !RecoveryCancel.this.globalError) {
                    this.executeWritingOps(this.numberW);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                RecoveryCancel.this.handleException(e);
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameW + ": Asking thread '" + this.nameW + "' to please stop!");
            }
            this.keepRunning = false;
        }

        private void executeWritingOps(int user) throws TestCaseException {
            int CurrentCycle = 0;
            this.mRunning = true;
            int objLength1 = 1000;
            int objLength2 = 2000;
            int objLength3 = 3000;
            Oid oid = new Oid();
            Oid oidKey = new Oid();
            try {
                while (this.keepRunning && !RecoveryCancel.this.globalError) {
                    if (CurrentCycle % 200 == 0 && mTraceLevel > 0) {
                        System.out.println(this.nameW + " - CurrentCycle:" + CurrentCycle);
                    }
                    oid = null;
                    oid = RecoveryCancel.this.prCreateMyvarobj(user + 1, "testteam", user, objLength1, 0);
                    if (oid == null) {
                        RecoveryCancel.this.globalError = true;
                        RecoveryCancel.this.globalErrorText = "The creation of an object fails, there is something wrong with the database; please look into knldiag and test protocol.";
                    }
                    RecoveryCancel.this.Oids[user].add(oid);
                    RecoveryCancel.this.prReadMyvarobj(user + 1, "testteam", user, oid, 0);
                    RecoveryCancel.this.prUpdateMyvarobj(user + 1, "testteam", user, oid, objLength2, 0);
                    RecoveryCancel.this.prReadMyvarobj(user + 1, "testteam", user, oid, 0);
                    if (mLongTransactions && RecoveryCancel.randomInteger(0, 100) < 5) {
                        RecoveryCancel.this.prCreateAndUpdateTable(user + 1, RecoveryCancel.randomInteger(800, 1200));
                    }
                    RecoveryCancel.this.prUpdateMyvarobj(user + 1, "testteam", user, oid, objLength3, 0);
                    RecoveryCancel.this.prReadMyvarobj(user + 1, "testteam", user, oid, 0);
                    if (CurrentCycle > mNumberOfWriters) {
                        RecoveryCancel.this.prCreateContainer(user + 1, 1, "testteam", CurrentCycle, 0);
                    }
                    RecoveryCancel.this.prCommit(user + 1);
                    int Key = RecoveryCancel.this.getNextKey();
                    RecoveryCancel.this.prCreateObject(user + 1, Key, Key + 1);
                    RecoveryCancel.this.prCommit(user + 1);
                    oidKey = null;
                    oidKey = RecoveryCancel.this.prGetOid(user + 1, Key);
                    RecoveryCancel.this.keyOids[user].add(oidKey);
                    if (oidKey == null) {
                        RecoveryCancel.this.globalError = true;
                        RecoveryCancel.this.globalErrorText = "The creation of a keyed object fails, there is something wrong with the database; please look into knldiag and test protocol.";
                    }
                    Writer.sleep(25L);
                    if (mNoOfCycles != -1 && ++CurrentCycle > mNoOfCycles) {
                        if (mTraceLevel > 0) {
                            System.out.println(this.nameW + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        }
                        this.keepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    if (mTraceLevel > 0) {
                        System.out.println(this.nameW + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                    }
                    this.keepRunning = false;
                    this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                }
            }
            catch (InterruptedException e) {
                if (mTraceLevel > 0) {
                    System.out.println(this.nameW + ": Hard interrupted");
                }
                this.setStatus(2);
                RecoveryCancel.this.globalError = true;
                RecoveryCancel.this.globalErrorText = this.nameW + ": hard interrupted -> " + e.getMessage();
            }
            catch (Exception e) {
                RecoveryCancel.this.globalError = true;
                if (mTraceLevel > 0) {
                    System.out.println(this.nameW + ": ** ERROR **  General exception: " + e.getMessage());
                }
                this.setStatus(-3, "Exception: " + e.getMessage());
                RecoveryCancel.this.globalErrorText = "During executeWritingOps an general exception occured for " + this.nameW + "; please look into knldiag and test protocol.";
            }
        }
    }
}

