/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class PrimaryException
extends PrimaryTest {
    private int xConsCounter = 0;

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + PrimaryException.getTestClassId());
    }

    public static String getTestClassId() {
        return "PrimaryException";
    }

    public static void prepare() throws TestCaseException {
        PrimaryTest.prepare();
        System.out.println("Start of " + PrimaryException.getTestClassId());
        System.out.println(" Crash the kernel and check the knldiag...");
    }

    public void callXCons() {
        ++this.xConsCounter;
        try {
            String dbState = ((TestDatabaseSap)PrimaryException.getDatabase()).executeDBMcmd("db_state");
            String dbHost = PrimaryException.getDatabase().getHost();
            if (dbHost.equals("localhost")) {
                String dbName = PrimaryException.getDatabase().getName();
                String cmd = "x_cons " + dbName + " show all";
                StringBuffer sb = new StringBuffer(500000);
                Execute exc = new Execute(cmd, new String[]{"SAPDB_NO_INDEPPATH=y"}, sb);
                exc.enableWritingStdout(true);
                exc.setErrPrefix("STDERR ");
                exc.ignoreBufferLimitForStdOut(true);
                exc.exec();
                int exitValue = exc.getExitValue();
                if (exitValue != 0) {
                    if (exitValue == 1 && System.getProperty("os.name").equals("HP-UX") && sb.toString().indexOf("Failed to map memory dump files") != -1) {
                        this.addMessage(PrimaryException.getTestClassId(), 'W', cmd + "\nThe database state (dbmsrv call: db_state) was: '" + dbState + "'.\nExit value of the " + this.xConsCounter + ". x_cons call is: " + exitValue + "\nSize of the Stringbuffer in bytes is: " + sb.length() + "\nOutput is written to disk: " + this.getDataOutputPath() + "\n\nNo error because it is a HP-UX machine and this error of the x_cons call is not critcial.");
                    } else {
                        this.addMessage(PrimaryException.getTestClassId(), 'E', cmd + "\nThe database state (dbmsrv call: db_state) was: '" + dbState + "'.\nExit value of the " + this.xConsCounter + ". x_cons call is: " + exitValue + "\nSize of the Stringbuffer in bytes is: " + sb.length() + "\nOutput is written to disk: " + this.getDataOutputPath());
                    }
                } else {
                    this.addMessage(PrimaryException.getTestClassId(), 'I', "\nThe database state (dbmsrv call: db_state) was: '" + dbState + "'.\n" + this.xConsCounter + ". 'x_cons " + dbName + " show all' worked fine! Exit value of '" + cmd + "' was: " + exitValue);
                }
                try {
                    File xconsOutFile = new File(this.getDataOutputPath() + System.getProperty("file.separator") + "xconsShowAll_PE_" + this.xConsCounter + ".prt");
                    if (xconsOutFile.exists()) {
                        xconsOutFile.delete();
                    }
                    FileWriter xconsOutFileW = new FileWriter(xconsOutFile);
                    xconsOutFileW.write("The database state (dbmsrv call: db_state) was: '" + dbState + "'.\n");
                    xconsOutFileW.write("The errorcode of the command " + this.xConsCounter + ". 'x_cons " + dbName + " show all' was: " + exitValue + "\n\nThe content was:\n\n");
                    xconsOutFileW.write(sb.toString());
                    xconsOutFileW.close();
                }
                catch (IOException ioe) {
                    this.addMessage(PrimaryException.getTestClassId(), 'W', "Can not write the " + this.xConsCounter + ". 'x_cons " + dbName + " show all' output to a seperate file. \nReason: " + ioe.getLocalizedMessage());
                }
            }
        }
        catch (Exception e2) {
            System.out.println("Message: " + e2.getLocalizedMessage());
            e2.printStackTrace();
        }
    }

    public void run() {
        TestDatabaseSap myDB = (TestDatabaseSap)PrimaryException.getDatabase();
        String knldiag = "";
        String suppressCore = null;
        try {
            if (System.getProperty("os.name").indexOf("Windows") == -1) {
                suppressCore = PrimaryException.getDatabase().executeDBMcmd("param_getvalue SUPPRESS_CORE").trim();
                System.out.println(" Database parameter SUPPRESS_CORE: " + suppressCore);
            }
            if (suppressCore != null && suppressCore.equalsIgnoreCase("NO")) {
                this.addMessage(PrimaryException.getTestClassId(), 'W', "The kernel parameter SUPPRESS_CORE is set to NO, so that the crash of the kernel will not produce a readable stack back trace.");
            } else {
                this.callXCons();
                this.callXCons();
                Connection con = this.getConnection(1);
                CallableStatement stmt = con.prepareCall("CALL THROW_EXCEPTION");
                stmt.execute();
                this.addMessage(PrimaryException.getTestClassId(), 'E', "The kernel is still alive. No stackback trace is written.");
            }
        }
        catch (Exception e) {
            this.addMessage(PrimaryException.getTestClassId(), 'I', "Kernel crashed. Good. Call x_cons and check the stackback trace...\n" + e.getMessage());
            try {
                this.callXCons();
                knldiag = myDB.getDatabaseProtocolViaDBMKey("KNLDIAG");
                int lineCounter = 0;
                int excexcp = 0;
                int corehand = 0;
                int emstbt = 0;
                int symsear = 0;
                int regdump = 0;
                int modlist = 0;
                int stbktrc = 0;
                int systbatr = 0;
                int warncounter = 0;
                int notInAnyLoadedRegionCnt = 0;
                StringBuffer sb = new StringBuffer();
                sb.append("knldiag analysis summary:\n\n");
                String aRow = null;
                StringTokenizer sti = new StringTokenizer(knldiag, "\n");
                while (sti.hasMoreTokens()) {
                    aRow = sti.nextToken();
                    ++lineCounter;
                    if (aRow.indexOf("EXCEPT") != -1 && aRow.indexOf(" EXCEPTION") != -1) {
                        sb.append("\tfound EXCEPT and EXCEPTION \t\t\tin line " + lineCounter + "\n");
                        excexcp = lineCounter;
                    }
                    if (aRow.indexOf("COREHAND") != -1 && aRow.indexOf("ABORTING") != -1) {
                        sb.append("\tfound COREHAND and ABORTING \t\t\tin line " + lineCounter + "\n");
                        corehand = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") != -1 && aRow.indexOf("Emergency Stack Back Trace") != -1) {
                        sb.append("\tfound BTRACE and 'Emergency Stack Back Trace' \tin line " + lineCounter + "\n");
                        emstbt = lineCounter;
                    }
                    if (aRow.indexOf("MsgOutp") != -1 && aRow.indexOf("Emergency Stack Back Trace") != -1) {
                        sb.append("\tfound MsgOutp and 'Emergency Stack Back Trace' \tin line " + lineCounter + "\n");
                        emstbt = lineCounter;
                    }
                    if (aRow.indexOf("RTEKERN") != -1 && aRow.indexOf("Emergency Stack Back Trace") != -1) {
                        sb.append("\tfound RTEKERN and 'Emergency Stack Back Trace' \tin line " + lineCounter + "\n");
                        emstbt = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") != -1 && aRow.indexOf("Symbolic Stack Back Trace") != -1) {
                        sb.append("\tfound BTRACE and 'Symbolic Stack Back Trace' \tin line " + lineCounter + "\n");
                        systbatr = lineCounter;
                    }
                    if (aRow.indexOf("MsgOutp") != -1 && aRow.indexOf("Symbolic Stack Back Trace") != -1) {
                        sb.append("\tfound MsgOutp and 'Symbolic Stack Back Trace' \tin line " + lineCounter + "\n");
                        systbatr = lineCounter;
                    }
                    if (aRow.indexOf("RTEKERN") != -1 && aRow.indexOf("Symbolic Stack Back Trace") != -1) {
                        sb.append("\tfound RTEKERN and 'Symbolic Stack Back Trace' \tin line " + lineCounter + "\n");
                        systbatr = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") != -1 && aRow.indexOf("SymbolSearchPath") != -1) {
                        sb.append("\tfound BTRACE and 'SymbolSearchPath' \t\tin line " + lineCounter + "\n");
                        symsear = lineCounter;
                    }
                    if (aRow.indexOf("MsgOutp") != -1 && aRow.indexOf("SymbolSearchPath") != -1) {
                        sb.append("\tfound MsgOutp and 'SymbolSearchPath' \t\tin line " + lineCounter + "\n");
                        symsear = lineCounter;
                    }
                    if (aRow.indexOf("RTEKERN") != -1 && aRow.indexOf("SymbolSearchPath") != -1) {
                        sb.append("\tfound RTEKERN and 'SymbolSearchPath' \t\tin line " + lineCounter + "\n");
                        symsear = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") != -1 && aRow.indexOf("Register Dump") != -1) {
                        sb.append("\tfound BTRACE and 'Register Dump' \t\tin line " + lineCounter + "\n");
                        regdump = lineCounter;
                    }
                    if (aRow.indexOf("MsgOutp") != -1 && aRow.indexOf("Register Dump") != -1) {
                        sb.append("\tfound MsgOutp and 'Register Dump' \t\tin line " + lineCounter + "\n");
                        regdump = lineCounter;
                    }
                    if (aRow.indexOf("RTEKERN") != -1 && aRow.indexOf("Register Dump") != -1) {
                        sb.append("\tfound RTEKERN and 'Register Dump' \t\tin line " + lineCounter + "\n");
                        regdump = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") != -1 && aRow.indexOf("Module List") != -1) {
                        sb.append("\tfound BTRACE and 'Module List' \t\t\tin line " + lineCounter + "\n");
                        modlist = lineCounter;
                    }
                    if (aRow.indexOf("MsgOutp") != -1 && aRow.indexOf("Module List") != -1) {
                        sb.append("\tfound MsgOutp and 'Module List' \t\tin line " + lineCounter + "\n");
                        modlist = lineCounter;
                    }
                    if (aRow.indexOf("RTEKERN") != -1 && aRow.indexOf("Module List") != -1) {
                        sb.append("\tfound RTEKERN and 'Module List' \t\tin line " + lineCounter + "\n");
                        modlist = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") != -1 && aRow.indexOf(" Stack Back Trace ") != -1) {
                        sb.append("\tfound BTRACE and 'Stack Back Trace' \t\tin line " + lineCounter + "\n");
                        stbktrc = lineCounter;
                    }
                    if (aRow.indexOf("MsgOutp") != -1 && aRow.indexOf(" Stack Back Trace ") != -1) {
                        sb.append("\tfound MsgOutp and 'Stack Back Trace' \t\tin line " + lineCounter + "\n");
                        stbktrc = lineCounter;
                    }
                    if (aRow.indexOf("RTEKERN") != -1 && aRow.indexOf(" Stack Back Trace ") != -1) {
                        sb.append("\tfound RTEKERN and 'Stack Back Trace' \t\tin line " + lineCounter + "\n");
                        stbktrc = lineCounter;
                    }
                    if (aRow.indexOf("BTRACE") == -1 && aRow.indexOf("RTEKERN") == -1 && aRow.indexOf("MsgOutp") == -1 || aRow.indexOf("not in any loaded region") == -1) continue;
                    sb.append("\tfound BTRACE and 'not in any loaded region' \t\tin line " + lineCounter + "\n");
                    ++notInAnyLoadedRegionCnt;
                }
                this.addMessage(PrimaryException.getTestClassId(), 'I', "" + sb.toString());
                sb = new StringBuffer();
                if (excexcp == 0 || corehand == 0 || symsear == 0 || regdump == 0 || modlist == 0 || stbktrc == 0) {
                    sb.append("Warning(s) during knldiag analysis\n\n");
                }
                if (excexcp == 0) {
                    sb.append("\tnot found: EXCEPT and EXCEPTION (perhaps unix system)\n");
                    ++warncounter;
                }
                if (corehand == 0) {
                    sb.append("\tnot found: COREHAND and ABORTING (perhaps nt system)\n");
                    ++warncounter;
                }
                if (emstbt == 0) {
                    sb.append("\tnot found: BTRACE/MsgOutp/RTEKERN and 'Emergency Stack Back Trace' (perhaps nt system)\n");
                    ++warncounter;
                }
                if (systbatr == 0) {
                    sb.append("\tnot found: BTRACE/MsgOutp/RTEKERN and 'Symbolic Stack Back Trace' (perhaps nt system)\n");
                    ++warncounter;
                }
                if (symsear == 0) {
                    sb.append("\tnot found: BTRACE/MsgOutp/RTEKERN and 'SymbolSearchPath'\n");
                    ++warncounter;
                }
                if (regdump == 0) {
                    sb.append("\tnot found: BTRACE/MsgOutp/RTEKERN and 'Register Dump'\n");
                    ++warncounter;
                }
                if (modlist == 0) {
                    sb.append("\tnot found: BTRACE/MsgOutp/RTEKERN and 'Module List'\n");
                    ++warncounter;
                }
                if (stbktrc == 0) {
                    sb.append("\tnot found: BTRACE/MsgOutp/RTEKERN and 'Stack Back Trace'\n");
                    ++warncounter;
                }
                if (notInAnyLoadedRegionCnt > 4) {
                    warncounter += notInAnyLoadedRegionCnt;
                    sb.append("\tfound " + notInAnyLoadedRegionCnt + " times: BTRACE/MsgOutp/RTEKERN and 'not in any loaded region' - perhaps stackback trace not correct.\n");
                }
                if (sb.length() > 10) {
                    if (warncounter > 4) {
                        this.addMessage(PrimaryException.getTestClassId(), 'E', "Too many warnings give supposition for \"NO stack back trace\" routine.\n" + sb.toString());
                    } else {
                        this.addMessage(PrimaryException.getTestClassId(), 'I', "" + sb.toString());
                    }
                }
                this.callXCons();
            }
            catch (Exception ex) {
                this.addMessage(PrimaryException.getTestClassId(), 'E', "Something wrong... " + ex.getMessage());
                System.out.println("Something wrong ... " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public String getLogFile() {
        File theZipFile = null;
        try {
            File knldiagFile = new File(this.getDataOutputPath() + File.separator + "knldiag.txt");
            FileWriter fwknl = new FileWriter(knldiagFile);
            String knldiag = ((TestDatabaseSap)PrimaryException.getDatabase()).getDatabaseProtocolViaDBMKey("KNLDIAG");
            fwknl.write(knldiag.substring(0), 0, knldiag.length());
            fwknl.close();
            theZipFile = new File(this.getDataOutputPath() + File.separator + "knldiag_PrimaryException.zip");
            Zipper myZipper = new Zipper(theZipFile);
            myZipper.addFile(knldiagFile);
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage(PrimaryException.getTestClassId(), 'W', "Failed to create a zipfile with the knldiag\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (Exception ex) {
            this.addMessage(PrimaryException.getTestClassId(), 'W', "Failed to get the knldiag\n" + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        return theZipFile.getAbsolutePath();
    }
}

