/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.PrimaryTest;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class PrimaryCriticalSection
extends PrimaryTest {
    public static void cleanUp() throws TestCaseException {
        PrimaryTest.cleanUp();
    }

    public static void prepare() throws TestCaseException {
        PrimaryTest.prepare();
    }

    public void run() {
        try {
            TestDatabaseSap thisDB = (TestDatabaseSap)PrimaryCriticalSection.getDatabase();
            if (thisDB.getKernelVersion() == null || thisDB.getKernelBuild() == null) {
                PrimaryCriticalSection.addGlobalMessage((String)"Check database version", (char)'E', (String)("ERROR!\nCan not read database version or build.\nVersion: " + thisDB.getKernelVersion() + "\nBuild: " + thisDB.getKernelBuild()));
                return;
            }
            int noOfAllowedRegions = new Integer(thisDB.getParameter("_OMS_REGIONS"));
            PrimaryCriticalSection.addGlobalMessage((String)"prMaxCriticalSections", (char)'I', (String)("Kernel parameter setting: _OMS_REGIONS = " + noOfAllowedRegions));
            this.prMaxCriticalSections(1, noOfAllowedRegions, 0);
            int tooManyRegions = noOfAllowedRegions + 1;
            PrimaryCriticalSection.addGlobalMessage((String)"prMaxCriticalSections", (char)'I', (String)("Using more than allowed _OMS_REGIONS = " + tooManyRegions));
            if (TestDriver.compareRelease((String)(thisDB.getKernelVersion() + "." + thisDB.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.5.0.7")) {
                this.prMaxCriticalSections(1, tooManyRegions, -28540);
            } else {
                this.prMaxCriticalSections(1, tooManyRegions, -3999);
            }
            PrimaryCriticalSection.addGlobalMessage((String)"PrimaryCriticalSection", (char)'I', (String)"Provoking error -28517: Already in critical section");
            this.prEnterCriticalSection(1, -28517);
            PrimaryCriticalSection.addGlobalMessage((String)"PrimaryCriticalSection", (char)'I', (String)"Provoking error -2851: Not in critical section");
            this.prLeaveCriticalSection(1, -28518);
        }
        catch (SQLException se) {
            PrimaryCriticalSection.addGlobalMessage((String)"PrimaryCriticalSection", (char)'E', (String)("Received an SQL error: " + se.getMessage()));
        }
        catch (Exception e) {
            PrimaryCriticalSection.addGlobalMessage((String)"PrimaryCriticalSection", (char)'E', (String)("Received an error: " + e.getMessage()));
        }
    }
}

