/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;

public class OmsHeap
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.2";
    private static int excCtr = 0;
    private static int m_noOfTasks = 1;
    private static int m_maxTasks;
    private static boolean m_consoleMsg;
    private static boolean m_jdbcTrace;
    private static boolean m_defaultVtrace;
    private static boolean m_objectVtrace;
    private static int m_traceLvl;
    private static int m_trace;
    private static boolean m_runTimeLimit;
    private static int m_maxRunTime;
    private static int m_tasks;
    private static int m_sqlError;
    private static String m_sqlErrorMsg;
    private static volatile boolean m_stop;
    private static volatile boolean m_wait;
    private static String m_ReleaseId;
    private static int m_heapSizePerTask;
    private static int m_heapLimit;
    private static int m_heapThreshold;
    private static int m_versionThreshold;
    private static int m_randomStart;

    public static void abort() {
        m_sqlError = -11111;
        m_sqlErrorMsg = "Test aborted";
    }

    private static void checkLiveCache(Connection con) throws TestCaseException {
        try {
            TestStatement stmt = new TestStatement(null, con, 1005, 1007);
            stmt.executeQuery("select * from dbparameters where value = 'LVC'");
            if (stmt.getResultCounter() != 1) {
                OmsHeap.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)"database instance must be a liveCache");
                throw new TestCaseException("Error during preparation: no liveCache");
            }
        }
        catch (SQLException e) {
            if (-4004 == e.getErrorCode()) {
                OmsHeap.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)"system tables not loaded");
                throw new TestCaseException("Error during preparation: system tables not loaded");
            }
            OmsHeap.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)("SQL error" + e.getErrorCode()));
            throw new TestCaseException("Error during preparation: SQL error " + e.getErrorCode());
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    public static Connection connect() throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", "LCTEST");
        conp.put("password", "LCTEST");
        if (m_jdbcTrace) {
            conp.put("trace", "jdbcTrace.prt");
        }
        Connection con = OmsHeap.getDatabase().connect(conp);
        try {
            con.commit();
            con.setAutoCommit(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    private static void createDBProcedure(Connection con, String DBProcName, String PackageName) throws SQLException {
        OmsHeap.createDBProcedure(con, DBProcName, PackageName, false);
    }

    private static void createDBProcedure(Connection con, String DBProcName, String PackageName, boolean NoWait) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP DBPROC " + DBProcName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        String CallString = "CREATE DBPROC " + DBProcName + " IN " + PackageName + " EXECUTE INPROC";
        if (NoWait) {
            CallString = CallString + " NOWAIT";
        }
        stmt.execute(CallString);
    }

    private static void createDBProcedures(Connection con, String PackageName) throws SQLException {
        OmsHeap.createDBProcedure(con, "HEAP_TEST", PackageName);
        con.commit();
    }

    private static void createLcTestUser(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        try {
            stmt.enableExceptions(false);
            stmt.executeUpdate("DROP USER LCTEST");
            stmt.enableExceptions(true);
            stmt.executeUpdate("CREATE USER LCTEST PASSWORD LCTEST DBA NOT EXCLUSIVE");
        }
        catch (SQLException e) {
            OmsHeap.addGlobalMessage((String)"User creation", (char)'E', (String)"Could not create user LCTEST");
            throw e;
        }
        finally {
            con.commit();
            con.close();
        }
    }

    private static void createPackage(Connection con, String PackageName, String ProgId) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP PACKAGE " + PackageName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        stmt.execute("CREATE PACKAGE " + PackageName + " AS '" + ProgId + "' INPROC");
    }

    private static void createPackageWithFile(Connection con, String PackageName, String ProgId) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP PACKAGE " + PackageName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        stmt.execute("CREATE PACKAGE " + PackageName + " FILE '" + ProgId + "' INPROC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningTasks() {
        OmsHeap omsHeap = this;
        synchronized (omsHeap) {
            --m_tasks;
        }
    }

    private static void enableVtrace(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        if (m_defaultVtrace) {
            stmt.executeUpdate("DIAGNOSE VTRACE DEFAULT ON");
        }
        if (m_objectVtrace) {
            stmt.executeUpdate("DIAGNOSE VTRACE OBJECT ON");
        }
        stmt.close();
    }

    private static void enableWriteTransaction(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        stmt.executeUpdateIgnoreErrors("ENABLE WRITE TRANSACTION");
        stmt.close();
    }

    private static void evalTestSettings() {
    }

    private int evalCpuCount() {
        int CPU = 0;
        String sDevTool = System.getProperty("env.tool");
        if (sDevTool == null) {
            this.Trace_0("Environment variable TOOL not defined.");
            return 1;
        }
        String sFileSep = System.getProperty("file.separator");
        String sCommand = sDevTool + sFileSep + "bin" + sFileSep + "machineInfo";
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        SystemProcess = new Execute(sCommand, null, ProcessOutput);
        SystemProcess.exec();
        StringTokenizer st = new StringTokenizer(ProcessOutput.toString());
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase("PROCESSORS:")) continue;
            CPU = new Integer(st.nextToken().toString());
            break;
        }
        if (CPU == 0) {
            this.Trace_0("Could not read number of CPUs.");
        } else {
            this.Trace_0("CPU's for this System: " + CPU);
        }
        if (CPU > 0) {
            return CPU;
        }
        return 1;
    }

    synchronized int getRunningTasks() {
        return m_tasks;
    }

    public static String getTestClassId() {
        return "OmsHeap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningTask() {
        OmsHeap omsHeap = this;
        synchronized (omsHeap) {
            ++m_tasks;
        }
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSapOnly() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection con = null;
        try {
            try {
                OmsHeap.readParameters();
                String DBAUser = OmsHeap.getDatabase().getDBAUser();
                String DBAPassword = OmsHeap.getDatabase().getDBAPassword();
                TestDatabase database = OmsHeap.getDatabase();
                con = database.connect(DBAUser, DBAPassword);
                OmsHeap.enableVtrace(con);
                OmsHeap.checkLiveCache(con);
                if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                    OmsHeap.enableWriteTransaction(con);
                }
                OmsHeap.createLcTestUser(con);
                OmsHeap.testProlog();
            }
            catch (Exception e) {
                System.out.println("Exception in prepare(): " + e.getMessage());
                e.printStackTrace();
                OmsHeap.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed - see the concole output for more information");
                throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
            }
            Object var5_5 = null;
            if (null == con) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (null == con) throw throwable;
            try {
                con.commit();
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        con.commit();
        con.close();
        return;
    }

    private static void readParameters() {
        System.out.println("->readParameters");
        m_maxRunTime = OmsHeap.getParameterInt((String)"MAX_RUN_TIME", (int)20);
        m_consoleMsg = OmsHeap.getParameterBoolean((String)"CONSOLE_MSG", (boolean)true);
        m_traceLvl = OmsHeap.getParameterInt((String)"TRACE_LVL", (int)1);
        m_trace = OmsHeap.getParameterInt((String)"DBPROC_TRACE_LVL", (int)0);
        m_noOfTasks = OmsHeap.getParameterInt((String)"MAX_TASKS", (int)20);
        m_jdbcTrace = OmsHeap.getParameterBoolean((String)"JDBC_TRACE", (boolean)false);
        m_defaultVtrace = OmsHeap.getParameterBoolean((String)"DEFAULT_VTRACE", (boolean)false);
        m_objectVtrace = OmsHeap.getParameterBoolean((String)"OBJECT_VTRACE", (boolean)false);
        m_heapLimit = OmsHeap.getParameterInt((String)"OMS_HEAP_LIMIT", (int)0);
        m_heapSizePerTask = OmsHeap.getParameterInt((String)"TASK_HEAP_SIZE", (int)300);
        m_randomStart = OmsHeap.getParameterInt((String)"RANDOM_START", (int)0);
        OmsHeap.Trace(m_consoleMsg, "MAX_RUN_TIME         = " + m_maxRunTime + " min");
        OmsHeap.Trace(m_consoleMsg, "MAX_TASKS            = " + m_noOfTasks);
        OmsHeap.Trace(m_consoleMsg, "DEFAULT_VTRACE       = " + m_defaultVtrace);
        OmsHeap.Trace(m_consoleMsg, "OBJECT_VTRACE        = " + m_objectVtrace);
        OmsHeap.Trace(m_consoleMsg, "OMS_HEAP_LIMIT       = " + m_heapLimit + " KB");
        OmsHeap.Trace(m_consoleMsg, "TASK_HEAP_SIZE       = " + m_heapSizePerTask + " KB");
        System.out.println("<-readParameters");
    }

    private static void restartLcTest(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("CALL RESTART");
        call.execute();
        call.close();
    }

    public void run() {
        System.out.println("Running test OmsHeap 1.2");
        OmsHeap.Trace(m_consoleMsg, "Running OmsHeap test, version: 1.2");
        MaxRunTimeTimer RunTimeTimer = new MaxRunTimeTimer(m_maxRunTime);
        this.runRandomTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean runRandomTest() {
        boolean ok;
        block17: {
            Connection con = null;
            ok = true;
            OmsHeap.evalTestSettings();
            this.setLcParameters();
            con = OmsHeap.connect();
            OmsHeap.enableVtrace(con);
            if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                OmsHeap.enableWriteTransaction(con);
            }
            Thread t = Thread.currentThread();
            m_stop = false;
            OmsHeap.Trace(m_consoleMsg, "Start the tasks...");
            Thread.sleep(60000L);
            for (int p = 0; p < m_noOfTasks; ++p) {
                this.startTask(p, p + 1 < m_noOfTasks ? p + 1 : m_maxRunTime * 60);
            }
            while (this.getRunningTasks() > 0) {
                Thread.sleep(1000L);
                if (m_runTimeLimit) {
                    m_stop = true;
                    break;
                }
                if (0 == this.sqlError()) continue;
                ok = false;
                m_stop = true;
                break;
            }
            m_stop = true;
            while (this.getRunningTasks() > 0) {
                Thread.sleep(500L);
            }
            if (0 != this.sqlError()) {
                ok = false;
                this.addMessage("", 'E', "SQL Error in coordinator : " + m_sqlError + " " + m_sqlErrorMsg);
                throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
            }
            Object var6_6 = null;
            this.Trace_1("Max. runtime of " + m_maxRunTime + " exceeded, finishing test.");
            try {
                if (con != null && !con.isClosed()) {
                    con.commit();
                    con.close();
                }
                break block17;
            }
            catch (Exception e2) {}
            break block17;
            {
                catch (Exception e) {
                    ok = false;
                    e.printStackTrace();
                    OmsHeap.abort();
                    this.handleExceptions(e);
                    Object var6_7 = null;
                    this.Trace_1("Max. runtime of " + m_maxRunTime + " exceeded, finishing test.");
                    try {
                        if (con != null && !con.isClosed()) {
                            con.commit();
                            con.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.Trace_1("Max. runtime of " + m_maxRunTime + " exceeded, finishing test.");
                try {
                    if (con != null && !con.isClosed()) {
                        con.commit();
                        con.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ok;
    }

    synchronized void setGlobalSqlError(SQLException e) {
        if (0 == m_sqlError) {
            m_sqlError = e.getErrorCode();
            m_sqlErrorMsg = e.getMessage();
        }
    }

    private void setLcParameters() throws TestDatabaseException {
        try {
            String heapLimit = OmsHeap.getDatabase().executeDBMcmd("param_getvalue OMS_HEAP_LIMIT").trim();
            String heapThreshold = OmsHeap.getDatabase().executeDBMcmd("param_getvalue OMS_HEAP_THRESHOLD").trim();
            String versionThreshold = OmsHeap.getDatabase().executeDBMcmd("param_getvalue OMS_VERS_THRESHOLD").trim();
            if (!heapLimit.equals("" + m_heapLimit) || this.evalCpuCount() > 1) {
                OmsHeap.getDatabase().executeDBMcmd("db_offline");
                OmsHeap.getDatabase().executeDBMcmd("param_startsession");
                OmsHeap.getDatabase().executeDBMcmd("param_put OMS_HEAP_LIMIT " + m_heapLimit);
                OmsHeap.getDatabase().executeDBMcmd("param_put OMS_HEAP_COUNT " + this.evalCpuCount());
                OmsHeap.getDatabase().executeDBMcmd("param_checkall");
                OmsHeap.getDatabase().executeDBMcmd("param_commitsession");
                OmsHeap.getDatabase().executeDBMcmd("db_warm");
            }
        }
        catch (Exception e) {
            throw new TestDatabaseException("Error while setting new LC parameters");
        }
    }

    synchronized int sqlError() {
        return m_sqlError;
    }

    void startGarbageCollectors(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        stmt.executeUpdate("DELETE OBJECT STORAGE");
    }

    private void startTask(int processId, int sleepDuration) throws SQLException, TestDatabaseException {
        this.incRunningTask();
        Task task = new Task(processId, sleepDuration);
    }

    private static void testProlog() throws SQLException, TestDatabaseException {
        Connection con = OmsHeap.connect();
        String Package2 = "LVCTIMEOUTTEST";
        if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
            OmsHeap.createPackageWithFile(con, Package2, "lctest");
        } else {
            OmsHeap.createPackage(con, Package2, "livecache.lctest.test");
        }
        OmsHeap.createDBProcedures(con, Package2);
        Package2 = "SYS_PACKAGE";
        try {
            if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                OmsHeap.createPackageWithFile(con, Package2, "dbpinstall");
            } else {
                OmsHeap.createPackage(con, Package2, "livecache.dbpinstall.V72");
            }
        }
        catch (TestDatabaseException e) {
            throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'liveCache.dbpInstall.V72' ");
        }
        try {
            OmsHeap.createDBProcedure(con, "FORCE_AND_WAIT_FOR_CHECKPOINT", Package2, true);
        }
        catch (SQLException e) {
            OmsHeap.createDBProcedure(con, "FORCE_AND_WAIT_FOR_CHECKPOINT", Package2);
        }
        con.commit();
        con.close();
    }

    private static void Trace(boolean consoleMsg, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        OmsHeap.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private void Trace_0(String msg) {
        if (m_consoleMsg) {
            System.out.println(msg);
        }
        this.addMessage("", 'I', msg);
    }

    private void Trace_1(String msg) {
        if (m_traceLvl >= 1) {
            if (m_consoleMsg) {
                System.out.println(msg);
            }
            this.addMessage("", 'I', msg);
        }
    }

    private void Trace_2(String msg) {
        if (m_traceLvl >= 2) {
            if (m_consoleMsg) {
                System.out.println(msg);
            }
            this.addMessage("", 'E', msg);
        }
    }

    private void TraceError(String msg) {
        if (m_consoleMsg) {
            System.out.println(msg);
        }
        this.addMessage("Error", 'E', msg);
    }

    private static String xgetVersionString() throws TestDatabaseException {
        String KernelVersion = "";
        if (KernelVersion.equals("7.2.4")) {
            return "V72";
        }
        if (KernelVersion.equals("7.2.5")) {
            return "V725";
        }
        if (KernelVersion.equals("7.4")) {
            return "V74";
        }
        if (KernelVersion.equals("8.0")) {
            return "V80";
        }
        throw new TestDatabaseException("SAP DB version " + KernelVersion + " currently not supported for liveCache tests.");
    }

    static {
        m_jdbcTrace = false;
        m_defaultVtrace = false;
        m_objectVtrace = false;
        m_traceLvl = 2;
        m_runTimeLimit = false;
        m_maxRunTime = 20;
        m_tasks = 0;
        m_sqlError = 0;
        m_stop = false;
        m_wait = false;
    }

    class Task
    extends LcTest
    implements Runnable {
        Task(int processId, int sleepDuration) throws SQLException, TestDatabaseException {
            Thread t = new Thread(this);
            this.m_processId = processId;
            if (sleepDuration <= 0) {
                sleepDuration = 1;
            }
            this.m_sleep = sleepDuration;
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                OmsHeap.this.Trace_1("Task " + this.m_processId + " : starting task ");
                Thread t = Thread.currentThread();
                this.threadConnect();
                OmsHeap.this.Trace_1("Task " + this.m_processId + " connected");
                PreparedStatement call = null;
                boolean dummy = false;
                int heapSize = m_heapSizePerTask;
                while (!m_stop) {
                    if (null == call) {
                        call = this.m_connection.prepareCall("CALL HEAP_TEST(?, ?)");
                        call.registerOutParameter(1, 4);
                    }
                    call.setInt(1, heapSize);
                    if (m_traceLvl >= 2) {
                        String string = OmsHeap.sVersion;
                        // MONITORENTER : "1.2"
                        excCtr++;
                        // MONITOREXIT : string
                        OmsHeap.this.Trace_2(excCtr + " Task " + this.m_processId + " call heap_test(" + heapSize + ")");
                    }
                    call.execute();
                }
                return;
            }
            catch (SQLException sql_e) {
                this.setSqlError(sql_e);
                return;
            }
            catch (Exception e) {
                this.exceptionHandler(e);
                return;
            }
            finally {
                this.closeConnection();
            }
        }
    }

    class MaxRunTimeTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        MaxRunTimeTimer(int intervall) {
            this.m_intervall = intervall * 60000;
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_runTimeLimit = true;
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    abstract class LcTest {
        Connection m_connection = null;
        int m_processId = -1;
        int m_sleep = 0;
        private String m_currVersion = "DummyVersion";

        LcTest() {
        }

        protected void exceptionHandler(Exception e) {
            OmsHeap.this.TraceError("Unknown exception in task " + this.m_processId + " " + e.getClass() + " " + e.getMessage());
            e.printStackTrace();
            OmsHeap.abort();
        }

        protected void setSqlError(SQLException e) {
            OmsHeap.this.TraceError("SQL Error in Task " + this.m_processId + " : " + e.getErrorCode() + " " + e.getMessage() + " " + e.getSQLState());
            OmsHeap.this.setGlobalSqlError(e);
        }

        protected void closeConnection() {
            try {
                if (null != this.m_connection) {
                    this.m_connection.commit();
                    this.m_connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            OmsHeap.this.Trace_2("Task " + this.m_processId + " : finished");
            OmsHeap.this.decRunningTasks();
        }

        protected boolean sqlExecuteCall(CallableStatement call) throws SQLException {
            boolean ok = true;
            try {
                call.execute();
            }
            catch (SQLException e) {
                ok = false;
                int error = e.getErrorCode();
                throw e;
            }
            return ok;
        }

        protected void threadConnect() throws TestDatabaseException, SQLException {
            try {
                this.m_connection = OmsHeap.connect();
            }
            catch (Exception e) {
                this.exceptionHandler(e);
            }
        }
    }
}

