/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.DirectoryCleaner;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class MultiUserRandom
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "6.5";
    static final String traceFile = "LCTESTJAVA.prt";
    private static int LC_VERSION = 0;
    static final int NO_OF_LOGSEGMENTS = 2000;
    private static String m_testKind = "";
    private static int m_noOfRandomTest = 1;
    private static int m_noOfVerifiers = 1;
    private static int m_noOfUpdaters = 1;
    private static int m_maxLoops;
    private static int m_minLoops;
    private static int m_maxObjects;
    private static int m_maxUpdaters;
    private static int m_maxVerifiers;
    private static int m_probListUsage;
    private static int m_probVarObjUsage;
    private static int m_probCommit;
    private static int m_probVersionUsage;
    private static int m_maxVarObjLength;
    private static int m_maxContainers;
    private static int m_maxVarObjContainers;
    private static int m_dropSchemaDistance;
    private static int m_checkPointDistance;
    private static int m_shutdownDistance;
    private static int m_copyAutosaveDistance;
    private static int m_savepointDistance;
    private static boolean m_dropSchemas;
    private static boolean m_checkPoints;
    private static boolean m_consoleMsg;
    private static boolean m_shutdown;
    private static boolean m_shutdownEvent;
    private static boolean m_crashEvent;
    private static boolean m_jdbcTrace;
    private static boolean m_defaultVtrace;
    private static boolean m_objectVtrace;
    private static int m_traceLvl;
    private static boolean m_crashes;
    private static boolean m_hssCrashes;
    private static int m_crashDistance;
    private static int m_restartDelay;
    private static int m_noOfObjects;
    private static int m_loopCnt;
    private static int m_varObj;
    private static int m_trace;
    private static int m_inproc;
    private static int m_disconnect;
    private static boolean m_useVersions;
    private static int m_list;
    private static int m_maxVarObjLengthCurrent;
    private static int m_containerOffset;
    private static int m_useStreams;
    private static int m_noOfContainers;
    private static int m_noOfVarObjContainers;
    private static boolean m_runTimeLimit;
    private static int m_maxRunTime;
    private static int m_updater;
    private static int m_verifier;
    private static int m_sqlError;
    private static String m_sqlErrorMsg;
    private static boolean m_stop;
    private static boolean m_cold;
    private static int m_delay;
    private static boolean m_delayUpdaters;
    private static int m_breakAtCall;
    private static int m_breakAtLoop;
    private static InterlockedCounter m_errorCounter;
    private static int m_dropSchemaCnt;
    private static String m_ReleaseId;
    private static int m_heapLimit;
    private static int m_heapThreshold;
    private static int m_versionThreshold;
    private static int m_randomStart;
    private static DirectoryCleaner mDirectoryCleaner;
    private static String m_hsNode001;
    private static String m_hsNode002;
    private static String m_actualMasterNode;
    private static String m_actualStandbyNode;
    protected static int mLOG_SEGMENT_SIZE;
    private static boolean m_keepLogSegments;

    public MultiUserRandom() throws SQLException, TestDatabaseException {
        m_errorCounter = new InterlockedCounter();
    }

    public static void abort() {
        m_sqlError = -11111;
        m_sqlErrorMsg = "Test aborted";
    }

    private void callBreakAt(Connection con) {
        try {
            CallableStatement call = con.prepareCall("CALL BREAK_AT (?, ?)");
            call.setInt(1, m_breakAtCall);
            call.setInt(2, m_breakAtLoop);
            this.Trace_1("callBreak(" + m_breakAtCall + ',' + m_breakAtLoop);
            call.execute();
        }
        catch (SQLException e) {
            this.Trace_1("callBreakAt" + e);
        }
    }

    private static void callInit(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("CALL INIT (?)");
        call.setInt(1, m_containerOffset);
        call.execute();
        con.commit();
    }

    public static void callSettings(Connection con, int processNo) throws SQLException {
        CallableStatement call = con.prepareCall("CALL SETTINGS (?,?,?,?,?,?,?,?)");
        short pNo = (short)processNo;
        call.setShort(1, pNo);
        call.setInt(2, m_noOfObjects);
        call.setInt(3, m_varObj);
        call.setInt(4, m_list);
        call.setInt(5, m_maxVarObjLengthCurrent);
        call.setInt(6, m_trace);
        call.setInt(7, m_noOfContainers);
        call.setInt(8, m_noOfVarObjContainers);
        call.execute();
        call.close();
        con.commit();
    }

    private static void checkLiveCache(Connection con) throws TestCaseException {
        try {
            TestStatement stmt = new TestStatement(null, con, 1005, 1007);
            stmt.executeQuery("select * from dbparameters where value = 'LVC'");
            if (stmt.getResultCounter() != 1) {
                MultiUserRandom.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)"database instance must be a liveCache");
                throw new TestCaseException("Error during preparation: no liveCache");
            }
        }
        catch (SQLException e) {
            if (-4004 == e.getErrorCode()) {
                MultiUserRandom.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)"system tables not loaded");
                throw new TestCaseException("Error during preparation: system tables not loaded");
            }
            MultiUserRandom.addGlobalMessage((String)"checkLiveCache", (char)'E', (String)("SQL error" + e.getErrorCode()));
            throw new TestCaseException("Error during preparation: SQL error " + e.getErrorCode());
        }
    }

    private void checkpoint(Connection con) throws SQLException {
        this.Trace_1("checkpoint ...");
        try {
            CallableStatement call = con.prepareCall("CALL FORCE_AND_WAIT_FOR_CHECKPOINT");
            call.execute();
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 500) {
                throw e;
            }
            this.Trace_1("checkpoint not possible due to timeout");
            return;
        }
        this.Trace_1("checkpoint done");
    }

    private static void checkIntegrity(Connection con) throws SQLException {
        CallableStatement call = null;
        int fullVerify = 1;
        call = con.prepareCall("CALL VERIFY (?, ?)");
        call.setInt(1, fullVerify);
        try {
            call.execute();
        }
        catch (Exception e) {
            call.execute();
        }
        System.out.println("data integrity ok after restart");
    }

    public static void cleanUp() throws TestCaseException {
        try {
            if (MultiUserRandom.getDatabase().getHost() == "localhost") {
                mDirectoryCleaner.stop();
            }
        }
        catch (Exception e) {
            MultiUserRandom.addGlobalMessage((String)"Method cleanUp", (char)'E', (String)("cleanUp failed\n" + e.getLocalizedMessage()));
            throw new TestCaseException("Error during cleanup: " + e.getClass() + e.getMessage());
        }
    }

    private static void closeTraceFile(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("CALL CLOSE_TRACE_FILE");
        call.execute();
    }

    public static Connection connect() throws TestDatabaseException {
        Properties conp = new Properties();
        conp.put("user", "LCTEST");
        conp.put("password", "LCTEST");
        conp.put("autocommit", "off");
        conp.put("reconnect", "false");
        if (m_jdbcTrace) {
            conp.put("trace", "jdbcTrace.prt");
        }
        Connection con = MultiUserRandom.getDatabase().connect(conp);
        return con;
    }

    private static void createDBProcedure(Connection con, String DBProcName, String PackageName) throws SQLException {
        MultiUserRandom.createDBProcedure(con, DBProcName, PackageName, false);
    }

    private static void createDBProcedure(Connection con, String DBProcName, String PackageName, boolean NoWait) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP DBPROC " + DBProcName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        String CallString = "CREATE DBPROC " + DBProcName + " IN " + PackageName + " EXECUTE INPROC";
        if (NoWait) {
            CallString = CallString + " NOWAIT";
        }
        stmt.execute(CallString);
    }

    private static void createDBProcedures(Connection con, String PackageName) throws SQLException {
        MultiUserRandom.createDBProcedure(con, "ABORT", PackageName);
        MultiUserRandom.createDBProcedure(con, "CLOSE_TRACE_FILE", PackageName);
        MultiUserRandom.createDBProcedure(con, "CREATE_VERSION", PackageName);
        MultiUserRandom.createDBProcedure(con, "CLOSE_VERSION", PackageName);
        MultiUserRandom.createDBProcedure(con, "DROP_VERSION", PackageName);
        MultiUserRandom.createDBProcedure(con, "DROP_SCHEMA", PackageName);
        MultiUserRandom.createDBProcedure(con, "INIT", PackageName);
        MultiUserRandom.createDBProcedure(con, "EVAL_SPACE_INFO", PackageName);
        MultiUserRandom.createDBProcedure(con, "GET_OID", PackageName);
        MultiUserRandom.createDBProcedure(con, "OPEN_TRACE_FILE", PackageName);
        MultiUserRandom.createDBProcedure(con, "OPEN_VERSION", PackageName);
        MultiUserRandom.createDBProcedure(con, "GET_STATISTICS", PackageName);
        MultiUserRandom.createDBProcedure(con, "GET_PROCESS_NO", PackageName);
        MultiUserRandom.createDBProcedure(con, "PARAM_TEST", PackageName);
        if (0 == m_testKind.compareTo("EXCEPTION")) {
            MultiUserRandom.createDBProcedure(con, "REQUIRE_BAD_ALLOC", PackageName);
        }
        MultiUserRandom.createDBProcedure(con, "RESTART", PackageName);
        MultiUserRandom.createDBProcedure(con, "SETTINGS", PackageName);
        MultiUserRandom.createDBProcedure(con, "STREAMTEST", PackageName);
        MultiUserRandom.createDBProcedure(con, "SYNC_TRACE_FILE", PackageName);
        MultiUserRandom.createDBProcedure(con, "VERIFY", PackageName);
        MultiUserRandom.createDBProcedure(con, "VERIFYTEST", PackageName);
        try {
            MultiUserRandom.createDBProcedure(con, "BREAK_AT", PackageName);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        con.commit();
    }

    private static void createLcTestUser(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        try {
            stmt.enableExceptions(false);
            stmt.executeUpdate("DROP USER LCTEST");
            stmt.enableExceptions(true);
            stmt.executeUpdate("CREATE USER LCTEST PASSWORD LCTEST DBA NOT EXCLUSIVE");
        }
        catch (SQLException e) {
            MultiUserRandom.addGlobalMessage((String)"User creation", (char)'E', (String)"Could not create user LCTEST");
            throw e;
        }
        finally {
            con.commit();
            con.close();
        }
    }

    private static void createPackage(Connection con, String PackageName, String ProgId) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute("DROP PACKAGE " + PackageName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (LC_VERSION >= 744) {
            stmt.execute("CREATE PACKAGE " + PackageName + " FILE '" + ProgId + "'");
        } else {
            stmt.execute("CREATE PACKAGE " + PackageName + " AS '" + ProgId + "' INPROC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningUpdater() {
        MultiUserRandom multiUserRandom = this;
        synchronized (multiUserRandom) {
            --m_updater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decRunningVerifier() {
        MultiUserRandom multiUserRandom = this;
        synchronized (multiUserRandom) {
            --m_verifier;
        }
    }

    void dropSchema(Connection con, int taskId) throws SQLException {
        block5: {
            try {
                this.Trace_1("T" + taskId + " : drop schema ...");
                CallableStatement call = con.prepareCall("CALL DROP_SCHEMA");
                call.execute();
                con.commit();
                this.Trace_1("drop schema (" + ++m_dropSchemaCnt + ") done");
            }
            catch (SQLException e) {
                if (m_crashEvent) break block5;
                if (-51 == e.getErrorCode()) {
                    this.Trace_1("drop schema failed due to lock timeout");
                }
                StringBuffer ProcessOutput = new StringBuffer();
                Execute SystemProcess = null;
                ProcessOutput.setLength(0);
                String tempName = MultiUserRandom.getDatabase().getName();
                String currentCmd = "x_stop " + tempName + " dump";
                this.Trace_1("An error in drop schema occurred.");
                this.Trace_1("Try to stop the database with: " + currentCmd + " for a better analysis.");
                SystemProcess = new Execute(currentCmd, null, ProcessOutput);
                SystemProcess.exec();
                if (SystemProcess.getExitValue() != 0) {
                    this.Trace_1("Error in " + currentCmd + " with ErrorCode: " + SystemProcess.getExitValue());
                } else {
                    this.Trace_1(currentCmd + " -> ok!");
                }
                this.TraceError("drop schema failed with " + e.getErrorCode());
                this.TraceError("Additional: ErrMessage: " + e.getMessage());
                this.TraceError("Additional: SQLState: " + e.getSQLState());
                throw e;
            }
        }
    }

    private static void enableVtrace(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        if (m_defaultVtrace) {
            stmt.executeUpdate("DIAGNOSE VTRACE DEFAULT ON");
        }
        if (m_objectVtrace) {
            stmt.executeUpdate("DIAGNOSE VTRACE OBJECT ON");
        }
        try {
            stmt.executeUpdate("DIAGNOSE VTRACE OBJECT OMS_LOCK ON");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.close();
    }

    private static void enableWriteTransaction(Connection con) {
        try {
            TestStatement stmt = new TestStatement(null, con);
            stmt.executeUpdateIgnoreErrors("ENABLE WRITE TRANSACTION");
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static int evalTaskID(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("select process into ? from transactions t, connectparameters c where c.session = t.session");
        call.registerOutParameter(1, 4);
        call.execute();
        int id = call.getInt(1);
        return id;
    }

    private static void evalTestSettings() {
        int startValue = m_randomStart;
        if (0 == m_randomStart) {
            Random startRandom = new Random();
            startValue = startRandom.nextInt();
        }
        Random r = new Random(startValue);
        if (0 != m_testKind.compareTo("RANDOM")) {
            System.out.println("Single Test");
            m_noOfUpdaters = m_maxUpdaters;
            m_noOfVerifiers = m_maxVerifiers;
            m_loopCnt = m_maxLoops;
            m_noOfObjects = m_maxObjects;
            m_varObj = m_probVarObjUsage > 0 ? 1 : 0;
            m_maxVarObjLengthCurrent = m_maxVarObjLength;
            m_list = m_probListUsage > 0 ? 1 : 0;
            m_noOfContainers = m_maxContainers;
            m_noOfVarObjContainers = m_maxVarObjContainers;
            m_useVersions = m_probVersionUsage > 0;
        } else {
            m_noOfUpdaters = 1 + Math.abs(r.nextInt() % m_maxUpdaters);
            m_noOfVerifiers = 0 == m_maxVerifiers ? 0 : 1 + Math.abs(r.nextInt() % m_maxVerifiers);
            m_loopCnt = m_minLoops + Math.abs(r.nextInt() % (m_maxLoops - m_minLoops));
            m_noOfObjects = 1 + Math.abs(r.nextInt() % m_maxObjects);
            if (m_noOfObjects < 30) {
                m_noOfObjects = 30;
            }
            m_varObj = 0;
            if (m_probVarObjUsage > 0) {
                if (100 == m_probVarObjUsage) {
                    m_varObj = 1;
                } else if (Math.abs(r.nextInt() % 100) < m_probVarObjUsage) {
                    m_varObj = 1;
                }
            }
            m_list = 0;
            if (m_probListUsage > 0) {
                if (100 == m_probListUsage) {
                    m_list = 1;
                } else if (Math.abs(r.nextInt() % 100) < m_probListUsage) {
                    m_list = 1;
                }
            }
            m_maxVarObjLengthCurrent = 1 + Math.abs(r.nextInt() % m_maxVarObjLength);
            if (m_maxVarObjLength < 500) {
                m_maxVarObjLengthCurrent = 500;
            }
            m_containerOffset = 0;
            m_noOfContainers = 1 + Math.abs(r.nextInt() % m_maxContainers);
            m_noOfVarObjContainers = 1 + Math.abs(r.nextInt() % m_maxVarObjContainers);
            m_useVersions = false;
            if (m_probVersionUsage > 0) {
                if (100 == m_probVersionUsage) {
                    m_useVersions = true;
                } else if (Math.abs(r.nextInt() % 100) < m_probVersionUsage) {
                    m_useVersions = true;
                }
            }
        }
        String outString = "\n        Start value    : " + startValue + "\n";
        outString = outString + "        No of Updaters : " + m_noOfUpdaters + "\n";
        outString = outString + "        No of Verifiers: " + m_noOfVerifiers + "\n";
        outString = outString + "        No of Loops    : " + m_loopCnt + "\n";
        outString = outString + "        No of Objects  : " + m_noOfObjects + "\n";
        outString = outString + "        Use Varobjects : " + m_varObj + "\n";
        outString = outString + "        Use Lists      : " + m_list + "\n";
        outString = outString + "        Max VarObjLen  : " + m_maxVarObjLengthCurrent + "\n";
        outString = outString + "        Use Versions   : " + m_useVersions + "\n";
        MultiUserRandom.Trace(m_consoleMsg, outString);
    }

    synchronized int getRunningUpdater() {
        return m_updater;
    }

    synchronized int getRunningVerifier() {
        return m_verifier;
    }

    int getNumberOfConsistentViews(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("select count(*) into ? from CONSISTENTVIEWS");
        call.registerOutParameter(1, 4);
        call.execute();
        int count = call.getInt(1);
        return count;
    }

    void garbageCollectorCatchUp(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("select PCTUSEDPERM into ? from SERVERDBSTATISTICS");
        call.registerOutParameter(1, 4);
        call.execute();
        int pctUsed = call.getInt(1);
        if (pctUsed > 50) {
            TestStatement stmt = new TestStatement(null, con);
            stmt.executeUpdateIgnoreErrors("DELETE OBJECT STORAGE");
        }
        if (pctUsed > 90) {
            m_delay = 10;
            return;
        }
        if (pctUsed > 80) {
            m_delay = 5;
            return;
        }
        if (pctUsed > 70) {
            m_delay = 3;
            return;
        }
        if (pctUsed > 60) {
            m_delay = 2;
            return;
        }
        if (pctUsed > 50) {
            m_delay = 1;
            return;
        }
        m_delay = 0;
    }

    void selectMonitor(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("select RESERVED into ? from OMS_MEMORY_USAGE");
        call.registerOutParameter(1, 4);
        call.execute();
        int reserved = call.getInt(1);
        TestStatement stmt = new TestStatement(null, con);
        ResultSet rs = stmt.executeQuery("select * from monitor_oms");
        boolean found = false;
        while (found = rs.next()) {
            double avgRunTime = rs.getDouble("AvgRuntime");
            if (avgRunTime < 0.0) {
                throw new SQLException("invalid runtime", "", -1);
            }
            long mallocMax = rs.getLong("MallocMax");
            if (rs.wasNull() || mallocMax <= (long)reserved) continue;
            throw new SQLException("maxMax > reserved", "", -1);
        }
    }

    void getStatistics(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        ResultSet rs = stmt.executeQuery("select fixed(sum(pagecount), 10) from historyinfo");
        rs.next();
        int sum = rs.getInt(1);
        this.Trace_1("History pages : " + sum);
        rs.close();
        rs = stmt.executeQuery("select count(*), fixed(sum(pagecount), 10) from classcontainers");
        rs.next();
        int cnt = rs.getInt(1);
        sum = rs.getInt(2);
        this.Trace_1(cnt + " containers, pagecount = " + sum);
        rs.close();
        int oldestCnsView = 0;
        try {
            CallableStatement call = con.prepareCall("select max(fixed(num(timediff(time, opentime)), 10)) into ? from consistentviews");
            call.registerOutParameter(1, 4);
            oldestCnsView = call.getInt(1);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.Trace_1("Oldest consistent view : " + oldestCnsView);
    }

    public static String getTestClassId() {
        return "MultiUserRandom";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningUpdater() {
        MultiUserRandom multiUserRandom = this;
        synchronized (multiUserRandom) {
            ++m_updater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incRunningVerifier() {
        MultiUserRandom multiUserRandom = this;
        synchronized (multiUserRandom) {
            ++m_verifier;
        }
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSapOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean liveCacheCold() {
        MultiUserRandom multiUserRandom = this;
        synchronized (multiUserRandom) {
            return m_cold;
        }
    }

    private static void openTraceFile(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("CALL OPEN_TRACE_FILE (?)");
        call.setString(1, traceFile);
        call.execute();
    }

    public static long getTimeout() {
        return 60000 * (m_maxRunTime + 10);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection con = null;
        String lastFunctionCall = "prepare()";
        try {
            block10: {
                try {
                    lastFunctionCall = "readParameters()";
                    MultiUserRandom.readParameters();
                    lastFunctionCall = "getDatabase()...";
                    String DBAUser = MultiUserRandom.getDatabase().getDBAUser();
                    String DBAPassword = MultiUserRandom.getDatabase().getDBAPassword();
                    TestDatabase database = MultiUserRandom.getDatabase();
                    con = database.connect(DBAUser, DBAPassword);
                    lastFunctionCall = "enableVtrace(con)";
                    MultiUserRandom.enableVtrace(con);
                    lastFunctionCall = "checkLiveCache(con)";
                    MultiUserRandom.checkLiveCache(con);
                    lastFunctionCall = "enableWriteTransaction(con)";
                    MultiUserRandom.enableWriteTransaction(con);
                    lastFunctionCall = "createLcTestUser(con)";
                    MultiUserRandom.createLcTestUser(con);
                    lastFunctionCall = "testProlog()";
                    MultiUserRandom.testProlog();
                    if (!m_keepLogSegments) {
                        if (MultiUserRandom.getDatabase().getHost() == "localhost") {
                            lastFunctionCall = "mDirectoryCleaner";
                            mDirectoryCleaner = new DirectoryCleaner(new File(((TestDatabaseSap)database).getRunDir()), "autosave.*", 1200000);
                            mDirectoryCleaner.start();
                        }
                        break block10;
                    }
                    MultiUserRandom.addGlobalMessage((String)"run()", (char)'I', (String)"Will keep all log segments and copy them to data output path of this test ...");
                    System.out.println("Keeping all log segments and copying them to data output path of this test ...");
                }
                catch (Exception e) {
                    System.out.println("Exception in prepare() in " + lastFunctionCall + " : " + e.getMessage());
                    MultiUserRandom.addGlobalMessage((String)"Method prepare", (char)'E', (String)("preparation failed. \n" + e.getLocalizedMessage()));
                    throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage() + " in " + lastFunctionCall);
                }
            }
            Object var6_6 = null;
            if (null == con) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (null == con) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        con.close();
        return;
    }

    private static void readParameters() {
        m_testKind = MultiUserRandom.getParameterString((String)"TEST_KIND", (String)"SINGLE");
        m_testKind = m_testKind.toUpperCase();
        m_maxRunTime = MultiUserRandom.getParameterInt((String)"MAX_RUN_TIME", (int)60);
        m_consoleMsg = MultiUserRandom.getParameterBoolean((String)"CONSOLE_MSG", (boolean)false);
        m_traceLvl = MultiUserRandom.getParameterInt((String)"TRACE_LVL", (int)1);
        m_trace = MultiUserRandom.getParameterInt((String)"DBPROC_TRACE_LVL", (int)0);
        m_noOfRandomTest = MultiUserRandom.getParameterInt((String)"NO_OF_RANDOM_TESTS", (int)1);
        m_maxLoops = MultiUserRandom.getParameterInt((String)"MAX_LOOPS", (int)500);
        m_minLoops = MultiUserRandom.getParameterInt((String)"MIN_LOOPS", (int)500);
        m_maxObjects = MultiUserRandom.getParameterInt((String)"MAX_OBJECTS", (int)500);
        m_probListUsage = MultiUserRandom.getParameterInt((String)"PROB_LIST_USAGE", (int)50);
        m_probVarObjUsage = MultiUserRandom.getParameterInt((String)"PROB_VAROBJ_USAGE", (int)50);
        m_probVersionUsage = MultiUserRandom.getParameterInt((String)"PROB_VERSION_USAGE", (int)50);
        m_maxVarObjLength = MultiUserRandom.getParameterInt((String)"MAX_VAROBJ_LEN", (int)1000);
        m_maxContainers = MultiUserRandom.getParameterInt((String)"MAX_CONTAINER", (int)1);
        m_maxVarObjContainers = MultiUserRandom.getParameterInt((String)"MAX_VAROBJ_CONTAINER", (int)1);
        m_maxUpdaters = MultiUserRandom.getParameterInt((String)"MAX_UPDATERS", (int)2);
        m_maxVerifiers = MultiUserRandom.getParameterInt((String)"MAX_VERIFIERS", (int)1);
        m_dropSchemas = MultiUserRandom.getParameterBoolean((String)"DROP_SCHEMAS", (boolean)false);
        m_dropSchemaDistance = MultiUserRandom.getParameterInt((String)"DROP_SCHEMA_DISTANCE", (int)60);
        m_checkPoints = MultiUserRandom.getParameterBoolean((String)"FORCE_CHECKPOINTS", (boolean)false);
        m_checkPointDistance = MultiUserRandom.getParameterInt((String)"CHECKPOINT_DISTANCE", (int)60);
        m_shutdown = MultiUserRandom.getParameterBoolean((String)"SHUTDOWN", (boolean)false);
        m_shutdownDistance = MultiUserRandom.getParameterInt((String)"SHUTDOWN_DISTANCE", (int)120);
        m_copyAutosaveDistance = MultiUserRandom.getParameterInt((String)"COPY_AUTOSAVE_DISTANCE", (int)20);
        m_savepointDistance = MultiUserRandom.getParameterInt((String)"SAVEPOINT_DISTANCE", (int)0);
        m_jdbcTrace = MultiUserRandom.getParameterBoolean((String)"JDBC_TRACE", (boolean)false);
        m_defaultVtrace = MultiUserRandom.getParameterBoolean((String)"DEFAULT_VTRACE", (boolean)false);
        m_objectVtrace = MultiUserRandom.getParameterBoolean((String)"OBJECT_VTRACE", (boolean)false);
        m_heapLimit = MultiUserRandom.getParameterInt((String)"HEAP_LIMIT", (int)0);
        m_heapThreshold = MultiUserRandom.getParameterInt((String)"HEAP_THRESHOLD", (int)100);
        m_versionThreshold = MultiUserRandom.getParameterInt((String)"VERSION_THRESHOLD", (int)0x200000);
        m_randomStart = MultiUserRandom.getParameterInt((String)"RANDOM_START", (int)0);
        m_crashes = MultiUserRandom.getParameterBoolean((String)"CRASHES", (boolean)false);
        m_hssCrashes = MultiUserRandom.getParameterBoolean((String)"HSS_CRASHES", (boolean)false);
        m_crashDistance = MultiUserRandom.getParameterInt((String)"CRASH_DISTANCE", (int)120);
        m_restartDelay = MultiUserRandom.getParameterInt((String)"RESTART_DELAY", (int)300);
        m_probCommit = MultiUserRandom.getParameterInt((String)"PROB_COMMIT", (int)50);
        m_breakAtCall = MultiUserRandom.getParameterInt((String)"BREAK_CALL", (int)0);
        m_breakAtLoop = MultiUserRandom.getParameterInt((String)"BREAK_LOOP", (int)0);
        m_delayUpdaters = MultiUserRandom.getParameterBoolean((String)"DELAY_UPDATERS", (boolean)false);
        mLOG_SEGMENT_SIZE = MultiUserRandom.getParameterInt((String)"LOG_SEGMENT_SIZE", (int)600);
        m_keepLogSegments = MultiUserRandom.getParameterBoolean((String)"KEEP_LOGSEGMENTS", (boolean)false);
        String outString = "\n\tTEST_KIND            = " + m_testKind + "\n";
        if (0 == m_testKind.compareTo("RANDOM")) {
            outString = outString + "\tNO_OF_RANDOM_TESTS   = " + m_noOfRandomTest + "\n";
        } else {
            m_noOfRandomTest = 1;
        }
        outString = outString + "\tMAX_RUN_TIME         = " + m_maxRunTime + " min" + "\n";
        outString = outString + "\tMAX_LOOPS            = " + m_maxLoops + "\n";
        outString = outString + "\tMIN_LOOPS            = " + m_minLoops + "\n";
        outString = outString + "\tMAX_OBJECTS          = " + m_maxObjects + "\n";
        outString = outString + "\tPROB_LIST_USAGE      = " + m_probListUsage + "\n";
        outString = outString + "\tPROB_VAROBJ_USAGE    = " + m_probVarObjUsage + "\n";
        outString = outString + "\tPROB_COMMIT          = " + m_probCommit + "\n";
        outString = outString + "\tPROB_VERSION_USAGE   = " + m_probVersionUsage + "\n";
        outString = outString + "\tMAX_VAROBJ_LEN       = " + m_maxVarObjLength + "\n";
        outString = outString + "\tMAX_CONTAINER        = " + m_maxContainers + "\n";
        outString = outString + "\tMAX_VAROBJ_CONTAINER = " + m_maxVarObjContainers + "\n";
        outString = outString + "\tMAX_UPDATERS         = " + m_maxUpdaters + "\n";
        outString = outString + "\tMAX_VERIFIERS        = " + m_maxVerifiers + "\n";
        outString = outString + "\tDROP_SCHEMAS         = " + m_dropSchemas + "\n";
        outString = outString + "\tCRASHES              = " + m_crashes + "\n";
        outString = outString + "\tHSS_CRASHES          = " + m_hssCrashes + "\n";
        outString = outString + "\tDELAY_UPDATERS       = " + m_delayUpdaters + "\n";
        outString = outString + "\tRELEASE              = " + m_ReleaseId + "\n";
        outString = outString + "\tBREAK_CALL           = " + m_breakAtCall + "\n";
        outString = outString + "\tBREAK_LOOP           = " + m_breakAtLoop + "\n";
        if (m_dropSchemas) {
            outString = outString + "\tDROP_SCHEMA_DISTANCE = " + m_dropSchemaDistance + "\n";
        }
        outString = outString + "\tFORCE_CHECKPOINTS    = " + m_checkPoints + "\n";
        if (m_checkPoints) {
            outString = outString + "\tCHECKPOINT_DISTANCE  = " + m_checkPointDistance + "\n";
        }
        outString = outString + "\tSHUTDOWN             = " + m_shutdown + "\n";
        if (m_shutdown) {
            outString = outString + "\tSHUTDOWN_DISTANCE    = " + m_shutdownDistance + "\n";
        }
        if (m_savepointDistance > 0) {
            outString = outString + "\tSAVEPOINT_DISTANCE   = " + m_savepointDistance + "\n";
        }
        if (m_crashes || m_hssCrashes) {
            outString = outString + "\tCRASH_DISTANCE       = " + m_crashDistance + "\n";
            outString = outString + "\tRESTART_DELAY        = " + m_crashDistance + "\n";
        }
        outString = outString + "\tDEFAULT_VTRACE       = " + m_defaultVtrace + "\n";
        outString = outString + "\tOBJECT_VTRACE        = " + m_objectVtrace + "\n";
        MultiUserRandom.Trace(m_consoleMsg, outString);
    }

    private static void restartLcTest(Connection con) throws SQLException {
        CallableStatement call = con.prepareCall("CALL RESTART");
        call.execute();
        call.close();
        MultiUserRandom.checkIntegrity(con);
    }

    public void run() {
        Connection dbaCon = null;
        MultiUserRandom.Trace(m_consoleMsg, "Running MultiUserRandom version: 6.5");
        if (0 == m_testKind.compareTo("EXCEPTION")) {
            try {
                MultiUserRandom.getDatabase().executeDBMcmd("db_offline");
                System.out.println("db_register -t");
                MultiUserRandom.getDatabase().executeDBMcmd("db_register -t");
                System.out.println("db_warm -t");
                MultiUserRandom.getDatabase().executeDBMcmd("db_warm -t");
            }
            catch (Exception e) {
                this.TraceError("Execption Text: " + e.getMessage());
                this.handleExceptions(e);
                return;
            }
        }
        try {
            System.out.println("Doing param_directput LOG_SEGMENT_SIZE " + mLOG_SEGMENT_SIZE);
            MultiUserRandom.getDatabase().executeDBMcmd("param_directput LOG_SEGMENT_SIZE " + mLOG_SEGMENT_SIZE);
            System.out.println("Doing db_restart");
            MultiUserRandom.getDatabase().executeDBMcmd("db_restart");
        }
        catch (Exception e) {
            this.TraceError("Execption Text: " + e.getMessage());
            this.handleExceptions(e);
            return;
        }
        try {
            String DBAUser = MultiUserRandom.getDatabase().getDBAUser();
            String DBAPassword = MultiUserRandom.getDatabase().getDBAPassword();
            dbaCon = MultiUserRandom.getDatabase().connect(DBAUser, DBAPassword);
            TestStatement stmt = new TestStatement(null, dbaCon);
            stmt.execute("CALL DROP_SCHEMAS");
            stmt.close();
            dbaCon.close();
            if (((TestDatabaseSap)MultiUserRandom.getDatabase()).isHSS()) {
                System.out.println("Test is running in a Hot Standby environment");
                MultiUserRandom.Trace(m_consoleMsg, "Test is running in a Hot Standby environment");
                m_hsNode001 = ((TestDatabaseSap)MultiUserRandom.getDatabase()).getParameter("HS_NODE_001");
                m_hsNode002 = ((TestDatabaseSap)MultiUserRandom.getDatabase()).getParameter("HS_NODE_002");
                m_actualMasterNode = m_hsNode001;
                m_actualStandbyNode = m_hsNode002;
                MultiUserRandom.Trace(m_consoleMsg, "Actual Master : " + m_actualMasterNode);
                MultiUserRandom.Trace(m_consoleMsg, "Actual Standby: " + m_actualStandbyNode);
            }
        }
        catch (Exception e) {
            this.TraceError("Execption Text: " + e.getMessage());
            this.handleExceptions(e);
            return;
        }
        MaxRunTimeTimer RunTimeTimer = new MaxRunTimeTimer(m_maxRunTime);
        for (int ix = 0; ix < m_noOfRandomTest && !m_runTimeLimit; ++ix) {
            MultiUserRandom.Trace(m_consoleMsg, "\nRunning " + (ix + 1) + ". Test ...");
            if (!this.runRandomTest()) break;
            MultiUserRandom.Trace(m_consoleMsg, "Test " + (ix + 1) + " successfully finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean runRandomTest() {
        boolean ok;
        block41: {
            int p;
            Connection con = null;
            ok = true;
            int taskId = -1;
            MultiUserRandom.evalTestSettings();
            this.setLcParameters();
            con = MultiUserRandom.connect();
            taskId = MultiUserRandom.evalTaskID(con);
            MultiUserRandom.enableVtrace(con);
            MultiUserRandom.enableWriteTransaction(con);
            MultiUserRandom.callSettings(con, 1);
            MultiUserRandom.callInit(con);
            int remaining = m_dropSchemaDistance;
            int checkPointRemaining = m_checkPointDistance;
            int shutdownCnt = 0;
            Timer shutdownTimer = null;
            CrashTimer crashTimer = null;
            SavepointTimer savepointTimer = null;
            if (m_keepLogSegments) {
                new CopyAutosaveTimer(m_copyAutosaveDistance);
            }
            if (m_shutdown) {
                shutdownTimer = new Timer(m_shutdownDistance);
            }
            if (m_savepointDistance > 0) {
                savepointTimer = new SavepointTimer(m_savepointDistance);
            }
            if (m_crashes || m_hssCrashes) {
                crashTimer = new CrashTimer(m_crashDistance);
            }
            m_stop = false;
            MultiUserRandom.Trace(m_consoleMsg, "Start the verifiers...");
            for (p = 0; p < m_noOfVerifiers; ++p) {
                this.startVerifier(p + 1);
            }
            MultiUserRandom.Trace(m_consoleMsg, "Start the updaters...");
            for (p = 0; p < m_noOfUpdaters; ++p) {
                this.startUpdater(m_noOfVerifiers + p + 1);
            }
            Thread t = Thread.currentThread();
            MonitorInitTimer monitorTimer = new MonitorInitTimer();
            while (this.getRunningUpdater() > 0) {
                try {
                    Thread.sleep(1000L);
                    if (m_runTimeLimit) {
                        m_stop = true;
                        break;
                    }
                    if (0 != this.sqlError()) {
                        ok = false;
                        m_stop = true;
                        break;
                    }
                    if (m_shutdownEvent && !m_crashEvent) {
                        this.setCold(true);
                        this.Trace_1("(T" + taskId + ") shutdown(" + ++shutdownCnt + ")");
                        this.shutdown();
                        Thread.sleep(5000L);
                        MultiUserRandom.getDatabase().restart();
                        checkPointRemaining = m_checkPointDistance;
                        remaining = m_dropSchemaDistance;
                        con = MultiUserRandom.connect();
                        taskId = MultiUserRandom.evalTaskID(con);
                        MultiUserRandom.enableVtrace(con);
                        MultiUserRandom.enableWriteTransaction(con);
                        MultiUserRandom.callSettings(con, 0);
                        MultiUserRandom.restartLcTest(con);
                        this.startGarbageCollectors(con);
                        this.Trace_1("restarted T(" + taskId + ")");
                        this.setCold(false);
                        m_shutdownEvent = false;
                        shutdownTimer.start();
                        con.commit();
                    }
                    if (m_checkPoints && !m_crashEvent && 0 == --checkPointRemaining) {
                        this.checkpoint(con);
                        checkPointRemaining = m_checkPointDistance;
                    }
                    if (m_dropSchemas && !m_crashEvent && 0 == --remaining) {
                        this.dropSchema(con, taskId);
                        remaining = m_dropSchemaDistance;
                    }
                    if (m_crashEvent) {
                        this.Trace_1("liveCache crashed");
                        throw new SQLException(m_sqlErrorMsg, "", -8000);
                    }
                    if (m_delayUpdaters) {
                        this.garbageCollectorCatchUp(con);
                    }
                    this.selectMonitor(con);
                }
                catch (Exception e) {
                    if (m_crashEvent) {
                        this.Trace_1("waiting " + m_restartDelay / 60 + " minutes");
                        this.Trace_1("...");
                        Thread.sleep(1000 * m_restartDelay);
                        if (m_hssCrashes) {
                            this.Trace_1("Takeover after crash");
                            MultiUserRandom.getDatabase().executeDBMcmd("hss_execute " + m_actualStandbyNode + " db_execute TAKEOVER");
                            this.Trace_1("New Master: " + m_actualStandbyNode);
                            this.Trace_1("Reintegrate the old Master as a new Standby");
                            MultiUserRandom.getDatabase().executeDBMcmd("hss_execute " + m_actualStandbyNode + " db_standby " + m_actualMasterNode);
                            this.Trace_1("New Standby: " + m_actualMasterNode);
                            String m_tempNode = m_actualMasterNode;
                            m_actualMasterNode = m_actualStandbyNode;
                            m_actualStandbyNode = m_tempNode;
                            ((TestDatabaseSap)MultiUserRandom.getDatabase()).setHost(m_actualMasterNode);
                        } else {
                            this.Trace_1("Restart after crash");
                            try {
                                MultiUserRandom.getDatabase().restart();
                            }
                            catch (Exception restartError) {
                                Thread.sleep(600000L);
                                this.Trace_1("restart after crash (2. attempt)");
                                MultiUserRandom.getDatabase().restart();
                            }
                        }
                        checkPointRemaining = m_checkPointDistance;
                        remaining = m_dropSchemaDistance;
                        con = MultiUserRandom.connect();
                        MultiUserRandom.enableVtrace(con);
                        taskId = MultiUserRandom.evalTaskID(con);
                        MultiUserRandom.enableWriteTransaction(con);
                        MultiUserRandom.callSettings(con, 0);
                        MultiUserRandom.restartLcTest(con);
                        this.startGarbageCollectors(con);
                        this.Trace_1("restarted (T" + taskId + ")");
                        this.setCold(false);
                        m_crashEvent = false;
                        if (m_shutdown) {
                            shutdownTimer.start();
                        }
                        m_shutdownEvent = false;
                        crashTimer.start();
                        con.commit();
                        continue;
                    }
                    throw e;
                }
            }
            m_stop = true;
            while (this.getRunningUpdater() + this.getRunningVerifier() > 0) {
                Thread.sleep(500L);
            }
            if (0 != this.sqlError()) {
                ok = false;
                this.addMessage("", 'E', "SQL Error in coordinator : " + m_sqlError + " " + m_sqlErrorMsg);
                throw new SQLException(m_sqlErrorMsg, "", m_sqlError);
            }
            Object var16_17 = null;
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                Thread t2 = Thread.currentThread();
                m_stop = true;
                Thread.sleep(20000L);
            }
            catch (Exception e2) {}
            break block41;
            {
                catch (Exception e) {
                    ok = false;
                    e.printStackTrace();
                    MultiUserRandom.abort();
                    this.handleExceptions(e);
                    Object var16_18 = null;
                    try {
                        if (con != null && !con.isClosed()) {
                            con.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        Thread t2 = Thread.currentThread();
                        m_stop = true;
                        Thread.sleep(20000L);
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    Thread t2 = Thread.currentThread();
                    m_stop = true;
                    Thread.sleep(20000L);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCold(boolean isCold) {
        MultiUserRandom multiUserRandom = this;
        synchronized (multiUserRandom) {
            m_cold = isCold;
        }
    }

    synchronized void setGlobalSqlError(SQLException e) {
        if (0 == m_sqlError) {
            m_sqlError = e.getErrorCode();
            m_sqlErrorMsg = e.getMessage();
        }
    }

    private void setLcParameters() throws TestDatabaseException {
        try {
            String heapLimit = MultiUserRandom.getDatabase().executeDBMcmd("param_getvalue OMS_HEAP_LIMIT").trim();
            String heapThreshold = MultiUserRandom.getDatabase().executeDBMcmd("param_getvalue OMS_HEAP_THRESHOLD").trim();
            String versionThreshold = MultiUserRandom.getDatabase().executeDBMcmd("param_getvalue OMS_VERS_THRESHOLD").trim();
            if (!(heapLimit.equals("" + m_heapLimit) && heapThreshold.equals("" + m_heapThreshold) && versionThreshold.equals("" + m_versionThreshold))) {
                this.Trace_0("Setting OMS_HEAP_LIMIT from " + m_heapLimit + " to " + heapLimit);
                this.Trace_0("Setting OMS_HEAP_THRESHOLD from " + m_heapThreshold + " to " + heapThreshold);
                this.Trace_0("Setting OMS_VERS_THRESHOLD from " + m_versionThreshold + " to " + versionThreshold);
                MultiUserRandom.getDatabase().executeDBMcmd("db_offline");
                MultiUserRandom.getDatabase().executeDBMcmd("param_startsession");
                MultiUserRandom.getDatabase().executeDBMcmd("param_put OMS_HEAP_LIMIT " + m_heapLimit);
                MultiUserRandom.getDatabase().executeDBMcmd("param_put OMS_HEAP_THRESHOLD " + m_heapThreshold);
                MultiUserRandom.getDatabase().executeDBMcmd("param_put OMS_VERS_THRESHOLD " + m_versionThreshold);
                MultiUserRandom.getDatabase().executeDBMcmd("param_checkall");
                MultiUserRandom.getDatabase().executeDBMcmd("param_commitsession");
                MultiUserRandom.getDatabase().executeDBMcmd("db_warm");
            }
        }
        catch (Exception e) {
            throw new TestDatabaseException("Error while setting new LC parameters");
        }
    }

    private void shutdown() throws TestDatabaseException {
        MultiUserRandom.getDatabase().executeDBMcmd("db_offline");
    }

    private void shutdownRestart() throws TestDatabaseException {
        MultiUserRandom.getDatabase().executeDBMcmd("db_offline");
        MultiUserRandom.getDatabase().executeDBMcmd("db_warm");
    }

    synchronized int sqlError() {
        return m_sqlError;
    }

    void startGarbageCollectors(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        stmt.executeUpdate("DELETE OBJECT STORAGE");
        stmt.close();
    }

    private void startUpdater(int processId) throws SQLException, TestDatabaseException {
        this.incRunningUpdater();
        Updater updater = new Updater(processId);
    }

    private void startVerifier(int processId) throws SQLException, TestDatabaseException {
        this.incRunningVerifier();
        Verifier verifier = new Verifier(processId);
    }

    private static void testProlog() throws SQLException, TestDatabaseException {
        Connection con = MultiUserRandom.connect();
        LC_VERSION = MultiUserRandom.xgetVersionString();
        String Package2 = "LCTEST";
        if (LC_VERSION >= 744) {
            MultiUserRandom.createPackage(con, Package2, "lctest");
        } else {
            MultiUserRandom.createPackage(con, Package2, "livecache.lctest.TEST");
        }
        MultiUserRandom.createDBProcedures(con, Package2);
        Package2 = "SYS_PACKAGE";
        if (LC_VERSION >= 744) {
            MultiUserRandom.createPackage(con, Package2, "dbpinstall");
        } else {
            MultiUserRandom.createPackage(con, Package2, "livecache.dbpinstall.V72");
        }
        try {
            MultiUserRandom.createDBProcedure(con, "FORCE_AND_WAIT_FOR_CHECKPOINT", Package2, true);
        }
        catch (SQLException e) {
            MultiUserRandom.createDBProcedure(con, "FORCE_AND_WAIT_FOR_CHECKPOINT", Package2);
        }
        con.commit();
        con.close();
    }

    private static void Trace(boolean consoleMsg, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        MultiUserRandom.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private void Sleep(Thread t, int sleepTime) throws InterruptedException {
        while (sleepTime > 0) {
            int s = sleepTime > 10000 ? 10000 : sleepTime;
            Thread.sleep(s);
            sleepTime -= s;
            if (!m_stop) continue;
            throw new InterruptedException();
        }
    }

    private void Trace_0(String msg) {
        if (m_consoleMsg) {
            System.out.println(msg);
        }
        this.addMessage("", 'I', msg);
    }

    private void Trace_1(String msg) {
        if (m_traceLvl >= 1) {
            if (m_consoleMsg) {
                System.out.println(msg);
            }
            this.addMessage("", 'I', msg);
        }
    }

    private void Trace_2(String msg) {
        if (m_traceLvl >= 2) {
            if (m_consoleMsg) {
                System.out.println(msg);
            }
            this.addMessage("", 'E', msg);
        }
    }

    private void TraceError(String msg) {
        if (m_consoleMsg) {
            System.out.println(msg);
        }
        this.addMessage("Error", 'E', msg);
    }

    void waitForEmptyHistory(Connection con) throws SQLException {
        TestStatement stmt = new TestStatement(null, con);
        int sum = 0;
        ResultSet rs = stmt.executeQuery("select fixed(num(value), 10) from dbparameters where description = 'MAXUSERTASKS'");
        rs.next();
        int maxUserTasks = rs.getInt(1);
        rs.close();
        int attempts = 0;
        do {
            rs = stmt.executeQuery("select sum(PAGECOUNT) from historyinfo");
            rs.next();
            sum = rs.getInt(1);
            if (maxUserTasks == sum) continue;
            this.Trace_1("History pages : " + sum);
            Thread t = Thread.currentThread();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++attempts;
        } while (sum != maxUserTasks && attempts < 10);
    }

    private static int xgetVersionString() throws TestDatabaseException {
        String KernelVersion = "";
        try {
            KernelVersion = ((TestDatabaseSap)MultiUserRandom.getDatabase()).getKernelVersion();
            MultiUserRandom.Trace(m_consoleMsg, "Running livecache kernel version: " + KernelVersion);
        }
        catch (TestDatabaseException testDatabaseException) {
            // empty catch block
        }
        if (KernelVersion.equals("7.2.4") || KernelVersion.equals("7.2.04")) {
            return 724;
        }
        if (KernelVersion.equals("7.2.5") || KernelVersion.equals("7.2.05")) {
            return 725;
        }
        if (KernelVersion.equals("7.4.1") || KernelVersion.equals("7.4.01")) {
            return 741;
        }
        if (KernelVersion.equals("7.4.2") || KernelVersion.equals("7.4.02")) {
            return 742;
        }
        if (KernelVersion.equals("7.4.3") || KernelVersion.equals("7.4.03")) {
            return 743;
        }
        if (KernelVersion.equals("7.4.4") || KernelVersion.equals("7.4.04")) {
            return 744;
        }
        if (KernelVersion.equals("7.4.5") || KernelVersion.equals("7.4.05")) {
            return 745;
        }
        if (KernelVersion.equals("7.4.6") || KernelVersion.equals("7.4.06")) {
            return 746;
        }
        if (KernelVersion.equals("7.4.7") || KernelVersion.equals("7.4.07")) {
            return 747;
        }
        if (KernelVersion.equals("7.4.8") || KernelVersion.equals("7.4.08")) {
            return 748;
        }
        if (KernelVersion.equals("7.4.9") || KernelVersion.equals("7.4.09")) {
            return 749;
        }
        if (KernelVersion.equals("7.5.0") || KernelVersion.equals("7.5.00")) {
            return 750;
        }
        if (KernelVersion.equals("7.5.1") || KernelVersion.equals("7.5.01")) {
            return 751;
        }
        if (KernelVersion.equals("7.5.2") || KernelVersion.equals("7.5.02")) {
            return 752;
        }
        if (KernelVersion.equals("7.5.00")) {
            return 750;
        }
        if (KernelVersion.equals("7.5.01")) {
            return 751;
        }
        if (KernelVersion.equals("7.5.02")) {
            return 752;
        }
        if (KernelVersion.equals("7.6.0")) {
            return 760;
        }
        if (KernelVersion.equals("7.6.00")) {
            return 760;
        }
        if (KernelVersion.equals("7.6.01") || KernelVersion.equals("7.6.1")) {
            return 761;
        }
        if (KernelVersion.equals("7.6.02") || KernelVersion.equals("7.6.2")) {
            return 762;
        }
        if (KernelVersion.equals("7.6.03") || KernelVersion.equals("7.6.3")) {
            return 763;
        }
        if (KernelVersion.equals("7.7.00") || KernelVersion.equals("7.7.0")) {
            return 770;
        }
        if (KernelVersion.equals("7.7.01") || KernelVersion.equals("7.7.1")) {
            return 770;
        }
        if (KernelVersion.equals("7.7.02") || KernelVersion.equals("7.7.2")) {
            return 770;
        }
        if (KernelVersion.equals("8.0")) {
            return 800;
        }
        throw new TestDatabaseException("SAP DB version " + KernelVersion + " currently not supported for liveCache tests.");
    }

    static {
        m_shutdownEvent = false;
        m_crashEvent = false;
        m_jdbcTrace = false;
        m_defaultVtrace = false;
        m_objectVtrace = false;
        m_traceLvl = 1;
        m_crashes = false;
        m_hssCrashes = false;
        m_crashDistance = 0;
        m_restartDelay = 0;
        m_runTimeLimit = false;
        m_maxRunTime = 60;
        m_updater = 0;
        m_verifier = 0;
        m_sqlError = 0;
        m_stop = false;
        m_cold = false;
        m_delay = 0;
        m_delayUpdaters = false;
        m_breakAtCall = 0;
        m_breakAtLoop = 0;
        m_dropSchemaCnt = 0;
        mDirectoryCleaner = null;
    }

    class MaxRunTimeTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        MaxRunTimeTimer(int intervall) {
            this.m_intervall = intervall * 60000;
            this.start();
        }

        public void run() {
            try {
                MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_runTimeLimit = true;
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class Timer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;
        private int m_version = 0;

        Timer(int intervall) {
            this.m_intervall = intervall * 1000;
            this.start();
        }

        public void run() {
            int version = this.m_version;
            try {
                MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (version == this.m_version) {
                m_shutdownEvent = true;
            }
        }

        public void start() {
            ++this.m_version;
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class MonitorInitTimer
    implements Runnable {
        private int m_intervall = 300000;
        private Thread m_thread = null;

        MonitorInitTimer() {
            this.start();
        }

        public void run() {
            try {
                MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
            }
            catch (Exception e) {
                // empty catch block
            }
            Connection con = null;
            while (true) {
                block11: {
                    int taskId;
                    try {
                        MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (m_stop) break;
                    if (m_cold) continue;
                    try {
                        con = MultiUserRandom.connect();
                        taskId = MultiUserRandom.evalTaskID(con);
                    }
                    catch (Exception e) {
                        if (m_cold) continue;
                        MultiUserRandom.this.Trace_0("monitor timer : could not connect ");
                        continue;
                    }
                    MultiUserRandom.this.Trace_0("initialising object monitor (T" + taskId + ")");
                    try {
                        TestStatement stmt = new TestStatement(null, con);
                        stmt.executeUpdate("MONITOR INIT OBJECT");
                    }
                    catch (SQLException e) {
                        if (m_cold) break block11;
                        MultiUserRandom.this.Trace_0("MONITOR INIT OBJECT failed with" + e.getErrorCode());
                        break;
                    }
                }
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class CrashTimer
    implements Runnable {
        private int m_intervall = 0;
        private int m_crashCnt = 0;
        private Thread m_thread = null;

        CrashTimer(int intervall) {
            this.m_intervall = intervall * 1000;
            m_crashEvent = false;
            this.start();
        }

        public void run() {
            try {
                MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
            }
            catch (Exception e) {
                // empty catch block
            }
            Connection con = null;
            try {
                con = MultiUserRandom.connect();
            }
            catch (Exception e) {
                MultiUserRandom.this.Trace_1("crash : could not connect ");
                return;
            }
            ++this.m_crashCnt;
            MultiUserRandom.this.Trace_1("crash liveCache(" + this.m_crashCnt + ")");
            try {
                CallableStatement call = con.prepareCall("CALL ABORT");
                MultiUserRandom.this.setCold(true);
                m_crashEvent = true;
                call.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class CopyAutosaveTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;
        private boolean mDataBackupCopied = false;
        private boolean mFirstAutosaveFile = false;
        private long mFirstFileHadThisSize = 0L;
        private Vector m_alreadyCopiedAutosave = new Vector(200);

        CopyAutosaveTimer(int intervall) {
            this.m_intervall = intervall * 60 * 1000;
            this.start();
        }

        private void copyAutosaveFile(String lFileName, File lFileDir) {
            StringBuffer processOutupt = new StringBuffer();
            try {
                String progToCall = "";
                Execute exc = null;
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    progToCall = "cmd /c copy " + lFileDir + File.separator + lFileName + " " + MultiUserRandom.this.getDataOutputPath() + File.separator + lFileName;
                    exc = this.isDevelopmentInstallation() ? new Execute(progToCall, new String[]{"SAPDB_NO_INDEPPATH=yes"}, processOutupt) : new Execute(progToCall, null, processOutupt);
                } else {
                    progToCall = "cp " + lFileDir + File.separator + lFileName + " " + MultiUserRandom.this.getDataOutputPath() + File.separator + lFileName;
                    String[] cmdArr = new String[]{"sh", "-c", progToCall};
                    exc = this.isDevelopmentInstallation() ? new Execute(cmdArr, new String[]{"SAPDB_NO_INDEPPATH=yes"}, processOutupt) : new Execute(cmdArr, null, processOutupt);
                }
                MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'I', "Try to call '" + progToCall + "'");
                exc.exec(new File(System.getProperty("jtest.root")));
            }
            catch (Exception ex) {
                MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'E', "Catched an unexpected exception: " + ex.getMessage());
            }
        }

        private void copyDataBackup(File lFileDir) {
            StringBuffer processOutupt = new StringBuffer();
            try {
                String progToCall = "";
                Execute exc = null;
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    progToCall = "cmd /c copy " + lFileDir + File.separator + "DAT_RESET.dat" + " " + MultiUserRandom.this.getDataOutputPath() + File.separator + "DAT_RESET.dat";
                    exc = this.isDevelopmentInstallation() ? new Execute(progToCall, new String[]{"SAPDB_NO_INDEPPATH=yes"}, processOutupt) : new Execute(progToCall, null, processOutupt);
                } else {
                    progToCall = "cp " + lFileDir + File.separator + "DAT_RESET.dat" + " " + MultiUserRandom.this.getDataOutputPath() + File.separator + "DAT_RESET.dat";
                    String[] cmdArr = new String[]{"sh", "-c", progToCall};
                    exc = this.isDevelopmentInstallation() ? new Execute(cmdArr, new String[]{"SAPDB_NO_INDEPPATH=yes"}, processOutupt) : new Execute(cmdArr, null, processOutupt);
                }
                MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'I', "Try to call '" + progToCall + "'");
                exc.exec(new File(System.getProperty("jtest.root")));
            }
            catch (Exception ex) {
                MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'E', "Catched an unexpected exception: " + ex.getMessage());
            }
        }

        private void deleteExistingFiles(String lAbsPath, String lFileName) {
            StringBuffer processOutupt = new StringBuffer();
            try {
                String progToCall = "";
                Execute exc = null;
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    progToCall = "cmd /c del " + lAbsPath + lFileName;
                    exc = this.isDevelopmentInstallation() ? new Execute(progToCall, new String[]{"SAPDB_NO_INDEPPATH=yes"}, processOutupt) : new Execute(progToCall, null, processOutupt);
                } else {
                    progToCall = "rm " + lAbsPath + lFileName;
                    String[] cmdArr = new String[]{"sh", "-c", progToCall};
                    exc = this.isDevelopmentInstallation() ? new Execute(cmdArr, new String[]{"SAPDB_NO_INDEPPATH=yes"}, processOutupt) : new Execute(cmdArr, null, processOutupt);
                }
                MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'I', "Try to call '" + progToCall + "'");
                exc.exec(new File(System.getProperty("jtest.root")));
            }
            catch (Exception ex) {
                MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'E', "Catched an unexpected exception: " + ex.getMessage());
            }
        }

        public boolean isDevelopmentInstallation() {
            String itprop = System.getProperty("db.insttype");
            return itprop == null || itprop.equalsIgnoreCase("develop") || itprop.equalsIgnoreCase("developer") || itprop.equalsIgnoreCase("development");
        }

        public boolean copyLockfile(String lCreateOrDelete) {
            if (lCreateOrDelete.equalsIgnoreCase("create")) {
                try {
                    File copyLockfile = new File(MultiUserRandom.this.getDataOutputPath() + System.getProperty("file.separator") + ".." + File.separator + "copyLockfile");
                    copyLockfile.createNewFile();
                    if (copyLockfile == null) {
                        MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'W', "Creation of copyLockfile failed!");
                        return false;
                    }
                }
                catch (IOException ioe) {}
            } else if (lCreateOrDelete.equalsIgnoreCase("delete")) {
                File copyLockfile = new File(MultiUserRandom.this.getDataOutputPath() + File.separator + ".." + File.separator + "copyLockfile");
                if (copyLockfile != null) {
                    copyLockfile.delete();
                } else {
                    MultiUserRandom.this.addMessage(MultiUserRandom.getTestClassId(), 'W', "Deletion of copyLockfile failed! No file existed!");
                    return false;
                }
            }
            return true;
        }

        public void possiblyDeleteOldAutosaveFiles() {
            File FileDir = null;
            FileDir = new File(MultiUserRandom.this.getDataOutputPath() + File.separator);
            String absPath = MultiUserRandom.this.getDataOutputPath() + File.separator;
            if (FileDir == null) {
                MultiUserRandom.addGlobalMessage((String)"possiblyDeleteOldAutosaveFiles()", (char)'I', (String)"No deletion of autosave files possible: can't read dataOutputPath; getting: null");
                return;
            }
            if (FileDir.isDirectory()) {
                String[] FileList = FileDir.list();
                int filecounter = 0;
                for (int i = 0; i < FileList.length && filecounter < 2000; ++i) {
                    File file = new File(FileDir, FileList[i]);
                    String fileName = file.getName();
                    this.deleteExistingFiles(absPath, fileName);
                    System.out.println("Deleted file " + fileName + " from output dir of this test!");
                }
                if (filecounter == 0) {
                    System.out.println("No old autosave file there! Deletion not necessary!");
                }
            }
        }

        public void checkDirectoryAgainAndAgain() {
            MultiUserRandom.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'I', (String)"Will keep all log segments and copy them to data output path of this test ...");
            System.out.println("Keeping all log segments and copying them to data output path of this test ...");
            File FileDir = null;
            try {
                TestDatabaseSap sapdb = (TestDatabaseSap)TestCase.getDatabase();
                FileDir = new File(sapdb.getRunDir());
            }
            catch (TestDatabaseException e) {
                MultiUserRandom.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'E', (String)("Getting RUNDIR failed! TestDatabaseException: \n" + e.getMessage()));
            }
            if (FileDir == null) {
                MultiUserRandom.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'I', (String)"No copying of autosave files possible: can't read RUNDIRECTORY; getting: null");
                return;
            }
            if (FileDir.isDirectory()) {
                String[] FileList = FileDir.list();
                int filecounter = 0;
                for (int i = 0; i < FileList.length && filecounter < 1000; ++i) {
                    File file = new File(FileDir, FileList[i]);
                    String fileName = file.getName();
                    if (!fileName.startsWith("autosave.") || this.m_alreadyCopiedAutosave.contains(fileName)) continue;
                    if (!this.mDataBackupCopied) {
                        this.copyDataBackup(FileDir);
                        this.mDataBackupCopied = true;
                        MultiUserRandom.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'I', (String)"Data backup copied ONCE!");
                        System.out.println("Data backup copied ONCE!");
                    }
                    if (!this.mFirstAutosaveFile) {
                        this.mFirstFileHadThisSize = file.length();
                        this.mFirstAutosaveFile = true;
                        MultiUserRandom.addGlobalMessage((String)"checkDirectoryAgainAndAgain()", (char)'I', (String)("Autosave files should have this size: " + this.mFirstFileHadThisSize));
                        System.out.println("Autosave files should have this size: " + this.mFirstFileHadThisSize);
                    }
                    long currentFileHasThisSize = 0L;
                    currentFileHasThisSize = file.length();
                    if (this.mFirstFileHadThisSize == currentFileHasThisSize) {
                        this.copyLockfile("create");
                        this.copyAutosaveFile(fileName, FileDir);
                        this.m_alreadyCopiedAutosave.add(fileName);
                        ++filecounter;
                        this.copyLockfile("delete");
                        continue;
                    }
                    System.out.println("Will sleep for 60 seconds to wait for autosave file with correct size!");
                    try {
                        MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (filecounter == 0) {
                    System.out.println("No new autosave file there yet!");
                }
            }
        }

        public void run() {
            this.possiblyDeleteOldAutosaveFiles();
            while (true) {
                try {
                    while (true) {
                        MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
                        this.checkDirectoryAgainAndAgain();
                        Thread.sleep(60000L);
                    }
                }
                catch (Exception e) {
                    if (!m_stop) continue;
                    return;
                }
                break;
            }
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class SavepointTimer
    implements Runnable {
        private int m_intervall = 0;
        private Thread m_thread = null;

        SavepointTimer(int intervall) {
            this.m_intervall = intervall * 1000;
            this.start();
        }

        public void run() {
            while (true) {
                block7: {
                    try {
                        MultiUserRandom.this.Sleep(this.m_thread, this.m_intervall);
                    }
                    catch (Exception e) {
                        if (!m_stop) break block7;
                        return;
                    }
                }
                Connection con = null;
                try {
                    con = MultiUserRandom.connect();
                }
                catch (Exception e) {
                    MultiUserRandom.this.Trace_1("crash : could not connect ");
                    return;
                }
                MultiUserRandom.this.Trace_1("force savepoint");
                try {
                    CallableStatement call = con.prepareCall("FORCE SAVEPOINT");
                    call.execute();
                    con.close();
                }
                catch (Exception exception) {
                }
            }
        }

        public void start() {
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }
    }

    class Updater
    extends LcTest
    implements Runnable {
        boolean keepRunning;

        Updater(int processId) throws SQLException, TestDatabaseException {
            super("updater");
            this.keepRunning = true;
            Thread t = new Thread(this);
            this.m_processId = processId;
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : starting updater ");
            try {
                this.threadConnect();
                this.runUpdater();
            }
            catch (SQLException sql_e) {
                this.setSqlError(sql_e);
            }
            catch (Exception e) {
                this.exceptionHandler(e);
            }
            finally {
                this.closeConnection();
            }
        }

        private void runUpdater() throws SQLException {
            try {
                CallableStatement call = null;
                PreparedStatement requiredBadAlloc = null;
                int loopCnt = 0;
                boolean isExceptionTest = 0 == m_testKind.compareTo("EXCEPTION");
                Random r = isExceptionTest ? new Random(13L) : new Random(m_randomStart);
                if (m_breakAtCall > 0) {
                    MultiUserRandom.this.callBreakAt(this.m_connection);
                }
                int exceptionWanted = 1;
                boolean setBadAlloc = isExceptionTest;
                Thread t = Thread.currentThread();
                int successCallCnt = 0;
                int maxSuccessCnt = 0;
                for (int ix = 0; ix < m_loopCnt && !m_stop; ++ix) {
                    boolean versionAction = false;
                    boolean transEnd = !isExceptionTest;
                    try {
                        if (m_traceLvl >= 1 && ix > 0 && 0 == ix % 100) {
                            if (isExceptionTest) {
                                MultiUserRandom.this.Trace_1("Task " + this.m_processId + " (T" + this.m_taskId + ") : " + ix + " loops executed, " + maxSuccessCnt + " successful calls");
                            } else {
                                MultiUserRandom.this.Trace_1("Task " + this.m_processId + " (T" + this.m_taskId + ") : " + ix + " loops executed");
                            }
                        }
                        if (setBadAlloc) {
                            if (null == requiredBadAlloc) {
                                requiredBadAlloc = this.m_connection.prepareCall("CALL REQUIRE_BAD_ALLOC (?)");
                            }
                            requiredBadAlloc.setInt(1, exceptionWanted);
                            MultiUserRandom.this.Trace_2("require bad alloc " + exceptionWanted);
                            this.sqlExecuteCall((CallableStatement)requiredBadAlloc);
                            setBadAlloc = false;
                        }
                        if (null == call) {
                            call = this.m_connection.prepareCall("CALL VERIFYTEST (?, ?)");
                            call.setInt(2, m_trace);
                        }
                        if (m_useVersions) {
                            boolean bl = versionAction = Math.abs(r.nextInt() % 100) <= 5;
                        }
                        if (versionAction) {
                            transEnd = this.versionAction(r);
                        } else {
                            loopCnt = 50 + Math.abs(r.nextInt() % 1000);
                            call.setInt(1, loopCnt);
                            MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : call VERIFY_TEST(" + loopCnt + ")" + " ix = " + ix);
                            this.sqlExecuteCall(call);
                            ++successCallCnt;
                        }
                        if (m_delay > 0) {
                            transEnd = true;
                        }
                        if (this.randomTransEnd(r, transEnd)) {
                            // empty if block
                        }
                        if (m_delay <= 0) continue;
                        int delay = m_delay;
                        try {
                            Thread.sleep(delay * 1000);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    catch (SQLException sql_e) {
                        boolean workRolledBack;
                        if (MultiUserRandom.this.liveCacheCold()) {
                            call = null;
                            this.reconnect();
                            continue;
                        }
                        int errorCount = m_errorCounter.Increment();
                        int cnsViews = 0;
                        if (1 == m_noOfUpdaters) {
                            cnsViews = MultiUserRandom.this.getNumberOfConsistentViews(this.m_connection);
                        }
                        boolean bl = workRolledBack = 600 == sql_e.getErrorCode() || 4135 == sql_e.getErrorCode();
                        if (0 == cnsViews && isExceptionTest && workRolledBack) {
                            if (successCallCnt < maxSuccessCnt && 1 == m_noOfUpdaters) {
                                System.out.println("sequence not reproducable");
                            }
                            if (successCallCnt > maxSuccessCnt) {
                                maxSuccessCnt = successCallCnt;
                            }
                            successCallCnt = 0;
                            if (Math.abs(r.nextInt() % 1000) < 0) {
                                this.m_connection.close();
                                System.out.println("Connection closed");
                                this.threadConnect();
                                System.out.println("Reconnected");
                                requiredBadAlloc = null;
                                call = null;
                            }
                            try {
                                MultiUserRandom.callSettings(this.m_connection, this.m_processId);
                            }
                            catch (SQLException dummy) {
                                MultiUserRandom.callSettings(this.m_connection, this.m_processId);
                            }
                            ix = 0;
                            if (m_noOfUpdaters > 1) {
                                exceptionWanted = 1 + Math.abs(r.nextInt(30000));
                            } else {
                                MultiUserRandom.callInit(this.m_connection);
                                r = new Random(13L);
                                ++exceptionWanted;
                            }
                            this.m_inVersion = false;
                            setBadAlloc = true;
                            continue;
                        }
                        throw sql_e;
                    }
                    catch (NullPointerException npe) {
                        if (m_crashEvent) {
                            call = null;
                            this.reconnect();
                            continue;
                        }
                        MultiUserRandom.this.Trace_1("unexpected NullPointerException in task " + this.m_processId);
                        if (null == call) {
                            MultiUserRandom.this.Trace_1("\u00b4call null unexpected");
                        }
                        throw npe;
                    }
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                MultiUserRandom.this.TraceError("Sql Exception " + sqle.getErrorCode());
                MultiUserRandom.this.TraceError("Sql Execption Text: " + sqle.getMessage());
                MultiUserRandom.this.handleExceptions(sqle);
                throw sqle;
            }
            catch (Exception e) {
                e.printStackTrace();
                MultiUserRandom.this.TraceError("Unknown exception in updater" + e.getClass() + " " + e.getMessage());
                MultiUserRandom.this.handleExceptions(e);
            }
            if (0 != m_sqlError) {
                SQLException ex = new SQLException(m_sqlErrorMsg, "", m_sqlError);
                throw ex;
            }
        }
    }

    class Verifier
    extends LcTest
    implements Runnable {
        Verifier(int processId) throws SQLException, TestDatabaseException {
            super("verifier");
            Thread t = new Thread(this);
            this.m_processId = processId;
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : starting verifier ");
                Thread t = Thread.currentThread();
                this.threadConnect();
                CallableStatement call = null;
                int dummy = 0;
                while (!m_stop) {
                    try {
                        if (null == call) {
                            call = this.m_connection.prepareCall("CALL VERIFY (?, ?)");
                            call.setInt(1, dummy);
                        }
                        if (this.sqlExecuteCall(call)) {
                            int objCnt = call.getInt(2);
                            MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : CALL_VERIFY : " + objCnt + " Objects found");
                        }
                        Thread.sleep(500L);
                        this.m_connection.commit();
                    }
                    catch (SQLException sql_e) {
                        if (!MultiUserRandom.this.liveCacheCold()) throw sql_e;
                        this.reconnect();
                        call = null;
                    }
                    catch (NullPointerException npe) {
                        if (m_crashEvent) {
                            this.reconnect();
                            call = null;
                            continue;
                        }
                        MultiUserRandom.this.Trace_1("unexpected NullPointerException in task " + this.m_processId);
                        if (null != call) throw npe;
                        MultiUserRandom.this.Trace_1("\u00b4call null unexpected");
                        throw npe;
                        return;
                    }
                }
            }
            catch (SQLException sql_e) {
                this.setSqlError(sql_e);
                return;
            }
            catch (Exception e) {
                this.exceptionHandler(e);
                return;
            }
            finally {
                this.closeConnection();
            }
        }
    }

    abstract class LcTest {
        Connection m_connection = null;
        int m_processId = -1;
        int m_taskId = -1;
        boolean m_inVersion = false;
        boolean m_traceFileOpen = false;
        String m_kind;
        private String m_currVersion = "DummyVersion";

        LcTest(String kind) {
            this.m_kind = kind;
        }

        private void closeVersion() throws SQLException {
            this.m_connection.commit();
            MultiUserRandom.this.Trace_2("Task " + this.m_processId + ": close version");
            CallableStatement call = this.m_connection.prepareCall("CALL CLOSE_VERSION (?)");
            call.setString(1, this.m_currVersion);
            if (this.sqlExecuteCall(call)) {
                this.m_inVersion = false;
            }
            this.m_connection.commit();
        }

        private void createVersion() throws SQLException {
            this.m_connection.commit();
            CallableStatement call = this.m_connection.prepareCall("CALL CREATE_VERSION (?)");
            call.registerOutParameter(1, 1);
            if (this.sqlExecuteCall(call)) {
                this.m_currVersion = call.getString(1);
                this.m_inVersion = true;
                MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : created version : " + this.m_currVersion);
            }
        }

        private void openVersion() throws SQLException {
            block3: {
                try {
                    this.m_connection.commit();
                    CallableStatement call = this.m_connection.prepareCall("CALL OPEN_VERSION (?)");
                    call.registerOutParameter(1, 1);
                    if (this.sqlExecuteCall(call)) {
                        this.m_currVersion = call.getString(1);
                        MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : opened version : " + this.m_currVersion);
                        this.m_inVersion = true;
                    }
                }
                catch (SQLException e) {
                    if (17 == e.getErrorCode() || e.getErrorCode() == -28532) break block3;
                    throw e;
                }
            }
        }

        private boolean dropVersion() throws SQLException {
            this.m_connection.commit();
            MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : drop version " + this.m_currVersion);
            CallableStatement call = this.m_connection.prepareCall("CALL DROP_VERSION (?)");
            call.setString(1, this.m_currVersion);
            if (this.sqlExecuteCall(call)) {
                this.m_connection.commit();
                return true;
            }
            return false;
        }

        protected void exceptionHandler(Exception e) {
            if (!m_crashEvent) {
                MultiUserRandom.this.TraceError("Unknown exception in task " + this.m_processId + "(" + this.m_kind + ") " + e.getClass() + " " + e.getMessage());
                e.printStackTrace();
                MultiUserRandom.this.handleExceptions(e);
                MultiUserRandom.abort();
            }
        }

        protected void setSqlError(SQLException e) {
            MultiUserRandom.this.TraceError("SQL Error in Task " + this.m_processId + "(" + this.m_kind + ") : " + e.getErrorCode() + " " + e.getMessage() + " " + e.getSQLState());
            MultiUserRandom.this.setGlobalSqlError(e);
        }

        protected boolean randomTransEnd(Random r, boolean transEnd) throws SQLException {
            if (transEnd && this.m_inVersion) {
                transEnd = Math.abs(r.nextInt() % 10) < 4;
            } else if (!transEnd) {
                boolean bl = transEnd = Math.abs(r.nextInt() % 10) < 3;
            }
            if (transEnd) {
                if (Math.abs(r.nextInt() % 100) < m_probCommit) {
                    MultiUserRandom.this.Trace_2("Task " + this.m_processId + ": commit");
                    this.m_connection.commit();
                } else {
                    MultiUserRandom.this.Trace_2("Task " + this.m_processId + ": rollback");
                    this.m_connection.rollback();
                }
            } else {
                MultiUserRandom.this.Trace_2("Task " + this.m_processId + ": no trans end");
            }
            return transEnd;
        }

        protected void closeConnection() {
            try {
                if (null != this.m_connection) {
                    this.m_connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MultiUserRandom.this.Trace_2("Task " + this.m_processId + this.m_kind + " : finished");
            if (this.m_kind == "verifier") {
                MultiUserRandom.this.decRunningVerifier();
            } else {
                MultiUserRandom.this.decRunningUpdater();
            }
        }

        protected void reconnect() throws SQLException {
            try {
                this.m_connection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_inVersion = false;
            this.m_connection = null;
            Thread t = Thread.currentThread();
            while (MultiUserRandom.this.liveCacheCold() && !m_stop) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception dummy) {}
            }
            try {
                this.threadConnect();
                MultiUserRandom.this.Trace_1("Reconnect(" + this.m_processId + ") (T" + this.m_taskId + ") ok");
            }
            catch (TestDatabaseException e) {
                throw new SQLException("cannot reconnect", "", -101);
            }
        }

        protected boolean sqlExecuteCall(CallableStatement call) throws SQLException {
            boolean ok = true;
            try {
                call.execute();
            }
            catch (SQLException e) {
                ok = false;
                int error = e.getErrorCode();
                switch (error) {
                    case 18: 
                    case 19: {
                        MultiUserRandom.this.Trace_2("Task " + this.m_processId + " : Schema dropped");
                        this.m_connection.commit();
                        if (this.m_inVersion && this.dropVersion()) {
                            this.m_inVersion = false;
                        }
                        if (error != 19) break;
                        try {
                            Thread t = Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (Exception dummy) {}
                        break;
                    }
                    case -28815: 
                    case -28804: {
                        if (!this.m_inVersion || !this.dropVersion()) break;
                        this.m_inVersion = false;
                        break;
                    }
                    case -51: {
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
            }
            return ok;
        }

        protected void threadConnect() throws TestDatabaseException, SQLException {
            try {
                this.m_connection = MultiUserRandom.connect();
                this.m_connection.setAutoCommit(false);
                MultiUserRandom.openTraceFile(this.m_connection);
                MultiUserRandom.callSettings(this.m_connection, this.m_processId);
                this.m_taskId = MultiUserRandom.evalTaskID(this.m_connection);
            }
            catch (Exception e) {
                this.exceptionHandler(e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean versionAction(Random r) throws SQLException {
            boolean transEnd = true;
            int action = Math.abs(r.nextInt() % 100);
            if (!this.m_inVersion) {
                if (action < 40) {
                    this.createVersion();
                    return false;
                }
                if (action < 80) {
                    this.openVersion();
                    return false;
                }
                try {
                    this.dropVersion();
                    return transEnd;
                }
                catch (SQLException e) {
                    if (-5001 == e.getErrorCode()) return transEnd;
                    throw e;
                }
            } else if (action < 70) {
                this.closeVersion();
                return transEnd;
            } else {
                if (!this.dropVersion()) return transEnd;
                this.m_inVersion = false;
            }
            return transEnd;
        }
    }

    class InterlockedCounter {
        private int m_counter = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int Increment() {
            InterlockedCounter interlockedCounter = this;
            synchronized (interlockedCounter) {
                ++this.m_counter;
                return this.m_counter;
            }
        }
    }
}

