/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DataConsistencyException;
import com.sap.sapdb.lctest.ListDescriptor;
import com.sap.sapdb.lctest.LiveCacheActor;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Date;

public class LiveCacheReader
extends LiveCacheActor {
    private int mObjectIndex;
    private int mExpectedObjectValue;
    private int mNumberOfLists = 0;
    private boolean mTwoPhaseCommit = false;

    public LiveCacheReader() {
        this.mTitle = "Reader";
    }

    public void check() throws DataConsistencyException {
        if (this.mTitle.trim().compareTo("Reader0") != 0) {
            return;
        }
        try {
            for (int i = 0; i < this.mNumberOfLists; ++i) {
                ListDescriptor fallbackList;
                ListDescriptor List2 = this.mMaster.getList(i);
                if (!this.checkList(i, List2, fallbackList = this.mMaster.getFallbackList(i))) continue;
                LiveCacheMaster.printInfo(this.mTitle, " check the livecache objects in list " + i + " ok.");
            }
        }
        catch (SQLException e) {
            throw new DataConsistencyException("Objects not accessible: " + e.getMessage());
        }
    }

    boolean checkList(int ListIndex, ListDescriptor pList, ListDescriptor pFallbackList) throws DataConsistencyException, SQLException {
        if (this.mTraceOn) {
            if (pList != null && pFallbackList == null) {
                LiveCacheMaster.printTrace(this.mTitle + ": Reading list <" + ListIndex + ">, expecting checksum:" + pList.getChecksum());
            }
            if (pList == null && pFallbackList != null) {
                LiveCacheMaster.printTrace(this.mTitle + ": Reading list <" + ListIndex + ">, expecting checksum:" + pFallbackList.getChecksum());
            }
            if (pList != null && pFallbackList != null) {
                LiveCacheMaster.printTrace(this.mTitle + ": Reading list <" + ListIndex + ">, expecting checksum:" + pList.getChecksum());
            }
        }
        try {
            if (this.mConnection.isClosed()) {
                this.mConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                this.mStatement = new TestStatement(null, this.mConnection);
                this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
                this.mStatement.execute("CALL CLASS_REGISTER");
                this.mConnection.commit();
            }
        }
        catch (TestDatabaseException e) {
            System.out.println(e.getMessage());
        }
        if (pList == null && pFallbackList != null && !this.mTwoPhaseCommit) {
            int NumberOfObjects;
            int Checksum;
            CallableStatement stm;
            try {
                LiveCacheMaster.printTrace(this.mTitle + ": Reading fallbacklist <" + ListIndex + ">, expecting checksum: " + pFallbackList.getChecksum());
                stm = this.mConnection.prepareCall("CALL LIST_READ(?,?,?)");
                stm.setBytes(1, pFallbackList.getRootOid().getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                stm.execute();
                Checksum = stm.getInt(2);
                NumberOfObjects = stm.getInt(3);
            }
            catch (Exception ex) {
                LiveCacheMaster.printInfo(this.mTitle, "ERROR in Check during CALL LIST_READ, list was probably dropped: " + ex.getMessage() + "\n If list is dropped (\"too old oid\"), it is ok!");
                return true;
            }
            this.mMaster.addMessage(this.mTitle, 'W', "Using fallback list for data check.");
            if (pFallbackList.getChecksum() != Checksum || pFallbackList.getNumberOfObjects() != NumberOfObjects) {
                LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting <" + pFallbackList.getChecksum() + "," + pFallbackList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
                throw new DataConsistencyException("Expecting <" + pFallbackList.getChecksum() + "," + pFallbackList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
            }
            stm.close();
            return true;
        }
        if (pList != null && pFallbackList != null && !this.mTwoPhaseCommit) {
            int NumberOfObjects;
            int Checksum;
            CallableStatement stm;
            try {
                LiveCacheMaster.printTrace(this.mTitle + ": Reading list <" + ListIndex + ">, expecting checksum: " + pList.getChecksum() + " or " + pFallbackList.getChecksum());
                stm = this.mConnection.prepareCall("CALL LIST_READ(?,?,?)");
                stm.setBytes(1, pList.getRootOid().getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                stm.execute();
                Checksum = stm.getInt(2);
                NumberOfObjects = stm.getInt(3);
            }
            catch (Exception ex) {
                CallableStatement stm2 = this.mConnection.prepareCall("CALL LIST_READ(?,?,?)");
                stm2.setBytes(1, pFallbackList.getRootOid().getOmsOid());
                stm2.registerOutParameter(2, 4);
                stm2.registerOutParameter(3, 4);
                stm2.execute();
                int Checksum2 = stm2.getInt(2);
                int NumberOfObjects2 = stm2.getInt(3);
                if (pFallbackList.getChecksum() != Checksum2 || pFallbackList.getNumberOfObjects() != NumberOfObjects2) {
                    LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting <" + pList.getChecksum() + "," + pList.getNumberOfObjects() + ">, but found <" + Checksum2 + "," + NumberOfObjects2 + ">");
                    throw new DataConsistencyException("Expecting <" + pList.getChecksum() + "," + pList.getNumberOfObjects() + ">, but found <" + Checksum2 + "," + NumberOfObjects2 + ">");
                }
                stm2.close();
                return true;
            }
            if (pList.getChecksum() != Checksum || pList.getNumberOfObjects() != NumberOfObjects) {
                stm = this.mConnection.prepareCall("CALL LIST_READ(?,?,?)");
                stm.setBytes(1, pFallbackList.getRootOid().getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                stm.execute();
                Checksum = stm.getInt(2);
                NumberOfObjects = stm.getInt(3);
                if (pFallbackList.getChecksum() != Checksum || pFallbackList.getNumberOfObjects() != NumberOfObjects) {
                    LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting <" + pList.getChecksum() + "," + pList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
                    throw new DataConsistencyException("Expecting <" + pList.getChecksum() + "," + pList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
                }
                stm.close();
                return true;
            }
            stm.close();
            return true;
        }
        if (pList == null && this.mTwoPhaseCommit) {
            LiveCacheMaster.printInfo(this.mTitle, "Reading list <" + ListIndex + ">; expecting nothing, because list should be dropped.");
            return true;
        }
        if (pList != null && this.mTwoPhaseCommit) {
            CallableStatement stm = this.mConnection.prepareCall("CALL LIST_READ(?,?,?)");
            stm.setBytes(1, pList.getRootOid().getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, 4);
            stm.execute();
            int Checksum = stm.getInt(2);
            int NumberOfObjects = stm.getInt(3);
            if (pList.getChecksum() != Checksum || pList.getNumberOfObjects() != NumberOfObjects) {
                LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting <" + pList.getChecksum() + "," + pList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
                throw new DataConsistencyException("Expecting <" + pList.getChecksum() + "," + pList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
            }
            stm.close();
            return true;
        }
        return true;
    }

    public int getActorType() {
        return 2;
    }

    protected int nextAction() {
        switch (this.mAction) {
            case 0: {
                this.mAction = 1;
                break;
            }
            case 1: {
                this.mAction = 2;
                break;
            }
            case 2: {
                this.mAction = 3;
                break;
            }
            case 3: {
                this.mAction = 1;
            }
        }
        return this.mAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int CurrentCycle = 0;
        int ListIndex = 0;
        int CurrentLoop = 0;
        boolean KeepRunning = true;
        ListDescriptor mList = null;
        this.mRunning = true;
        try {
            block21: while (KeepRunning) {
                this.mAction = this.nextAction();
                if (CurrentLoop % LiveCacheMaster.mTraceLoops == 0) {
                    LiveCacheMaster.printInfo(this.mTitle, "Starting cycle " + CurrentLoop);
                }
                ++CurrentLoop;
                switch (this.mAction) {
                    case 1: {
                        ListIndex = LiveCacheReader.randomInteger(0, this.mNumberOfLists - 1);
                        if (this.mTraceOn) {
                            LiveCacheMaster.printTrace(this.mTitle + ": trying to open a Consistent view for list <" + ListIndex + ">");
                        }
                        CallableStatement stm = this.mConnection.prepareCall("CALL LIST_CONSISTENT(?)");
                        Boolean SyncObject = this.mMaster.getSyncObject(ListIndex);
                        try {
                            Boolean bl = SyncObject;
                            synchronized (bl) {
                                mList = this.mMaster.getList(ListIndex);
                                if (mList == null || mList.isInProgress()) {
                                    if (this.mTraceOn) {
                                        LiveCacheMaster.printTrace(this.mTitle + ": list <" + ListIndex + "> still inexistent or in progress");
                                    }
                                    this.mAction = 3;
                                    break;
                                }
                                stm.setBytes(1, mList.getRootOid().getOmsOid());
                                stm.execute();
                            }
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == -28815) {
                                LiveCacheMaster.printInfo(this.mTitle, "Consistent View of List " + ListIndex + " too old");
                                this.mAction = 3;
                                continue block21;
                            }
                            if (this.mShouldStop && (e.getErrorCode() == -708 || e.getErrorCode() == -700 || e.getErrorCode() == -904 || e.getErrorCode() == -907)) {
                                LiveCacheMaster.printInfo(this.mTitle, "Consistent View of List " + ListIndex + " too old");
                                this.mAction = 3;
                                continue block21;
                            }
                            throw e;
                        }
                        if (!this.mTraceOn) break;
                        LiveCacheMaster.printTrace(this.mTitle + ": Consistent end; checksum:" + mList.getChecksum());
                        break;
                    }
                    case 2: {
                        if (this.mTraceOn) {
                            LiveCacheMaster.printTrace(this.mTitle + ": Reading list <" + ListIndex + ">, expecting checksum:" + mList.getChecksum());
                        }
                        CallableStatement stm = this.mConnection.prepareCall("CALL LIST_READ(?,?,?)");
                        stm.setBytes(1, mList.getRootOid().getOmsOid());
                        stm.registerOutParameter(2, 4);
                        stm.registerOutParameter(3, 4);
                        try {
                            stm.execute();
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == -28815) {
                                LiveCacheMaster.printInfo(this.mTitle, "Consistent View of List " + ListIndex + " too old");
                                this.mAction = 3;
                                continue block21;
                            }
                            throw e;
                        }
                        int Checksum = stm.getInt(2);
                        int NumberOfObjects = stm.getInt(3);
                        if (mList.getChecksum() != Checksum || mList.getNumberOfObjects() != NumberOfObjects) {
                            LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR ** Consistency error: Expecting <" + mList.getChecksum() + "," + mList.getNumberOfObjects() + ">, but found <" + Checksum + "," + NumberOfObjects + ">");
                            KeepRunning = false;
                        }
                        stm.close();
                        break;
                    }
                    case 3: {
                        this.mConnection.commit();
                        ++CurrentCycle;
                    }
                }
                LiveCacheReader.sleep(25L);
                if (this.mCycleNumber != -1 && CurrentCycle > this.mCycleNumber) {
                    LiveCacheMaster.printTrace(this.mTitle + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                    KeepRunning = false;
                    this.setStatus(1);
                }
                if (!this.mShouldStop) continue;
                LiveCacheMaster.printTrace(this.mTitle + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                KeepRunning = false;
                this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
            }
        }
        catch (SQLException e) {
            if (this.mShouldStop && (e.getErrorCode() == -708 || e.getErrorCode() == -700 || e.getErrorCode() == -904 || e.getErrorCode() == -907)) {
                LiveCacheMaster.printTrace(this.mTitle + ": Exception but soft interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                KeepRunning = false;
                this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles (in exception)");
            } else {
                LiveCacheMaster.printTrace(this.mTitle + ": Raising exception " + e.getMessage());
                this.setStatus(-2, "SQLException: " + e.getMessage());
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                System.err.println("last action of " + this.mTitle + ": " + this.mAction + " on " + mDateFormat.format(new Date()));
                System.err.println("sql-error-trace:\n" + sw.toString());
            }
        }
        catch (InterruptedException e) {
            LiveCacheMaster.printTrace(this.mTitle + ": Hard interrupted");
            this.setStatus(2);
        }
        catch (Exception e) {
            LiveCacheMaster.printTrace(this.mTitle + ": ** ERROR **  General exception: " + e.getMessage());
            this.setStatus(-3, "Exception: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            super.cleanup();
        }
        this.mRunning = false;
        LiveCacheMaster.printTrace(this.mTitle + ": Terminating");
    }

    public void setMaster(LiveCacheMaster newMaster) throws TestDatabaseException, SQLException {
        super.setMaster(newMaster);
        this.mTraceOn = this.mMaster.isTraceOn();
        this.mNumberOfLists = TestCase.getParameterInt((String)"NumberOfLists", (int)1);
        this.mTwoPhaseCommit = TestCase.getParameterBoolean((String)"TwoPhaseCommit", (boolean)false);
    }
}

