/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DataConsistencyException;
import com.sap.sapdb.lctest.LiveCacheActor;
import com.sap.sapdb.lctest.LiveCacheMaster;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.sql.SQLException;
import java.util.Date;

class LiveCacheKiller
extends LiveCacheActor {
    private static int mShutdownDistance;
    private static int mHardShutdownPercentage;

    public LiveCacheKiller() {
        this.mTitle = "Killer";
    }

    public void check() throws DataConsistencyException {
    }

    public int getActorType() {
        return 3;
    }

    protected int nextAction() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean CurrentCycle = false;
        boolean KeepRunning = true;
        this.mRunning = true;
        long NextShutdownTime = new Date().getTime() + (long)(mShutdownDistance * 60000);
        if (mShutdownDistance == -1) {
            this.setStatus(1);
            return;
        }
        try {
            this.setStatus(5);
            while (KeepRunning) {
                if (new Date().getTime() > NextShutdownTime) {
                    NextShutdownTime = new Date().getTime() + (long)mShutdownDistance;
                    this.setStatus(4);
                    LiveCacheMaster.printInfo(this.mTitle, "Shutdown with 'db_stop -dump'!");
                    TestCase.getDatabase().executeDBMcmd("db_stop -dump");
                    this.setStatus(3);
                    KeepRunning = false;
                }
                LiveCacheKiller.sleep(500L);
                if (!KeepRunning || !this.mShouldStop) continue;
                KeepRunning = false;
                this.setStatus(2);
            }
        }
        catch (TestDatabaseException e) {
            this.setStatus(-3, "TestDatabaseException: " + e.getMessage());
        }
        catch (InterruptedException e) {
            this.setStatus(2, "InterruptedException: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.setStatus(-3, "Exception: " + e.getMessage());
        }
        finally {
            super.cleanup();
        }
        this.mRunning = false;
        if (this.mTraceOn) {
            LiveCacheMaster.printTrace(this.mTitle + ": Terminating");
        }
    }

    public void setMaster(LiveCacheMaster newMaster) throws TestDatabaseException, SQLException {
        super.setMaster(newMaster);
        mShutdownDistance = TestCase.getParameterInt((String)"ShutdownDistance", (int)5);
        mHardShutdownPercentage = TestCase.getParameterInt((String)"HardShutdownPercentage", (int)50);
    }
}

