/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class LcDiscoTest
extends TestCase {
    private static final int DBERR_DUPLICATE_NAME = -6006;
    private static final String sUser = "LcDisco";
    private static final String sPassword = "LcDisco";
    private DBM mDBMan = null;

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = LcDiscoTest.getDatabase().getHost();
            mName = LcDiscoTest.getDatabase().getName();
            int mPort = LcDiscoTest.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON " + LcDiscoTest.getDatabase().getDBMUser() + "," + LcDiscoTest.getDatabase().getDBMPassword();
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void Trace(boolean consoleMsg, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        LcDiscoTest.addGlobalMessage((String)"", (char)'I', (String)msg);
    }

    private static void callTestWithoutParms(TestStatement Statement2, String ProcedureName) throws TestCaseException {
        String CallString = "";
        try {
            CallString = "CALL " + ProcedureName;
            Statement2.execute(CallString);
        }
        catch (SQLException e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    public static void createPackageWithFile(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        String CallString = "";
        String CreationMode = "INPROC";
        try {
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " FILE '" + PackageIdentifier + "' " + CreationMode;
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getLocalizedMessage());
        }
    }

    private static void createProc(TestStatement Statement2, String ProcedureName, String PackageName) throws TestCaseException {
        String CallString = "";
        try {
            CallString = "CREATE DBPROC " + ProcedureName + " IN " + PackageName + " EXECUTE INPROC";
            Statement2.execute(CallString);
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        String pkg = "LCDISCO_PACKAGE";
        try {
            con = LcDiscoTest.getDatabase().connect("LcDisco", "LcDisco");
            stmt = new TestStatement(null, con);
            LcDiscoTest.createPackageWithFile(stmt, pkg, "lcdisco");
            LcDiscoTest.createProc(stmt, "LCDISCO_TEST1", pkg);
            LcDiscoTest.createProc(stmt, "LCDISCO_TEST2", pkg);
            LcDiscoTest.createProc(stmt, "LCDISCO_TEST3", pkg);
            LcDiscoTest.createProc(stmt, "LCDISCO_TEST4", pkg);
            LcDiscoTest.createProc(stmt, "LCDISCO_TEST5", pkg);
            con.commit();
        }
        catch (Exception e) {
            LcDiscoTest.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("LcDiscoTest.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            block13: {
                lDefConnection = LcDiscoTest.getDatabase().connect(LcDiscoTest.getUser(), LcDiscoTest.getPassword());
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                lDefTstmt.executeUpdate("drop user LcDisco");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user LcDisco password LcDisco dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block13;
                    LcDiscoTest.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : LcDisco not possible");
                    throw e;
                }
            }
            LcDiscoTest.createDBProcedures();
        }
        catch (Exception e) {
            LcDiscoTest.handleGlobalExceptions((Exception)e);
        }
        finally {
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block8: {
            Connection lConnection = null;
            Object lConnection2 = null;
            TestStatement lTstmt = null;
            Object lTstmt2 = null;
            Object lTPstmt = null;
            lConnection = LcDiscoTest.getDatabase().connect("LcDisco", "LcDisco");
            lTstmt = new TestStatement((TestCase)this, lConnection);
            LcDiscoTest.callTestWithoutParms(lTstmt, "LCDISCO_TEST1");
            LcDiscoTest.callTestWithoutParms(lTstmt, "LCDISCO_TEST2");
            LcDiscoTest.callTestWithoutParms(lTstmt, "LCDISCO_TEST3");
            LcDiscoTest.callTestWithoutParms(lTstmt, "LCDISCO_TEST4");
            LcDiscoTest.callTestWithoutParms(lTstmt, "LCDISCO_TEST5");
            lTstmt.execute("COMMIT");
            Object var8_6 = null;
            try {
                lTstmt.close();
                lTPstmt.close();
                lConnection.close();
                LcDiscoTest.Trace(true, "restart DB kernel");
                this.executeDBMCmd("db_restart");
            }
            catch (Exception e2) {}
            break block8;
            {
                catch (Exception e) {
                    this.handleExceptions(e);
                    Object var8_7 = null;
                    try {
                        lTstmt.close();
                        lTPstmt.close();
                        lConnection.close();
                        LcDiscoTest.Trace(true, "restart DB kernel");
                        this.executeDBMCmd("db_restart");
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    lTstmt.close();
                    lTPstmt.close();
                    lConnection.close();
                    LcDiscoTest.Trace(true, "restart DB kernel");
                    this.executeDBMCmd("db_restart");
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

