/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.StringTokenizer;

public class BackupRestoreLog1
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.2";
    private Connection mConnection = null;
    private TestStatement stmt = null;
    private static int mTraceLevel;
    private static int mWorkOnDatabase;
    private static int mLoops;
    private DBM mDBMan = null;
    private String sString = null;
    private int i = 0;
    private int j = 0;
    private boolean indexExists = false;
    private Random r = new Random();
    private int rand = 0;
    private int expectedLogSaves = 0;
    private String[] LogSaves;
    private String checkValues = null;
    private String mKernelMode = "FAST";

    public static String getTestClassId() {
        return "BackupRestoreLog1";
    }

    public static String getMinimumRelease() {
        return "7.4.1.*";
    }

    public static void prepare() throws TestCaseException {
        BackupRestoreLog1.readAndPrintParameters();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            BackupRestoreLog1.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            BackupRestoreLog1.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    protected static void readAndPrintParameters() throws TestCaseException {
        int defaultValue = 10;
        mTraceLevel = BackupRestoreLog1.getParameterInt((String)"TraceLevel", (int)2);
        mWorkOnDatabase = BackupRestoreLog1.getParameterInt((String)"WorkOnDatabase", (int)1000);
        mLoops = BackupRestoreLog1.getParameterInt((String)"Loops", (int)2);
        BackupRestoreLog1.printInfo(1, "\n" + BackupRestoreLog1.getTestClassId(), "Starting " + BackupRestoreLog1.getTestClassId() + " Test - Version: " + sVersion + "\n");
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Parameter: TraceLevel        = " + mTraceLevel);
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Parameter: WorkonDatabase    = " + mWorkOnDatabase + " cycles");
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Parameter: Loops             = " + mLoops + " loops");
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        BackupRestoreLog1.printInfo(5, BackupRestoreLog1.getTestClassId(), "executeDBMCmd: " + pCmd);
        try {
            mHost = BackupRestoreLog1.getDatabase().getHost();
            mName = BackupRestoreLog1.getDatabase().getName();
            int mPort = BackupRestoreLog1.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private void recoverData() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("recover_start lcrecover03dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void recoverLog() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        String firstLogSaveNumber = this.LogSaves[0].substring(this.LogSaves[0].indexOf(".") + 1, this.LogSaves[0].length());
        this.executeDBMCmd("recover_start lcrecover03log LOG " + firstLogSaveNumber);
        for (int lo = 1; lo < this.expectedLogSaves; ++lo) {
            this.executeDBMCmd("recover_replace lcrecover03log " + this.LogSaves[lo]);
        }
        this.executeDBMCmd("recover_ignore");
        this.executeDBMCmd("util_release");
    }

    private void restartDatabaseCold() throws TestCaseException, SQLException, TestDatabaseException {
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Restart");
        this.executeDBMCmd("db_offline");
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        this.executeDBMCmd("util_execute clear log");
    }

    private void startUp() throws TestCaseException, SQLException, TestDatabaseException {
        this.mConnection = BackupRestoreLog1.getDatabase().connect(BackupRestoreLog1.getUser(), BackupRestoreLog1.getPassword());
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        TestDatabaseSap sapdb = (TestDatabaseSap)BackupRestoreLog1.getDatabase();
        this.mKernelMode = sapdb.getKernelMode();
        this.executeDBMCmd("autosave_off");
        this.executeDBMCmd("util_connect");
        if (!TestDriver.compareRelease((String)((TestDatabaseSap)BackupRestoreLog1.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
            this.executeDBMCmd("util_execute diagnose vtrace check 'log' on");
        }
        this.executeDBMCmd("util_release");
    }

    private void checkBackUpState() throws SQLException, TestDatabaseException {
        String[] szLines = new String[200];
        int nCurrent = 0;
        String[] tempArray = new String[100];
        int tempArrayInt = 0;
        String szBuffer = this.executeDBMCmd("backup_history_list -c KEY -m -r LAST");
        String dummy = "";
        BackupRestoreLog1.printInfo(4, BackupRestoreLog1.getTestClassId(), "DBM command: 'backup_history_list -c KEY -m -r LAST' returns:\n" + szBuffer);
        StringTokenizer stBuffer = new StringTokenizer(szBuffer);
        while (stBuffer.hasMoreTokens()) {
            dummy = stBuffer.nextToken("\n");
            if (!dummy.startsWith("M:") || dummy.indexOf("YES") == -1) continue;
            StringTokenizer singleLine = new StringTokenizer(dummy);
            int lastElementOfSingleLine = singleLine.countTokens();
            while (singleLine.hasMoreTokens()) {
                tempArray[tempArrayInt++] = singleLine.nextToken("|");
            }
            szLines[nCurrent++] = tempArray[lastElementOfSingleLine];
            tempArray = new String[100];
            tempArrayInt = 0;
        }
        this.LogSaves = szLines;
        for (int z = 0; z < 200; ++z) {
            if (this.LogSaves[z] == null) continue;
            BackupRestoreLog1.printInfo(4, BackupRestoreLog1.getTestClassId(), "LogSaves[" + z + "] = " + this.LogSaves[z]);
        }
        if (this.LogSaves[0] == null) {
            this.addMessage(BackupRestoreLog1.getTestClassId(), 'E', "Can not read the last log saves by using the statement \"backup_history_list -c KEY -m -r LAST\"");
            this.addMessage(BackupRestoreLog1.getTestClassId(), 'I', "get:\n" + szBuffer);
            throw new TestDatabaseException("Can not read the last log saves.");
        }
    }

    private void checkState() throws SQLException, TestDatabaseException {
        ResultSet rs = null;
        this.mConnection = BackupRestoreLog1.getDatabase().connect(BackupRestoreLog1.getUser(), BackupRestoreLog1.getPassword());
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        if (this.checkValues == null) {
            this.checkValues = "";
            this.checkValues = this.checkValues + "Eintr\u00e4ge laut Java in der Tabelle: " + this.j + "\n";
            this.sString = "Select count(*) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\" -> ";
            this.checkValues = this.checkValues + rs.getInt(1) + "\n";
            this.sString = "Select * from TT_LOG WHERE PRIMKEY > " + (this.j - 10);
            rs = this.stmt.executeQuery(this.sString);
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\"\n";
            this.checkValues = this.checkValues + "PrimKey \t Name \t\t PersNr\t Adresse\n";
            while (rs.next()) {
                this.checkValues = this.checkValues + " " + rs.getInt(1) + " ";
                this.checkValues = this.checkValues + "\t\t " + rs.getString(2) + " ";
                this.checkValues = this.checkValues + "\t  " + rs.getInt(3) + " ";
                this.checkValues = this.checkValues + "\t  " + rs.getString(4) + "\n";
            }
            this.sString = "Select SUM(PRIMKEY) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            this.checkValues = this.checkValues + "Result of \"" + this.sString + "\" -> ";
            this.checkValues = this.checkValues + rs.getInt(1) + "\n";
        } else {
            String dummy = "";
            dummy = dummy + "Eintr\u00e4ge laut Java in der Tabelle: " + this.j + "\n";
            this.sString = "Select count(*) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            dummy = dummy + "Result of \"" + this.sString + "\" -> ";
            dummy = dummy + rs.getInt(1) + "\n";
            this.sString = "Select * from TT_LOG WHERE PRIMKEY > " + (this.j - 10);
            rs = this.stmt.executeQuery(this.sString);
            dummy = dummy + "Result of \"" + this.sString + "\"\n";
            dummy = dummy + "PrimKey \t Name \t\t PersNr\t Adresse\n";
            while (rs.next()) {
                dummy = dummy + " " + rs.getInt(1) + " ";
                dummy = dummy + "\t\t " + rs.getString(2) + " ";
                dummy = dummy + "\t  " + rs.getInt(3) + " ";
                dummy = dummy + "\t  " + rs.getString(4) + "\n";
            }
            this.sString = "Select SUM(PRIMKEY) from TT_LOG";
            rs = this.stmt.executeQuery(this.sString);
            rs.next();
            dummy = dummy + "Result of \"" + this.sString + "\" -> ";
            dummy = dummy + rs.getInt(1) + "\n";
            if (this.checkValues.compareTo(dummy) != 0) {
                BackupRestoreLog1.addGlobalMessage((String)BackupRestoreLog1.getTestClassId(), (char)'E', (String)("***** ERROR ****** \nwrong table content --> expecting:\n" + this.checkValues + "\ngetting:\n" + dummy));
            }
        }
        this.stmt.close();
    }

    private void createTable() throws TestCaseException, SQLException {
        this.sString = "DROP INDEX TT_LOG_IND1";
        BackupRestoreLog1.printInfo(5, BackupRestoreLog1.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "DROP TABLE TT_LOG";
        BackupRestoreLog1.printInfo(5, BackupRestoreLog1.getTestClassId(), this.sString);
        this.stmt.executeUpdateIgnoreErrors(this.sString);
        this.sString = "CREATE TABLE TT_LOG(PRIMKEY INTEGER PRIMARY KEY, NAME CHAR(3000), PERSNR INTEGER, ADRESSE VARCHAR(2000) )";
        BackupRestoreLog1.printInfo(5, BackupRestoreLog1.getTestClassId(), this.sString);
        this.stmt.executeUpdate(this.sString);
        this.mConnection.commit();
    }

    private void createBackUpMedium() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_media_put lcrecover03log lcrecover03log FILE LOG");
        this.executeDBMCmd("backup_media_put lcrecover03dat lcrecover03dat FILE DATA 0 8 YES NO ");
        this.executeDBMCmd("util_release");
    }

    private void backUpData() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Backup_save DATA");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcrecover03dat DATA");
        this.executeDBMCmd("util_release");
    }

    private void backUpLogWarm() throws TestCaseException, SQLException, TestDatabaseException {
        this.setStatus("createBackup");
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Backup_save LOG");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcrecover03log LOG");
        this.executeDBMCmd("util_release");
        ++this.expectedLogSaves;
    }

    private void backUpLogCold() throws TestCaseException, SQLException, TestDatabaseException {
        this.executeDBMCmd("db_cold -" + this.mKernelMode);
        this.setStatus("createBackup");
        BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Backup_save LOG");
        this.executeDBMCmd("util_connect");
        this.executeDBMCmd("backup_save lcrecover03log LOG");
        this.executeDBMCmd("util_release");
        ++this.expectedLogSaves;
    }

    private void workOnTheDatabase() throws TestCaseException, SQLException, TestDatabaseException {
        this.workOnTheDatabase(-1);
    }

    private void workOnTheDatabase(int loopCounter) throws TestCaseException, SQLException, TestDatabaseException {
        this.mConnection = BackupRestoreLog1.getDatabase().connect(BackupRestoreLog1.getUser(), BackupRestoreLog1.getPassword());
        this.stmt = new TestStatement((TestCase)this, this.mConnection);
        if (mWorkOnDatabase <= 0) {
            return;
        }
        if (loopCounter != -1) {
            BackupRestoreLog1.printInfo(4, BackupRestoreLog1.getTestClassId(), "Working with data in the database ( " + loopCounter + " )...");
        } else {
            BackupRestoreLog1.printInfo(2, BackupRestoreLog1.getTestClassId(), "Working with data in the database...");
        }
        this.i = 1;
        while (this.i <= mWorkOnDatabase) {
            this.rand = Math.abs(this.r.nextInt() % 100) + 1;
            if (this.rand < 50) {
                ++this.j;
                String longAdress = "24";
                for (int lz = 0; lz < 1000; ++lz) {
                    this.rand = Math.abs(this.r.nextInt() % 9) + 1;
                    longAdress = longAdress + "" + this.rand;
                }
                this.sString = "INSERT INTO TT_LOG VALUES(" + this.j + ", 'name " + this.j + "', " + this.j * 2 + " , 'adresse " + this.j + " No.: " + longAdress + "')";
                BackupRestoreLog1.printInfo(7, BackupRestoreLog1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
                this.mConnection.commit();
            }
            if (this.rand >= 50 && this.rand < 90 && this.j > 3) {
                int newRand = Math.abs(this.r.nextInt() % this.j) + 1;
                this.sString = "UPDATE TT_LOG SET PERSNR = " + this.j * newRand + " WHERE PRIMKEY = " + newRand;
                BackupRestoreLog1.printInfo(7, BackupRestoreLog1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
                this.mConnection.commit();
            }
            if (this.rand >= 90 && this.rand < 100 && this.j > 50) {
                this.sString = "DELETE FROM TT_LOG WHERE PRIMKEY = " + this.j;
                BackupRestoreLog1.printInfo(7, BackupRestoreLog1.getTestClassId(), this.sString);
                this.stmt.execute(this.sString);
                this.mConnection.commit();
                --this.j;
            }
            if (this.rand >= 100) {
                if (this.indexExists) {
                    this.sString = "DROP INDEX TT_LOG_IND1";
                    this.stmt.execute(this.sString);
                    this.mConnection.commit();
                    this.indexExists = false;
                }
                this.sString = "CREATE INDEX TT_LOG_IND1 ON TT_LOG (PERSNR)";
                this.stmt.execute(this.sString);
                this.mConnection.commit();
                this.indexExists = true;
            }
            if (this.i % 100 == 0) {
                this.mConnection.commit();
            }
            ++this.i;
        }
        this.mConnection.commit();
    }

    public void run() {
        try {
            this.setStatus("startUp");
            this.startUp();
            this.setStatus("createBackUpMedium");
            this.createBackUpMedium();
            this.setStatus("createTable");
            this.createTable();
            this.setStatus("BackUp DATA");
            this.backUpData();
            this.setStatus("Work on Database");
            this.workOnTheDatabase();
            this.setStatus("BackUp LOG Cold");
            this.backUpLogCold();
            this.executeDBMCmd("db_warm -" + this.mKernelMode);
            for (int loop = 1; loop < mLoops + 1; ++loop) {
                this.setStatus("Work on Database");
                this.workOnTheDatabase(loop);
                this.setStatus("BackUp LOG warm");
                this.backUpLogWarm();
                this.setStatus("Work on Database");
                this.workOnTheDatabase(loop);
                this.setStatus("BackUp LOG Cold");
                this.backUpLogCold();
                this.executeDBMCmd("db_warm -" + this.mKernelMode);
            }
            this.setStatus("Check State");
            this.checkState();
            this.setStatus("Restart Database");
            this.restartDatabaseCold();
            this.checkBackUpState();
            this.setStatus("Recover Data");
            this.recoverData();
            this.setStatus("Recover LOG");
            this.recoverLog();
            this.setStatus("Check State");
            this.checkState();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            BackupRestoreLog1.addGlobalMessage((String)BackupRestoreLog1.getTestClassId(), (char)'E', (String)("Exception: " + e.getClass() + " " + e.getMessage()));
            BackupRestoreLog1.addGlobalMessage((String)BackupRestoreLog1.getTestClassId(), (char)'T', (String)("Trace: " + sw.toString()));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    static {
        mWorkOnDatabase = 0;
        mLoops = 0;
    }
}

