/*
 * Created on 06.04.2005
 *
 */
package com.sap.sapdb.DBMTest.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import com.sap.sapdb.testframe.driver.TestProtocol;
import com.sap.sapdb.testframe.testcase.TestCase;

/**
 * @author d025561
 *
 * MarcW's StreamReader class for everybody 
 */
public class StreamReader extends Thread
{
	private InputStream m_Stream = null;
	private ByteArrayOutputStream m_BOS = new ByteArrayOutputStream();
	private byte[] m_Data = new byte[1024];
	
	private boolean m_IsStopped = false;
	
	private TestCase m_testCase=null;

	public void stopReading() {
		m_IsStopped = true;
	}
	
	public StreamReader( InputStream stream, TestCase testCase ) {
		m_Stream = stream;
		m_testCase=testCase;
	}
	
	public void run() {
		int byteCount;
		try {
			while ((byteCount = m_Stream.read(m_Data, 0, m_Data.length)) > -1) {
                m_BOS.write(m_Data, 0, byteCount);
                if( m_IsStopped )
                	return;
            }
		}
		catch( IOException ioe ) {
            m_testCase.addMessage(
                    "error reading stream " + m_Stream.toString(),
                    TestProtocol.TRACE,
                    "something went wrong...",
                    ioe);
		}
	}

	public String getData() {
		if( m_BOS.size() == 0 )
			return "(no data)";
		else
			return m_BOS.toString();
	}

}
