package com.sap.sapdb.DBMTest;
/*!
  -----------------------------------------------------------------------------
  module: ParamDirectdel.java
  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
import java.sql.*;
import com.sap.sapdb.testframe.driver.*;
import java.util.*;

/**
 * DBMServer
 * <xmp>
 * -----------------------------------------------------------------------------
 * Class:        ParamDirectdel
 * -----------------------------------------------------------------------------
 * responsible:  ChristianH
 * special area: DBMServer Java Test
 * description:  DBMServer param_directdel command tests
 * version:      7.4.*
 * copyright:    (c) 2002-2004 SAP AG
 * -----------------------------------------------------------------------------
 * </xmp>
 */

public class ParamDirectdel extends BackupState
{
  private Vector ParamLabel;

  public ParamDirectdel() throws SQLException, TestDatabaseException
  {
    super();

    ParamLabel = new Vector();
  }
  /**
   * run() contains the test implementation
   */
  public void run()
  {
    DBMUtility oDBM         = new DBMUtility(getDatabase(), this);
    //  create one global try-catch block to handle exceptions
    try
    {
      //Too few parameter
      oDBM.execCmd("param_directdel", DBMUtility.ERR_TOFEWPARAM);
      //With param session
      oDBM.execCmd("param_startsession", DBMUtility.OK_OK);
      oDBM.execCmd("param_directdel KERNELVERSION", DBMUtility.ERR_XPSESSION);
      oDBM.execCmd("param_abortsession", DBMUtility.OK_OK);
      //Without param session
      oDBM.execCmd("param_directdel KERNELVERSION", DBMUtility.OK_OK);

      //Restoring param file
      oDBM.execCmd("param_directgetall", DBMUtility.OK_OK, false);
      String param = oDBM.getAnswer();

      //Creating vector for label
      Vector ParamArray = new Vector();

      StringTokenizer st_param = new StringTokenizer(param,"\n");
      while (st_param.hasMoreTokens())
      {
        StringTokenizer st_st = new StringTokenizer(st_param.nextToken(),"\t");
        while (st_st.hasMoreTokens())
        {
          ParamArray.add(st_st.nextToken());
        }
      }
      //Searching for 'KERNELVERSION'
      boolean param_found = true;
      //Checking the gotten label string
      for (int i = 0;i < ParamLabel.size(); i++) {
        if (ParamArray.get(i).toString().equals("KERNELVERSION")) {
          param_found = false;
        } else {
          param_found = true;
        }
      }
      //Message to test protocol
      if (param_found == true) {
        addMessage(this.toString() + ".run",
                   TestProtocol.INFO,
                   "Parameter 'KERNELVERSION' not found in label.\n"+param);
      } else {
        addMessage(this.toString() + ".run",
                   TestProtocol.ERROR,
                   "Parameter 'KERNELVERSION' found in label.\n"+param);
      }

      //Restoring param file
      oDBM.execCmd("param_restore 1", DBMUtility.OK_OK);
    }
    // catch any kind of exception and write it to the protocol
    catch (Exception e) {
      // standard error handler

      this.handleExceptions(e);
    } // end try catch

    // clean up, i.e. close statements and connections
    finally {
      try {
        // print all parameters from the parameter object to the protocol.
        printParametersToProtocol();
      }
      catch (Exception e) {
        // do nothing
      } // end try catch
    } // end finally
  } // end run
  /**
   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
   * will set the name to the name of the java class. To make the test name independend
   * from the java implementation, this method should return a unique string.
   * Attention: The uniqueness is not automatically checked by anybody.
   * @return The UNIQUE name of the test class
   */
  public static String getTestClassId() {
    return "ParamDirectdel";
  } // end getTestClassId
} //end of class MediumGet