package com.sap.sapdb.DBMTest;
/*!
  -----------------------------------------------------------------------------
  module: EventRelease.java
  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
import java.sql.*;
import com.sap.sapdb.testframe.driver.*;
import java.util.*;

/**
 * DBMServer
 * <xmp>
 * -----------------------------------------------------------------------------
 * Class:        EventRelease
 * -----------------------------------------------------------------------------
 * responsible:  ChristianH
 * special area: DBMServer Java Test
 * description:  DBMServer event_release command tests
 * version:      7.4.*
 * copyright:    (c) 2002-2004 SAP AG
 * -----------------------------------------------------------------------------
 * </xmp>
 */

public class EventRelease extends BackupState
{

  public EventRelease() throws SQLException, TestDatabaseException
  {
    super();
  }
  /**
   * run() contains the test implementation
   */
  public void run()
  {
    DBMUtility oDBM           = new  DBMUtility(getDatabase(), this);
    boolean m_bEventFound     = false;

    //  create one global try-catch block to handle exceptions
    try
    {
      //Seeting parameters, so event will be happen
      oDBM.execCmd("param_directput _EVENT_ALIVE_CYCLE 5", DBMUtility.OK_OK);
      oDBM.execCmd("param_directput _MAXEVENTTASKS 1", DBMUtility.OK_OK);

      //Restarting database
      oDBM.execCmd("db_restart", DBMUtility.OK_OK);

      //Checking whether event is shown in event list
      oDBM.execCmd("event_wait", DBMUtility.OK_OK, false);

      m_bEventFound = false;

      // Searching for syntax -->
      // NAME=ALIVE
      // PRIORITY=LOW
      // DATE=20020930
      // TIME=00135754
      // COUNT=59
      // DESCRIPTION=Kernel is alive
      //

      if (oDBM.getAnswer().indexOf("NAME=ALIVE") >= 0 &&
          oDBM.getAnswer().indexOf("PRIORITY=LOW") >= 0 &&
          oDBM.getAnswer().indexOf("DATE") >= 0 &&
          oDBM.getAnswer().indexOf("TIME") >= 0 &&
          oDBM.getAnswer().indexOf("COUNT") >= 0 &&
          oDBM.getAnswer().indexOf("DESCRIPTION=Kernel is alive") >= 0) {

        m_bEventFound = true;
      }

      if (m_bEventFound == true) {

        addMessage("'event_wait'", TestProtocol.INFO, oDBM.getAnswer());
      } else {
        addMessage("'event_wait'", TestProtocol.ERROR, oDBM.getAnswer());
      }

      //Checking event table
      oDBM.execCmd("show tasks", DBMUtility.OK_OK, false);

      // Searching for syntax -->
      // T75    5  0x6F8 EventTs    1868 Command wait         no 0               30(s)
      //
      m_bEventFound = false;
      StringTokenizer stParam = new StringTokenizer(oDBM.getAnswer(),"\n");

      while (stParam.hasMoreTokens()) {

        String m_sLine = stParam.nextToken().toString().toUpperCase();

        if (m_sLine.indexOf("EventTs".toUpperCase()) >= 0) {

          if (m_sLine.indexOf("Command".toUpperCase()) >= 0 &&
              m_sLine.indexOf("wait".toUpperCase()) >= 0) {

            m_bEventFound = true;
            break;
          }
        }
      }

      if (m_bEventFound == true) {

        addMessage("'show tasks'", TestProtocol.INFO, "Event tasks found \n" + oDBM.getAnswer());
      } else {
        addMessage("'show tasks'", TestProtocol.ERROR, "Event tasks not found \n" + oDBM.getAnswer());
      }

      oDBM.execCmd("event_release", DBMUtility.OK_OK);

      //Checking event table
      oDBM.execCmd("show tasks", DBMUtility.OK_OK, false);

      // Searching for syntax -->
      // T75    5  0x6F8 EventTs    1868 Command wait         no 0               30(s)
      //
      m_bEventFound = false;
      stParam = new StringTokenizer(oDBM.getAnswer(),"\n");

      while (stParam.hasMoreTokens()) {

        String m_sLine = stParam.nextToken().toString().toUpperCase();

        if (m_sLine.indexOf("EventTs".toUpperCase()) >= 0) {

          if (m_sLine.indexOf("Command".toUpperCase()) >= 0 &&
              m_sLine.indexOf("wait".toUpperCase()) >= 0) {

            m_bEventFound = true;
            break;
          }
        }
      }

      if (m_bEventFound == false) {

        addMessage("'show tasks'", TestProtocol.INFO, "Event tasks could not found \n" + oDBM.getAnswer());
      } else {
        addMessage("'show tasks'", TestProtocol.ERROR, "Event tasks found \n" + oDBM.getAnswer());
      }

      //Ending util session
      oDBM.execCmd("util_release", DBMUtility.OK_OK);

      /**
       * Setting back parameters to default values
       */
      oDBM.execCmd("param_directput _EVENT_ALIVE_CYCLE 0", DBMUtility.OK_OK);
      oDBM.execCmd("param_directput _MAXEVENTTASKS 1", DBMUtility.OK_OK);

      //Restarting database
      oDBM.execCmd("db_restart", DBMUtility.OK_OK);
    }
    // catch any kind of exception and write it to the protocol
    catch (Exception e) {
      // standard error handler

      this.handleExceptions(e);
    } // end try catch

    // clean up, i.e. close statements and connections
    finally {
      try {
        // print all parameters from the parameter object to the protocol.
        printParametersToProtocol();
      }
      catch (Exception e) {
        // do nothing
      } // end try catch
    } // end finally
  } // end run
  /**
   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
   * will set the name to the name of the java class. To make the test name independend
   * from the java implementation, this method should return a unique string.
   * Attention: The uniqueness is not automatically checked by anybody.
   * @return The UNIQUE name of the test class
   */
  public static String getTestClassId() {
    return "EventRelease";
  } // end getTestClassId
} //end of class MediumGet