package com.sap.sapdb.DBMTest;
/*!
  -----------------------------------------------------------------------------
  module: DBMConfigset.java
  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
import java.sql.*;
import com.sap.sapdb.testframe.driver.*;

/**
 * DBMServer
 * <xmp>
 * -----------------------------------------------------------------------------
 * Class:        DBMConfigset
 * -----------------------------------------------------------------------------
 * responsible:  ChristianH
 * special area: DBMServer Java Test
 * description:  DBMServer dbm_configset command tests
 * version:      7.4.*
 * copyright:    (c) 2002-2004 SAP AG
 * -----------------------------------------------------------------------------
 * </xmp>
 */

public class DBMConfigset extends BackupState
{
  public DBMConfigset() throws SQLException, TestDatabaseException
  {
    super();
  }
  /**
   * run() contains the test implementation
   */
  public void run()
  {
    DBMUtility oDBM = new  DBMUtility(getDatabase(), this);

    //  create one global try-catch block to handle exceptions
    try
    {
      // Getting original value
      oDBM.execCmd("param_getdefault MAXCPU", DBMUtility.OK_OK);
      String DBMAnwser = oDBM.getAnswer().trim();

      oDBM.execCmd("dbm_configset", DBMUtility.ERR_TOFEWPARAM);
      oDBM.execCmd("dbm_configset MAXCPU", DBMUtility.ERR_TOFEWPARAM);
      oDBM.execCmd("dbm_configset MAXCPU 2", DBMUtility.OK_OK);

      oDBM.execCmd("dbm_configget MAXCPU", DBMUtility.OK_OK);

      // Getting new value for parameter
      if (oDBM.getAnswer().trim().indexOf("2") >= 0) {

        addMessage("'dbm_configset'", TestProtocol.INFO, "'2' expected, got: " + oDBM.getAnswer());
      } else {
        addMessage("'dbm_configset'", TestProtocol.ERROR, "'2' expected, got: " + oDBM.getAnswer());
      }
      // Setting back original value
      oDBM.execCmd("dbm_configset MAXCPU " + DBMAnwser, DBMUtility.OK_OK);
    }
    // catch any kind of exception and write it to the protocol
    catch (Exception e) {
      // standard error handler

      this.handleExceptions(e);
    } // end try catch

    // clean up, i.e. close statements and connections
    finally {
      try {
        // print all parameters from the parameter object to the protocol.
        printParametersToProtocol();
      }
      catch (Exception e) {
        // do nothing
      } // end try catch
    } // end finally
  } // end run
  /**
   * Returns (defines) the name of the test class. If this method doesn't exist, the test driver
   * will set the name to the name of the java class. To make the test name independend
   * from the java implementation, this method should return a unique string.
   * Attention: The uniqueness is not automatically checked by anybody.
   * @return The UNIQUE name of the test class
   */
  public static String getTestClassId() {
    return "DBMConfigset";
  } // end getTestClassId
} //end of class MediumGet