/*
 * @(#) iendlos.cpc	7.2



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




 */

#include <stdio.h>
#ifdef   _WIN32
#include <windows.h>
#define  getpid    GetCurrentProcessId
#define  sleep(x)  Sleep (x * 1000)
#define PROD 1
#if RELSTAT != PROD
#ifndef _M_AMD64
#define  DBPROCS_IMPLEMENTED
#endif
#endif

#endif
#define  ENV_DBNAME "DBNAME"

EXEC SQL INCLUDE "endlos.h" ;

#undef   SQLC
#define  SQLC      sqlca.sqlcode

#undef   CE
#define  CE(x,y)   { if (SQLC != 0 ) pe ( x , y ) ; }

#undef   ROLLBERR
#define  ROLLBERR  ( ( ( SQLC >= 400 ) && ( SQLC <= 800 ) ) || \
		   ( SQLC == -1 ) || ( SQLC == -106 ) || ( SQLC == -1000 ) )

void checkAndDeleteManySchemas () ;
void create_table_tab1 () ;
void create_table_tab_small () ;
void create_table_tab2 () ;
void init_tab2 () ;
void create_view_tabv1 () ;
void CreateSqlDbProcs () ;
void CreateOmsDbProcs () ;
void pe () ;
void print_f () ;
void movep () ;
void prot () ;

EXEC SQL BEGIN DECLARE SECTION;
typedef char    c20 [20] ;
typedef char    c100 [100] ;

long    k1 , k2 , k3 ;
char    c1 [20] , c2[20] , c3[20] ;
long    i1 , i2 , i3 , i4 , i5 , i6 ;
char    id [40] , pw [40] ;
int		ChpNum ;
int		vrc ;
char	schemaName [32] ;
long    schemaNo ;
EXEC SQL END DECLARE SECTION;

EXEC SQL INCLUDE SQLCA;

EXEC SQL WHENEVER SQLWARNING CONTINUE;
EXEC SQL WHENEVER SQLERROR   CONTINUE;
EXEC SQL WHENEVER SQLEXCEPTION CONTINUE;
EXEC SQL WHENEVER NOT FOUND  CONTINUE;
void init_tab1 () ;

#ifdef _WIN32
char    buf [256] ;
#else
FILE    *fo = NULL;
#endif
FILE	*fout ;
int     line = 2 , col = 1 ;
int     rows ;
int     pid ;
int     rolled_back = 0 ;
int     durch ;
int     user_c = 0 ;
int		UseOms = 0 ;

main (argc , argv)
int     argc ;
char    **argv ;
{
int     i ;
char    head_line [80] ;

#ifndef _WIN32
    fo = fopen ( "/dev/tty" , "w" ) ;
    if ( fo )
      if ( ! isatty(fileno(fo)) )
      {
        fclose(fo);
        fo = NULL ;
      }
#endif
	pid = getpid () ;

	strcpy (id , argv [1] ) ;
	strcpy (pw , argv [2] ) ;
	rows = atoi ( argv [3] ) ;
	if ( argc == 5 )
		if ( strcmp ( argv[4] , "-o" ) == 0 )
			UseOms = 1 ;

	{
		char filename [100] ;
		sprintf ( filename , "endlos%s.prot" , id ) ;

		if ( ( fout = fopen ( filename , "a" ) ) == NULL )
		{
			char outtext [100] ;
			sprintf ( outtext , "Error opening file '%s'\n" , filename ) ;
			perror ( outtext ) ;
			exit (-99) ;
		}
	}

	prot ("===== User   = %s =====\n" , id ) ;
        sprintf ( head_line,
              "===== %s = %s =====\n" , ENV_DBNAME, getenv ( ENV_DBNAME ) ) ;
        prot ( head_line, "" ) ;
	prot ("Rows = %d\n" , rows ) ;



	if ( id[0] == 'C' ) user_c = 1 ;

	movep (line-1 , col , "Initialisierung '%s'" , id ) ;

	EXEC SQL CONNECT :id IDENTIFIED BY :pw KEY SQLOPT ;
	movep ( line , col , "CONNECT , ERR = %d" , SQLC ) ;
	CE ("CONNECT" , 1 ) ;

	/* Daten bereitstellen  */

	do
	{
		movep ( line , col , "DROP TABLE TAB1", "" ) ;
		EXEC SQL
			DROP TABLE TAB1 ;
		CE ("DROP TABLE TAB1",0) ;
	}
	while ( rollberr (2) ) ;

	if ( SQLC )
	{
		if ( SQLC != -4004 )
			CE ("DROP TABLE TAB1",1) ;
	}
	else
		EXEC SQL COMMIT ;

	do
	{
		movep ( line , col , "DROP TABLE TAB2" , 0 ) ;
		EXEC SQL
			DROP TABLE TAB2 ;
		movep ( line , col , "DROP TABLE TAB2 , ERR = %d" , SQLC ) ;
		CE ("DROP TABLE TAB2",0) ;
	}
	while ( rollberr (2) ) ;

	if ( SQLC )
	{
		if ( SQLC != -4004 )
			CE ("DROP TABLE TAB2",1) ;
	}
	else
		EXEC SQL COMMIT ;

	do
	{
		movep ( line , col , "DROP TABLE TABSMALL" , 0 ) ;
		EXEC SQL
			DROP TABLE TABSMALL ;
		movep ( line , col , "DROP TABLE TABSMALL , ERR = %d" , SQLC ) ;
		CE ("DROP TABLE TABSMALL",0) ;
	}
	while ( rollberr (2) ) ;

	if ( SQLC )
	{
		if ( SQLC != -4004 )
			CE ("DROP TABLE TABSMALL",1) ;
	}
	else
		EXEC SQL COMMIT ;

	do
	{
		movep ( line , col , "DROP SYNONYM PUBVIEW " , 0 ) ;
		EXEC SQL
			DROP SYNONYM PUBVIEW ;

		movep ( line, col, "DROP SYNONYM PUBVIEW , ERR = %d",SQLC ) ;
		CE ("DROP SYNONYM PUBVIEW" , 0 ) ;

	}
	while ( rollberr (1) ) ;


	if ( SQLC )
	{
		if ( SQLC != -4007 )
			CE ("DROP SYNONYM PUBVIEW" , 1 ) ;
	}
	else
		EXEC SQL COMMIT ;

	create_table_tab1 () ;

	create_table_tab2 () ;

	create_view_tabv1 () ;

	create_table_tab_small () ;

	do
	{
	    EXEC SQL
		    CREATE SYNONYM PUBVIEW FOR SUPERU.TABV1 ;
	    CE ("CREATE SYNONYM TABV1",0) ;

	    if ( SQLC == 600 )
	    {
		EXEC SQL ROLLBACK ;
		movep (line,col,"CREATE SYNONYM ERR 600 : before sleep",0) ;
		sleep ( 30 + pid % 30 ) ;
		movep (line,col,"CREATE SYNONYM ERR 600 : after  sleep",0) ;
		SQLC = 600 ;
	    }
	}
	while ( rollberr (1) ) ;

	CE ("CREATE SYNONYM TABV1",1) ;

	EXEC SQL COMMIT ;

	movep ( line , col , "GRANT ... ON TAB1 TO SUPERU" , 0 ) ;

	do
		{
		EXEC SQL
			GRANT REFERENCES,SELECT,UPDATE,INSERT,DELETE ON TAB1
			TO SUPERU WITH GRANT OPTION ;
		CE ("GRANT ... ON TAB1 TO SUPERU",0) ;
		}
	while ( rollberr (1) ) ;

	if ( ! user_c )
	{
	    CE ("GRANT ... ON TAB1 TO SUPERU",1) ;

	    movep ( line , col , "GRANT ... ON TAB1 TO SUPERU" , 0 ) ;

	    do
	    {
		EXEC SQL
			GRANT SELECT ON TAB1
			TO C1,C2,C3 ;
		CE ("GRANT ... ON TAB1 TO C1 ...",0) ;
	    }
	    while ( rollberr (1) ) ;

	    CE ("GRANT ... ON TAB1 TO C1 ...",1) ;

	    EXEC SQL COMMIT ;
	}

	movep ( line , col , "CREATE VIEW TABU14" , "" ) ;

	do
	{
	    EXEC SQL CREATE VIEW TABU14
	    AS
		SELECT TAB1.K1 , TAB1.I1 , TAB1.I2 ,
		TAB1.C1 , TAB1.C2 , TAB1.I3 , T4.I4 , T4.C3
		FROM TAB1 , SUPERU.TAB4 T4
		WHERE TAB1.I3 = T4.I3
		WITH CHECK OPTION ;

	    CE ("CREATE VIEW TABU14",0) ;
	}
	while ( rollberr (1) ) ;

	CE ("CREATE VIEW TABU14",1) ;

	EXEC SQL COMMIT ;

	sleep (3) ;

	if ( ! user_c )
	{
	    movep ( line , col , "GRANT ... ON TABU14 TO C1 ..." , 0 ) ;

	    do
		    {
		    EXEC SQL
			    GRANT SELECT ON TABU14
			    TO C1,C2,C3 ;

		    CE ("GRANT ... ON TABU14 TO C1 ...",0) ;
		    }
	    while ( rollberr (1) ) ;

	    CE ("GRANT ... ON TABU14 TO C1 ...",1) ;

	    EXEC SQL COMMIT ;
	}

	do
		{
		EXEC SQL
		    GRANT REFERENCES,SELECT,UPDATE,INSERT,DELETE ON TAB1
		    TO SUPERU ;
		CE ("GRANT ... ON TAB1",0) ;
		}
	while ( rollberr (1) ) ;

	CE ("GRANT ... ON TAB1",1) ;

	EXEC SQL COMMIT ;
	movep ( line , col , "CREATE INDEX TAB1(I3)","" ) ;

	do
		{
		EXEC SQL
			CREATE INDEX TAB1_I3 ON TAB1(I3)  ;

		CE ( "CREATE INDEX TAB1.I3",0);
		}
		while ( rollberr (1) ) ;

	CE ( "CREATE INDEX TAB1.I3",1);

	EXEC SQL
     		COMMIT WORK;

	if ( !UseOms )
	{
		init_tab2 () ;
		init_tab1 () ;
	}

#ifdef DBPROCS_IMPLEMENTED

	CreateSqlDbProcs () ;

#endif

	if ( UseOms )
		CreateOmsDbProcs () ;

	if ( UseOms )
	{
		CreateOmsDbProcs () ;
		checkAndDeleteManySchemas (id) ;
		EXEC SQL COMMIT ;
	}


	cwr () ;

}

/*------------------------------------------------------------------------*/

void create_table_tab1 ()
{
	movep ( line , col , "CREATE TABLE TAB1 " , "" ) ;

	do
		{
		EXEC SQL
			CREATE TABLE TAB1
			(K1     FIXED (10) KEY ,
			 I1     FIXED (10) ,
			 I2     FIXED (10) ,
			 C1     CHAR  (20) ,
			 C2     CHAR  (20) ,
			 I3     FIXED (10) NOT NULL ,
			 FOREIGN KEY ( I3 ) REFERENCES SUPERU.TAB4
			 ON DELETE CASCADE ) ;

		CE ("CREATE TABLE TAB1",0) ;
		}
	while ( rollberr (2) ) ;

	CE ("CREATE TABLE TAB1",1) ;

        if ( rand () % 2 )
	{
            do
	    {
	        EXEC SQL ALTER TABLE TAB1 DYNAMIC ;
	        CE ("ALTER TABLE TAB1 DYNAMIC",0) ;
            }
            while ( rollberr (2) ) ;

	    CE ("ALTER TABLE TAB1 DYNAMIC",0) ;
            prot ("TAB1 is DYNAMIC\n", 0 ) ;
	}
}

/*------------------------------------------------------------------------*/

void create_table_tab_small ()
{
	movep ( line , col , "CREATE TABLE TABSMALL " , "" ) ;

	do
	{
			EXEC SQL
				CREATE TABLE TABSMALL
				(S CHAR (1) NOT NULL ) ;

			CE ("CREATE TABLE TAB2",0) ;
	}
	while ( rollberr (2) ) ;

	CE ("CREATE TABLE TABSMALL",1) ;

	EXEC SQL
		INSERT TABSMALL
		VALUES ( '1' ) ;

	CE ("INIT TABSMALL ( INSERT )" , 0 ) ;

	EXEC SQL COMMIT ;
}

/*------------------------------------------------------------------------*/

void create_table_tab2 ()
{
	movep ( line , col , "CREATE TABLE TAB2 " , "" ) ;

	do
		{
		EXEC SQL
			CREATE TABLE TAB2
			(I3     FIXED (10) KEY ,
			 I4     FIXED (10) ,
			 C3     CHAR(20) NOT NULL ,
			 CL     LONG ) ;
		CE ("CREATE TABLE TAB2",0) ;
		}
	while ( rollberr (2) ) ;

	CE ("CREATE TABLE TAB2",1) ;

	EXEC SQL COMMIT ;
}

/*------------------------------------------------------------------------*/

void init_tab1 ()
{
    EXEC SQL BEGIN DECLARE SECTION;

    int     loop_cnt ;
    long    k1 [50] ;
    c20     c1 [50] , c2[50] ;
    long    i1 [50], i2 [50] , i3 [50] ;

    EXEC SQL END DECLARE SECTION;

    int i , j ;

    movep ( line , col , "INSERT TAB1 " , "" ) ;

again_init_tab1:

    rolled_back = 0 ;

    for ( i = 1 ; i < rows / 4 ; i += 50 )
    {
	for ( loop_cnt = 0 , j = i ; loop_cnt < 50 && j < rows / 4 ;
	      j++ , loop_cnt++ )
	{
	    k1 [loop_cnt] = j ;
	    i1 [loop_cnt] = j * 100 ;
	    i2 [loop_cnt] = j % 10 ;
	    sprintf ( c1 [loop_cnt] , "Name%s_%d" , id , j ) ;
	    sprintf ( c2 [loop_cnt] , "Name%s.%d" , id , j / 10 ) ;
	    i3 [loop_cnt] = j / 10 ;
	}

	movep ( line , col , "INSERT TAB1, n = %d" , i - 1 + loop_cnt ) ;

	if ( loop_cnt == 0 ) return ; /* sonst evtl. Fehler in 3.0.1m-Kern */

	do
	{
	    EXEC SQL
		FOR :loop_cnt
		INSERT TAB1
		VALUES ( :k1 , :i1 , :i2 , :c1 , :c2 , :i3 ) ;

	    CE ("INIT TAB1 ( INSERT )" , 0 ) ;
	}
	while ( rollberr (1) && rolled_back == 0 ) ;

	loop_cnt = 0 ;

	if ( rolled_back ) goto again_init_tab1 ;

	if ( SQLC != 350 && SQLC != 200 )
	{
	    CE ("INSERT TAB1",1) ;
	}

	EXEC SQL
		COMMIT WORK;
    }
}

/*------------------------------------------------------------------------*/

void init_tab2 ()
{
    EXEC SQL BEGIN DECLARE SECTION;
    c20     c3 [40] ;
    long    i3 [40], i4 [40] ;
    int     loop_cnt ;
    VARCHAR cl [40][500] ;

    EXEC SQL END DECLARE SECTION;

    int i , j ;

  again_init_tab2:

    rolled_back = 0 ;

    movep ( line , col , "INSERT TAB2 " , "" ) ;

    for ( i = 0 ; i < rows / 8 ; i+=40 )
    {
	for ( loop_cnt = 0 , j = i ; loop_cnt < 40 && j < rows / 8 ;
	      j++ , loop_cnt++ )
	{
	    i3 [loop_cnt] = j ;
	    i4 [loop_cnt] = 10 - j ;
	    sprintf ( c3 [loop_cnt] , "tab2%d" , j ) ;
 	    strcpy ( cl [loop_cnt].arr , "Langer String                             bis hier") ;
	    cl [loop_cnt].len = (int)strlen ( cl [loop_cnt].arr ) ;
	}

	movep ( line , col , "INSERT TAB2, n = %d\n" , i + loop_cnt ) ;
	do
	{
	    EXEC SQL
		FOR :loop_cnt
		INSERT TAB2
		VALUES ( :i3 , :i4 , :c3  , :cl ) ;
	    CE ("INSERT TAB2",0) ;

	}
	while ( rollberr (1) && rolled_back == 0 ) ;

	if ( SQLC != 350 && SQLC != 200 )
		CE ("INSERT TAB2",1) ;

	if ( rolled_back )
	   goto again_init_tab2 ;

	EXEC SQL
	    COMMIT WORK;
    }
}

/*------------------------------------------------------------------------*/

void create_view_tabv1 ()
{
	movep ( line , col , "ALTER TABLE" , "" ) ;
	do
		{
		EXEC SQL ALTER TABLE TAB1 FOREIGN KEY LTABV1( I3 ) REFERENCES TAB2 ;

		CE ("ALTER TABLE",0) ;
		}
	while ( rollberr (2) ) ;

	CE ("ALTER TABLE",1) ;

	movep ( line , col , "CREATE VIEW TABV1 " , "" ) ;

	do
		{
		EXEC SQL CREATE VIEW TABV1
		AS
			SELECT K1 , I1 , I2 , C1 , C2 , TAB2.I3 , I4 , C3
			FROM TAB1 , TAB2
			WHERE TAB1.I3 = TAB2.I3
		WITH CHECK OPTION ;
		CE ("CREATE VIEW TABV1",0) ;
		}
	while ( rollberr (1) ) ;

	CE ("CREATE VIEW TABV1",1) ;

	EXEC SQL COMMIT ;
}

/*------------------------------------------------------------------------*/

void checkAndDeleteManySchemas (char *id)
{
	int i ;

	movep ( line , col, "CheckAndDelete %d Schemas" , MAXMAXSCHEMAS) ;

	for ( i = 0 ; i < MAXMAXSCHEMAS ; i++ )
	{
		sprintf ( schemaName , "schema%s%d" , id , i ) ;

		EXEC SQL DBPROC OMS_CHDEL_PRIVATE_SCHEMA (:schemaName , :schemaNo , :vrc ) ;
		/* commit () ; */
	}
}

/*------------------------------------------------------------------------*/

void CreateSqlDbProcs ()
{

		EXEC SQL DROP PACKAGE MUTDB_PACK ;

		EXEC SQL CREATE PACKAGE MUTDB_PACK  FILE 'MutDbProcsd' INPROC ;
		if ( SQLC && SQLC != -6006 )
			CE ( "CREATE PACKAGE MUTDB_PACK: sqlcode %d" , 1) ;

		EXEC SQL CREATE DBPROC MUTUPD100000 IN MUTDB_PACK EXECUTE INPROC ;
		if ( SQLC && SQLC != -6006 )
			CE ("CREATE DBPROC MUTUPD100000" , 1 ) ;
		EXEC SQL GRANT EXECUTE ON MUTUPD100000 TO PUBLIC ;
		EXEC SQL COMMIT ;

		EXEC SQL CREATE DBPROC MUTUPDTAB1 IN MUTDB_PACK EXECUTE INPROC ;
		if ( SQLC && SQLC != -6006 )
			CE ("CREATE DBPROC MUTUPDTAB1" , 1 ) ;
		EXEC SQL GRANT EXECUTE ON MUTUPDTAB1 TO PUBLIC ;
		EXEC SQL COMMIT ;

		EXEC SQL CREATE DBPROC MUTDELSUPTAB1 IN MUTDB_PACK EXECUTE INPROC ;
		if ( SQLC && SQLC != -6006 )
			CE ("CREATE DBPROC MUTDELSUPTAB1" , 1 ) ;
		EXEC SQL GRANT EXECUTE ON MUTDELSUPTAB1 TO PUBLIC ;
		EXEC SQL COMMIT ;

}

void CreateOmsDbProcs ()
{
	movep ( line , col , "CREATE DBPROCS" , "" ) ;

	/* 1. Projekt: CHL */

	EXEC SQL DROP PACKAGE CHL_PACK ;

	EXEC SQL CREATE PACKAGE CHL_PACK FILE 'chainedlist' INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ( "CREATE PACKAGE: sqlcode %d" , 1) ;

	EXEC SQL CREATE DBPROC CREATELIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CREATELIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC TRAVERSE_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC TRAVERSE_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC ADD_ELEMENT_TO_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC ADD_ELEMENT_TO_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC DELETE_ELEMENT_FROM_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC DELETE_ELEMENT_FROM_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC DELETE_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC DELETE_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_ITER_CLIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_ITER_CLIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CREATE_KEYOID_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CREATE_KEYOID_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC TRAVERSE_KEYOID_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC TRAVERSE_KEYOID_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC UPDATE_KEYOID_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC UPDATE_KEYOID_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC DELETE_FROM_KEYOID_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC DELETE_FROM_KEYOID_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC DELETE_KEYOID_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC DELETE_KEYOID_LIST" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_RELEASE_OIDS IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_RELEASE_OIDS" , 1 ) ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_DEBUG IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_DEBUG" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_DEBUG TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_CREATE_VERSION IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_CREATE_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_CREATE_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_OPEN_VERSION IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_OPEN_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_OPEN_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_CLOSE_VERSION IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_CLOSE_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_CLOSE_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_DROP_VERSION IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_DROP_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_DROP_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC INIT_FIRSTOID_LIST IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC INIT_FIRSTOID_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON INIT_FIRSTOID_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_START_SUBTRANS IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_START_SUBTRANS" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_START_SUBTRANS TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_COMMIT_SUBTRANS IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_COMMIT_SUBTRANS" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_COMMIT_SUBTRANS TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC CHL_ROLLBACK_SUBTRANS IN CHL_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC CHL_ROLLBACK_SUBTRANS" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON CHL_ROLLBACK_SUBTRANS TO PUBLIC ;
	EXEC SQL COMMIT ;

	/* 2. project : OMS1 */

	EXEC SQL DROP PACKAGE OMS1_PACK;

	EXEC SQL CREATE PACKAGE OMS1_PACK FILE 'OmsMut1' INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ( "CREATE PACKAGE: sqlcode %d" , 1) ;

	EXEC SQL CREATE DBPROC OMS1_CREATE_VERSION IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_CREATE_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_CREATE_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_OPEN_VERSION IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_OPEN_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_OPEN_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_CLOSE_VERSION IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_CLOSE_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_CLOSE_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_DROP_VERSION IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_DROP_VERSION" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_DROP_VERSION TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_INIT_FIRSTOID_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_INIT_FIRSTOID_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_INIT_FIRSTOID_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_CREATE_KEYOID_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_CREATE_KEYOID_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_CREATE_KEYOID_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_DELETE_KEYOID_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_DELETE_KEYOID_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_DELETE_KEYOID_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS1_UPDATE_KEYOID_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS1_UPDATE_KEYOID_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS1_UPDATE_KEYOID_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_CREATE_VAROBJ_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_CREATE_VAROBJ_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_CREATE_VAROBJ_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_DELETE_VAROBJ_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_DELETE_VAROBJ_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_DELETE_VAROBJ_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_UPDATE_VAROBJ_LIST IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_UPDATE_VAROBJ_LIST" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_UPDATE_VAROBJ_LIST TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_ADD_VAROBJ IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_ADD_VAROBJ" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_ADD_VAROBJ TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_CREATE_PRIVATE_SCHEMA IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_CREATE_PRIVATE_SCHEMA" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_CREATE_PRIVATE_SCHEMA TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_CHDEL_PRIVATE_SCHEMA IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_CHDEL_PRIVATE_SCHEMA" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_CHDEL_PRIVATE_SCHEMA TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_DROP_PRIVATE_SCHEMA IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_DROP_PRIVATE_SCHEMA" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_DROP_PRIVATE_SCHEMA TO PUBLIC ;
	EXEC SQL COMMIT ;

	EXEC SQL CREATE DBPROC OMS_ADDKEY_PRIVATE_SCHEMA IN OMS1_PACK EXECUTE INPROC ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE DBPROC OMS_ADDKEY_PRIVATE_SCHEMA" , 1 ) ;
	EXEC SQL GRANT EXECUTE ON OMS_ADDKEY_PRIVATE_SCHEMA TO PUBLIC ;
	EXEC SQL COMMIT ;

/*
	EXEC SQL CREATE SYNONYM LISTHEAD FOR SUPERU.LISTHEAD ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE SYNONYM LISTHEAD" , 1 ) ;
	EXEC SQL COMMIT ;
	EXEC SQL CREATE SYNONYM KEYLISTHEAD FOR SUPERU.KEYLISTHEAD ;
	if ( SQLC && SQLC != -6006 )
		CE ("CREATE SYNONYM KEYLISTHEAD" , 1 ) ;
	EXEC SQL COMMIT ;
*/
}

/*------------------------------------------------------------------------*/

void pe (s , leave )
char    *s ;
int     leave ;
{
char    zeile [200] ;

#ifdef DEBUG
	fprintf ( stderr , "pid %d , %s :  ERR = %d\n" , pid , s , SQLC ) ;
#endif

	sprintf ( zeile , "%s :  ERR = %d" , s , sqlca.sqlcode ) ;
	movep ( line , col , zeile , "" ) ;

	if ( ( SQLC != 100 ) && ( SQLC != 200 ) )
		print_f ( s ) ;

	if ( leave || SQLC == -108 || SQLC == -6000 || SQLC <= -9000 ||
		SQLC == -7500 ||
	   ( SQLC != -809 && ( SQLC <= -800 && SQLC > -900 ) ) )
		{
		print_f ( s ) ;
		print_f ("calling sqldump") ;
		sqladump () ;
		exit ( 1 ) ;
		}

}

/*------------------------------------------------------------------------*/

#include <time.h>

void print_f (s )
char    *s ;
{
char    da [40] ;
time_t  tm ;
tm = time ( (time_t *) 0) ;

strncpy ( da , ctime ( &tm ) , 39 ) ;

fprintf ( fout , "pid %d , %.19s , durch %3d , %s :  ERR = %d\n" ,
		    pid , da , durch , s , SQLC ) ;
}

/*------------------------------------------------------------------------*/

rollberr ( kind )
int kind ;
{
int sqlc ;

	if ( ROLLBERR )
	    switch ( kind )
		{
		case 0 : sleep (3) ; return ( 1 ) ; break ;
		case 1 :
		     if ( ( rand () % 10 ) == 0 )
			   {
			   EXEC SQL ROLLBACK ;
			   prot ("Transaction rolled back, loop again\n","") ;
			   rolled_back = 1 ;
			   sleep ( 3 ) ;
			   }
		     else if ( SQLC == -1000 )
			   sleep ( 3 ) ;
		     return ( 1 ) ;
		     break ;
		case 2 :
		     EXEC SQL ROLLBACK ;
		     if ( SQLC == -1000 )
			sleep ( 3 ) ;
		     else
			sleep ( 1 ) ;
		     prot ("Transaction rolled back, loop again\n","") ;
		     rolled_back = 1 ;
		     return ( 1 ) ;
		     break ;
		case 3 :
		     sqlc = SQLC ;
		     EXEC SQL ROLLBACK ;
		     prot ("Transaction rolled back, no more loop\n","") ;
		     SQLC = sqlc ;
		     rolled_back = 1 ;
		     return ( 0 ) ;
			 break ;
		default :
			 return -2 ;

		}
	else
		return (0) ;
}

/*------------------------------------------------------------------------*/

cwr()
{
	if ( fout )
		fclose ( fout ) ;

	EXEC SQL
     		COMMIT WORK RELEASE;

	exit (0) ;
}

/*------------------------------------------------------------------------*/

void movep (line,col,s1,s2)
int     line,col;
char    *s1 , *s2  ;
{
char    zeile [200] ;

      sprintf ( zeile , s1 , s2 ) ;

      if ( line > 22 ) line = 22 ;

#ifdef _WIN32
      sprintf (buf , "\033[%d;%dH\033[K%s\r",line,col,zeile);
      sflushf (buf) ;
      sprintf (buf , "\033[21;1H") ;
      sflushf (buf) ;
#else
    if ( fo )
    {
      fflush (fo) ;
      fprintf (fo , "\033[%d;%dH\033[K%s\r",line,col,zeile);
      fflush (fo) ;
      fprintf (fo , "\033[21;1H") ;
      fflush (fo) ;
    }
#endif
}

/*------------------------------------------------------------------------*/

void prot ( s1 , s2 )
char    *s1 ;
char    *s2 ;
{
     char    da [40] ;
     time_t    tm ;
     tm = time ( (time_t *) 0) ;

     strncpy ( da , ctime ( &tm ) , 39 ) ;

     fprintf ( fout , "pid %d , %.19s , durch %3d , " , pid , da , durch ) ;
     fprintf ( fout , s1 , s2 ) ;
     fflush ( fout ) ;
}
