/*!================================================================

 module:        ReuseCon.cpp

 -------------------------------------------------------------------

 responsible:   ThomasS

 special area:  SQL

 description:   Example: Simple Connect

 -------------------------------------------------------------------







    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end








 ===================================================================*/

#include <stdio.h>

#include "Interfaces/Runtime/IFR_Environment.h"
#include "Interfaces/Runtime/IFR_Connection.h"
#include "Interfaces/SQLDBC/SQLDBC_ClientRuntime.h"

int main (int argc, char *argv[])
{
  if (argc != 4) {
    printf ("usage: ReuseCon <servernode> <dbname> <username> <passwd>\n");
    return 0;
  }
  IFR_Environment *env = 
    new IFR_Environment(SQLDBC_ClientRuntimeInit());
  IFR_Connection  *conn = env->getConnection();
  // conn->enablePacketTrace();
  IFR_Retcode rc = conn->connect (argv[1],
                                  IFR_NTS,
				  argv[2],
                                  IFR_NTS,
				  argv[3],
                                  IFR_NTS,
				  argv[4],
                                  IFR_NTS,
                                  IFR_StringEncodingAscii);
  
  env->releaseConnection (conn);
  delete env;
  // conn->close ();

  return 0;
}



