/*!
  @file           ParamBind.cpp
  @author         D025086
  @ingroup        Tests
  @brief          Check binding of parameters before and after prepare.
  @todo           Half done, do some tests with wrong bindings.
                  
  @see            

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end







\endif
*/

#include "SAPDB/Interfaces/SQLDBC/tests/SQLDBCTestUtils.h"
#include <string.h>

class BindParameter : public SQLDBC_TestCase
{
public:
  BindParameter ()
    : SQLDBC_TestCase ("BindParameter")
  {}

  virtual SQLDBC_Bool run ()
  {
    SQLDBC_Retcode rc;
    SQLDBC_PreparedStatement *stmt = connection()->createPreparedStatement();

    char pdata[10];
    sprintf(pdata, "1");

    SQLDBC_Length ind=SQLDBC_NTS;
    tc_errorcheckrc(rc, stmt)->bindParameter(1, SQLDBC_HOSTTYPE_ASCII, pdata, &ind, sizeof(pdata), SQLDBC_TRUE);
    
    const char *szSQL = "SELECT 'ONE' from dual where '1' = ?";

    tc_errorcheckrc(rc, stmt)->prepare(szSQL);

    tc_errorcheckrc(rc, stmt)->execute();

    SQLDBC_ResultSet *res = stmt->getResultSet();

    if(!res)
      logerror("No resultset returned");

    tc_errorcheck(res)->next();

    char cdata[50];
    tc_errorcheckrc(rc, res)->getObject(1, SQLDBC_HOSTTYPE_ASCII, cdata, &ind, sizeof(cdata));
    
    if (strcmp(cdata, "ONE")) {
      logerror("Wrong data returned");
    }

    loginfo("cdata=%s", cdata);

    return m_success;
  }

};

int main (int argc, char **argv)
{
  // Initalize from command line params
  SQLDBC_TestFrame testframe (argc, argv);
  testframe.addTestCase (new BindParameter());
  if (testframe.run ()) 
    return 0;

  return 1;
}


