/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = new InternetHeaders(inputStream);
        try {
            this.content = ASCIIUtility.getBytes(inputStream);
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("Error reading input stream", iOException);
        }
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        this.headers = internetHeaders;
        this.content = byArray;
    }

    public int getSize() throws MessagingException {
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String string = this.getHeader("Content-Type", null);
        if (string == null) {
            string = "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) throws MessagingException {
        return MimeBodyPart.isMimeType(this, string);
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition(this);
    }

    public void setDisposition(String string) throws MessagingException {
        MimeBodyPart.setDisposition(this, string);
    }

    public String getEncoding() throws MessagingException {
        return MimeBodyPart.getEncoding(this);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) throws MessagingException {
        this.setHeader("Content-MD5", string);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage(this);
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        MimeBodyPart.setContentLanguage(this, stringArray);
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription(this);
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        MimeBodyPart.setDescription(this, string, string2);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName(this);
    }

    public void setFileName(String string) throws MessagingException {
        MimeBodyPart.setFileName(this, string);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.dh = dataHandler;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setContent(Object object, String string) throws MessagingException {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
            return;
        }
        this.setDataHandler(new DataHandler(object, string));
    }

    public void setText(String string) throws MessagingException {
        this.setText(string, null);
    }

    public void setText(String string, String string2) throws MessagingException {
        MimeBodyPart.setText(this, string, string2);
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.setDataHandler(new DataHandler(multipart, multipart.getContentType()));
        multipart.setParent(this);
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        MimeBodyPart.writeTo(this, outputStream, null);
    }

    public String[] getHeader(String string) throws MessagingException {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) throws MessagingException {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) throws MessagingException {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    protected void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders(this);
    }

    static boolean isMimeType(MimePart mimePart, String string) throws MessagingException {
        try {
            ContentType contentType = new ContentType(mimePart.getContentType());
            return contentType.match(string);
        }
        catch (ParseException parseException) {
            return mimePart.getContentType().equalsIgnoreCase(string);
        }
    }

    static void setText(MimePart mimePart, String string, String string2) throws MessagingException {
        if (string2 == null) {
            string2 = MimeUtility.checkAscii(string) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        mimePart.setContent(string, "text/plain; charset=" + MimeUtility.quote(string2, "()<>@,;:\\\"\t []/?="));
    }

    static String getDisposition(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Disposition", null);
        if (string == null) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition(string);
        return contentDisposition.getDisposition();
    }

    static void setDisposition(MimePart mimePart, String string) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Disposition");
            return;
        }
        String string2 = mimePart.getHeader("Content-Disposition", null);
        if (string2 != null) {
            ContentDisposition contentDisposition = new ContentDisposition(string2);
            contentDisposition.setDisposition(string);
            string = contentDisposition.toString();
        }
        mimePart.setHeader("Content-Disposition", string);
    }

    static String getDescription(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Description", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static void setDescription(MimePart mimePart, String string, String string2) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Description");
            return;
        }
        try {
            mimePart.setHeader("Content-Description", MimeUtility.encodeText(string, string2, null));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", unsupportedEncodingException);
        }
    }

    static String getFileName(MimePart mimePart) throws MessagingException {
        Object object;
        String string = null;
        String string2 = mimePart.getHeader("Content-Disposition", null);
        if (string2 != null) {
            object = new ContentDisposition(string2);
            string = ((ContentDisposition)object).getParameter("filename");
        }
        if (string == null && (string2 = mimePart.getHeader("Content-Type", null)) != null) {
            object = new ContentType(string2);
            string = ((ContentType)object).getParameter("name");
        }
        return string;
    }

    static void setFileName(MimePart mimePart, String string) throws MessagingException {
        String string2 = mimePart.getHeader("Content-Disposition", null);
        ContentDisposition contentDisposition = new ContentDisposition(string2 == null ? "attachment" : string2);
        contentDisposition.setParameter("filename", string);
        mimePart.setHeader("Content-Disposition", contentDisposition.toString());
        string2 = mimePart.getHeader("Content-Type", null);
        if (string2 != null) {
            ContentType contentType = new ContentType(string2);
            contentType.setParameter("name", string);
            mimePart.setHeader("Content-Type", contentType.toString());
        }
    }

    static String[] getContentLanguage(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n;
        String string = mimePart.getHeader("Content-Language", null);
        if (string == null) {
            return null;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        Vector<String> vector = new Vector<String>();
        while ((n = (token = headerTokenizer.next()).getType()) != -4) {
            if (n != -1) continue;
            vector.addElement(token.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void setContentLanguage(MimePart mimePart, String[] stringArray) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(',').append(stringArray[n]);
            ++n;
        }
        mimePart.setHeader("Content-Language", stringBuffer.toString());
    }

    static String getEncoding(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n;
        String string = mimePart.getHeader("Content-Transfer-Encoding", null);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("base64")) {
            return string;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while ((n = (token = headerTokenizer.next()).getType()) != -4) {
            if (n != -1) continue;
            return token.getValue();
        }
        return string;
    }

    static void setEncoding(MimePart mimePart, String string) throws MessagingException {
        mimePart.setHeader("Content-Transfer-Encoding", string);
    }

    static void updateHeaders(MimePart mimePart) throws MessagingException {
        DataHandler dataHandler = mimePart.getDataHandler();
        if (dataHandler == null) {
            return;
        }
        try {
            Object object;
            String string = dataHandler.getContentType();
            boolean bl = false;
            ContentType contentType = new ContentType(string);
            if (contentType.match("multipart/*")) {
                bl = true;
                object = dataHandler.getContent();
                ((MimeMultipart)object).updateHeaders();
            } else if (contentType.match("message/rfc822")) {
                bl = true;
            }
            if (mimePart.getHeader("Content-Type") == null) {
                ContentDisposition contentDisposition;
                String string2;
                object = mimePart.getHeader("Content-Disposition", null);
                if (object != null && (string2 = (contentDisposition = new ContentDisposition((String)object)).getParameter("filename")) != null) {
                    contentType.setParameter("name", string2);
                    string = contentType.toString();
                }
                mimePart.setHeader("Content-Type", string);
            }
            if (!bl && mimePart.getHeader("Content-Transfer-Encoding") == null) {
                MimeBodyPart.setEncoding(mimePart, MimeUtility.getEncoding(dataHandler));
                return;
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException updating headers", iOException);
        }
    }

    static void invalidateContentHeaders(MimePart mimePart) throws MessagingException {
        mimePart.removeHeader("Content-Type");
        mimePart.removeHeader("Content-Transfer-Encoding");
    }

    static void writeTo(MimePart mimePart, OutputStream outputStream, String[] stringArray) throws IOException, MessagingException {
        LineOutputStream lineOutputStream = null;
        lineOutputStream = outputStream instanceof LineOutputStream ? (LineOutputStream)outputStream : new LineOutputStream(outputStream);
        Enumeration enumeration = mimePart.getNonMatchingHeaderLines(stringArray);
        while (enumeration.hasMoreElements()) {
            lineOutputStream.writeln((String)enumeration.nextElement());
        }
        lineOutputStream.writeln();
        outputStream = MimeUtility.encode(outputStream, mimePart.getEncoding());
        mimePart.getDataHandler().writeTo(outputStream);
        outputStream.flush();
    }
}

